/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.DeliveryRouteProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryOrderVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteRecordService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.NOUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="INVENTORY_DELIVERY_TAG", topic="INVENTORY_DELIVERY_TOPIC")
public class DeliveryGenerateProcess
implements IMessageProcessor<String> {
    private Logger logger = LoggerFactory.getLogger(DeliveryGenerateProcess.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private CargoDas cargoDas;
    @Autowired
    private WarehouseDas warehouseDas;
    @Resource
    private ChangeLogDas changeLogDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private DeliveryRouteProducer deliveryRouteProducer;
    @Resource
    private IDeliveryRouteRecordService deliveryRouteRecordService;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(String deliveryOrderJson) {
        Thread.currentThread().setName("INVENTORY-DELIVERY-PROCESS-" + UUID.randomUUID().toString());
        this.logger.info("\u63a5\u6536\u5230\u4ea4\u6613\u4e2d\u5fc3\u53d1\u8fc7\u6765\u7684\u53d1\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)deliveryOrderJson);
        DeliveryOrderVo deliveryOrderVo = (DeliveryOrderVo)JSON.parseObject((String)deliveryOrderJson, DeliveryOrderVo.class);
        OrderDeliveryEo orderDeliveryEo = deliveryOrderVo.getOrderDelivery();
        List<RefDeliveryOrderEo> refDeliveryOrderEos = deliveryOrderVo.getRefDeliveryOrders();
        List<DeliveryItemEo> deliveryItems = deliveryOrderVo.getDeliveryItems();
        try {
            this.updateCargo(deliveryItems);
        }
        catch (Exception e) {
            this.logger.info("\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        OrderDeliveryEo select = new OrderDeliveryEo();
        select.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        int count = this.orderDeliveryDas.count((BaseEo)select);
        if (count > 0) {
            this.logger.info("\u8be5\u53d1\u8d27\u5355\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c\u3002deliveryNo:{}", (Object)orderDeliveryEo.getDeliveryNo());
            return MessageResponse.SUCCESS;
        }
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
        this.refDeliveryOrderDas.insertBatch(refDeliveryOrderEos);
        this.deliveryItemDas.insertBatch(deliveryItems);
        this.logger.info("\u63a5\u6536\u4ea4\u6613\u4e2d\u5fc3\u53d1\u8d27\u5355\u5165\u5e93\u5b8c\u6bd5...");
        this.saveRouteRecord(orderDeliveryEo, refDeliveryOrderEos.get(0));
        if (DeliveryStatusEnum.TO_ROUTE.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
            this.logger.info("\u53d1\u8d27\u5355\u72b6\u6001\u4e3a\u5f85\u8def\u7531\u72b6\u6001\uff0c\u53d1\u9001\u8def\u7531\u6d88\u606f\uff0cdeliveryNo:{}", (Object)orderDeliveryEo.getDeliveryNo());
            DeliveryRouteReqDto deliveryRouteReqDto = new DeliveryRouteReqDto();
            deliveryRouteReqDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            this.deliveryRouteProducer.sendDeliberyRoutCommand(deliveryRouteReqDto);
        }
        return MessageResponse.SUCCESS;
    }

    private void updateCargo(List<DeliveryItemEo> deliveryItems) {
        this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u6263\u51cf\u5f00\u59cb");
        if (CollectionUtils.isEmpty(deliveryItems)) {
            this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u6263\u51cf\u5546\u54c1\u4e3a\u7a7a\u4e0d\u6267\u884c");
            return;
        }
        this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u6263\u51cf\u5546\u54c1\u4e3a\uff1a{}", (Object)JSON.toJSONString(deliveryItems));
        List warehouseEos = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).eq("sub_type", (Object)9).eo()).getList();
        if (CollectionUtils.isEmpty((Collection)warehouseEos)) {
            this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u4e0d\u6267\u884c");
            return;
        }
        WarehouseEo warehouseEo = (WarehouseEo)warehouseEos.get(0);
        this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)warehouseEo));
        final Long warehouseId = warehouseEo.getId();
        List cargoCodes = deliveryItems.stream().map(StdDeliveryItemEo::getCargoSerial).collect(Collectors.toList());
        List cargoEos = this.cargoDas.select(SqlFilterBuilder.create(CargoEo.class).in("code", (Object)StringUtils.join(cargoCodes, (String)",")).eo());
        if (CollectionUtils.isEmpty((Collection)cargoEos)) {
            this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u6263\u51cf\u6839\u636e\u8d27\u54c1\u7f16\u7801\u67e5\u8be2\u8d27\u54c1\u4e3a\u7a7a\u4e0d\u6267\u884c");
            return;
        }
        Map<String, CargoEo> cargoEoMap = cargoEos.stream().collect(Collectors.toMap(StdCargoEo::getCode, cargoEo -> cargoEo));
        List cargoStorageEos = this.cargoStorageDas.select(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouse_id", (Object)warehouseId).eo());
        if (CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
            this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u6263\u51cf\u8be5\u6e20\u9053\u4ed3\u5173\u8054\u8d27\u54c1\u4e3a\u7a7a\u4e0d\u6267\u884c");
            return;
        }
        Map<String, BigDecimal> cargoStorageMap = cargoStorageEos.stream().collect(Collectors.toMap(StdCargoStorageEo::getCargoCode, StdCargoStorageEo::getAvailable));
        this.cargoStorageDas.updateList(deliveryItems.stream().map(s -> {
            CargoEo cargoEo = (CargoEo)cargoEoMap.get(s.getCargoSerial());
            if (null == cargoEo) {
                return null;
            }
            CargoStorageEo cargoStorageEo = new CargoStorageEo();
            cargoStorageEo.setCargoId(cargoEo.getId());
            cargoStorageEo.setAvailable(new BigDecimal(s.getItemNum()).negate());
            cargoStorageEo.setUpdateTime(new Date());
            return cargoStorageEo;
        }).filter(Objects::nonNull).collect(Collectors.toList()), (List)new ArrayList<Long>(){
            {
                this.add(warehouseId);
            }
        });
        this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u5e93\u5b58\u66f4\u65b0\u5b8c\u6210");
        this.changeLogDas.insertBatch(deliveryItems.stream().map(d -> {
            String no = NOUtil.generateNo();
            ChangeLogEo changeLogEo = new ChangeLogEo();
            changeLogEo.setRelevanceNo(no);
            String cargoSerial = d.getCargoSerial();
            CargoEo cargoEo = (CargoEo)cargoEoMap.get(cargoSerial);
            if (null != cargoEo) {
                changeLogEo.setCargoNo(cargoEo.getArtNo());
                changeLogEo.setCargoBarCode(cargoEo.getBarCode());
                changeLogEo.setClientName(cargoEo.getCustomerNo());
                changeLogEo.setCargoId(cargoEo.getId());
                changeLogEo.setCargoCode(cargoEo.getCode());
                changeLogEo.setCargoName(cargoEo.getName());
            }
            changeLogEo.setWarehouseId(warehouseId.toString());
            changeLogEo.setWarehouseCode(warehouseEo.getCode());
            changeLogEo.setWarehouseName(warehouseEo.getName());
            changeLogEo.setWarehouseSubType(warehouseEo.getSubType());
            changeLogEo.setType(ChangeLogTypeEnum.SALES_ORDER.getStatus());
            BigDecimal available = (BigDecimal)cargoStorageMap.get(cargoSerial);
            if (null == available) {
                return null;
            }
            changeLogEo.setOldNum(available);
            BigDecimal adjustNum = new BigDecimal(d.getItemNum()).negate();
            changeLogEo.setChangeNum(adjustNum);
            changeLogEo.setNewNum(available.add(adjustNum).compareTo(BigDecimal.ZERO) > 0 ? available.add(adjustNum) : BigDecimal.ZERO);
            return changeLogEo;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u5e93\u5b58\u65b0\u589e\u6d41\u6c34\u5b8c\u6210");
    }

    private void saveRouteRecord(OrderDeliveryEo orderDeliveryEo, RefDeliveryOrderEo refDeliveryOrderEo) {
        DeliveryRouteRecordReqDto deliveryRouteRecord = new DeliveryRouteRecordReqDto();
        deliveryRouteRecord.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        deliveryRouteRecord.setOrderNo(refDeliveryOrderEo.getOrderNo());
        deliveryRouteRecord.setOptCode(DeliveryRouteOptEnum.GENERATE.getOptCode());
        deliveryRouteRecord.setOptName(DeliveryRouteOptEnum.GENERATE.getOptDesc());
        deliveryRouteRecord.setDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryRouteRecord.setDeliveryStatusName(DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()));
        deliveryRouteRecord.setDetailDesc("\u7cfb\u7edf\u751f\u6210\u53d1\u8d27\u5355\uff0c\u521d\u59cb\u72b6\u6001\u4e3a" + DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()));
        this.deliveryRouteRecordService.saveRouteRecord(deliveryRouteRecord);
    }
}

