/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.process;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryMergeVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@MQDesc(tag="TRADE_DELIVERY_MERGE_TAG", topic="TRADE_DELIVERY_MERGE_TOPIC")
public class DeliveryMergeProcess
implements IMessageProcessor<String> {
    private final Logger logger = LoggerFactory.getLogger(DeliveryMergeProcess.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private IDeliveryOrderService deliveryOrderService;

    public MessageResponse process(String deliveryMergeVoJson) {
        this.logger.info("\u63a5\u6536\u5230\u4ea4\u6613\u4e2d\u5fc3\u53d1\u9001\u7684\u5408\u5355\u4fe1\u606f");
        DeliveryMergeVo deliveryMergeVo = (DeliveryMergeVo)JSON.parseObject((String)deliveryMergeVoJson, DeliveryMergeVo.class);
        DeliveryVo deliveryMerge = deliveryMergeVo.getDeliveryMerge();
        this.deliveryOrderService.saveDelivery(deliveryMerge);
        List<DeliveryMergeVo.DeliveryOld> deliveryOlds = deliveryMergeVo.getDeliveryOlds();
        deliveryOlds.stream().forEach(old -> {
            OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
            orderDeliverySelect.setDeliveryNo(old.getDeliveryNo());
            OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
            orderDeliveryEo.setCancelType(old.getCancelType());
            orderDeliveryEo.setCancelDesc(old.getCancelDesc());
            orderDeliveryEo.setCancelTime(old.getCancelTime());
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryEo);
        });
        return MessageResponse.SUCCESS;
    }
}

