/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.process;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.StockDsl;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MQDesc(topic="${STOCK_CHANGE_TOPIC:STOCK_CHANGE_TOPIC}", tag="${STOCK_CHANGE_TAG:STOCK_CHANGE_TAG}")
public class StockChangeProcess
implements IMessageProcessor<StockChangeDto> {
    @Resource
    private ICacheService cacheService;
    @Resource
    private StockDsl stockDsl;
    private static final Logger logger = LoggerFactory.getLogger(StockChangeProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(StockChangeDto dto) {
        String processKey = "stockChangeProcess:" + dto.getMessageId();
        try {
            if (!this.cacheService.setIfAbsent(processKey, "processing", 864000).booleanValue()) {
                return MessageResponse.SUCCESS;
            }
        }
        catch (Throwable e) {
            try {
                this.cacheService.delCache(processKey);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.error("\u5224\u65ad\u6d88\u606f\u5e42\u7b49\u5904\u7406\u51fa\u9519:", e);
            return MessageResponse.ERROR;
        }
        try {
            this.stockDsl.updateDbStock(dto);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5e93\u5b58\u66f4\u53d8\u51fa\u9519:", (Throwable)e);
        }
        finally {
            this.cacheService.setCache(processKey, (Object)"processed");
        }
        return MessageResponse.SUCCESS;
    }
}

