/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewInventoryCountProducer {
    private static final Logger logger = LoggerFactory.getLogger(NewInventoryCountProducer.class);
    @Resource
    private ICommonsMqService commonsMqService;

    public void sendChangeMq(StorageChangeReqDto storageChangeReqDto) {
        InventoryCountDto dto = new InventoryCountDto();
        dto.setWarehouseId(storageChangeReqDto.getWarehouseId());
        dto.setCargoId(storageChangeReqDto.getCargoId());
        dto.setNum(storageChangeReqDto.getAvailable());
        dto.setNo(TradeUtil.generateTradeNo(storageChangeReqDto.getCargoId().toString()));
        ArrayList<InventoryCountDto> inventoryCountDtos = new ArrayList<InventoryCountDto>();
        inventoryCountDtos.add(dto);
        MessageVo changeMessage = new MessageVo();
        changeMessage.setData(inventoryCountDtos);
        this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)changeMessage);
        logger.info("\u53d1\u9001\u5e93\u5b58\u8c03\u6574\u5185\u90e8\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)changeMessage));
        dto.setNum(storageChangeReqDto.getOriAvailable());
        MessageVo oriMessage = new MessageVo();
        oriMessage.setData(inventoryCountDtos);
        this.commonsMqService.publishMessage("inventorySafetyStockMessage", (Object)oriMessage);
        logger.info("\u53d1\u9001\u5b89\u5168\u5e93\u5b58\u6bd4\u4f8b\u53d8\u52a8\u5185\u90e8\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)oriMessage));
    }
}

