/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.mq.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TradeUtil {
    private static final int maxPerMSECSize = 999;
    @Autowired
    ICacheService cacheService;
    private static TradeUtil tradeUtil;
    private static final String TRADE_NO = "TRADENO";
    private static final Integer STR_FORMAT_10;
    private static final Integer STR_FORMAT_100;
    private static final Integer STR_FORMAT_1000;

    @PostConstruct
    public void init() {
        tradeUtil = this;
        TradeUtil.tradeUtil.cacheService = this.cacheService;
    }

    public static String generateTradeNo(String rootTradeNo) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeMsecStr = timeStr.substring(14, 17);
        String timeSecondStr = timeStr.substring(0, 14);
        Long result = TradeUtil.tradeUtil.cacheService.incr(TRADE_NO);
        Long mod = result % 999L;
        String resultNo = "" + mod;
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "0" + mod;
        }
        rootTradeNo = rootTradeNo.substring(rootTradeNo.length() - 4);
        String tradeNo = timeSecondStr + "0" + timeMsecStr + resultNo + rootTradeNo;
        System.out.println(tradeNo);
        return tradeNo;
    }

    static {
        STR_FORMAT_10 = 10;
        STR_FORMAT_100 = 100;
        STR_FORMAT_1000 = 1000;
    }
}

