/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.scheduler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageAdjustStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.NOUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustCargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageAdjustCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.connector.comm.constant.BizTypeEnum;
import com.dtyunxi.yundt.cube.connector.comm.dto.BizToExternalSystemReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="inventoryCountEvent")
@Scope(value="prototype")
public class InventoryCountEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(InventoryCountEvent.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CargoDas cargoDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private StorageAdjustDas storageAdjustDas;
    @Resource
    private StorageAdjustCargoDas storageAdjustCargoDas;
    @Resource
    private ChangeLogDas changeLogDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    Environment environment;
    private static final String INVENTORY_TIME = "INVENTORY_TIME";
    private static final String OMS_ORG_INVENTORY = "OMS_ORG_INVENTORY";
    private static final String B2C_ORG_INVENTORY = "B2C_ORG_INVENTORY";
    private static final String OMS_ALL_INVENTORY = "OMS_ALL_INVENTORY";
    private static final String B2C_ALL_INVENTORY = "B2C_ALL_INVENTORY";

    public void before(TaskMsg taskMsg) {
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean execute(TaskMsg taskMsg) {
        String cache = (String)this.cacheService.getCache(INVENTORY_TIME, String.class);
        Date date = new Date();
        if (StringUtils.isEmpty((CharSequence)cache)) {
            cache = DateUtil.format((Date)date, (String)DatePattern.DATETIME_PATTERN.getPattern());
        }
        Date oldDate = DateUtil.parse((String)cache, (String)DatePattern.DATETIME_PATTERN.getPattern());
        List select = this.storageAdjustDas.select(SqlFilterBuilder.create(StorageAdjustEo.class).eq("code", (Object)486).gt("create_time", (Object)oldDate).lt("create_time", (Object)date).eo());
        if (CollectionUtils.isEmpty((Collection)select)) {
            return true;
        }
        List warehouseIds = select.stream().map(StdStorageAdjustEo::getWarehouseId).collect(Collectors.toList());
        List cargoIds = this.storageAdjustCargoDas.selectPage(SqlFilterBuilder.create(StorageAdjustCargoEo.class).in("storage_adjust_no", (Object)StringUtils.join((Iterable)select.stream().map(StdStorageAdjustEo::getStorageAdjustNo).collect(Collectors.toList()), (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(10000000)).getList().stream().map(StdStorageAdjustCargoEo::getCargoId).collect(Collectors.toList());
        List warehouseEos = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join(warehouseIds, (String)",")).eq("inventory_share_status", (Object)1).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        if (CollectionUtils.isEmpty((Collection)warehouseEos)) {
            return true;
        }
        List cargoStorageEos = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).in("warehouse_id", (Object)StringUtils.join(warehouseIds, (String)",")).eq("inventory_share_status", (Object)1).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        if (CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
            return true;
        }
        Map map = (Map)JSONObject.parseObject((String)((DictDto)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "SYSTEM_SETTING", "INVENTORY_SHARE_STRATEGY_SETTING").getData()).getValue(), Map.class);
        String inventoryShareType = map.get("strategyType").toString();
        Map parseObject = (Map)JSONObject.parseObject((String)((DictDto)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "SYSTEM_SETTING", "STORE_INVENTORY_SHARING_SETTING").getData()).getValue(), Map.class);
        BigDecimal omsInventoryPercentage = new BigDecimal(parseObject.get("appletChannel").toString()).divide(new BigDecimal("100"));
        BigDecimal b2cInventoryPercentage = new BigDecimal(parseObject.get("oMSChannel").toString()).divide(new BigDecimal("100"));
        List cargoStorageEoList = cargoStorageEos.stream().map(c -> {
            if (cargoIds.contains(c.getCargoId())) {
                return c;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cargoStorageEoList)) {
            return true;
        }
        ArrayList<CargoStorageEo> omsUpdateDtos = new ArrayList<CargoStorageEo>();
        ArrayList<CargoStorageEo> b2cUpdateDtos = new ArrayList<CargoStorageEo>();
        Map<Long, List<CargoStorageEo>> cargoStorageIdMap = cargoStorageEoList.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getCargoId));
        if ("1".equals(inventoryShareType)) {
            for (Long key : cargoStorageIdMap.keySet()) {
                this.getInv(omsInventoryPercentage, cargoStorageIdMap, key, OMS_ORG_INVENTORY, omsUpdateDtos, b2cUpdateDtos);
                this.getInv(b2cInventoryPercentage, cargoStorageIdMap, key, B2C_ORG_INVENTORY, omsUpdateDtos, b2cUpdateDtos);
            }
        } else {
            for (Long key : cargoStorageIdMap.keySet()) {
                this.getAllInv(omsInventoryPercentage, cargoStorageIdMap, key, OMS_ALL_INVENTORY, omsUpdateDtos, b2cUpdateDtos);
                this.getAllInv(b2cInventoryPercentage, cargoStorageIdMap, key, B2C_ALL_INVENTORY, omsUpdateDtos, b2cUpdateDtos);
            }
        }
        List warehouseEoList = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).eq("sub_type", (Object)1).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        List warehouseEos1 = this.warehouseDas.selectPage(SqlFilterBuilder.create(WarehouseEo.class).eq("sub_type", (Object)2).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        this.cargoStorageDas.updateList(omsUpdateDtos, warehouseEoList.stream().map(BaseEo::getId).collect(Collectors.toList()));
        this.cargoStorageDas.updateList(b2cUpdateDtos, warehouseEos1.stream().map(BaseEo::getId).collect(Collectors.toList()));
        List storageEoList = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).eq("sub_type", (Object)1).in("cargo_id", (Object)StringUtils.join((Iterable)omsUpdateDtos.stream().map(StdCargoStorageEo::getCargoId).collect(Collectors.toList()), (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        List storageEoList1 = this.cargoStorageDas.selectPage(SqlFilterBuilder.create(CargoStorageEo.class).eq("sub_type", (Object)2).in("cargo_id", (Object)StringUtils.join((Iterable)b2cUpdateDtos.stream().map(StdCargoStorageEo::getCargoId).collect(Collectors.toList()), (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList();
        storageEoList.addAll(storageEoList1);
        warehouseEoList.addAll(warehouseEos1);
        Map<Long, CargoEo> cargoEoMap = this.cargoDas.selectPage(SqlFilterBuilder.create(CargoEo.class).in("id", (Object)StringUtils.join(cargoIds, (String)",")).eo(), Integer.valueOf(1), Integer.valueOf(1000000)).getList().stream().collect(Collectors.toMap(BaseEo::getId, c -> c));
        Map<Long, WarehouseEo> warehouseEoMap = warehouseEoList.stream().collect(Collectors.toMap(BaseEo::getId, w -> w));
        ArrayList changeLogEos = new ArrayList();
        Map<Long, List<CargoStorageEo>> wareHouseMap = storageEoList.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getWarehouseId));
        ArrayList<BizToExternalSystemReqDto> bizToExternalSystemReqDtos = new ArrayList<BizToExternalSystemReqDto>();
        ArrayList<StorageAdjustEo> storageAdjustEos = new ArrayList<StorageAdjustEo>();
        ArrayList storageAdjustCargoEos = new ArrayList();
        for (Long wareId : wareHouseMap.keySet()) {
            List<CargoStorageEo> storageEos = wareHouseMap.get(wareId);
            BizToExternalSystemReqDto systemReqDto = new BizToExternalSystemReqDto();
            StorageAdjustEo storageAdjustEo = new StorageAdjustEo();
            storageAdjustEo.setWarehouseId(wareId);
            storageAdjustEo.setStatus(StorageAdjustStatusEnum.SUCCESS.getStatus());
            storageAdjustEo.setAdjustType("SYSTEM_ADJUST");
            storageAdjustEo.setAdjustMethod("CUMULATIVE");
            String no = NOUtil.generateNo();
            storageAdjustEo.setStorageAdjustNo(no);
            WarehouseEo warehouseEo = warehouseEoMap.get(wareId);
            systemReqDto.setBizMethod("inventoryCountEvent");
            systemReqDto.setBizId(no);
            if (null != warehouseEo) {
                systemReqDto.setChannel(warehouseEo.getSubType() == 1 ? "wms" : "mini");
            }
            systemReqDto.setBizType(BizTypeEnum.INVENTORY.getType());
            bizToExternalSystemReqDtos.add(systemReqDto);
            storageAdjustCargoEos.addAll(storageEos.stream().map(s -> {
                StorageAdjustCargoEo storageAdjustCargoEo = new StorageAdjustCargoEo();
                ChangeLogEo changeLogEo = new ChangeLogEo();
                storageAdjustEo.setPositionId(s.getPositionId());
                storageAdjustCargoEo.setStorageAdjustNo(no);
                Long cargoId = s.getCargoId();
                CargoEo cargoEo = (CargoEo)cargoEoMap.get(cargoId);
                storageAdjustCargoEo.setCargoId(cargoId);
                storageAdjustCargoEo.setCargoCode(s.getCargoCode());
                storageAdjustCargoEo.setCargoName(s.getCargoName());
                if (null != cargoEo) {
                    storageAdjustCargoEo.setCargoNo(cargoEo.getArtNo());
                    storageAdjustCargoEo.setCargoBarCode(cargoEo.getBarCode());
                    storageAdjustCargoEo.setClientName(cargoEo.getCustomerNo());
                    changeLogEo.setCargoNo(cargoEo.getArtNo());
                    changeLogEo.setCargoBarCode(cargoEo.getBarCode());
                    changeLogEo.setClientName(cargoEo.getCustomerNo());
                }
                storageAdjustCargoEo.setClientId(null);
                changeLogEo.setRelevanceNo(no);
                changeLogEo.setCargoId(cargoId);
                changeLogEo.setCargoCode(s.getCargoCode());
                changeLogEo.setCargoName(s.getCargoName());
                changeLogEo.setClientId(null);
                changeLogEo.setWarehouseId(wareId.toString());
                if (null != warehouseEo) {
                    Integer subType = warehouseEo.getSubType();
                    if ("1".equals(inventoryShareType)) {
                        storageAdjustCargoEo.setAdjustNum(1 == subType ? new BigDecimal((Long)this.cacheService.getCache(OMS_ORG_INVENTORY + cargoId, Long.TYPE)) : new BigDecimal((Long)this.cacheService.getCache(B2C_ORG_INVENTORY + cargoId, Long.TYPE)));
                    } else {
                        storageAdjustCargoEo.setAdjustNum(1 == subType ? new BigDecimal((Long)this.cacheService.getCache(OMS_ALL_INVENTORY + cargoId, Long.TYPE)) : new BigDecimal((Long)this.cacheService.getCache(B2C_ALL_INVENTORY + cargoId, Long.TYPE)));
                    }
                    changeLogEo.setWarehouseCode(warehouseEo.getCode());
                    changeLogEo.setWarehouseName(warehouseEo.getName());
                    changeLogEo.setWarehouseSubType(subType);
                }
                BigDecimal adjustNum = storageAdjustCargoEo.getAdjustNum();
                changeLogEo.setType(ChangeLogTypeEnum.STORAGE_ADJUST_ORDER.getStatus());
                changeLogEo.setOldNum(s.getAvailable().divide(adjustNum));
                changeLogEo.setChangeNum(adjustNum);
                changeLogEo.setNewNum(s.getAvailable());
                changeLogEos.add(changeLogEo);
                return storageAdjustCargoEo;
            }).collect(Collectors.toList()));
            storageAdjustEos.add(storageAdjustEo);
        }
        this.storageAdjustDas.insertBatch(storageAdjustEos);
        this.storageAdjustCargoDas.insertBatch(storageAdjustCargoEos);
        this.changeLogDas.insertBatch(changeLogEos);
        this.sendInventoryAdjust(bizToExternalSystemReqDtos);
        this.cacheService.setPersistCache(INVENTORY_TIME, (Object)DateUtil.format((Date)date, (String)DatePattern.DATETIME_PATTERN.getPattern()));
        return true;
    }

    private void sendInventoryAdjust(List<BizToExternalSystemReqDto> bizToExternalSystemReqDtos) {
        logger.info("\u8def\u7531\u5230\u4ed3\u5e93\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u6570\u636e\u4e0b\u53d1WMS\uff0cbizToExternalSystemReqDto\uff1a{}", (Object)JSON.toJSONString(bizToExternalSystemReqDtos));
        try {
            bizToExternalSystemReqDtos.stream().forEach(b -> this.commonsMqService.sendSingleMessage(this.environment.resolvePlaceholders("YUNDT_CUBE_CONNECTOR_MQ_CONVERT"), "BIZ_TO_EXTERNAL_SYSTEM", b));
        }
        catch (Exception e) {
            logger.info("\u8def\u7531\u5230\u4ed3\u5e93\u53d1\u8d27\uff0c\u53d1\u8d27\u5355\u6570\u636e\u4e0b\u53d1WMS\u51fa\u73b0\u5f02\u5e38\uff0ce\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void getAllInv(BigDecimal omsInventoryPercentage, Map<Long, List<CargoStorageEo>> cargoStorageIdMap, Long key, String s, List<CargoStorageEo> omsUpdateDtos, List<CargoStorageEo> b2cUpdateDtos) {
        long oldAllInv = (Long)this.cacheService.getCache(s + key, Long.TYPE);
        BigDecimal sun = BigDecimal.ZERO;
        cargoStorageIdMap.get(key).stream().forEach(c -> sun.add(c.getBalance()));
        BigDecimal multiply = sun.multiply(omsInventoryPercentage);
        long allInv = multiply.setScale(0, 1).longValue();
        this.cacheService.setPersistCache(s + key, (Object)allInv);
        long oldB2cOrgInv = (Long)this.cacheService.getCache(s + key, Long.TYPE);
        if (allInv != oldB2cOrgInv) {
            long newInv = allInv - oldB2cOrgInv;
            CargoStorageEo upDto = new CargoStorageEo();
            upDto.setCargoId(key);
            upDto.setBalance(new BigDecimal(newInv));
            upDto.setUpdateTime(new Date());
            if (OMS_ORG_INVENTORY.equals(s)) {
                omsUpdateDtos.add(upDto);
            } else {
                b2cUpdateDtos.add(upDto);
            }
        }
    }

    private long getInv(BigDecimal omsInventoryPercentage, Map<Long, List<CargoStorageEo>> cargoStorageIdMap, Long key, String s, List<CargoStorageEo> omsUpdateDtos, List<CargoStorageEo> b2cUpdateDtos) {
        BigDecimal sun = BigDecimal.ZERO;
        cargoStorageIdMap.get(key).stream().forEach(c -> sun.add(c.getBalance()).multiply(omsInventoryPercentage));
        long orgInv = sun.setScale(0, 1).longValue();
        this.cacheService.setPersistCache(s + key, (Object)orgInv);
        long oldOmsOrgInv = (Long)this.cacheService.getCache(s + key, Long.TYPE);
        if (orgInv != oldOmsOrgInv) {
            long newInv = orgInv - oldOmsOrgInv;
            CargoStorageEo upDto = new CargoStorageEo();
            upDto.setCargoId(key);
            upDto.setBalance(new BigDecimal(newInv));
            upDto.setUpdateTime(new Date());
            if (OMS_ORG_INVENTORY.equals(s)) {
                omsUpdateDtos.add(upDto);
            } else {
                b2cUpdateDtos.add(upDto);
            }
        }
        return orgInv;
    }

    public void after(TaskMsg taskMsg) {
    }
}

