/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.RefWarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.SchedulerEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ShareStorageStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageShareDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.inventory.biz.conver.ShareDtoToCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.IgnorePropertiesUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageShareTaskDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageShareTaskEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class CargoStorageShareTask {
    private static Logger logger = LoggerFactory.getLogger(CargoStorageShareTask.class);
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Value(value="${scheduler.share.efficiency.expression:time.cron:0 */5 * * * ?}")
    private String scheduleExpression;
    @Value(value="${asynCargoStorageShareTask.number:100000}")
    private long groupNumber;
    @Resource
    private CargoStorageShareTaskDas shareTaskDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private RefWarehouseDas refWarehouseDas;
    @Resource
    private ICargoService cargoService;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private ITaskQueryApi taskQueryApi;

    @Transactional(rollbackFor={Exception.class})
    public void shareTask() {
        long startTime = System.currentTimeMillis();
        CargoStorageShareTaskEo shareTaskEo = new CargoStorageShareTaskEo();
        shareTaskEo.setTaskStatus(ShareStorageStatusEnum.EXECUTE_WAIT.getCode());
        List eoList = this.shareTaskDas.select((BaseEo)shareTaskEo);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            logger.info("\u6682\u65e0\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u9700\u8981\u6267\u884c...");
            return;
        }
        logger.info("\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u5177\u4f53\u4e3a\uff1a{}", (Object)eoList.size(), (Object)JSONObject.toJSONString((Object)eoList));
        for (CargoStorageShareTaskEo taskEo : eoList) {
            String taskRemark;
            CargoStorageShareDto shareDto;
            RefWarehouseEo refWarehouseEo;
            if (Objects.isNull(this.doBySelectWarehouse(taskEo, refWarehouseEo = new RefWarehouseEo(), (shareDto = (CargoStorageShareDto)JSONObject.parseObject((String)(taskRemark = taskEo.getTaskRemark()), CargoStorageShareDto.class)).getWarehouseCode(), null, false))) continue;
            List refWarehouseEos = shareDto.getCargoWarehouseShareDtos().stream().map(n -> this.doBySelectWarehouse(taskEo, new RefWarehouseEo(), n.getRefWarehouseCode(), n.getProportion(), true)).filter(m -> Objects.nonNull(m)).collect(Collectors.toList());
            logger.info("\u67e5\u8be2\u5173\u8054\u4ed3\u5e93\u7684\u6570\u91cf\u4e3a\uff1a{}\uff0c\u5177\u4f53\u4e3a\uff1a{}", (Object)refWarehouseEos.size(), (Object)JSONObject.toJSONString(refWarehouseEos));
            if (CollectionUtils.isEmpty(refWarehouseEos)) {
                logger.info("\u8be5\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u627e\u4e0d\u5230\u81f3\u5c11\u4e00\u4e2a\u5bf9\u5e94\u7684\u5173\u8054\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u4ed3\u5e93\u662f\u5426\u5b58\u5728...");
                taskEo.setTaskStatus(ShareStorageStatusEnum.EXECUTE_FALSE.getCode());
                taskEo.setTaskResult("\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u8be5\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u627e\u4e0d\u5230\u81f3\u5c11\u4e00\u4e2a\u5bf9\u5e94\u7684\u5173\u8054\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u4ed3\u5e93\u662f\u5426\u5b58\u5728...");
                this.shareTaskDas.update((BaseEo)taskEo);
                continue;
            }
            List<CargoEo> cargoEoList = this.cargoService.queryByCargoEo(ShareDtoToCargoEo.DtoToCargoEo(shareDto));
            int count = this.splitCargo(cargoEoList.size());
            for (int i = 0; i < count; ++i) {
                List refEos = cargoEoList.stream().limit(this.groupNumber * (long)count > (long)cargoEoList.size() ? (long)cargoEoList.size() : this.groupNumber * (long)count).skip(this.groupNumber * (long)(count - 1)).map(n -> refWarehouseEos.stream().map(m -> {
                    RefWarehouseEo eo = new RefWarehouseEo();
                    CubeBeanUtils.copyProperties((Object)eo, (Object)refWarehouseEo, (String[])IgnorePropertiesUtil.getNullPropertyNames(refWarehouseEo));
                    CubeBeanUtils.copyProperties((Object)eo, (Object)m, (String[])IgnorePropertiesUtil.getNullPropertyNames(m));
                    eo.setCargoId(n.getId());
                    eo.setCargoCode(n.getCode());
                    eo.setCargoName(n.getName());
                    return eo;
                }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
                this.refWarehouseDas.insertBatch(refEos);
                logger.info("\u6267\u884c\u6210\u529f\uff0c\u7b2c\uff1a{}\u7ec4\u63d2\u5165\u7684\u4ed3\u5e93\u5173\u8054\u8bb0\u5f55\u6570\u4e3a\uff1a{}\uff0c\u6d88\u8017\u65f6\u95f4\u4e3a\uff1a{}\u3002", new Object[]{i + 1, refEos.size(), System.currentTimeMillis() - startTime});
            }
            taskEo.setTaskStatus(ShareStorageStatusEnum.EXECUTE_SUCCESS.getCode());
            taskEo.setTaskResult("\u6267\u884c\u6210\u529f\uff0c\u5168\u90e8\u63d2\u5165\u7684\u4ed3\u5e93\u5173\u8054\u8bb0\u5f55\u6570\u4e3a:" + cargoEoList.size() * refWarehouseEos.size() + "\uff0c\u5206\u6210" + count + "\u7ec4\u6267\u884c\uff0c\u66f4\u65b0\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u4e3a\u6267\u884c\u6210\u529f\uff0c\u603b\u6d88\u8017\u65f6\u95f4\u4e3a\uff1a" + (System.currentTimeMillis() - startTime));
            this.shareTaskDas.update((BaseEo)taskEo);
            logger.info("\u6267\u884c\u6210\u529f\uff0c\u5168\u90e8\u63d2\u5165\u7684\u4ed3\u5e93\u5173\u8054\u8bb0\u5f55\u6570\u4e3a:" + cargoEoList.size() * refWarehouseEos.size() + "\uff0c\u5206\u6210" + count + "\u7ec4\u6267\u884c\uff0c\u66f4\u65b0\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u4e3a\u6267\u884c\u6210\u529f\uff0c\u603b\u6d88\u8017\u65f6\u95f4\u4e3a\uff1a" + (System.currentTimeMillis() - startTime));
        }
    }

    private int splitCargo(long number) {
        int count = (int)(number / this.groupNumber) + 1;
        logger.info("\u8d27\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u6309\u7167\u62c6\u5206\u6570\u91cf\u6bcf\u7ec4\uff1a{}\uff0c\u5206\u6210\uff1a{}\u7ec4", new Object[]{number, this.groupNumber, count});
        return count;
    }

    private RefWarehouseEo doBySelectWarehouse(CargoStorageShareTaskEo taskEo, RefWarehouseEo refWarehouseEo, String warehouseCode, BigDecimal proportion, boolean isRef) {
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setCode(warehouseCode);
        List warehouseEos = this.warehouseDas.select((BaseEo)warehouseEo);
        if (CollectionUtils.isEmpty((Collection)warehouseEos)) {
            if (isRef) {
                logger.warn("\u8be5\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5173\u8054\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u5173\u8054\u4ed3\u5e93\u662f\u5426\u5b58\u5728\uff0c\u5173\u8054\u4ed3\u5e93\u7f16\u7801\u4e3a\uff1a{}", (Object)warehouseCode);
            } else {
                logger.warn("\u8be5\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u65b0\u589e\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u65b0\u589e\u4ed3\u5e93\u662f\u5426\u5b58\u5728\uff0c\u65b0\u589e\u4ed3\u5e93\u7f16\u7801\u4e3a\uff1a{}", (Object)warehouseCode);
                taskEo.setTaskStatus(ShareStorageStatusEnum.EXECUTE_FALSE.getCode());
                taskEo.setTaskResult("\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u8be5\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u4efb\u52a1\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u65b0\u589e\u4ed3\u5e93\uff0c\u8bf7\u68c0\u67e5\u65b0\u589e\u4ed3\u5e93\u662f\u5426\u5b58\u5728\uff0c\u65b0\u589e\u4ed3\u5e93\u7f16\u7801\u4e3a\uff1a" + warehouseCode);
                this.shareTaskDas.update((BaseEo)taskEo);
            }
            return null;
        }
        if (isRef) {
            refWarehouseEo.setProportion(proportion);
            refWarehouseEo.setType(RefWarehouseTypeEnum.REF_CARGO.getCode());
            refWarehouseEo.setRefWarehouseId(((WarehouseEo)warehouseEos.get(0)).getId().toString());
            refWarehouseEo.setRefWarehouseCode(warehouseCode);
            refWarehouseEo.setRefWarehouseName(((WarehouseEo)warehouseEos.get(0)).getName());
            refWarehouseEo.setRefWarehouseType(Integer.valueOf(((WarehouseEo)warehouseEos.get(0)).getType()));
            refWarehouseEo.setRefWarehouseSubType(((WarehouseEo)warehouseEos.get(0)).getSubType());
            return refWarehouseEo;
        }
        refWarehouseEo.setWarehouseId(((WarehouseEo)warehouseEos.get(0)).getId().toString());
        refWarehouseEo.setWarehouseCode(warehouseCode);
        refWarehouseEo.setWarehouseName(((WarehouseEo)warehouseEos.get(0)).getName());
        refWarehouseEo.setWarehouseType(Integer.valueOf(((WarehouseEo)warehouseEos.get(0)).getType()));
        refWarehouseEo.setWarehouseSubType(((WarehouseEo)warehouseEos.get(0)).getSubType());
        return refWarehouseEo;
    }

    public void initDeliverTimeLimitTask() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011,scheduleExpression:{}", (Object)this.scheduleExpression);
        if (StringUtils.isEmpty((CharSequence)this.scheduleExpression)) {
            logger.warn("\u521d\u59cb\u5316\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u5931\u8d25,\u5e93\u5b58\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(SchedulerEnum.CARGO_STORAGE_SHARE.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u4e0d\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.creatShareTimeLimitTask();
            return;
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (this.scheduleExpression.equals(origTask.getScheduleExpression())) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                logger.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
            return;
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            logger.info("\u7981\u7528\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
        taskUpate.setScheduleExpression(this.scheduleExpression);
        taskUpate.setInstanceId(Long.valueOf(-1L));
        taskUpate.setTenantId(Long.valueOf(-1L));
        RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
        logger.info("\u66f4\u65b0\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        logger.info("\u542f\u7528\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    public void creatShareTimeLimitTask() {
        logger.info("\u5f00\u59cb\u521b\u5efa\u3010\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.appCode);
        taskAndBizCreate.setBizCode(SchedulerEnum.CARGO_STORAGE_SHARE.getBizCode());
        taskAndBizCreate.setBizName(SchedulerEnum.CARGO_STORAGE_SHARE.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(this.scheduleExpression);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(SchedulerEnum.CARGO_STORAGE_SHARE.getBizName());
        taskAndBizCreate.setTaskDesc("\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1");
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        logger.info("\u8d27\u54c1\u5e93\u5b58\u5171\u4eab\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
    }
}

