/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.SchedulerEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeliverThresholdTask {
    private static Logger logger = LoggerFactory.getLogger(DeliverThresholdTask.class);
    @Autowired
    private WarehouseDas warehouseDas;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Value(value="${scheduler.delivery.threshold.expression:}")
    private String scheduleExpression;

    public void calculateDeliverThreshold() {
        logger.info("\u5f00\u59cb\u91cd\u7f6e\u95e8\u5e97\u4ed3\u53d1\u8d27\u9608\u503c\u76f8\u5173\u4fe1\u606f\uff0c\u95e8\u5e97\u4ed3\u5269\u4f59\u53d1\u8d27\u9608\u503c\u66f4\u65b0\u4e3a\u4ed3\u5e93\u9608\u503c\uff0c\u9608\u503c\u5206\u6570\u66f4\u65b0\u4e3a100!");
        Integer count = this.warehouseDas.reSetThreshold();
        logger.info("\u91cd\u7f6e\u95e8\u5e97\u4ed3\u53d1\u8d27\u9608\u503c\u76f8\u5173\u4fe1\u606f\u5b8c\u6bd5\uff0c\u66f4\u65b0\u6761\u6570\uff1a{}", (Object)count);
    }

    public void initDeliverThresholdTask() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011,scheduleExpression:{}", (Object)this.scheduleExpression);
        if (StringUtils.isEmpty((CharSequence)this.scheduleExpression)) {
            logger.warn("\u521d\u59cb\u5316\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5931\u8d25,\u5e93\u5b58\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(SchedulerEnum.DELIVER_THRESHOLD.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u4e0d\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.createDeliverThresholdTask();
            return;
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (this.scheduleExpression.equals(origTask.getScheduleExpression())) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                logger.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
            return;
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            logger.info("\u7981\u7528\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
        taskUpate.setScheduleExpression(this.scheduleExpression);
        taskUpate.setInstanceId(Long.valueOf(-1L));
        taskUpate.setTenantId(Long.valueOf(-1L));
        RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
        logger.info("\u66f4\u65b0\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        logger.info("\u542f\u7528\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    public void createDeliverThresholdTask() {
        logger.info("\u5f00\u59cb\u521b\u5efa\u3010\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.appCode);
        taskAndBizCreate.setBizCode(SchedulerEnum.DELIVER_THRESHOLD.getBizCode());
        taskAndBizCreate.setBizName(SchedulerEnum.DELIVER_THRESHOLD.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(this.scheduleExpression);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(SchedulerEnum.DELIVER_THRESHOLD.getBizName());
        taskAndBizCreate.setTaskDesc("\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1");
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        logger.info("\u53d1\u8d27\u9608\u503c\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
    }
}

