/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.constants.ComConstants;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.SchedulerEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryEfficiencyRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.AppBizQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeliverTimeLimitTask {
    private static Logger logger = LoggerFactory.getLogger(DeliverTimeLimitTask.class);
    @Autowired
    private WarehouseDas warehouseDas;
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private IDictQueryApi dictQueryApi;
    @Resource
    private ITaskQueryApi taskQueryApi;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Value(value="${scheduler.delivery.efficiency.expression:}")
    private String scheduleExpression;

    public void calculateDeliverTimeLimit() {
        Object warehouseRespDto;
        logger.info("\u5f00\u59cb\u66f4\u65b0\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u2026\u2026");
        DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(ComConstants.TENANT, "STORE_SETTING", "STORE_DELIVERY_EFFICIENCY_SETTING").getData();
        logger.error("\u95e8\u5e97\u53d1\u8d27\u6548\u7387\u8bbe\u7f6e\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)dictDto));
        if (null == dictDto) {
            logger.error("\u95e8\u5e97\u53d1\u8d27\u6548\u7387\u8bbe\u7f6e\u672a\u914d\u7f6e\uff0c\u4e0d\u8fdb\u884c\u95e8\u5e97\u4ed3\u53d1\u8d27\u65f6\u6548\u8ba1\u7b97\uff01");
            return;
        }
        String deliveryEfficiencyJson = dictDto.getValue();
        List deliveryEfficiencys = JSON.parseArray((String)deliveryEfficiencyJson, DeliveryEfficiencyRespDto.class);
        if (CollectionUtils.isEmpty((Collection)deliveryEfficiencys)) {
            logger.error("\u95e8\u5e97\u53d1\u8d27\u6548\u7387\u8bbe\u7f6e\u5df2\u914d\u7f6e\uff0c\u4f46\u662f\u672a\u8bbe\u7f6e\u4efb\u4f55\u503c\uff01");
            return;
        }
        ArrayList<WarehouseRespDto> allWarehouses = new ArrayList<WarehouseRespDto>();
        this.loadAllWarehouse(allWarehouses);
        if (CollectionUtils.isEmpty(allWarehouses)) {
            logger.warn("\u8ba1\u7b97\u95e8\u5e97\u4ed3\u53d1\u8d27\u65f6\u6548\u672a\u627e\u5230\u4efb\u4f55\u95e8\u5e97\u4ed3\u2026\u2026");
            return;
        }
        ArrayList<OrderDeliveryEo> orderDeliverys = new ArrayList<OrderDeliveryEo>();
        this.loadAllOrderDelivery(orderDeliverys);
        if (CollectionUtils.isEmpty(orderDeliverys)) {
            logger.warn("\u8ba1\u7b97\u95e8\u5e97\u4ed3\u53d1\u8d27\u65f6\u6548\u672a\u627e\u5230\u4efb\u4f55\u53d1\u8d27\u5355\u4fe1\u606f\u2026\u2026");
            return;
        }
        Map<String, WarehouseRespDto> allWarehouseMap = allWarehouses.stream().collect(Collectors.toMap(WarehouseRespDto::getCode, w -> w));
        for (OrderDeliveryEo orderDeliveryEo : orderDeliverys) {
            String warehouseCode = orderDeliveryEo.getWarehouseCode();
            long deliveryTimeTotal = orderDeliveryEo.getDeliveryTime().getTime() - orderDeliveryEo.getReceiveTime().getTime();
            warehouseRespDto = allWarehouseMap.get(warehouseCode);
            warehouseRespDto.setDeliveryTimeTotal(warehouseRespDto.getDeliveryTimeTotal() + deliveryTimeTotal);
            warehouseRespDto.setDeliveryCount(warehouseRespDto.getDeliveryCount() + 1);
            if (warehouseRespDto.getDeliveryCount() <= 0) continue;
            warehouseRespDto.setDeliveryTimeAvg((double)warehouseRespDto.getDeliveryTimeTotal() / (double)warehouseRespDto.getDeliveryCount());
        }
        ArrayList<WarehouseRespDto> warehouseList = new ArrayList<WarehouseRespDto>(allWarehouseMap.values());
        warehouseList.sort(Comparator.comparing(WarehouseRespDto::getDeliveryTimeAvg));
        Integer count = null;
        WarehouseRespDto lastRespDto = null;
        for (WarehouseRespDto warehouseRespDto2 : warehouseList) {
            if (null == count) {
                count = 1;
            } else if (warehouseRespDto2.getDeliveryTimeAvg() != lastRespDto.getDeliveryTimeAvg()) {
                warehouseRespDto = count;
                Integer n = count = Integer.valueOf(count + 1);
            }
            Integer deliverTimeLimit = this.getDeliveryEfficiencyRespDto(deliveryEfficiencys, count);
            WarehouseEo warehouseEo = new WarehouseEo();
            warehouseEo.setId(warehouseRespDto2.getId());
            warehouseEo.setDeliverTimeLimit(deliverTimeLimit);
            this.warehouseDas.updateSelective((BaseEo)warehouseEo);
            lastRespDto = warehouseRespDto2;
        }
        logger.info("\u66f4\u65b0\u53d1\u8d27\u6548\u7387\u5b8c\u6bd5\uff01");
    }

    private void loadAllWarehouse(List<WarehouseRespDto> allWarehouses) {
        Integer pageNum = 1;
        Integer pageSize = 5000;
        WarehouseEo warehouseEoSelect = new WarehouseEo();
        warehouseEoSelect.setSubType(Integer.valueOf(WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode()));
        PageInfo pageInfo = this.warehouseDas.selectPage((BaseEo)warehouseEoSelect, pageNum, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList warehouseRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(warehouseRespDtos, (Collection)pageInfo.getList(), WarehouseRespDto.class);
            allWarehouses.addAll(warehouseRespDtos);
        }
        int pages = pageInfo.getPages();
        while (pageNum < pages) {
            pageInfo = this.warehouseDas.selectPage((BaseEo)warehouseEoSelect, Integer.valueOf(pageNum + 1), pageSize);
            List list = pageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                ArrayList warehouseRespDtos = new ArrayList();
                CubeBeanUtils.copyCollection(warehouseRespDtos, (Collection)list, WarehouseRespDto.class);
                allWarehouses.addAll(warehouseRespDtos);
            }
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }

    private void loadAllOrderDelivery(List<OrderDeliveryEo> orderDeliverys) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -6);
        calendar.add(5, -1);
        Date date = calendar.getTime();
        Integer pageNum = 1;
        Integer pageSize = 5000;
        OrderDeliveryEo orderDeliveryEoSelect = new OrderDeliveryEo();
        orderDeliveryEoSelect.setWarehouseSubType(String.valueOf(WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode()));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"deliveryStatus", Arrays.asList(DeliveryStatusEnum.DELIVERED.getStatus(), DeliveryStatusEnum.SIGNED.getStatus(), DeliveryStatusEnum.FINISHED.getStatus())));
        sqlFilters.add(SqlFilter.ge((String)"deliveryTime", (Object)format.format(date)));
        sqlFilters.add(SqlFilter.le((String)"deliveryTime", (Object)format.format(new Date())));
        orderDeliveryEoSelect.setSqlFilters(sqlFilters);
        PageInfo pageInfo = this.orderDeliveryDas.selectPage((BaseEo)orderDeliveryEoSelect, pageNum, pageSize);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            orderDeliverys.addAll(pageInfo.getList());
        }
        int pages = pageInfo.getPages();
        while (pageNum < pages) {
            pageInfo = this.orderDeliveryDas.selectPage((BaseEo)orderDeliveryEoSelect, Integer.valueOf(pageNum + 1), pageSize);
            List list = pageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                orderDeliverys.addAll(list);
            }
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }

    private Integer getDeliveryEfficiencyRespDto(List<DeliveryEfficiencyRespDto> deliveryEfficiencys, Integer count) {
        for (DeliveryEfficiencyRespDto deliveryEfficiencyRespDto : deliveryEfficiencys) {
            Integer start = deliveryEfficiencyRespDto.getStart();
            Integer end = deliveryEfficiencyRespDto.getEnd();
            if (count < start || count > end) continue;
            return deliveryEfficiencyRespDto.getScore().intValue();
        }
        return 0;
    }

    public void initDeliverTimeLimitTask() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011,scheduleExpression:{}", (Object)this.scheduleExpression);
        if (StringUtils.isEmpty((CharSequence)this.scheduleExpression)) {
            logger.warn("\u521d\u59cb\u5316\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5931\u8d25,\u5e93\u5b58\u4e2d\u5fc3\u914d\u7f6e\u6587\u4ef6\u672a\u914d\u7f6e\u4efb\u52a1\u6267\u884c\u8868\u8fbe\u5f0f\uff01");
            return;
        }
        AppBizQueryReqDto appBizQueryReqDto = new AppBizQueryReqDto();
        appBizQueryReqDto.setAppCode(this.appCode);
        appBizQueryReqDto.setBizCode(SchedulerEnum.DELIVERY_TIME_LIMIT.getBizCode());
        String filter = ObjectHelper.bean2Json((Object)appBizQueryReqDto);
        List appBizQueryRespDtos = ((PageInfo)this.appBizQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1)).getData()).getList();
        if (CollectionUtils.isEmpty((Collection)appBizQueryRespDtos)) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u4e0d\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u521d\u59cb\u5316\u2026\u2026");
            this.createDeliverTimeLimitTask();
            return;
        }
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5df2\u5b58\u5728\uff0c\u5f00\u59cb\u8fdb\u884c\u66f4\u65b0\u2026\u2026");
        AppBizQueryRespDto origAppBiz = (AppBizQueryRespDto)appBizQueryRespDtos.get(0);
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setTaskName(origAppBiz.getBizName());
        taskQueryReqDto.setAppBizId(origAppBiz.getId());
        String taskFilter = ObjectHelper.bean2Json((Object)taskQueryReqDto);
        PageInfo taskPageInfo = (PageInfo)this.taskQueryApi.queryByPage(taskFilter, Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (null == taskPageInfo || CollectionUtils.isEmpty((Collection)taskPageInfo.getList())) {
            throw new BizException("\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\uff01");
        }
        TaskQueryRespDto origTask = (TaskQueryRespDto)taskPageInfo.getList().get(0);
        String status = origTask.getStatus();
        if (this.scheduleExpression.equals(origTask.getScheduleExpression())) {
            logger.info("\u5b9a\u65f6\u4efb\u52a1\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u914d\u7f6e\u4e0d\u53d8\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\u3002");
            if (EnableEnum.DISABLE.getCodeEn().equals(status)) {
                RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
                logger.info("\u539f\u5b9a\u65f6\u4efb\u52a1\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u672a\u542f\u7528\uff0c\u542f\u7528\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
            }
            return;
        }
        if (EnableEnum.ENABLE.getCodeEn().equals(status)) {
            RestResponse disableResponse = this.taskApi.disableById(origTask.getId(), "{}");
            logger.info("\u7981\u7528\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u6210\u529f\uff0c{}", (Object)JSON.toJSONString((Object)disableResponse));
        }
        TaskUpdateReqDto taskUpate = new TaskUpdateReqDto();
        taskUpate.setScheduleExpression(this.scheduleExpression);
        taskUpate.setInstanceId(Long.valueOf(-1L));
        taskUpate.setTenantId(Long.valueOf(-1L));
        RestResponse updateResponse = this.taskApi.modifyById(origTask.getId(), taskUpate);
        logger.info("\u66f4\u65b0\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)updateResponse));
        RestResponse enbaleResponse = this.taskApi.enableById(origTask.getId(), "{}");
        logger.info("\u542f\u7528\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u5b8c\u6bd5\uff0c{}", (Object)JSON.toJSONString((Object)enbaleResponse));
    }

    public void createDeliverTimeLimitTask() {
        logger.info("\u5f00\u59cb\u521b\u5efa\u3010\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u3011\u2026\u2026");
        TaskAndBizCreateReqDto taskAndBizCreate = new TaskAndBizCreateReqDto();
        taskAndBizCreate.setAppCode(this.appCode);
        taskAndBizCreate.setBizCode(SchedulerEnum.DELIVERY_TIME_LIMIT.getBizCode());
        taskAndBizCreate.setBizName(SchedulerEnum.DELIVERY_TIME_LIMIT.getBizName());
        taskAndBizCreate.setParams("");
        taskAndBizCreate.setScheduleExpression(this.scheduleExpression);
        taskAndBizCreate.setShardType("SINGLE");
        taskAndBizCreate.setTaskName(SchedulerEnum.DELIVERY_TIME_LIMIT.getBizName());
        taskAndBizCreate.setTaskDesc("\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1");
        taskAndBizCreate.setInstanceId(Long.valueOf(-1L));
        taskAndBizCreate.setTenantId(Long.valueOf(-1L));
        RestResponse addResult = this.taskApi.addWithBiz(taskAndBizCreate);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        logger.info("\u4ed3\u5e93\u53d1\u8d27\u6548\u7387\u8ba1\u7b97\u5b9a\u65f6\u4efb\u52a1\u521b\u5efa\u6210\u529f\uff01");
    }
}

