/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.aralm;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.yundt.cube.alarm.api.IMonitorDataFetcher;
import com.dtyunxi.yundt.cube.alarm.api.domain.BaseMonitorData;
import com.dtyunxi.yundt.cube.alarm.api.dto.req.MonitorDataFetchReqDto;
import com.dtyunxi.yundt.cube.alarm.domain.AlarmRule;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.IWarehouseCargoQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InventoryRuleMonitorDataFetcherImpl
implements IMonitorDataFetcher {
    private static Logger logger = LoggerFactory.getLogger(InventoryRuleMonitorDataFetcherImpl.class);
    @Resource
    private IOrderQueryApi orderQueryApi;
    @Resource
    private IWarehouseCargoQueryApi warehouseCargoQueryApi;

    public List<BaseMonitorData> fetch(MonitorDataFetchReqDto reqDto) {
        logger.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u8ba1\u7b97\u5f00\u59cb");
        WarehouseCargoReqDto warehouseCargoReqDto = new WarehouseCargoReqDto();
        warehouseCargoReqDto.setUpdateTimeStart(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)DateUtil.addMinutes((Date)new Date(), (int)-10)));
        warehouseCargoReqDto.setUpdateTimeEnd(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date()));
        List list = ((PageInfo)this.warehouseCargoQueryApi.page(warehouseCargoReqDto, Integer.valueOf(1), Integer.valueOf(10000)).getData()).getList();
        logger.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u8ba1\u7b97\u67e5\u8be2\u51fa\u7684\u5e93\u5b58\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        AlarmRule alarmRule = reqDto.getAlarmRule();
        if (null == alarmRule) {
            return null;
        }
        List cargoCodes = list.stream().map(WarehouseCargoRespDto::getCargoCode).collect(Collectors.toList());
        OrderItemReqDto orderItemReqDto = new OrderItemReqDto();
        orderItemReqDto.setCargoCodes(cargoCodes);
        Map extFields = alarmRule.getExtFields();
        orderItemReqDto.setUpdateStartTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)DateUtil.addDays((Date)new Date(), (int)(-(null == extFields ? 7 : (Integer)extFields.get("messageCycle"))))));
        orderItemReqDto.setUpdateEndTime(DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)new Date()));
        List data = (List)this.orderQueryApi.countItem(orderItemReqDto).getData();
        logger.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u8ba1\u7b97\u67e5\u8be2\u51fa\u7684\u9500\u91cf\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)data));
        if (CollectionUtils.isEmpty((Collection)data)) {
            return null;
        }
        ArrayList<BaseMonitorData> baseMonitorDatas = new ArrayList<BaseMonitorData>(list.size());
        Map<String, List<TradeItemRespDto>> cargoMap = data.stream().collect(Collectors.groupingBy(TradeItemRespDto::getCargoSerial));
        list.stream().forEach(c -> {
            String cargoCode = c.getCargoCode();
            BigDecimal available = c.getAvailable();
            if (available.compareTo(BigDecimal.ZERO) != 0) {
                List tradeItemRespDtos = (List)cargoMap.get(cargoCode);
                Integer count = 0;
                if (CollectionUtils.isNotEmpty((Collection)tradeItemRespDtos)) {
                    for (TradeItemRespDto tradeItemRespDto : tradeItemRespDtos) {
                        count = count + tradeItemRespDto.getItemNum();
                    }
                }
                BigDecimal bigDecimal = new BigDecimal(count);
                BigDecimal divide = bigDecimal.divide(available, 2, 4);
                logger.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u8ba1\u7b97\u51fa\u7684\u5546\u54c1\u603b\u6570\u4e3a:{},\u5e93\u5b58\u6570\u4e3a:{}", (Object)bigDecimal, (Object)divide);
                HashMap<String, BigDecimal> vars = new HashMap<String, BigDecimal>();
                vars.put("available", divide);
                BaseMonitorData baseMonitorData = new BaseMonitorData(c.getCargoCode(), vars);
                baseMonitorDatas.add(baseMonitorData);
            }
        });
        logger.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u8ba1\u7b97\u7ec4\u5408\u51fa\u7684\u89c4\u5219\u4e3a\uff1a{}", (Object)JSON.toJSONString(baseMonitorDatas));
        if (CollectionUtils.isEmpty(baseMonitorDatas)) {
            return null;
        }
        logger.info("\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u8ba1\u7b97\u7ec4\u5408\u5b8c\u6210");
        return baseMonitorDatas;
    }
}

