/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IAddressService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.AddressEo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AddressServiceImpl
implements IAddressService {
    @Resource
    private AddressDas addressDas;

    @Override
    public AddressRespDto queryById(Long id) {
        AddressEo addressEo = (AddressEo)this.addressDas.selectByPrimaryKey(id);
        AddressRespDto addressReqDto = (AddressRespDto)EoUtil.eoToDto((BaseEo)addressEo, AddressRespDto.class);
        return addressReqDto;
    }

    @Override
    public AddressRespDto queryByRelatedId(Long id) {
        AddressEo query = (AddressEo)SqlFilterBuilder.create(AddressEo.class).eq("related_id", (Object)id).eo();
        List addresss = this.addressDas.select((BaseEo)query);
        if (CollectionUtils.isNotEmpty((Collection)addresss)) {
            AddressRespDto addressReqDto = (AddressRespDto)EoUtil.eoToDto((BaseEo)((BaseEo)addresss.get(0)), AddressRespDto.class);
            return addressReqDto;
        }
        return null;
    }

    @Override
    public List<AddressRespDto> queryByIds(List<Long> addressId) {
        AddressEo query = (AddressEo)SqlFilterBuilder.create(AddressEo.class).in("id", addressId).eo();
        List addresss = this.addressDas.select((BaseEo)query);
        List AddressRespDtos = EoUtil.eoListToDtoList((Collection)addresss, AddressRespDto.class);
        return AddressRespDtos;
    }
}

