/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ShareStorageStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ShareStorageTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageShareDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageShareTaskReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageShareTaskRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IAsynCargoStorageShareService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageShareTaskDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageShareTaskEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AsynCargoStorageShareServiceImpl
implements IAsynCargoStorageShareService {
    private static Logger logger = LoggerFactory.getLogger(AsynCargoStorageShareServiceImpl.class);
    @Value(value="${asynCargoStorageShareTask.name:\u903b\u8f91\u4ed3\u5e93\u5b58\u6279\u91cf\u5171\u4eab}")
    private String taskName;
    @Resource
    private CargoStorageShareTaskDas shareTaskDas;

    @Override
    public boolean asynCreateShareTask(CargoStorageShareDto shareDto) {
        CargoStorageShareTaskEo shareTaskEo = new CargoStorageShareTaskEo();
        shareTaskEo.setTaskCode(Long.valueOf(IdGenrator.nextId((long)IdGenrator.getWorkerId(), (long)ServiceContext.getContext().getRequestTenantCode())));
        shareTaskEo.setTaskName(this.taskName);
        shareTaskEo.setTaskType(ShareStorageTypeEnum.SHARE_STORAGE.getCode());
        shareTaskEo.setTaskStatus(ShareStorageStatusEnum.EXECUTE_WAIT.getCode());
        shareTaskEo.setTaskRemark(JSONObject.toJSONString((Object)shareDto));
        shareTaskEo.setTaskResult("\u8be5\u8bb0\u5f55\u6682\u65f6\u5c5e\u4e8e\u5f85\u6267\u884c\u72b6\u6001\u4e2d\uff0c\u7b49\u5f85\u5b9a\u65f6\u4efb\u52a1\u6267\u884c...");
        try {
            this.shareTaskDas.insert((BaseEo)shareTaskEo);
            return true;
        }
        catch (Exception e) {
            throw new BizException(InventoryExceptionCode.CARGO_STORAGE_SHARE_TASK_INSERT_FALSE.getCode(), InventoryExceptionCode.CARGO_STORAGE_SHARE_TASK_INSERT_FALSE.getMsg());
        }
    }

    @Override
    public PageInfo<CargoStorageShareTaskRespDto> queryByPage(CargoStorageShareTaskReqDto taskReqDto, Integer pageNum, Integer pageSize) {
        CargoStorageShareTaskEo shareTaskEo = (CargoStorageShareTaskEo)EoUtil.dtoToEo((BaseVo)taskReqDto, CargoStorageShareTaskEo.class);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (Objects.nonNull(shareTaskEo.getTaskCode())) {
            sqlFilterList.add(SqlFilter.like((String)"taskCode", (Object)("%" + shareTaskEo.getTaskCode() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)shareTaskEo.getTaskName())) {
            sqlFilterList.add(SqlFilter.like((String)"taskName", (Object)("%" + shareTaskEo.getTaskName() + "%")));
        }
        if (Objects.nonNull(shareTaskEo.getTaskType())) {
            sqlFilterList.add(SqlFilter.eq((String)"taskType", (Object)shareTaskEo.getTaskType()));
        }
        if (Objects.nonNull(shareTaskEo.getTaskStatus())) {
            sqlFilterList.add(SqlFilter.eq((String)"taskStatus", (Object)shareTaskEo.getTaskStatus()));
        }
        shareTaskEo.setSqlFilters(sqlFilterList);
        shareTaskEo.setOrderByDesc("updateTime");
        PageInfo taskEoPageInfo = this.shareTaskDas.selectPage((BaseEo)shareTaskEo, pageNum, pageSize);
        taskEoPageInfo.setPageNum(pageNum.intValue());
        taskEoPageInfo.setPageSize(pageSize.intValue());
        return EoUtil.eoPageToDtoPage((PageInfo)taskEoPageInfo, CargoStorageShareTaskRespDto.class);
    }

    @Override
    public CargoStorageShareTaskRespDto queryById(Long id) {
        CargoStorageShareTaskEo shareTaskEo = (CargoStorageShareTaskEo)this.shareTaskDas.selectByPrimaryKey(id);
        return (CargoStorageShareTaskRespDto)EoUtil.eoToDto((BaseEo)shareTaskEo, CargoStorageShareTaskRespDto.class);
    }
}

