/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.BillStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.InStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageCategoryEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillPageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.BillReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BillCombineRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BillDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.BillRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IBillService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.WarehouseCargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.BillDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.BillDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.BillDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.BillEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BillServiceImpl
implements IBillService {
    @Resource
    private BillDas billDas;
    @Resource
    private BillDetailDas billDetailDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private StorageOrderDas storageOrderDas;
    @Resource
    private StorageOrderDetailDas storageOrderDetailDas;
    @Resource
    private IWarehouseService wareHouseService;
    @Resource
    private IStorageOrderService storageOrderService;
    @Resource
    private ICargoService cargoService;
    @Resource
    private WarehouseCargoService warehouseCargoService;
    @Resource
    private ICommonsMqService commonsMqService;
    private Long workerId = IdGenrator.getWorkerId();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBill(BillCreateReqDto billReqDto) {
        BillEo billEo;
        if (billReqDto == null || billReqDto.getBillReqDto() == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billReqDto.getBillDetailReqDtos())) {
            throw new InventoryBusinessRuntimeException("\u8d27\u54c1\u5fc5\u9009");
        }
        BillReqDto reqDto = billReqDto.getBillReqDto();
        List billDetailReqDtos = billReqDto.getBillDetailReqDtos();
        WarehouseRespDto warehouseRespDto = null;
        Long warehouseId = reqDto.getWarehouseId();
        warehouseRespDto = Objects.nonNull(warehouseId) ? this.wareHouseService.queryById(warehouseId) : this.wareHouseService.queryByCode(reqDto.getWarehouseCode());
        if (warehouseRespDto == null) {
            throw new BizException(InventoryExceptionCode.WARE_HOUSE_NULL.getCode(), InventoryExceptionCode.WARE_HOUSE_NULL.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getBillNo())) {
            String BillNo = String.valueOf(IdGenrator.nextId((long)this.workerId, (long)ServiceContext.getContext().getRequestTenantCode()));
            reqDto.setBillNo(BillNo);
        }
        if (null == (billEo = (BillEo)EoUtil.dtoToEo((BaseVo)reqDto, BillEo.class)).getStatus()) {
            billEo.setStatus(BillStatusEnum.WAIT_COMMIT.getStatus());
        }
        if (StringUtils.isEmpty((CharSequence)billEo.getBillSrc())) {
            billEo.setBillSrc("\u4e2d\u53f0->\u4e2d\u53f0");
        }
        this.billDas.insert((BaseEo)billEo);
        for (BillDetailReqDto billDetailReqDto : billDetailReqDtos) {
            if (billDetailReqDto.getNum() == null) {
                throw new BizException(InventoryExceptionCode.NUM_NOT_NULL.getCode(), InventoryExceptionCode.NUM_NOT_NULL.getMsg());
            }
            CargoRespDto cargoRespDto = null;
            cargoRespDto = Objects.nonNull(cargoRespDto) ? this.cargoService.getById(billDetailReqDto.getCargoId()) : this.cargoService.getByCode(billDetailReqDto.getCargoCode());
            Assert.notNull(cargoRespDto, "\u8d27\u54c1\u4e0d\u5b58\u5728");
            billDetailReqDto.setInstanceId(billEo.getInstanceId());
            billDetailReqDto.setTenantId(billEo.getTenantId());
            billDetailReqDto.setBillId(billEo.getId());
            billDetailReqDto.setBillNo(billEo.getBillNo());
        }
        this.saveDetailBatch(billDetailReqDtos);
        return billEo.getId();
    }

    private void saveDetailBatch(List<BillDetailReqDto> billDetailReqDtos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billDetailReqDtos)) {
            List detailEos = billDetailReqDtos.stream().map(b -> (BillDetailEo)EoUtil.dtoToEo((BaseVo)b, BillDetailEo.class)).collect(Collectors.toList());
            BillDetailEo detailEo = new BillDetailEo();
            detailEo.setBillId(((BillDetailEo)detailEos.get(0)).getBillId());
            this.billDetailDas.insertBatchByExample(detailEos, (BaseEo)detailEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBill(BillCreateReqDto billReqDto) {
        if (billReqDto == null || billReqDto.getBillReqDto() == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        BillReqDto reqDto = billReqDto.getBillReqDto();
        BillEo billEo = (BillEo)this.billDas.getMapper().findById(BillEo.class, reqDto.getId());
        if (null == billEo) {
            throw new InventoryBusinessRuntimeException("\u8be5\u5355\u636e\u4e0d\u5b58\u5728");
        }
        List billDetailReqDtos = billReqDto.getBillDetailReqDtos();
        CubeBeanUtils.copyProperties((Object)billEo, (Object)reqDto, (String[])new String[0]);
        EoUtil.setNullVal((Object)billEo, (String[])new String[]{"createTime"});
        this.billDas.updateSelective((BaseEo)billEo);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billDetailReqDtos)) {
            for (BillDetailReqDto billDetailReqDto : billDetailReqDtos) {
                if (billDetailReqDto.getNum() == null) {
                    throw new BizException(InventoryExceptionCode.NUM_NOT_NULL.getCode(), InventoryExceptionCode.NUM_NOT_NULL.getMsg());
                }
                CargoRespDto cargoRespDto = this.cargoService.getById(billDetailReqDto.getCargoId());
                Assert.notNull(cargoRespDto, "\u8d27\u54c1\u4e0d\u5b58\u5728");
                billDetailReqDto.setInstanceId(billEo.getInstanceId());
                billDetailReqDto.setTenantId(billEo.getTenantId());
                billDetailReqDto.setBillId(billEo.getId());
                billDetailReqDto.setBillNo(billEo.getBillNo());
            }
            this.saveDetailBatch(billDetailReqDtos);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBill(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillCombineRespDto queryById(Long id) {
        BillCombineRespDto billCombineRespDto = new BillCombineRespDto();
        BillEo billEo = (BillEo)this.billDas.getMapper().findById(BillEo.class, id);
        BillRespDto billReqDto = (BillRespDto)EoUtil.eoToDto((BaseEo)billEo, BillRespDto.class);
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.getMapper().findById(WarehouseEo.class, billReqDto.getWarehouseId());
        if (null != warehouseEo) {
            billReqDto.setWarehouseName(warehouseEo.getName());
        }
        billCombineRespDto.setBillRespDto(billReqDto);
        List billDetailRespDtos = EoUtil.eoListToDtoList((Collection)this.billDetailDas.select(SqlFilterBuilder.create(BillDetailEo.class).eq("bill_id", (Object)id).eo()), BillDetailRespDto.class);
        List<CargoRespDto> cargoRespDtos = this.cargoService.getByIds(billDetailRespDtos.stream().map(BillDetailRespDto::getCargoId).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(cargoRespDtos)) {
            Map<Long, CargoRespDto> cargoRespDtoMap = cargoRespDtos.stream().collect(Collectors.toMap(CargoRespDto::getId, cargoRespDto -> cargoRespDto));
            billCombineRespDto.setBillDetailRespDtos(billDetailRespDtos.stream().map(d -> {
                CargoRespDto cargoRespDto = (CargoRespDto)cargoRespDtoMap.get(d.getCargoId());
                d.setCargoCode(cargoRespDto.getCode());
                d.setCargoName(cargoRespDto.getName());
                d.setArtNo(cargoRespDto.getArtNo());
                ArrayList<Integer> arrayList = new ArrayList<Integer>(){
                    {
                        this.add(BillStatusEnum.SUCCESS.getStatus());
                    }
                };
                if (arrayList.contains(billEo.getStatus())) {
                    d.setActualNum(d.getNum());
                }
                return d;
            }).collect(Collectors.toList()));
        }
        return billCombineRespDto;
    }

    @Override
    public List<BillRespDto> queryByIds(List<Long> billId) {
        BillEo query = (BillEo)SqlFilterBuilder.create(BillEo.class).in("id", billId).eo();
        List bills = this.billDas.select((BaseEo)query);
        List BillRespDtos = EoUtil.eoListToDtoList((Collection)bills, BillRespDto.class);
        return BillRespDtos;
    }

    @Override
    public PageInfo<BillRespDto> queryByPage(BillPageDto billPageReqDto, Integer pageNum, Integer pageSize) {
        List select;
        BillEo queryEo = (BillEo)EoUtil.dtoToEo((BaseVo)billPageReqDto, BillEo.class);
        ArrayList sqlFilters = new ArrayList(4);
        if (StringUtils.isNotEmpty((CharSequence)billPageReqDto.getBillSrc())) {
            sqlFilters.addAll(SqlFilterBuilder.create(BillEo.class).like("Bill_src", (Object)("%" + billPageReqDto.getBillSrc() + "%")).filters());
            queryEo.setBillSrc(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)billPageReqDto.getBillNo())) {
            sqlFilters.addAll(SqlFilterBuilder.create(BillEo.class).like("Bill_no", (Object)("%" + billPageReqDto.getBillNo() + "%")).filters());
            queryEo.setBillNo(null);
        }
        if (null != billPageReqDto.getBusinessId()) {
            sqlFilters.addAll(SqlFilterBuilder.create(BillEo.class).like("business_id", (Object)("%" + billPageReqDto.getBusinessId() + "%")).filters());
            queryEo.setBusinessId(null);
        }
        if (null != billPageReqDto.getBillSrcId()) {
            sqlFilters.addAll(SqlFilterBuilder.create(BillEo.class).like("Bill_src_id", (Object)("%" + billPageReqDto.getBillSrcId() + "%")).filters());
            queryEo.setBillSrcId(null);
        }
        if (null != billPageReqDto.getCreateStartTime() && null != billPageReqDto.getCreateEndTime()) {
            sqlFilters.addAll(SqlFilterBuilder.create(BillEo.class).ge("create_time", (Object)billPageReqDto.getCreateStartTime()).le("update_time", (Object)billPageReqDto.getCreateEndTime()).filters());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(sqlFilters)) {
            queryEo.setSqlFilters(sqlFilters);
        }
        queryEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.billDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        PageInfo billRespDtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, BillRespDto.class);
        List dtoPageInfoList = billRespDtoPageInfo.getList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)dtoPageInfoList) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(select = this.warehouseDas.select(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join((Iterable)dtoPageInfoList.stream().map(BillRespDto::getWarehouseId).collect(Collectors.toList()), (String)",")).eo())))) {
            Map<Long, String> nameMap = select.stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getName));
            dtoPageInfoList.stream().forEach(d -> d.setWarehouseName((String)nameMap.get(d.getWarehouseId())));
            billRespDtoPageInfo.setList(dtoPageInfoList);
        }
        return billRespDtoPageInfo;
    }

    @Override
    public void auditBill(Long id, Integer status, String name) {
        BillEo billEo = (BillEo)this.billDas.getMapper().findById(BillEo.class, id);
        if (new ArrayList<Integer>(){
            {
                this.add(BillStatusEnum.TOBE_DELIVERED.getStatus());
                this.add(BillStatusEnum.AUDIT_NO_PASS.getStatus());
            }
        }.contains(status)) {
            billEo.setAuditPerson(name);
            billEo.setAuditTime(new Date());
        }
        String category = billEo.getCategory();
        List billDetailEos = this.billDetailDas.select(SqlFilterBuilder.create(BillDetailEo.class).eq("bill_id", (Object)id).eo());
        if (BillStatusEnum.TOBE_DELIVERED.getStatus().equals(status)) {
            if (!"1".equals(category)) {
                this.saveStorageOrder(billEo, billDetailEos, StorageCategoryEnum.CATEGORY_OUT.getCategory(), 7);
                if ("3".equals(category)) {
                    ArrayList<BillDetailEo> winEos = new ArrayList<BillDetailEo>();
                    ArrayList<BillDetailEo> deficitEos = new ArrayList<BillDetailEo>();
                    billDetailEos.forEach(b -> {
                        if (b.getNum() > 0L) {
                            winEos.add((BillDetailEo)b);
                        } else {
                            deficitEos.add((BillDetailEo)b);
                        }
                    });
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(winEos)) {
                        this.saveStorageOrder(billEo, winEos, StorageCategoryEnum.CATEGORY_IN.getCategory(), 12);
                    }
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deficitEos)) {
                        this.saveStorageOrder(billEo, deficitEos, StorageCategoryEnum.CATEGORY_OUT.getCategory(), 5);
                    }
                }
            }
            status = BillStatusEnum.SUCCESS.getStatus();
            this.warehouseCargoService.subCargoStorage(billDetailEos.stream().map(b -> {
                CargoStorageInfoCreateReqDto dto = (CargoStorageInfoCreateReqDto)EoUtil.eoToDto((BaseEo)b, CargoStorageInfoCreateReqDto.class);
                dto.setNum(new BigDecimal(b.getNum()).negate());
                dto.setType(Integer.valueOf(2));
                return dto;
            }).collect(Collectors.toList()));
            MessageVo messageVo = new MessageVo();
            messageVo.setData(billDetailEos.stream().map(b -> {
                InventoryCountDto dto = new InventoryCountDto();
                dto.setWarehouseId(b.getWarehouseId());
                dto.setCargoId(b.getCargoId());
                dto.setNum(new BigDecimal(b.getNum()).negate());
                dto.setNo(TradeUtil.generateTradeNo(b.getCargoId().toString()));
                return dto;
            }).collect(Collectors.toList()));
            this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)messageVo);
        }
        billEo.setStatus(status);
        this.billDas.updateSelective((BaseEo)billEo);
    }

    private void saveStorageOrder(BillEo billEo, List<BillDetailEo> billDetailEos, String category, Integer type) {
        StorageOrderCreateDto dto = new StorageOrderCreateDto();
        StorageOrderReqDto storageOrderReqDto = (StorageOrderReqDto)EoUtil.eoToDto((BaseEo)billEo, StorageOrderReqDto.class);
        storageOrderReqDto.setBusinessId(billEo.getId().toString());
        storageOrderReqDto.setCategory(category);
        storageOrderReqDto.setWarehouseId(((WarehouseEo)this.warehouseDas.getMapper().findById(WarehouseEo.class, billEo.getWarehouseId())).getParentId());
        storageOrderReqDto.setType(type);
        storageOrderReqDto.setId(null);
        storageOrderReqDto.setStatus(InStorageOrderStatusEnum.FINISH.getStatus());
        storageOrderReqDto.setOrderSrc("\u7b2c\u4e09\u65b9->\u4e2d\u53f0");
        dto.setStorageOrderReqDto(storageOrderReqDto);
        dto.setStorageOrderDetailReqDtoList(billDetailEos.stream().map(b -> {
            StorageOrderDetailReqDto storageOrderDetailReqDto = (StorageOrderDetailReqDto)EoUtil.eoToDto((BaseEo)b, StorageOrderDetailReqDto.class);
            storageOrderDetailReqDto.setOrderId(b.getBillId());
            storageOrderDetailReqDto.setOrderNo(b.getBillNo());
            storageOrderDetailReqDto.setId(null);
            return storageOrderDetailReqDto;
        }).collect(Collectors.toList()));
        Long storageOrderId = this.storageOrderService.addStorageOrder(dto);
        StorageOrderEo storageOrderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)storageOrderId);
        List orderDetailEos = this.storageOrderDetailDas.select(SqlFilterBuilder.create(StorageOrderDetailEo.class).eq("order_id", (Object)storageOrderId).eo());
        this.storageOrderService.updateCargoStorage(storageOrderEo, orderDetailEos);
    }
}

