/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderPackageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CargoOrderDeliveryServiceImpl
implements ICargoOrderDeliveryService {
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private IPackageService packageService;

    @Override
    public List<OrderPackageRespDto> queryStorageOutPackage(List<String> orderNos) {
        ArrayList<OrderPackageRespDto> orderPackageRespDtos = new ArrayList<OrderPackageRespDto>();
        List orderEos = this.orderDeliveryDas.getByTradeOrderNo(orderNos);
        Set<Long> deliveryIds = orderEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
        List<PackageDto> packageDtos = this.packageService.queryByDeliveryIds(deliveryIds);
        List<PackageDetailDto> packageDetailDtos = this.packageService.queryDetailByPackageIds(this.getPackageIds(packageDtos));
        if (packageDetailDtos != null) {
            for (PackageDto packageDto : packageDtos) {
                packageDto.setPackageDetailDtos(this.getByPackageId(packageDetailDtos, packageDto.getId()));
                OrderPackageRespDto orderPackageRespDto = new OrderPackageRespDto();
                orderPackageRespDto.setOrderNo(this.getOrderNoByDeliveryId(orderEos, packageDto.getDeliveryOrderId()));
                orderPackageRespDto.setPackageDto(packageDto);
                orderPackageRespDtos.add(orderPackageRespDto);
            }
        }
        return orderPackageRespDtos;
    }

    @Override
    public List<OrderPackageRespDto> queryAllPackage(List<String> orderNoList) {
        ArrayList<OrderPackageRespDto> orderPackageRespDtos = new ArrayList<OrderPackageRespDto>();
        List<PackageDto> packageDtos = this.packageService.queryByOrderNos(orderNoList);
        List<PackageDetailDto> packageDetailDtos = this.packageService.queryDetailByPackageIds(this.getPackageIds(packageDtos));
        if (packageDetailDtos != null) {
            for (PackageDto packageDto : packageDtos) {
                packageDto.setPackageDetailDtos(this.getByPackageId(packageDetailDtos, packageDto.getId()));
                OrderPackageRespDto orderPackageRespDto = new OrderPackageRespDto();
                orderPackageRespDto.setPackageDto(packageDto);
                orderPackageRespDtos.add(orderPackageRespDto);
            }
        }
        return orderPackageRespDtos;
    }

    @Override
    public List<PackageShippingLogRespDto> queryPackageLog(List<String> orderNoList) {
        ArrayList<PackageShippingLogRespDto> packageShippingLogRespDto = new ArrayList<PackageShippingLogRespDto>();
        List<PackageDto> packageDtos = this.packageService.queryByOrderNos(orderNoList);
        for (PackageDto packageDto : packageDtos) {
            PackageShippingLogRespDto packageShippingLog = this.packageService.queryPackLog(packageDto);
            if (packageShippingLog == null) {
                packageShippingLog = new PackageShippingLogRespDto();
                packageShippingLog.setPack(packageDto);
            }
            packageShippingLogRespDto.add(packageShippingLog);
        }
        return packageShippingLogRespDto;
    }

    Set<Long> getPackageIds(List<PackageDto> packageDtos) {
        HashSet<Long> packageIds = new HashSet<Long>();
        if (packageDtos != null) {
            for (PackageDto packageDto : packageDtos) {
                packageIds.add(packageDto.getId());
            }
        }
        return packageIds;
    }

    private List<PackageDetailDto> getByPackageId(List<PackageDetailDto> packageDetailDtos, Long packageId) {
        ArrayList<PackageDetailDto> packageDetails = new ArrayList<PackageDetailDto>();
        for (PackageDetailDto packageDetailDto : packageDetailDtos) {
            if (!packageDetailDto.getPackageId().equals(packageId)) continue;
            packageDetails.add(packageDetailDto);
        }
        return packageDetails;
    }

    private String getOrderNoByDeliveryId(List<OrderDeliveryEo> orderEos, Long deliveryId) {
        for (OrderDeliveryEo orderEo : orderEos) {
            if (!orderEo.getId().equals(deliveryId)) continue;
            return orderEo.getDeliveryNo();
        }
        return null;
    }
}

