/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CargoServiceImpl
implements ICargoService {
    private static Logger logger = LoggerFactory.getLogger(CargoServiceImpl.class);
    @Resource
    private CargoDas cargoDas;
    @Resource
    private CargoStorageDas cargoStorageDas;

    @Override
    public Long addCargo(CargoCreateReqDto cargoCreateReqDto) {
        this.checkData(cargoCreateReqDto);
        CargoEo cargoEo = new CargoEo();
        BeanUtils.copyProperties((Object)cargoCreateReqDto, (Object)cargoEo);
        this.cargoDas.insert((BaseEo)cargoEo);
        return cargoEo.getId();
    }

    private void checkData(CargoCreateReqDto cargoCreateReqDto) {
        if (StringUtils.isEmpty((CharSequence)cargoCreateReqDto.getCode())) {
            throw new BizException("\u8d27\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)cargoCreateReqDto.getName())) {
            throw new BizException("\u8d27\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CargoEo cargoEoSelect = new CargoEo();
        cargoEoSelect.setCode(cargoCreateReqDto.getCode());
        CargoEo cargo = (CargoEo)this.cargoDas.selectOne((BaseEo)cargoEoSelect);
        if (null != cargo) {
            throw new BizException("\u8be5\u8d27\u54c1\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8d27\u54c1\u7f16\u53f7\uff01");
        }
    }

    @Override
    public void modifyCargo(CargoUpdateReqDto cargoUpdateReqDto) {
        boolean ifUpdateCargoStorage;
        logger.info("\u66f4\u65b0\u8d27\u54c1\u4fe1\u606fcargoUpdateReqDto\uff1a{}", (Object)JSON.toJSONString((Object)cargoUpdateReqDto));
        CargoEo cargoSelect = (CargoEo)this.cargoDas.selectByPrimaryKey(cargoUpdateReqDto.getId());
        if (null == cargoSelect) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u8d27\u54c1\u4fe1\u606f\uff01");
        }
        CargoEo cargoEo = new CargoEo();
        BeanUtils.copyProperties((Object)cargoUpdateReqDto, (Object)cargoEo);
        this.cargoDas.updateSelective((BaseEo)cargoEo);
        boolean bl = ifUpdateCargoStorage = StringUtils.isNotEmpty((CharSequence)cargoUpdateReqDto.getName()) && !cargoUpdateReqDto.getName().equals(cargoSelect.getName()) || StringUtils.isNotEmpty((CharSequence)cargoUpdateReqDto.getArtNo()) && !cargoUpdateReqDto.getArtNo().equals(cargoSelect.getArtNo());
        if (ifUpdateCargoStorage) {
            CargoStorageEo cargoStorageEo = new CargoStorageEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"cargoId", (Object)cargoUpdateReqDto.getId()));
            cargoStorageEo.setSqlFilters(sqlFilterList);
            cargoStorageEo.setCargoName(cargoUpdateReqDto.getName());
            cargoStorageEo.setArtNo(cargoUpdateReqDto.getArtNo());
            int num = this.cargoStorageDas.updateSelectiveSqlFilter((BaseEo)cargoStorageEo);
            logger.info("\u66f4\u65b0\u5173\u8054\u4ed3\u5e93\u8d27\u54c1\u6570\uff1a{},cargoId:{}", (Object)num, (Object)cargoUpdateReqDto.getId());
        }
    }

    @Override
    public void removeById(Long id) {
        this.cargoDas.logicDeleteById(id);
    }

    @Override
    public void removeByCode(String code) {
        CargoEo cargoEo = new CargoEo();
        cargoEo.setCode(code);
        List cargoEos = this.cargoDas.select((BaseEo)cargoEo);
        for (CargoEo cargo1 : cargoEos) {
            this.cargoDas.logicDeleteById(cargo1.getId());
        }
    }

    @Override
    public CargoRespDto getById(Long id) {
        CargoEo cargoEo = (CargoEo)this.cargoDas.selectByPrimaryKey(id);
        if (null != cargoEo) {
            CargoRespDto cargoRespDto = new CargoRespDto();
            DtoHelper.eo2Dto((BaseEo)cargoEo, (BaseVo)cargoRespDto);
            return cargoRespDto;
        }
        return null;
    }

    @Override
    public List<CargoRespDto> getByIds(List<Long> ids) {
        return EoUtil.eoListToDtoList((Collection)this.cargoDas.select(SqlFilterBuilder.create(CargoEo.class).in("id", (Object)StringUtils.join(ids, (String)",")).eo()), CargoRespDto.class);
    }

    @Override
    public CargoRespDto getById(Long id, Long tenantId, Long instanceId) {
        CargoEo cargo = new CargoEo();
        cargo.setId(id);
        cargo.setTenantId(tenantId);
        cargo.setInstanceId(instanceId);
        CargoEo cargoEo = (CargoEo)this.cargoDas.selectOne((BaseEo)cargo);
        if (null != cargoEo) {
            CargoRespDto cargoRespDto = new CargoRespDto();
            DtoHelper.eo2Dto((BaseEo)cargoEo, (BaseVo)cargoRespDto);
            return cargoRespDto;
        }
        return null;
    }

    @Override
    public CargoRespDto getByCode(String code) {
        CargoEo select = new CargoEo();
        select.setCode(code);
        CargoEo cargoEo = (CargoEo)this.cargoDas.selectOne((BaseEo)select);
        if (null == cargoEo) {
            return null;
        }
        CargoRespDto cargoRespDto = new CargoRespDto();
        BeanUtils.copyProperties((Object)cargoEo, (Object)cargoRespDto);
        return cargoRespDto;
    }

    @Override
    public List<CargoRespDto> listByCodes(List<String> cargoCodes) {
        CargoEo select = new CargoEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", cargoCodes));
        select.setSqlFilters(sqlFilters);
        List eos = this.cargoDas.select((BaseEo)select, Integer.valueOf(1), Integer.valueOf(cargoCodes.size()));
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return null;
        }
        ArrayList<CargoRespDto> dtos = new ArrayList<CargoRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtos, CargoRespDto.class);
        return dtos;
    }

    @Override
    public PageInfo<CargoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo cargoRespDtoPageInfo = new PageInfo();
        cargoRespDtoPageInfo.setPageNum(pageNum.intValue());
        cargoRespDtoPageInfo.setPageSize(pageSize.intValue());
        CargoQueryReqDto cargoQueryReqDto = (CargoQueryReqDto)JSON.parseObject((String)filter, CargoQueryReqDto.class);
        CargoEo cargoEo = new CargoEo();
        if (null != cargoQueryReqDto) {
            DtoHelper.dto2Eo((BaseVo)cargoQueryReqDto, (BaseEo)cargoEo);
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getName())) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + cargoQueryReqDto.getName() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getCode())) {
            sqlFilterList.add(SqlFilter.like((String)"code", (Object)("%" + cargoQueryReqDto.getCode() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getArtNo())) {
            sqlFilterList.add(SqlFilter.like((String)"artNo", (Object)("%" + cargoQueryReqDto.getArtNo() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getBrandCode())) {
            sqlFilterList.add(SqlFilter.eq((String)"brandCode", (Object)cargoQueryReqDto.getBrandCode()));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getCustomerNo())) {
            sqlFilterList.add(SqlFilter.eq((String)"customerNo", (Object)cargoQueryReqDto.getCustomerNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getUpdateTimeStart())) {
            sqlFilterList.add(SqlFilter.ge((String)"updateTime", (Object)cargoQueryReqDto.getUpdateTimeStart()));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoQueryReqDto.getUpdateTimeEnd())) {
            sqlFilterList.add(SqlFilter.le((String)"updateTime", (Object)cargoQueryReqDto.getUpdateTimeEnd()));
        }
        cargoEo.setSqlFilters(sqlFilterList);
        cargoEo.setOrderByDesc("updateTime");
        PageInfo cargoEoPageInfo = this.cargoDas.selectPage((BaseEo)cargoEo, pageNum, pageSize);
        if (null == cargoEoPageInfo) {
            return cargoRespDtoPageInfo;
        }
        cargoRespDtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)cargoEoPageInfo, CargoRespDto.class);
        return cargoRespDtoPageInfo;
    }

    @Override
    public List<CargoRespDto> queryByList(String filter) {
        CargoQueryReqDto cargoQueryReqDto = (CargoQueryReqDto)JSON.parseObject((String)filter, CargoQueryReqDto.class);
        CargoEo cargoEo = new CargoEo();
        if (null != cargoQueryReqDto) {
            DtoHelper.dto2Eo((BaseVo)cargoQueryReqDto, (BaseEo)cargoEo);
        }
        List cargoEos = this.cargoDas.select((BaseEo)cargoEo);
        ArrayList<CargoRespDto> cargoRespDtos = new ArrayList<CargoRespDto>();
        if (cargoEos.size() != 0) {
            DtoHelper.eoList2DtoList((Collection)cargoEos, cargoRespDtos, CargoRespDto.class);
        }
        return cargoRespDtos;
    }

    @Override
    public List<CargoEo> queryByCargoEo(CargoEo cargoEo) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)cargoEo.getName())) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)("%" + cargoEo.getName() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoEo.getCode())) {
            sqlFilterList.add(SqlFilter.like((String)"code", (Object)("%" + cargoEo.getCode() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoEo.getCustomerNo())) {
            sqlFilterList.add(SqlFilter.in((String)"customerNo", (Object)cargoEo.getCustomerNo()));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoEo.getArtNo())) {
            sqlFilterList.add(SqlFilter.like((String)"artNo", (Object)("%" + cargoEo.getArtNo() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)cargoEo.getBarCode())) {
            sqlFilterList.add(SqlFilter.like((String)"barCode", (Object)("%" + cargoEo.getBarCode() + "%")));
        }
        cargoEo.setSqlFilters(sqlFilterList);
        List cargoEoList = this.cargoDas.select((BaseEo)cargoEo);
        logger.info("\u901a\u8fc7\u8d27\u54c1\u53c2\u6570\u67e5\u8be2\u8d27\u54c1\u96c6\u5408\uff0c\u8d27\u54c1\u53c2\u6570\u4e3a\uff1a{}\uff0c\u67e5\u8be2\u5230\u8d27\u54c1\u96c6\u5408\u6570\u91cf\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)cargoEo), (Object)cargoEoList.size());
        return cargoEoList;
    }
}

