/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageInfoQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.CargoStorageServiceImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.CargoStorageCacheUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RAreaWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageCheckConfigDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RAreaWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RServiceAreaEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageCheckConfigEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CargoStorageQueryServiceImpl
implements ICargoStorageQueryService {
    private Logger logger = LoggerFactory.getLogger(CargoStorageQueryServiceImpl.class);
    @Resource
    private ICargoService cargoService;
    @Resource
    private StorageCheckConfigDas storageCheckConfigDas;
    @Resource
    private CargoStorageCacheUtils cargoStorageCacheUtils;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private RServiceAreaDas rServiceAreaDas;
    @Resource
    private RAreaWarehouseDas rAreaWarehouseDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private CargoStorageServiceImpl cargoStorageServiceImpl;

    @Override
    public CargoStorageQueryRespDto queryCargoStorage(CargoStorageQueryReqDto cargoStorageQueryReqDto) {
        if (cargoStorageQueryReqDto == null || CollectionUtils.isEmpty((Collection)cargoStorageQueryReqDto.getCargoStorageList()) || cargoStorageQueryReqDto.getInstanceId() == null || cargoStorageQueryReqDto.getTenantId() == null) {
            this.logger.info("CargoStorageQueryReqDto:{}", (Object)JSON.toJSONString((Object)cargoStorageQueryReqDto));
            InventoryBusinessRuntimeException.parameterError();
        }
        List cargoStorageQueryReqDtoCargoList = cargoStorageQueryReqDto.getCargoStorageList();
        ArrayList<CargoStorageInfoQueryRespDto> cargoStorageInfoQueryRespDtoList = new ArrayList<CargoStorageInfoQueryRespDto>(cargoStorageQueryReqDtoCargoList.size());
        for (CargoStorageInfoQueryReqDto cargoStorageInfoQueryReqDto : cargoStorageQueryReqDtoCargoList) {
            CargoStorageEo cargoStorageEo = this.queryCargoStorageNum(cargoStorageQueryReqDto.getProvCode(), cargoStorageQueryReqDto.getCityCode(), cargoStorageQueryReqDto.getAreaCode(), cargoStorageInfoQueryReqDto, cargoStorageQueryReqDto.getInstanceId(), cargoStorageQueryReqDto.getTenantId());
            CargoStorageInfoQueryRespDto cargoStorageInfoQueryRespDto = new CargoStorageInfoQueryRespDto();
            BeanUtils.copyProperties((Object)cargoStorageInfoQueryReqDto, (Object)cargoStorageInfoQueryRespDto);
            cargoStorageInfoQueryRespDto.setNum(cargoStorageEo.getAvailable());
            cargoStorageInfoQueryRespDto.setAvailable(cargoStorageEo.getAvailable());
            cargoStorageInfoQueryRespDto.setBalance(cargoStorageEo.getBalance());
            cargoStorageInfoQueryRespDto.setPreempt(cargoStorageEo.getPreempt());
            cargoStorageInfoQueryRespDtoList.add(cargoStorageInfoQueryRespDto);
        }
        CargoStorageQueryRespDto cargoStorageQueryRespDto = new CargoStorageQueryRespDto();
        cargoStorageQueryRespDto.setCargoStorageList(cargoStorageInfoQueryRespDtoList);
        return cargoStorageQueryRespDto;
    }

    @Override
    public PageInfo<CargoStorageDetailQueryRespDto> queryCargoStorageDetail(CargoStorageDetailQueryReqDto cargoStorageDetailQueryReqDto, Integer pageNum, Integer pageSize) {
        if (cargoStorageDetailQueryReqDto == null || cargoStorageDetailQueryReqDto.getInstanceId() == null || cargoStorageDetailQueryReqDto.getTenantId() == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        BeanUtils.copyProperties((Object)cargoStorageDetailQueryReqDto, (Object)cargoStorageEo);
        cargoStorageEo.setOrderByDesc("updateTime");
        PageInfo pageInfo = this.cargoStorageDas.selectPage((BaseEo)cargoStorageEo, pageNum, pageSize);
        List cargoStorageEoList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)cargoStorageEoList)) {
            return new PageInfo();
        }
        PageInfo rePageInfo = EoUtil.eoPageToDtoPage((PageInfo)pageInfo, CargoStorageDetailQueryRespDto.class);
        return rePageInfo;
    }

    private CargoStorageEo queryCargoStorageNum(String provCode, String cityCode, String areaCode, CargoStorageInfoQueryReqDto cargoStorageInfoDto, Long instanceId, Long tenantId) {
        if (cargoStorageInfoDto.getCargoId() == null && cargoStorageInfoDto.getCargoCode() == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        CargoStorageEo result = null;
        if (cargoStorageInfoDto.getWarehouseId() == null && cargoStorageInfoDto.getWarehouseCode() == null) {
            CargoRespDto cargoRespDto = this.cargoService.getById(cargoStorageInfoDto.getCargoId(), tenantId, instanceId);
            if (cargoRespDto == null) {
                throw new BizException(InventoryExceptionCode.CARGO_NOT_EXIST.getCode(), InventoryExceptionCode.CARGO_NOT_EXIST.getMsg());
            }
            StorageCheckConfigEo storageCheckConfigEo = (StorageCheckConfigEo)this.storageCheckConfigDas.selectByPrimaryKey(cargoRespDto.getCheckConfigId());
            if (storageCheckConfigEo == null) {
                throw new BizException(InventoryExceptionCode.CARGO_NOT_SPLIT.getCode(), InventoryExceptionCode.CARGO_NOT_SPLIT.getMsg());
            }
            WarehouseEo warehouseEo = new WarehouseEo();
            warehouseEo.setInstanceId(instanceId);
            warehouseEo.setTenantId(tenantId);
            if (WarehouseTypeEnum.GENERAL.getType().equals(storageCheckConfigEo.getType())) {
                warehouseEo.setType(WarehouseTypeEnum.GENERAL.getType());
                warehouseEo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
                Assert.notNull(warehouseEo, "\u627e\u4e0d\u5230\u8be5\u79df\u6237\u548c\u5b9e\u4f8b\u7684\u603b\u4ed3");
            } else if (WarehouseTypeEnum.SEPARATE.getType().equals(storageCheckConfigEo.getType())) {
                RServiceAreaEo rServiceAreaEo;
                if (StringUtils.isEmpty((CharSequence)provCode) || StringUtils.isEmpty((CharSequence)cityCode) || StringUtils.isEmpty((CharSequence)areaCode)) {
                    InventoryBusinessRuntimeException.parameterError();
                }
                if ((rServiceAreaEo = this.queryRServiceArea(provCode, cityCode, areaCode)) == null) {
                    return null;
                }
                RAreaWarehouseEo rAreaWarehouseEo = this.queryRAreaWarehouseEo(rServiceAreaEo.getServiceAreaId());
                if (rAreaWarehouseEo == null) {
                    return null;
                }
                warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(rAreaWarehouseEo.getWarehouseId());
            } else if (WarehouseTypeEnum.WHOLE.getType().equals(storageCheckConfigEo.getType())) {
                warehouseEo.setType(WarehouseTypeEnum.WHOLE.getType());
                warehouseEo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
            }
            if (warehouseEo == null) {
                return null;
            }
            cargoStorageInfoDto.setWarehouseId(warehouseEo.getId());
            if (WarehouseTypeEnum.WHOLE.getType().equals(warehouseEo.getType())) {
                warehouseEo.setType(WarehouseTypeEnum.SEPARATE.getType());
                List warehouseEoList = this.warehouseDas.select((BaseEo)warehouseEo);
                CargoStorageEo sumCargoStorage = new CargoStorageEo();
                sumCargoStorage.setCargoId(cargoStorageInfoDto.getCargoId());
                sumCargoStorage.setCargoCode(cargoStorageInfoDto.getCargoCode());
                sumCargoStorage.setWarehouseId(warehouseEo.getId());
                sumCargoStorage.setWarehouseCode(warehouseEo.getCode());
                sumCargoStorage.setPreempt(new BigDecimal(0L));
                sumCargoStorage.setAvailable(new BigDecimal(0L));
                sumCargoStorage.setBalance(new BigDecimal(0L));
                Long num = 0L;
                for (WarehouseEo warehouseQueryEo : warehouseEoList) {
                    CargoStorageEo cargoStorageEo = this.queryCargoStorageNum(warehouseQueryEo.getId(), cargoStorageInfoDto.getCargoId(), cargoStorageInfoDto.getCargoCode(), cargoStorageInfoDto.getWarehouseCode());
                    sumCargoStorage.setPreempt(sumCargoStorage.getPreempt().add(cargoStorageEo.getPreempt()));
                    sumCargoStorage.setAvailable(sumCargoStorage.getAvailable().add(cargoStorageEo.getAvailable()));
                    sumCargoStorage.setBalance(sumCargoStorage.getBalance().add(cargoStorageEo.getBalance()));
                }
                result = sumCargoStorage;
            } else {
                result = this.queryCargoStorageNum(cargoStorageInfoDto.getWarehouseId(), cargoStorageInfoDto.getCargoId(), cargoStorageInfoDto.getCargoCode(), cargoStorageInfoDto.getWarehouseCode());
            }
        } else {
            result = this.queryCargoStorageNum(cargoStorageInfoDto.getWarehouseId(), cargoStorageInfoDto.getCargoId(), cargoStorageInfoDto.getCargoCode(), cargoStorageInfoDto.getWarehouseCode());
        }
        return result;
    }

    private RAreaWarehouseEo queryRAreaWarehouseEo(Long serviceAreaId) {
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setServiceAreaId(serviceAreaId);
        return (RAreaWarehouseEo)this.rAreaWarehouseDas.selectOne((BaseEo)rAreaWarehouseEo);
    }

    private RServiceAreaEo queryRServiceArea(String provCode, String cityCode, String areaCode) {
        RServiceAreaEo rServiceAreaEo = new RServiceAreaEo();
        rServiceAreaEo.setProvCode(provCode);
        rServiceAreaEo.setCityCode(cityCode);
        rServiceAreaEo.setAreaCode(areaCode);
        List rServiceAreaEoList = this.rServiceAreaDas.select((BaseEo)rServiceAreaEo);
        if (CollectionUtils.isNotEmpty((Collection)rServiceAreaEoList)) {
            return (RServiceAreaEo)rServiceAreaEoList.get(0);
        }
        rServiceAreaEo.setAreaCode(null);
        rServiceAreaEoList = this.rServiceAreaDas.select((BaseEo)rServiceAreaEo);
        if (CollectionUtils.isNotEmpty((Collection)rServiceAreaEoList)) {
            return (RServiceAreaEo)rServiceAreaEoList.get(0);
        }
        rServiceAreaEo.setCityCode(null);
        rServiceAreaEoList = this.rServiceAreaDas.select((BaseEo)rServiceAreaEo);
        if (CollectionUtils.isNotEmpty((Collection)rServiceAreaEoList)) {
            return (RServiceAreaEo)rServiceAreaEoList.get(0);
        }
        return null;
    }

    private CargoStorageEo queryCargoStorageNum(Long warehouseId, Long cargoId, String cargoCode, String warehouseCode) {
        long num = 0L;
        if (warehouseId == null && StringUtils.isEmpty((CharSequence)warehouseCode) || cargoId == null && StringUtils.isEmpty((CharSequence)cargoCode)) {
            throw new BizException(ExceptionCode.INVALID_PARAM.getCode(), ExceptionCode.INVALID_PARAM.getMsg());
        }
        CargoStorageEo cargoStorageQuery = new CargoStorageEo();
        cargoStorageQuery.setWarehouseId(warehouseId);
        cargoStorageQuery.setCargoId(cargoId);
        cargoStorageQuery.setWarehouseCode(warehouseCode);
        cargoStorageQuery.setCargoCode(cargoCode);
        List cargoStorageEoList = this.cargoStorageDas.select((BaseEo)cargoStorageQuery);
        if (CollectionUtils.isEmpty((Collection)cargoStorageEoList)) {
            CargoStorageEo cargoStorageEo = new CargoStorageEo();
            BigDecimal balance = new BigDecimal("0");
            BigDecimal preempt = new BigDecimal("0");
            BigDecimal available = new BigDecimal("0");
            cargoStorageEo.setBalance(balance);
            cargoStorageEo.setPreempt(preempt);
            cargoStorageEo.setAvailable(available);
            return cargoStorageEo;
        }
        CargoStorageEo cargoStorageEo = (CargoStorageEo)cargoStorageEoList.get(0);
        BigDecimal balance = new BigDecimal("0");
        BigDecimal preempt = new BigDecimal("0");
        BigDecimal available = new BigDecimal("0");
        for (CargoStorageEo storageEo : cargoStorageEoList) {
            balance = balance.add(storageEo.getBalance());
            available = available.add(storageEo.getAvailable());
            if (!Objects.nonNull(storageEo.getPreempt())) continue;
            preempt = preempt.add(storageEo.getPreempt());
        }
        cargoStorageEo.setBalance(balance);
        cargoStorageEo.setPreempt(preempt);
        cargoStorageEo.setAvailable(available);
        return cargoStorageEo;
    }
}

