/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageChangeStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStoragePreemptConfirmReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageRestReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustCoverReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.UpdateStorageSynNumReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageInfoQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.NewInventoryCountProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.MqUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.CargoStorageChangeVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageAdjustService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.StockDsl;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.CargoStorageCacheUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CargoStorageServiceImpl
implements ICargoStorageService {
    private static final Logger logger = LoggerFactory.getLogger(CargoStorageServiceImpl.class);
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private CargoStorageCacheUtils cargoStorageCacheUtils;
    @Resource
    private ICargoStorageQueryService cargoStorageQueryService;
    @Resource
    private CargoDas cargoDas;
    @Resource
    private ICargoStorageService cargoStorageService;
    @Resource
    private MqUtils mqUtils;
    @Resource
    private ICacheService cacheService;
    @Resource
    private NewInventoryCountProducer newInventoryCountProducer;
    @Resource
    private StockDsl stockDsl;
    @Resource
    private IStorageAdjustService storageAdjustService;
    @Resource
    private WarehouseDas wareHouseDas;

    @Override
    public List<CargoStorageEo> queryCargoStorageList(Long instanceId, Long tenantId, Long cargoId, Long warehouseId) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setWarehouseId(warehouseId);
        cargoStorageEo.setCargoId(cargoId);
        cargoStorageEo.setInstanceId(instanceId);
        cargoStorageEo.setTenantId(tenantId);
        return this.cargoStorageDas.select((BaseEo)cargoStorageEo);
    }

    @Override
    @Transactional
    public void modifyStorageChange(List<StorageChangeLogEo> storageChangeLogEoList, String status, Boolean syn) {
        for (StorageChangeLogEo storageChangeLogEo : storageChangeLogEoList) {
            storageChangeLogEo.setStatus(StorageChangeStatusEnum.INIT.getStatus());
        }
        this.storageChangeLogDas.insertBatch(storageChangeLogEoList);
        if (syn.booleanValue()) {
            this.modifyStorageChange(storageChangeLogEoList, status);
        } else {
            CargoStorageChangeVo cargoStorageChangeVo = new CargoStorageChangeVo();
            cargoStorageChangeVo.setStatus(status);
            cargoStorageChangeVo.setStorageChangeList(storageChangeLogEoList);
            this.mqUtils.sendCargoStorageChangeMq(cargoStorageChangeVo);
        }
    }

    private int countChange(String orderNo, String type, String status) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setChangeType(type);
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setStatus(status);
        return this.storageChangeLogDas.count((BaseEo)storageChangeLogEo);
    }

    private void updateChange(Long id, String status) {
        StorageChangeLogEo updateEo = new StorageChangeLogEo();
        updateEo.setId(id);
        updateEo.setStatus(status);
        this.storageChangeLogDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public int countByWareHouse(Long wareHouseId) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setWarehouseId(wareHouseId);
        return this.cargoStorageDas.count((BaseEo)cargoStorageEo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void modifyStorageChange(List<StorageChangeLogEo> storageChangeLogEoList, String status) {
        if (CollectionUtils.isEmpty(storageChangeLogEoList)) {
            return;
        }
        storageChangeLogEoList.sort(Comparator.comparing(StdStorageChangeLogEo::getCargoId));
        StorageChangeLogEo storageChangeLog = storageChangeLogEoList.get(0);
        String cacheKey = "change_order_no_" + status + storageChangeLog.getOrderNo() + storageChangeLog.getChangeType();
        boolean isNotExit = this.cacheService.add(cacheKey, (Object)"1");
        if (isNotExit) {
            try {
                if (this.countChange(storageChangeLog.getOrderNo(), storageChangeLog.getChangeType(), status) > 0) {
                    return;
                }
                for (StorageChangeLogEo storageChangeLogEo : storageChangeLogEoList) {
                    this.updateChange(storageChangeLogEo.getId(), status);
                    storageChangeLogEo.setStatus(status);
                }
                for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
                    Number balance;
                    Long warehouseId = changeLogEo.getWarehouseId();
                    Long cargoId = changeLogEo.getCargoId();
                    CargoStorageEo cargoStorageEo = new CargoStorageEo();
                    cargoStorageEo.setWarehouseId(warehouseId);
                    cargoStorageEo.setCargoId(cargoId);
                    cargoStorageEo.setTenantId(changeLogEo.getTenantId());
                    cargoStorageEo = (CargoStorageEo)this.cargoStorageDas.selectOne((BaseEo)cargoStorageEo);
                    if (cargoStorageEo == null) {
                        cargoStorageEo = new CargoStorageEo();
                        BeanUtils.copyProperties((Object)changeLogEo, (Object)cargoStorageEo);
                        CargoEo cargoEo = (CargoEo)this.cargoDas.selectByPrimaryKey(cargoId);
                        if (cargoEo == null) {
                            throw new BizException(InventoryExceptionCode.CARGO_NOT_EXIST.getCode(), InventoryExceptionCode.CARGO_NOT_EXIST.getCode());
                        }
                        cargoStorageEo.setCargoCode(cargoEo.getCode());
                        cargoStorageEo.setGroupId(cargoEo.getGroupId());
                        balance = new BigDecimal(changeLogEo.getBalance());
                        cargoStorageEo.setAvailable(balance);
                        cargoStorageEo.setBalance(balance);
                        this.cargoStorageDas.insert((BaseEo)cargoStorageEo);
                    } else {
                        this.addCargoStorage(changeLogEo, cargoStorageEo);
                    }
                    if (StorageChangeStatusEnum.ROLLBACK.getStatus().equals(changeLogEo.getStatus())) {
                        this.cargoStorageCacheUtils.addCargoStorageCache(warehouseId, cargoId, cargoId, -changeLogEo.getAppending().longValue());
                    }
                    if (!StorageChangeStatusEnum.STORAGE_IN.getStatus().equals(changeLogEo.getStatus())) continue;
                    BigDecimal available = new BigDecimal(this.cargoStorageCacheUtils.queryCargoStorageCache(warehouseId, cargoId, cargoId));
                    balance = BigDecimal.ZERO.equals(available) ? cargoStorageEo.getBalance().longValue() : changeLogEo.getBalance().longValue();
                    this.cargoStorageCacheUtils.addCargoStorageCache(warehouseId, cargoId, cargoId, (Long)balance);
                }
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        } else {
            logger.info("\u7f13\u5b58key\u5df2\u7ecf\u6267\u884c\u5728\u6267\u884c\u4e2d key=" + cacheKey);
        }
    }

    private void addCargoStorage(StorageChangeLogEo changeLogEo, CargoStorageEo cargoStorageEo) {
        if (changeLogEo.getBalance() != null) {
            BigDecimal bigDecimal = new BigDecimal(changeLogEo.getBalance());
            cargoStorageEo.setBalance(cargoStorageEo.getBalance().add(bigDecimal));
            cargoStorageEo.setAvailable(cargoStorageEo.getAvailable().add(bigDecimal));
        }
        if (changeLogEo.getIntransit() != null) {
            cargoStorageEo.setIntransit(cargoStorageEo.getIntransit().add(new BigDecimal(changeLogEo.getIntransit())));
        }
        if (changeLogEo.getIndemnity() != null) {
            cargoStorageEo.setIndemnity(Long.valueOf(cargoStorageEo.getIndemnity() + changeLogEo.getIndemnity()));
        }
        if (changeLogEo.getImperfections() != null) {
            cargoStorageEo.setImperfections(Long.valueOf(cargoStorageEo.getImperfections() + changeLogEo.getImperfections()));
        }
        this.cargoStorageDas.updateSelective((BaseEo)cargoStorageEo);
    }

    @Override
    public void modifyCargoStorage(Long id, CargoStorageUpdateReqDto cargoStorageUpdateReqDto) {
        if (id == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        if (cargoStorageUpdateReqDto.getGroupId() != null) {
            CargoStorageEo cargoStorageEo = (CargoStorageEo)this.cargoStorageDas.selectByPrimaryKey(id);
            if (cargoStorageEo == null) {
                InventoryBusinessRuntimeException.recordNotExist();
            }
            cargoStorageEo.setGroupId(cargoStorageUpdateReqDto.getGroupId());
            this.cargoStorageDas.updateSelective((BaseEo)cargoStorageEo);
        } else if (StringUtils.isNotBlank((CharSequence)cargoStorageUpdateReqDto.getStatus())) {
            StorageChangeLogEo storageChangeLogEo = (StorageChangeLogEo)this.storageChangeLogDas.selectByPrimaryKey(id);
            if (storageChangeLogEo == null) {
                InventoryBusinessRuntimeException.recordNotExist();
            }
            storageChangeLogEo.setStatus(cargoStorageUpdateReqDto.getStatus());
            this.storageChangeLogDas.updateSelective((BaseEo)storageChangeLogEo);
        } else {
            InventoryBusinessRuntimeException.parameterError();
        }
    }

    @Override
    public void subCargoStorage(CargoStorageCreateReqDto cargoStorageCreateReqDto) {
        List cargoStorageInfoDtoList = cargoStorageCreateReqDto.getCargoList();
        if (StringUtils.isBlank((CharSequence)cargoStorageCreateReqDto.getOrderNo()) || CollectionUtils.isEmpty((Collection)cargoStorageInfoDtoList)) {
            logger.error("\u4ea4\u6613\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a\u6216\u8981\u6263\u51cf\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a,orderNo={}", (Object)cargoStorageCreateReqDto.getOrderNo());
            InventoryBusinessRuntimeException.parameterError();
        }
        for (CargoStorageInfoCreateReqDto infoDto : cargoStorageInfoDtoList) {
            if (infoDto.getCargoId() == null || infoDto.getNum() == null) {
                logger.error("\u8981\u6263\u51cf\u5e93\u5b58\u4fe1\u606f\u4e0d\u5168,cargoId={},num={}", (Object)infoDto.getCargoId(), (Object)infoDto.getNum());
                InventoryBusinessRuntimeException.parameterError();
            }
            if (!new BigDecimal(0).equals(infoDto.getNum())) continue;
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.CARGO_NUM_CAN_NOT_ZERO);
        }
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(cargoStorageCreateReqDto.getOrderNo());
        storageChangeLogEo.setInstanceId(cargoStorageCreateReqDto.getInstanceId());
        storageChangeLogEo.setTenantId(cargoStorageCreateReqDto.getTenantId());
        if (this.storageChangeLogDas.count((BaseEo)storageChangeLogEo) > 0) {
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.ORDER_EXISTS);
        }
        StockChangeDto stockChangeDto = new StockChangeDto();
        stockChangeDto.setChangeType("PREEMPT_INIT");
        stockChangeDto.setOrderNo(cargoStorageCreateReqDto.getOrderNo());
        ArrayList<StockChangeDto.StockChangeItemDto> stockChangeItemDtoList = new ArrayList<StockChangeDto.StockChangeItemDto>();
        stockChangeDto.setItems(stockChangeItemDtoList);
        for (CargoStorageInfoCreateReqDto cargoStorageInfoDto : cargoStorageInfoDtoList) {
            StockChangeDto.StockChangeItemDto stockChangeItemDto = new StockChangeDto.StockChangeItemDto();
            if (cargoStorageInfoDto.getWarehouseId() == null) {
                stockChangeItemDto.setWarehouseId(this.queryWarehouseId(cargoStorageCreateReqDto.getProvCode(), cargoStorageCreateReqDto.getCityCode(), cargoStorageCreateReqDto.getAreaCode(), cargoStorageInfoDto.getCargoId(), cargoStorageCreateReqDto.getInstanceId(), cargoStorageCreateReqDto.getTenantId()));
            } else {
                stockChangeItemDto.setWarehouseId(cargoStorageInfoDto.getWarehouseId());
            }
            if (stockChangeItemDto.getWarehouseId() == null) {
                throw new BizException(InventoryExceptionCode.WARE_HOUSE__NULL.getCode(), InventoryExceptionCode.WARE_HOUSE__NULL.getMsg());
            }
            stockChangeItemDto.setCargoId(cargoStorageInfoDto.getCargoId());
            ArrayList<StockChangeDto.Stock> stockList = new ArrayList<StockChangeDto.Stock>();
            StockChangeDto.Stock stockPreempt = new StockChangeDto.Stock();
            stockPreempt.setStockType("preempt");
            stockPreempt.setNum(cargoStorageInfoDto.getNum());
            stockList.add(stockPreempt);
            StockChangeDto.Stock stockBalance = new StockChangeDto.Stock();
            stockBalance.setStockType("available");
            stockBalance.setNum(cargoStorageInfoDto.getNum().negate());
            stockList.add(stockBalance);
            stockChangeItemDto.setStocks(stockList);
            stockChangeItemDtoList.add(stockChangeItemDto);
        }
        this.stockDsl.modifyStock(stockChangeDto);
    }

    private Long queryWarehouseId(String provCode, String cityCode, String areaCode, Long cargoId, Long instanceId, Long tenantId) {
        CargoStorageQueryReqDto cargoStorageQueryReqDto = new CargoStorageQueryReqDto();
        cargoStorageQueryReqDto.setProvCode(provCode);
        cargoStorageQueryReqDto.setCityCode(cityCode);
        cargoStorageQueryReqDto.setAreaCode(areaCode);
        ArrayList<CargoStorageInfoQueryReqDto> cargoStorageList = new ArrayList<CargoStorageInfoQueryReqDto>();
        CargoStorageInfoQueryReqDto cargoStorageInfoQueryReqDto = new CargoStorageInfoQueryReqDto();
        cargoStorageInfoQueryReqDto.setCargoId(cargoId);
        cargoStorageList.add(cargoStorageInfoQueryReqDto);
        cargoStorageQueryReqDto.setCargoStorageList(cargoStorageList);
        cargoStorageQueryReqDto.setInstanceId(instanceId);
        cargoStorageQueryReqDto.setTenantId(tenantId);
        CargoStorageQueryRespDto cargoStorageQueryRespDto = this.cargoStorageQueryService.queryCargoStorage(cargoStorageQueryReqDto);
        if (cargoStorageQueryRespDto == null || CollectionUtils.isEmpty((Collection)cargoStorageQueryRespDto.getCargoStorageList())) {
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.WAREHOUSE_INFO_NOT_EXISTS);
        }
        return ((CargoStorageInfoQueryRespDto)cargoStorageQueryRespDto.getCargoStorageList().get(0)).getWarehouseId();
    }

    private void subCargoStorage(List<CargoStorageDto> cargoStorageDtoList) {
        ArrayList<StorageChangeLogEo> storageChangeLogEos = new ArrayList<StorageChangeLogEo>();
        try {
            for (CargoStorageDto cargoStorageDto : cargoStorageDtoList) {
                CargoStorageEo cargoStorageEo = new CargoStorageEo();
                cargoStorageEo.setWarehouseId(cargoStorageDto.getWarehouseId());
                cargoStorageEo.setCargoId(cargoStorageDto.getCargoId());
                cargoStorageEo.setInstanceId(cargoStorageDto.getInstanceId());
                cargoStorageEo.setTenantId(cargoStorageDto.getTenantId());
                List cargoStorageEoList = this.cargoStorageDas.select((BaseEo)cargoStorageEo);
                if (CollectionUtils.isEmpty((Collection)cargoStorageEoList)) {
                    throw new BizException(InventoryExceptionCode.CARGO_NOT_ENOUGH_INFO.getCode(), InventoryExceptionCode.CARGO_NOT_ENOUGH_INFO.getMsg());
                }
                for (CargoStorageEo storageEo : cargoStorageEoList) {
                    storageEo.setBalance(new BigDecimal(this.cargoStorageCacheUtils.queryCargoStorageCache((long)storageEo.getWarehouseId(), (long)storageEo.getPositionId(), (long)storageEo.getCargoId())));
                }
                cargoStorageEoList.sort(Comparator.comparing(StdCargoStorageEo::getBalance).reversed());
                BigDecimal subTotalNum = BigDecimal.ZERO;
                BigDecimal num = cargoStorageDto.getBalance();
                for (CargoStorageEo storageEo : cargoStorageEoList) {
                    BigDecimal remainNum;
                    if (num.compareTo(BigDecimal.ZERO) < 0) {
                        num = num.negate();
                    }
                    if ((remainNum = num.subtract(subTotalNum)).compareTo(BigDecimal.ZERO) == 0) break;
                    BigDecimal wantSubNum = storageEo.getBalance().compareTo(remainNum) > 0 ? remainNum : storageEo.getBalance();
                    boolean subFlag = this.cargoStorageCacheUtils.subCargoStorageCache(storageEo.getWarehouseId(), storageEo.getPositionId(), storageEo.getCargoId(), wantSubNum.longValue());
                    if (!subFlag) {
                        throw new InventoryBusinessRuntimeException(InventoryExceptionCode.CARGO_NOT_ENOUGH);
                    }
                    subTotalNum = wantSubNum.add(wantSubNum);
                    storageEo.setBalance(new BigDecimal(this.cargoStorageCacheUtils.queryCargoStorageCache(storageEo.getWarehouseId(), storageEo.getPositionId(), storageEo.getCargoId())));
                    StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
                    storageChangeLogEo.setChangeType(cargoStorageDto.getChangeType());
                    storageChangeLogEo.setOrderNo(cargoStorageDto.getOrderNo());
                    storageChangeLogEo.setWarehouseId(storageEo.getWarehouseId());
                    storageChangeLogEo.setPositionId(storageEo.getPositionId());
                    storageChangeLogEo.setCargoId(storageEo.getCargoId());
                    storageChangeLogEo.setAppending(Long.valueOf(wantSubNum.longValue()));
                    storageChangeLogEo.setStatus(StorageChangeStatusEnum.INIT.getStatus());
                    storageChangeLogEo.setInstanceId(cargoStorageDto.getInstanceId());
                    storageChangeLogEo.setTenantId(cargoStorageDto.getTenantId());
                    storageChangeLogEos.add(storageChangeLogEo);
                }
                if (subTotalNum != null && subTotalNum.equals(cargoStorageDto.getBalance())) continue;
                throw new BizException(InventoryExceptionCode.CARGO_NOT_ENOUGH.getCode(), InventoryExceptionCode.CARGO_NOT_ENOUGH.getMsg());
            }
            this.modifyStorageChange(storageChangeLogEos, StorageChangeStatusEnum.APPENDED.getStatus(), false);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.rollbackAppendingCargoStorage(storageChangeLogEos);
            throw e;
        }
    }

    private void rollbackOutCargoStorage(List<StorageChangeLogEo> storageChangeLogEoList) {
        for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
            logger.info("\u8d27\u54c1redis\u7f13\u5b58\u56de\u9000:{}", (Object)JSON.toJSONString((Object)changeLogEo));
            if (changeLogEo == null || changeLogEo.getBalance() == null || changeLogEo.getBalance().equals(0L)) continue;
            this.cargoStorageCacheUtils.addCargoStorageCache(changeLogEo.getWarehouseId(), changeLogEo.getCargoId(), changeLogEo.getCargoId(), changeLogEo.getBalance());
        }
    }

    private void rollbackAppendingCargoStorage(List<StorageChangeLogEo> storageChangeLogEoList) {
        for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
            logger.info("\u8d27\u54c1redis\u7f13\u5b58\u56de\u9000:{}", (Object)JSON.toJSONString((Object)changeLogEo));
            if (changeLogEo == null || changeLogEo.getAppending() == null || changeLogEo.getAppending().equals(0L)) continue;
            this.cargoStorageCacheUtils.addCargoStorageCache(changeLogEo.getWarehouseId(), changeLogEo.getPositionId(), changeLogEo.getCargoId(), changeLogEo.getAppending());
        }
    }

    @Override
    public int countByStatus(Long instanceId, Long tenantId, String orderNo, String type, String status) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setInstanceId(instanceId);
        storageChangeLogEo.setTenantId(tenantId);
        storageChangeLogEo.setChangeType(type);
        storageChangeLogEo.setStatus(status);
        return this.storageChangeLogDas.count((BaseEo)storageChangeLogEo);
    }

    @Override
    public List<StorageChangeLogEo> queryByStatus(Long instanceId, Long tenantId, String orderNo, String type, String status) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setInstanceId(instanceId);
        storageChangeLogEo.setTenantId(tenantId);
        storageChangeLogEo.setChangeType(type);
        storageChangeLogEo.setStatus(status);
        return this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
    }

    @Override
    public void cancelByOrderNo(String tradeOrderNo) {
        List<StorageChangeLogEo> storageChangeLogEos = this.queryByOrderNoList(tradeOrderNo, StorageChangeTypeEnum.ORDER_CHANGE.getType());
        for (StorageChangeLogEo storageChangeLogEo : storageChangeLogEos) {
            if (!storageChangeLogEo.getStatus().equals(StorageChangeStatusEnum.APPENDED.getStatus()) && !storageChangeLogEo.getStatus().equals(StorageChangeStatusEnum.CONFIRM.getStatus())) {
                return;
            }
            storageChangeLogEo.setAppending(Long.valueOf(-storageChangeLogEo.getAppending().longValue()));
        }
        this.modifyStorageChange(storageChangeLogEos, StorageChangeStatusEnum.ROLLBACK.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCargoStorage(CargoStorageRestReqDto cargoStorageRestReqDto) {
        if (cargoStorageRestReqDto == null || cargoStorageRestReqDto.getInstanceId() == null || cargoStorageRestReqDto.getTenantId() == null) {
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.PARAMETER_ERROR);
        }
        String lockKey = "rest_" + cargoStorageRestReqDto.getInstanceId() + "_" + cargoStorageRestReqDto.getTenantId();
        if (this.cacheService.add(lockKey, (Object)"1", 1800)) {
            try {
                List cargoStorageEoList;
                CargoStorageEo cargoStorageEo = new CargoStorageEo();
                cargoStorageEo.setInstanceId(cargoStorageRestReqDto.getInstanceId());
                cargoStorageEo.setTenantId(cargoStorageRestReqDto.getTenantId());
                if (CollectionUtils.isNotEmpty((Collection)cargoStorageRestReqDto.getCargoIdList())) {
                    ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
                    sqlFilterList.add(SqlFilter.in((String)"cargo_id", (Object)StringUtils.join((Iterable)cargoStorageRestReqDto.getCargoIdList(), (String)",")));
                    cargoStorageEo.setSqlFilters(sqlFilterList);
                }
                if (CollectionUtils.isEmpty((Collection)(cargoStorageEoList = this.cargoStorageDas.select((BaseEo)cargoStorageEo)))) {
                    return;
                }
                cargoStorageEoList.stream().forEach(cargoStorage -> {
                    Long cargoNum = this.cargoStorageCacheUtils.queryCargoStorageCache(cargoStorage.getWarehouseId(), cargoStorage.getPositionId(), cargoStorage.getCargoId());
                    if (cargoNum != null && cargoNum > 0L || cargoStorage.getBalance().compareTo(BigDecimal.ZERO) > 0) {
                        // empty if block
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.cacheService.delCache(lockKey);
            }
        } else {
            logger.info("\u7f13\u5b58\u91cd\u7f6e\u4efb\u52a1\u5df2\u7ecf\u5728\u6267\u884c\u4e2d...");
        }
    }

    @Override
    public List<StorageChangeLogEo> queryByOrderNoList(String orderNo, String changeType) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setChangeType(changeType);
        return this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
    }

    @Override
    public List<CargoStorageEo> queryByCargoIdList(Set<Long> ids) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"cargo_id", (Object)StringUtils.join(ids, (String)",")));
        cargoStorageEo.setSqlFilters(sqlFilterList);
        return this.cargoStorageDas.select((BaseEo)cargoStorageEo);
    }

    @Override
    public List<StorageChangeLogEo> queryByType(Long instanceId, Long tenantId, String orderNo, String type) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setInstanceId(instanceId);
        storageChangeLogEo.setTenantId(tenantId);
        storageChangeLogEo.setChangeType(type);
        return this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
    }

    @Override
    public List<StorageChangeLogEo> queryByType(String orderNo, String type, Long cargoId) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setOrderNo(orderNo);
        storageChangeLogEo.setCargoId(cargoId);
        storageChangeLogEo.setChangeType(type);
        return this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
    }

    @Override
    public void addAvailablePreempt(StorageChangeReqDto storageChangeReqDto) {
        logger.info("\u66f4\u65b0\u4ed3\u5e93\u8d27\u54c1\u9884\u5360\u548c\u53ef\u7528\u5e93\u5b58\uff0cStorageChangeReqDto\uff1a{}", (Object)JSON.toJSONString((Object)storageChangeReqDto));
        CargoStorageEo cargoStorageSelect = new CargoStorageEo();
        cargoStorageSelect.setWarehouseId(storageChangeReqDto.getWarehouseId());
        cargoStorageSelect.setCargoCode(storageChangeReqDto.getCargoCode());
        CargoStorageEo cargoStorage = (CargoStorageEo)this.cargoStorageDas.selectOne((BaseEo)cargoStorageSelect);
        if (null == cargoStorage) {
            logger.warn("\u6263\u51cf\u53ef\u7528\u5e93\u5b58\uff0c\u589e\u52a0\u9884\u5360\u5e93\u5b58\u5931\u8d25\uff0cwarehouseId\uff1a{}\uff0ccargoCode\uff1a{}\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u8d27\u54c1\u4fe1\u606f\uff0c", (Object)storageChangeReqDto.getWarehouseId(), (Object)storageChangeReqDto.getCargoCode());
            return;
        }
        storageChangeReqDto.setOriAvailable(cargoStorage.getAvailable());
        storageChangeReqDto.setCargoId(cargoStorage.getCargoId());
        this.cargoStorageDas.addAvailablePreempt(storageChangeReqDto.getWarehouseId(), storageChangeReqDto.getCargoCode(), storageChangeReqDto.getPreempt(), storageChangeReqDto.getAvailable());
        this.newInventoryCountProducer.sendChangeMq(storageChangeReqDto);
    }

    @Override
    public void changeCargoStorageNum(StorageChangeReqDto storageChangeReqDto) {
        logger.info("\u66f4\u65b0\u4ed3\u5e93\u8d27\u54c1\u603b\u5e93\u5b58\u3001\u9884\u5360\uff0cStorageChangeReqDto\uff1a{}", (Object)JSON.toJSONString((Object)storageChangeReqDto));
        this.cargoStorageDas.changeCargoStorageNum(storageChangeReqDto.getWarehouseId(), storageChangeReqDto.getCargoCode(), storageChangeReqDto.getBalance(), storageChangeReqDto.getPreempt());
    }

    @Override
    public void confirmPreempt(CargoStoragePreemptConfirmReqDto preemptConfirmReqDto) {
        List<StorageChangeLogEo> storageChangeLogEos = this.queryByOrderNoList(preemptConfirmReqDto.getOrderNo(), null);
        for (StorageChangeLogEo storageChangeLogEo : storageChangeLogEos) {
            if (storageChangeLogEo.getChangeType().equals("PREEMPT_INIT")) continue;
            return;
        }
        StockChangeDto stockChangeDto = new StockChangeDto();
        stockChangeDto.setChangeType("PREEMPT_CONFIRM");
        stockChangeDto.setOrderNo(preemptConfirmReqDto.getOrderNo());
        ArrayList<StockChangeDto.StockChangeItemDto> stockChangeItemDtoList = new ArrayList<StockChangeDto.StockChangeItemDto>();
        Iterator<StorageChangeLogEo> iterator = storageChangeLogEos.iterator();
        while (iterator.hasNext()) {
            String stockFiled = "preempt";
            StorageChangeLogEo changeLogEo = iterator.next();
            if (!stockFiled.equals(changeLogEo.getActionStatus())) continue;
            StockChangeDto.StockChangeItemDto stockChangeItemDto = new StockChangeDto.StockChangeItemDto();
            stockChangeItemDto.setWarehouseId(changeLogEo.getWarehouseId());
            stockChangeItemDto.setCargoId(changeLogEo.getCargoId());
            ArrayList<StockChangeDto.Stock> stockList = new ArrayList<StockChangeDto.Stock>();
            Long allocate = changeLogEo.getAllocate();
            StockChangeDto.Stock stockPreempt = new StockChangeDto.Stock();
            stockPreempt.setStockType("preempt");
            stockPreempt.setNum(new BigDecimal(allocate).negate());
            stockList.add(stockPreempt);
            StockChangeDto.Stock stockBalance = new StockChangeDto.Stock();
            stockBalance.setStockType("balance");
            stockBalance.setNum(new BigDecimal(allocate).negate());
            stockList.add(stockBalance);
            stockChangeItemDto.setStocks(stockList);
            stockChangeItemDtoList.add(stockChangeItemDto);
        }
        stockChangeDto.setItems(stockChangeItemDtoList);
        this.stockDsl.modifyStock(stockChangeDto);
    }

    @Override
    public void updateStorageSynNum(List<UpdateStorageSynNumReqDto> synStorageUpdateNumReqDtoList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u5373\u65f6\u540c\u6b65\u6570\u91cf size={}, {}", (Object)synStorageUpdateNumReqDtoList.size(), synStorageUpdateNumReqDtoList);
        this.cargoStorageDas.updateStorageSynNum(synStorageUpdateNumReqDtoList);
    }

    @Override
    public void coverCargoStorage(StorageAdjustCoverReqDto storageAdjustCoverReqDto) {
        this.storageAdjustService.storageAdjustCover(storageAdjustCoverReqDto);
    }

    public List<CargoEo> queryCargoCodeById(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return new ArrayList<CargoEo>();
        }
        CargoEo cargoEo = new CargoEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codeList));
        cargoEo.setSqlFilters(sqlFilters);
        List cargoEoList = this.cargoDas.select((BaseEo)cargoEo);
        return cargoEoList;
    }

    public List<WarehouseEo> queryWarehouseCodeById(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return new ArrayList<WarehouseEo>();
        }
        WarehouseEo warehouseEo = new WarehouseEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codeList));
        warehouseEo.setSqlFilters(sqlFilters);
        List warehouseEoList = this.wareHouseDas.select((BaseEo)warehouseEo);
        return warehouseEoList;
    }
}

