/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ChangeLogPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ChangeLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IChangeLogService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChangeLogServiceImpl
implements IChangeLogService {
    @Resource
    private ChangeLogDas changeLogDas;

    @Override
    public ChangeLogRespDto queryById(Long id) {
        ChangeLogEo changeLogEo = (ChangeLogEo)this.changeLogDas.selectByPrimaryKey(id);
        ChangeLogRespDto changeLogReqDto = (ChangeLogRespDto)EoUtil.eoToDto((BaseEo)changeLogEo, ChangeLogRespDto.class);
        return changeLogReqDto;
    }

    @Override
    public List<ChangeLogRespDto> queryByIds(List<Long> changeLogId) {
        ChangeLogEo query = (ChangeLogEo)SqlFilterBuilder.create(ChangeLogEo.class).in("id", changeLogId).eo();
        List changeLogs = this.changeLogDas.select((BaseEo)query);
        List changeLogDtos = EoUtil.eoListToDtoList((Collection)changeLogs, ChangeLogRespDto.class);
        return changeLogDtos;
    }

    @Override
    public PageInfo<ChangeLogRespDto> queryByPage(ChangeLogPageReqDto changeLogPageReqDto) {
        ChangeLogEo queryEo = (ChangeLogEo)EoUtil.dtoToEo((BaseVo)changeLogPageReqDto, ChangeLogEo.class);
        ArrayList sqlFilters = new ArrayList(5);
        if (StringUtils.isNotEmpty((CharSequence)changeLogPageReqDto.getCargoCode())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChangeLogEo.class).like("cargoCode", (Object)("%" + changeLogPageReqDto.getCargoCode() + "%")).filters());
            queryEo.setCargoCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)changeLogPageReqDto.getCargoName())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChangeLogEo.class).like("cargoName", (Object)("%" + changeLogPageReqDto.getCargoName() + "%")).filters());
            queryEo.setCargoName(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)changeLogPageReqDto.getCargoNo())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChangeLogEo.class).like("cargoNo", (Object)("%" + changeLogPageReqDto.getCargoNo() + "%")).filters());
            queryEo.setCargoNo(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)changeLogPageReqDto.getClientName())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChangeLogEo.class).like("clientName", (Object)("%" + changeLogPageReqDto.getClientName() + "%")).filters());
            queryEo.setClientId(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)changeLogPageReqDto.getWarehouseId())) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChangeLogEo.class).eq("warehouseId", (Object)changeLogPageReqDto.getWarehouseId()).filters());
            queryEo.setWarehouseId(null);
        }
        if (null != changeLogPageReqDto.getUpdateStartTime() && null != changeLogPageReqDto.getUpdateEndTime()) {
            sqlFilters.addAll(SqlFilterBuilder.create(ChangeLogEo.class).ge("update_time", (Object)changeLogPageReqDto.getUpdateStartTime()).le("update_time", (Object)changeLogPageReqDto.getUpdateEndTime()).filters());
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            queryEo.setSqlFilters(sqlFilters);
        }
        queryEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.changeLogDas.selectPage((BaseEo)queryEo, changeLogPageReqDto.getPageNum(), changeLogPageReqDto.getPageSize());
        PageInfo changeLogRespDtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, ChangeLogRespDto.class);
        return changeLogRespDtoPageInfo;
    }

    @Override
    public Long addChangeLog(ChangeLogEo changeLogEo) {
        this.changeLogDas.insert((BaseEo)changeLogEo);
        return changeLogEo.getId();
    }

    @Override
    public void modifyChangeLog(ChangeLogEo changeLogEo) {
        EoUtil.setNullVal((Object)changeLogEo, (String[])new String[]{"createTime"});
        this.changeLogDas.updateSelective((BaseEo)changeLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeChangeLog(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.changeLogDas.logicDeleteById(Long.valueOf(id));
        }
    }
}

