/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryItemSumReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryItemService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.DeliveryItemMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryItemServiceImpl
implements IDeliveryItemService {
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private DeliveryItemMapper deliveryItemMapper;

    @Override
    public List<DeliveryItemRespDto> queryByDeliveryNo(String deliveryNo) {
        DeliveryItemEo deliveryItemSelect = new DeliveryItemEo();
        deliveryItemSelect.setDeliveryNo(deliveryNo);
        List deliveryItemEos = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        if (CollectionUtils.isEmpty((Collection)deliveryItemEos)) {
            return null;
        }
        ArrayList<DeliveryItemRespDto> deliveryItemRespDtos = new ArrayList<DeliveryItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)deliveryItemEos, deliveryItemRespDtos, DeliveryItemRespDto.class);
        return deliveryItemRespDtos;
    }

    @Override
    public List<DeliveryItemRespDto> sumItem(DeliveryItemSumReqDto dto) {
        List deliveryItemEos = this.deliveryItemMapper.sumItem(dto.getStartTime(), dto.getEndTime(), dto.getWarehouseCodes(), dto.getCargoCodes());
        return deliveryItemEos.stream().map(e -> {
            DeliveryItemRespDto respDto = new DeliveryItemRespDto();
            respDto.setDeliveryNo(e.getDeliveryNo());
            respDto.setItemNum(e.getItemNum());
            return respDto;
        }).collect(Collectors.toList());
    }
}

