/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryErrorEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.StockInsufficientException;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.DeliveryRouteProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryOrderVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteRecordService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryRouteRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryRouteRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryOrderServiceImpl
implements IDeliveryOrderService {
    private final Logger logger = LoggerFactory.getLogger(DeliveryOrderServiceImpl.class);
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private CargoDas cargoDas;
    @Autowired
    private WarehouseDas warehouseDas;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Autowired
    private IDeliveryRouteService deliveryRouteService;
    @Autowired
    private IDeliveryRouteRecordService deliveryRouteRecordService;
    @Autowired
    private DeliveryRouteProducer deliveryRouteProducer;
    @Autowired
    private DeliveryRouteRecordDas deliveryRouteRecordDas;
    @Autowired
    private ICargoStorageService cargoStorageService;

    @Override
    public void deliveryRoute(DeliveryRouteReqDto deliveryRouteReqDto) {
        DeliveryRouteRecordEo routeRecord = new DeliveryRouteRecordEo();
        routeRecord.setOptCode(DeliveryRouteOptEnum.AUTO_ROUTE.getOptCode());
        routeRecord.setOptName(DeliveryRouteOptEnum.AUTO_ROUTE.getOptDesc());
        try {
            this.deliveryRouteService.route(deliveryRouteReqDto, routeRecord);
        }
        catch (BizException be) {
            this.logger.info("\u53d1\u8d27\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u51fa\u73b0\u4e1a\u52a1\u5f02\u5e38,deliveryNo:{}, errorCode:{}, message:{} ", new Object[]{deliveryRouteReqDto.getDeliveryNo(), be.getCode(), be.getMessage()});
            if (DeliveryErrorEnum.ERROR_610019.getErrorCode().equals(be.getCode())) {
                return;
            }
            OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
            orderDeliverySelect.setDeliveryNo(deliveryRouteReqDto.getDeliveryNo());
            OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
            OrderDeliveryEo orderDeliveryUpdate = new OrderDeliveryEo();
            orderDeliveryUpdate.setId(orderDeliveryEo.getId());
            DeliveryErrorEnum errorEnum = DeliveryErrorEnum.getByCode((String)be.getCode());
            if (null != errorEnum && !errorEnum.getToStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
                orderDeliveryUpdate.setDeliveryStatus(errorEnum.getToStatus());
                this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
                DeliveryRouteRespDto deliveryRouteRespDto = new DeliveryRouteRespDto();
                deliveryRouteRespDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
                deliveryRouteRespDto.setDeliveryStatus(errorEnum.getToStatus());
                deliveryRouteRespDto.setWarehouseCode(orderDeliveryEo.getWarehouseCode());
                deliveryRouteRespDto.setWarehouseName(orderDeliveryEo.getWarehouseName());
                deliveryRouteRespDto.setWarehouseSubType(orderDeliveryEo.getWarehouseSubType());
                deliveryRouteRespDto.setOrganizationId(orderDeliveryEo.getWarehouseOrganizationId());
                deliveryRouteRespDto.setOrganizationName(orderDeliveryEo.getWarehouseOrganizationName());
                this.logger.info("\u63a5\u6536\u5230\u53d1\u8d27\u5355\u8def\u7531\u6307\u4ee4 --> \u53d1\u8d27\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u51fa\u73b0\u4e1a\u52a1\u5f02\u5e38 --> \u8bbe\u7f6e\u5e93\u5b58\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u4ed3\u5e93\u7ec4\u7ec7id) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[DeliveryOrderServiceImpl].[deliveryRoute]", (Object)JSONObject.toJSONString((Object)deliveryRouteRespDto));
                this.deliveryRouteProducer.sendDeliberyRoutReslut(deliveryRouteRespDto);
                if (DeliveryStatusEnum.TO_ROUTE.getMsg().equals(errorEnum.getToStatus())) {
                    this.logger.info("\u53d1\u8d27\u5355\u72b6\u6001\u4e3a\u5f85\u8def\u7531\u72b6\u6001\uff0c\u53d1\u9001\u8def\u7531\u6d88\u606f\uff0cdeliveryNo:{}", (Object)orderDeliveryEo.getDeliveryNo());
                    DeliveryRouteReqDto deliveryRoute = new DeliveryRouteReqDto();
                    deliveryRoute.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
                    this.deliveryRouteProducer.sendDeliberyRoutCommand(deliveryRoute);
                }
            }
            if (StringUtils.isEmpty((CharSequence)routeRecord.getErrorCode())) {
                routeRecord.setRouteInfo(be.getCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                routeRecord.setRouteResult(errorEnum.getDesc());
            }
        }
        catch (Exception e) {
            this.logger.info("\u53d1\u8d27\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38,deliveryNo:{}, e:{}", new Object[]{deliveryRouteReqDto.getDeliveryNo(), e.getMessage(), e});
            OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
            orderDeliverySelect.setDeliveryNo(deliveryRouteReqDto.getDeliveryNo());
            OrderDeliveryEo orderDeliveryEo = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
            OrderDeliveryEo orderDeliveryUpdate = new OrderDeliveryEo();
            orderDeliveryUpdate.setId(orderDeliveryEo.getId());
            orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.TO_DO.getStatus());
            this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
            DeliveryRouteRespDto deliveryRouteRespDto = new DeliveryRouteRespDto();
            deliveryRouteRespDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            deliveryRouteRespDto.setDeliveryStatus(DeliveryStatusEnum.TO_DO.getStatus());
            deliveryRouteRespDto.setWarehouseCode("");
            deliveryRouteRespDto.setWarehouseName("");
            deliveryRouteRespDto.setOrganizationId(Long.valueOf(0L));
            deliveryRouteRespDto.setOrganizationName("\u9ed8\u8ba4\u6743\u9650");
            this.logger.info("\u63a5\u6536\u5230\u53d1\u8d27\u5355\u8def\u7531\u6307\u4ee4 --> \u53d1\u8d27\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38 --> \u8bbe\u7f6e\u5e93\u5b58\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u4ed3\u5e93\u7ec4\u7ec7id) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[DeliveryOrderServiceImpl].[deliveryRoute]", (Object)JSONObject.toJSONString((Object)deliveryRouteRespDto));
            this.deliveryRouteProducer.sendDeliberyRoutReslut(deliveryRouteRespDto);
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38\uff0ce:{}", (Object)e.getMessage(), (Object)e);
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_100000.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            routeRecord.setRouteResult("\u8def\u7531\u51fa\u73b0\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
        }
        this.deliveryRouteRecordDas.insert((BaseEo)routeRecord);
    }

    @Override
    public DeliveryVo getDeliveryByDeliveryNo(String deliveryNo) {
        DeliveryVo deliveryVo = new DeliveryVo();
        OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
        orderDeliverySelect.setDeliveryNo(deliveryNo);
        OrderDeliveryEo orderDelivery = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        RefDeliveryOrderEo refDeliveryOrderSelect = new RefDeliveryOrderEo();
        refDeliveryOrderSelect.setDeliveryNo(deliveryNo);
        List refDeliveryOrders = this.refDeliveryOrderDas.select((BaseEo)refDeliveryOrderSelect);
        DeliveryItemEo deliveryItemSelect = new DeliveryItemEo();
        deliveryItemSelect.setDeliveryNo(deliveryNo);
        List deliveryItems = this.deliveryItemDas.select((BaseEo)deliveryItemSelect);
        deliveryVo.setOrderDelivery(orderDelivery);
        deliveryVo.setRefDeliveryOrders(refDeliveryOrders);
        deliveryVo.setDeliveryItems(deliveryItems);
        return deliveryVo;
    }

    @Override
    public void saveDelivery(DeliveryVo deliveryVo) {
        OrderDeliveryEo orderDelivery = deliveryVo.getOrderDelivery();
        OrderDeliveryEo orderDeliverySelect = new OrderDeliveryEo();
        orderDeliverySelect.setDeliveryNo(orderDelivery.getDeliveryNo());
        OrderDeliveryEo oriOrderDelivery = (OrderDeliveryEo)this.orderDeliveryDas.selectOne((BaseEo)orderDeliverySelect);
        if (null != oriOrderDelivery) {
            this.logger.info("\u5e93\u4e2d\u5df2\u5b58\u5728\u53d1\u8d27\u5355\uff1a{}\u4fe1\u606f\uff0c\u4e0d\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c", (Object)orderDelivery.getDeliveryNo());
            return;
        }
        List<DeliveryItemEo> deliveryItems = deliveryVo.getDeliveryItems();
        List<RefDeliveryOrderEo> refDeliveryOrders = deliveryVo.getRefDeliveryOrders();
        this.orderDeliveryDas.insert((BaseEo)orderDelivery);
        this.deliveryItemDas.insertBatch(deliveryItems);
        this.refDeliveryOrderDas.insertBatch(refDeliveryOrders);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void genDeliveryOrder(DeliveryOrderGenerateReqDto deliveryOrderGenerateReqDto) {
        OrderDeliveryEo select = new OrderDeliveryEo();
        select.setDeliveryNo(deliveryOrderGenerateReqDto.getOrderDelivery().getDeliveryNo());
        int count = this.orderDeliveryDas.count((BaseEo)select);
        if (count > 0) {
            throw new BizException("\u53d1\u8d27\u5355\u6570\u636e\u5df2\u5b58\u5728!");
        }
        deliveryOrderGenerateReqDto.getDeliveryItems().forEach(e -> e.setTradeNo(deliveryOrderGenerateReqDto.getOrderDelivery().getTradeNo()));
        String deliveryOrderJson = JSON.toJSONString((Object)deliveryOrderGenerateReqDto);
        DeliveryOrderVo deliveryOrderVo = (DeliveryOrderVo)JSON.parseObject((String)deliveryOrderJson, DeliveryOrderVo.class);
        OrderDeliveryEo orderDeliveryEo = deliveryOrderVo.getOrderDelivery();
        List<RefDeliveryOrderEo> refDeliveryOrderEos = deliveryOrderVo.getRefDeliveryOrders();
        List<DeliveryItemEo> deliveryItems = deliveryOrderVo.getDeliveryItems();
        deliveryItems.forEach(e -> {
            e.setTradeNo(orderDeliveryEo.getTradeNo());
            e.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
            e.setParentDeliveryNo(orderDeliveryEo.getParentDeliveryNo());
        });
        deliveryOrderVo.setInstanceId(deliveryOrderGenerateReqDto.getInstanceId());
        deliveryOrderVo.setTenantId(deliveryOrderGenerateReqDto.getTenantId());
        try {
            this.reserveStock(deliveryOrderVo);
        }
        catch (StockInsufficientException e2) {
            throw new BizException("\u5e93\u8db3\u4e0d\u8db3[" + e2.getMessage() + "],\u751f\u6210\u53d1\u8d27\u5355\u5931\u8d25");
        }
        this.orderDeliveryDas.insert((BaseEo)orderDeliveryEo);
        this.refDeliveryOrderDas.insertBatch(refDeliveryOrderEos);
        this.deliveryItemDas.insertBatch(deliveryItems);
        this.logger.info("\u63a5\u6536\u4ea4\u6613\u4e2d\u5fc3\u53d1\u8d27\u5355\u5165\u5e93\u5b8c\u6bd5...");
    }

    private void reserveStock(DeliveryOrderVo deliveryOrderVo) {
        List<DeliveryItemEo> deliveryItems = deliveryOrderVo.getDeliveryItems();
        if (CollectionUtils.isEmpty(deliveryItems)) {
            this.logger.info("\u81ea\u6709\u5546\u57ce\u6e20\u9053\u4ed3\u6263\u51cf\u5546\u54c1\u4e3a\u7a7a\u4e0d\u6267\u884c");
            return;
        }
        OrderDeliveryEo orderDelivery = deliveryOrderVo.getOrderDelivery();
        String warehouseIdStr = orderDelivery.getWarehouseSerial();
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setCode(orderDelivery.getWarehouseCode());
        warehouseEo.setId(StringUtils.isEmpty((CharSequence)warehouseIdStr) ? null : Long.valueOf(warehouseIdStr));
        warehouseEo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
        if (warehouseEo == null) {
            throw new BizException(InventoryExceptionCode.WARE_HOUSE_NULL.getCode(), InventoryExceptionCode.WARE_HOUSE_NULL.getMsg());
        }
        Long warehouseId = warehouseEo.getId();
        CargoStorageCreateReqDto cargoStorageReqDto = new CargoStorageCreateReqDto();
        cargoStorageReqDto.setProvCode(orderDelivery.getProvinceCode());
        cargoStorageReqDto.setCityCode(orderDelivery.getCityCode());
        cargoStorageReqDto.setAreaCode(orderDelivery.getAreaCode());
        cargoStorageReqDto.setOrderNo(orderDelivery.getDeliveryNo());
        cargoStorageReqDto.setInstanceId(deliveryOrderVo.getInstanceId());
        cargoStorageReqDto.setTenantId(deliveryOrderVo.getTenantId());
        List cargoCodes = deliveryItems.stream().map(StdDeliveryItemEo::getCargoSerial).collect(Collectors.toList());
        List cargoEos = this.cargoDas.select(SqlFilterBuilder.create(CargoEo.class).in("code", (Object)StringUtils.join(cargoCodes, (String)",")).eo());
        Map<String, Long> codeToId = cargoEos.stream().collect(Collectors.toMap(StdCargoEo::getCode, BaseEo::getId));
        List cargoStorageList = deliveryItems.stream().map(e -> {
            CargoStorageInfoCreateReqDto cargoStorageInfoCreateReqDto = new CargoStorageInfoCreateReqDto();
            cargoStorageInfoCreateReqDto.setCargoId((Long)codeToId.get(e.getCargoSerial()));
            cargoStorageInfoCreateReqDto.setWarehouseId(warehouseId);
            cargoStorageInfoCreateReqDto.setNum(new BigDecimal(e.getItemNum()));
            return cargoStorageInfoCreateReqDto;
        }).collect(Collectors.toList());
        cargoStorageReqDto.setCargoList(cargoStorageList);
        this.cargoStorageService.subCargoStorage(cargoStorageReqDto);
    }

    private void saveRouteRecord(OrderDeliveryEo orderDeliveryEo, RefDeliveryOrderEo refDeliveryOrderEo) {
        DeliveryRouteRecordReqDto deliveryRouteRecord = new DeliveryRouteRecordReqDto();
        deliveryRouteRecord.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        deliveryRouteRecord.setOrderNo(refDeliveryOrderEo.getOrderNo());
        deliveryRouteRecord.setOptCode(DeliveryRouteOptEnum.GENERATE.getOptCode());
        deliveryRouteRecord.setOptName(DeliveryRouteOptEnum.GENERATE.getOptDesc());
        deliveryRouteRecord.setDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        deliveryRouteRecord.setDeliveryStatusName(DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()));
        deliveryRouteRecord.setDetailDesc("\u7cfb\u7edf\u751f\u6210\u53d1\u8d27\u5355\uff0c\u521d\u59cb\u72b6\u6001\u4e3a" + DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()));
        this.deliveryRouteRecordService.saveRouteRecord(deliveryRouteRecord);
    }
}

