/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteCountReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteRecordReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRecordRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteRecordService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryRouteRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryRouteRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdDeliveryRouteRecordEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeliveryRouteRecordServiceImpl
implements IDeliveryRouteRecordService {
    @Autowired
    private DeliveryRouteRecordDas deliveryRouteRecordDas;

    @Override
    public void saveRouteRecord(DeliveryRouteRecordReqDto deliveryRouteRecordReqDto) {
        DeliveryRouteRecordEo deliveryRouteRecordEo = new DeliveryRouteRecordEo();
        BeanUtils.copyProperties((Object)deliveryRouteRecordReqDto, (Object)deliveryRouteRecordEo);
        this.deliveryRouteRecordDas.insert((BaseEo)deliveryRouteRecordEo);
    }

    @Override
    public Integer countRouteRecord(DeliveryRouteCountReqDto deliveryRouteCountReqDto) {
        DeliveryRouteRecordEo deliveryRouteRecordEo = new DeliveryRouteRecordEo();
        deliveryRouteRecordEo.setDeliveryNo(deliveryRouteCountReqDto.getDeliveryNo());
        if (CollectionUtils.isNotEmpty((Collection)deliveryRouteCountReqDto.getOptCodes())) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            SqlFilter sqlFilter = new SqlFilter();
            sqlFilters.add(SqlFilter.in((String)"optCode", (Object)deliveryRouteCountReqDto.getOptCodes()));
            sqlFilters.add(sqlFilter);
            deliveryRouteRecordEo.setSqlFilters(sqlFilters);
        }
        return this.deliveryRouteRecordDas.count((BaseEo)deliveryRouteRecordEo);
    }

    @Override
    public List<String> getHasRouteWarehouseCodes(String deliveryNo) {
        DeliveryRouteRecordEo deliveryRouteRecordSelect = new DeliveryRouteRecordEo();
        deliveryRouteRecordSelect.setDeliveryNo(deliveryNo);
        List list = this.deliveryRouteRecordDas.select((BaseEo)deliveryRouteRecordSelect);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<String> warehouseCodes = list.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getWarehouseCode())).map(StdDeliveryRouteRecordEo::getWarehouseCode).distinct().collect(Collectors.toList());
            return warehouseCodes;
        }
        return null;
    }

    @Override
    public PageInfo<DeliveryRouteRecordRespDto> queryRouteRecord(DeliveryRouteRecordReqDto deliveryRouteRecordReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum.intValue());
        pageInfo.setPages(pageSize.intValue());
        DeliveryRouteRecordEo deliveryRouteRecord = new DeliveryRouteRecordEo();
        BeanUtils.copyProperties((Object)deliveryRouteRecordReqDto, (Object)deliveryRouteRecord);
        List list = this.deliveryRouteRecordDas.selectPage((BaseEo)deliveryRouteRecord, pageNum, pageSize).getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList respDtos = new ArrayList();
            CubeBeanUtils.copyCollection(respDtos, (Collection)list, DeliveryRouteRecordRespDto.class);
            pageInfo.setList(respDtos);
        }
        return pageInfo;
    }
}

