/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteCountReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.DeliveryRouteReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRuleWeightRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.LngLatRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRouteRestDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryErrorEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteRuleEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliverySplitFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.InventoryPriorityEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.OrderRouteRuleStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.RouteTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.DeliveryRouteProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteRecordService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteSplitService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IOrderRouteRuleService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRuleService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.PointUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryRouteRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeliveryRouteServiceImpl
implements IDeliveryRouteService {
    private Logger logger = LoggerFactory.getLogger(DeliveryRouteServiceImpl.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private CargoStorageDas cargoStorageDas;
    @Autowired
    private IOrderRouteRuleService orderRouteRuleService;
    @Resource
    private IDictQueryApi dictQueryApi;
    @Resource
    private DeliveryRouteProducer deliveryRouteProducer;
    @Autowired
    private ICargoStorageService cargoStorageService;
    @Autowired
    private IWarehouseService warehouseService;
    @Resource
    private IRuleService ruleService;
    @Autowired
    private IDeliveryRouteRecordService deliveryRouteRecordService;
    @Autowired
    private IDeliveryRouteSplitService deliveryRouteSplitService;
    @Autowired
    private IDeliveryOrderService deliveryOrderService;
    @Value(value="${gaode.amap.key:}")
    private String gaodeAmapKey;
    @Value(value="${gaode.amap.url:}")
    private String gaodeAmapUrl;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void route(DeliveryRouteReqDto deliveryRouteReqDto, DeliveryRouteRecordEo routeRecord) {
        String deliveryNo = deliveryRouteReqDto.getDeliveryNo();
        long startTime = System.currentTimeMillis();
        DeliveryRouteCountReqDto deliveryRouteCountReqDto = new DeliveryRouteCountReqDto();
        deliveryRouteCountReqDto.setDeliveryNo(deliveryNo);
        deliveryRouteCountReqDto.setOptCodes(Arrays.asList(DeliveryRouteOptEnum.AUTO_ROUTE.getOptCode(), DeliveryRouteOptEnum.RE_ROUTE.getOptCode()));
        Integer routeCount = this.deliveryRouteRecordService.countRouteRecord(deliveryRouteCountReqDto);
        this.logger.info("\u5f00\u59cb\u8def\u7531\u53d1\u8d27\u5355\uff0cdeliveryNo\uff1a{}\uff0c\u5f53\u524d\u8fdb\u884c\u7b2c{}\u6b21\u8def\u7531\u2026\u2026", (Object)deliveryNo, (Object)(routeCount + 1));
        DeliveryVo deliveryVo = this.deliveryOrderService.getDeliveryByDeliveryNo(deliveryNo);
        this.logger.info("deliveryVo:{}", (Object)JSON.toJSONString((Object)deliveryVo));
        OrderDeliveryEo orderDeliveryEo = deliveryVo.getOrderDelivery();
        if (null == orderDeliveryEo) {
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
            throw new BizException("\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u4fe1\u606f");
        }
        String orderNo = deliveryVo.getRefDeliveryOrders().get(0).getOrderNo();
        routeRecord.setDeliveryNo(deliveryNo);
        routeRecord.setOrderNo(orderNo);
        routeRecord.setPreDeliveryStatus(orderDeliveryEo.getDeliveryStatus());
        routeRecord.setPreDeliveryStatusName(DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()));
        if (!DeliveryStatusEnum.TO_ROUTE.getStatus().equals(orderDeliveryEo.getDeliveryStatus())) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610019.getErrorCode(), orderDeliveryEo.getDeliveryStatus(), DeliveryStatusEnum.getMsg((String)orderDeliveryEo.getDeliveryStatus()), "\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u9519\u8bef\uff0c\u5f53\u524d\u7684\u72b6\u6001\u4e3a\u201c" + DeliveryStatusEnum.getMsg((String)(orderDeliveryEo.getDeliveryStatus() + "\u201d\uff0c\u8def\u7531\u72b6\u6001\u4e0d\u66f4\u65b0\u3002")));
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u9519\u8bef\uff0c\u4e0d\u662f\u5f85\u8def\u7531\u72b6\u6001\uff0cdeliveryNo\uff1a{}\uff0cdeliveryStatus\uff1a{}", (Object)deliveryNo, (Object)orderDeliveryEo.getDeliveryStatus());
            throw new BizException(DeliveryErrorEnum.ERROR_610019.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u4e0d\u4e3a\u5f85\u8def\u7531\u72b6\u6001");
        }
        if (StringUtils.isEmpty((CharSequence)orderDeliveryEo.getChannel())) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610004.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u65e0\u6e20\u9053\u4fe1\u606f\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u65e0\u6e20\u9053\u4fe1\u606f\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
            throw new BizException(DeliveryErrorEnum.ERROR_610004.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u65e0\u6e20\u9053\u4fe1\u606f");
        }
        List<DeliveryItemEo> deliveryItemEos = deliveryVo.getDeliveryItems();
        if (CollectionUtils.isEmpty(deliveryItemEos)) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610005.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u65e0\u6e20\u9053\u4fe1\u606f\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u505c\u6b62\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
            throw new BizException(DeliveryErrorEnum.ERROR_610005.getErrorCode(), "\u627e\u4e0d\u5230\u53d1\u8d27\u5355\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f");
        }
        OrderRouteRuleRespDto orderRouteRule = this.getRuleByChannel(orderDeliveryEo.getChannel());
        if (null == orderRouteRule) {
            orderRouteRule = this.getRuleByChannel("default_channel");
        }
        if (null == orderRouteRule) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610000.getErrorCode(), DeliveryStatusEnum.INIT.getStatus(), DeliveryStatusEnum.INIT.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6e20\u9053\u201c" + orderDeliveryEo.getChannel() + "\u201d\u5bf9\u5e94\u7684\u8def\u7531\u89c4\u5219\u914d\u7f6e\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6e20\u9053\u5bf9\u5e94\u7684\u8def\u7531\u89c4\u5219\uff0cdeliveryNo\uff1a{}\uff0cchannel\uff1a{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)orderDeliveryEo.getChannel());
            throw new BizException(DeliveryErrorEnum.ERROR_610000.getErrorCode(), "\u627e\u4e0d\u5230\u6e20\u9053\u5bf9\u5e94\u6e20\u9053\u7684\u8def\u7531\u89c4\u5219");
        }
        this.checkData(deliveryItemEos, routeRecord);
        if (RouteTypeEnum.ASSIGN.getType().equals(orderRouteRule.getRouteType())) {
            this.handleAssignRouteType(orderRouteRule, deliveryItemEos, orderDeliveryEo, routeRecord);
        } else if (RouteTypeEnum.COMBINE.getType().equals(orderRouteRule.getRouteType())) {
            this.handleCombineRouteType(deliveryVo, orderRouteRule, deliveryItemEos, orderDeliveryEo, routeRecord);
        } else {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610017.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5e93\u5b58\u89c4\u5219\u672a\u914d\u7f6e\u8def\u7531\u7c7b\u578b\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u5e93\u5b58\u89c4\u5219\u672a\u914d\u7f6e\u8def\u7531\u7c7b\u578b\uff0cdeliveryNo\uff1a{}\uff0cchannel\uff1a{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)orderDeliveryEo.getChannel());
            throw new BizException(DeliveryErrorEnum.ERROR_610017.getErrorCode(), "\u5e93\u5b58\u89c4\u5219\u672a\u914d\u7f6e\u8def\u7531\u7c7b\u578b\uff0c\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("\u53d1\u8d27\u5355\u8def\u7531\u5b8c\u6bd5\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u603b\u5171\u8017\u65f6\uff1a{}s", (Object)deliveryNo, (Object)Float.valueOf((float)(endTime - startTime) / 1000.0f));
    }

    private void checkData(List<DeliveryItemEo> deliveryItemEos, DeliveryRouteRecordEo routeRecord) {
        StringBuilder sb = new StringBuilder();
        for (DeliveryItemEo deliveryItem : deliveryItemEos) {
            if (!StringUtils.isEmpty((CharSequence)deliveryItem.getCargoSerial())) continue;
            sb.append(deliveryItem.getSkuSerial()).append(",");
        }
        if (sb.length() != 0) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610009.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u5546\u54c1SKU:\u201c" + sb.toString() + "\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u8d27\u54c1\u7f16\u53f7\uff0c\u65e0\u6cd5\u8def\u7531\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.info("\u53d1\u8d27\u5355\u8d27\u54c1\u6570\u636e\u5f02\u5e38\uff0c\u8d27\u54c1\u6570\u636e\u672a\u914d\u7f6e\u8d27\u54c1\u7f16\u7801,deliveryNo:{}, skuIds:{}", (Object)deliveryItemEos.get(0).getDeliveryNo(), (Object)sb.toString());
            throw new BizException(DeliveryErrorEnum.ERROR_610009.getErrorCode(), "\u53d1\u8d27\u5355\u8d27\u54c1\u6570\u636e\u5f02\u5e38\uff0c\u53d1\u8d27\u5355\u8d27\u54c1\u6ca1\u6709\u5bf9\u5e94\u7684\u8d27\u54c1\u7f16\u7801");
        }
    }

    public void handleAssignRouteType(OrderRouteRuleRespDto orderRouteRule, List<DeliveryItemEo> deliveryItemEos, OrderDeliveryEo orderDeliveryEo, DeliveryRouteRecordEo routeRecord) {
        this.logger.info("\u53d1\u8d27\u5355\u8fdb\u884c\u6307\u5b9a\u8def\u5f84\u7c7b\u578b\u8def\u7531...");
        String deliveryWarehouseCode = orderRouteRule.getDeliveryWarehouseCode();
        routeRecord.setRouteType(RouteTypeEnum.ASSIGN.getType());
        if (StringUtils.isEmpty((CharSequence)deliveryWarehouseCode)) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610006.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u672a\u914d\u7f6e\u5177\u4f53\u7684\u4ed3\u5e93\u7f16\u53f7\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u672a\u914d\u7f6e\u5177\u4f53\u7684\u4ed3\u5e93\u7f16\u53f7, OrderRouteRuleRespDto:{}", (Object)JSON.toJSONString((Object)orderRouteRule));
            throw new BizException(DeliveryErrorEnum.ERROR_610006.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u672a\u914d\u7f6e\u5177\u4f53\u7684\u4ed3\u5e93\u7f16\u53f7");
        }
        WarehouseRespDto warehouseRespDto = this.warehouseService.queryByCode(deliveryWarehouseCode);
        if (null == warehouseRespDto) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610007.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u4ed3\u5e93\u7f16\u7801\u201c" + deliveryWarehouseCode + "\u201d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u4ed3\u5e93\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u4ed3\u5e93\u7f16\u7801\uff1a{}", (Object)deliveryWarehouseCode);
            throw new BizException(DeliveryErrorEnum.ERROR_610007.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u4ed3\u5e93\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u4fe1\u606f");
        }
        WarehouseRouteRestDto warehouseRouteRestDto = new WarehouseRouteRestDto();
        BeanUtils.copyProperties((Object)warehouseRespDto, (Object)warehouseRouteRestDto);
        List cargoCodes = deliveryItemEos.stream().map(deliveryItem -> deliveryItem.getCargoSerial()).collect(Collectors.toList());
        CargoStorageEo cargoStorageSelect = new CargoStorageEo();
        cargoStorageSelect.setWarehouseCode(deliveryWarehouseCode);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"cargoCode", cargoCodes));
        cargoStorageSelect.setSqlFilters(sqlFilters);
        List cargoStorages = this.cargoStorageDas.select((BaseEo)cargoStorageSelect);
        Map<String, CargoStorageEo> cargoStorageMap = cargoStorages.stream().collect(Collectors.toMap(StdCargoStorageEo::getCargoCode, w -> w));
        Map<String, List<DeliveryItemEo>> deliveryItemGroupMap = deliveryItemEos.stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getCargoSerial));
        for (Map.Entry<String, List<DeliveryItemEo>> entry : deliveryItemGroupMap.entrySet()) {
            String cargoCode = entry.getKey();
            Integer needItemNum = entry.getValue().stream().mapToInt(StdDeliveryItemEo::getItemNum).sum();
            CargoStorageEo cargoStorage = cargoStorageMap.get(cargoCode);
            if (null == cargoStorage) {
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610001.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u5f84\u4ed3\u5e93\uff1a\u201c" + cargoCode + "\u201d\u91cc\u627e\u4e0d\u5230\u8d27\u54c1\uff1a\u201c" + cargoCode + "\u201d\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
                this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u4ed3\u5e93\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d27\u54c1\u4fe1\u606f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\uff0c\u4ed3\u5e93\u7f16\u7801\uff1a{}\uff0c\u8d27\u54c1\u7f16\u7801\uff1a{}", (Object)deliveryWarehouseCode, (Object)cargoCode);
                throw new BizException(DeliveryErrorEnum.ERROR_610001.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u4ed3\u5e93\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8d27\u54c1\u4fe1\u606f");
            }
            if (cargoStorage.getAvailable().compareTo(new BigDecimal(needItemNum)) >= 0) continue;
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610002.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u6307\u5b9a\u8def\u7531\uff0c\u4ed3\u5e93\uff1a\u201c" + warehouseRespDto.getCode() + "\u201d\u8d27\u54c1\uff1a\u201c" + cargoCode + "\u201d\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u6240\u9700\u5e93\u5b58\u6570\uff1a\u201c" + needItemNum + "\u201d\uff0c\u5b9e\u9645\u5e93\u5b58\u6570\uff1a\u201c" + cargoStorage.getAvailable().intValue() + "\u201d\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\uff0c\u4ed3\u5e93\u7f16\u7801\uff1a{}\uff0c\u8d27\u54c1\u7f16\u7801\uff1a{}\uff0c\u9700\u8981\u5e93\u5b58\u6570\uff1a{}, \u53ef\u7528\u5e93\u5b58\uff1a{}", new Object[]{deliveryWarehouseCode, cargoCode, needItemNum, cargoStorage.getAvailable()});
            throw new BizException(DeliveryErrorEnum.ERROR_610002.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u4e0d\u8db3");
        }
        this.router2Warehouse(warehouseRouteRestDto, orderDeliveryEo, deliveryItemEos, routeRecord);
    }

    /*
     * WARNING - void declaration
     */
    public void handleCombineRouteType(DeliveryVo deliveryVo, OrderRouteRuleRespDto orderRouteRule, List<DeliveryItemEo> deliveryItemEos, OrderDeliveryEo orderDeliveryEo, DeliveryRouteRecordEo routeRecord) {
        this.logger.info("\u53d1\u8d27\u5355\u8fdb\u884c\u7ec4\u5408\u8def\u5f84\u7c7b\u578b\u8def\u7531...");
        routeRecord.setRouteType(RouteTypeEnum.COMBINE.getType());
        LngLatRespDto lngLatRespDto = this.getLngLat(orderDeliveryEo.getAddress());
        if (null == lngLatRespDto) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610016.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u9ad8\u5fb7\u5730\u56fe\u83b7\u53d6\u4e0d\u5230\u5730\u5740\u201c" + orderDeliveryEo.getAddress() + "\u201d\u5bf9\u5e94\u7684\u7ecf\u7eac\u5ea6\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u9ad8\u5fb7\u5730\u56fe\u6839\u636e\u6536\u8d27\u5730\u5740\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ecf\u7eac\u5ea6\uff0c\u505c\u6b62\u8def\u7531\uff0caddress\uff1a{}", (Object)orderDeliveryEo.getAddress());
            throw new BizException(DeliveryErrorEnum.ERROR_610016.getErrorCode(), "\u9ad8\u5fb7\u5730\u56fe\u627e\u4e0d\u5230\u6536\u8d27\u5730\u5740\u7684\u7ecf\u7eac\u5ea6");
        }
        String deliveryNo = orderDeliveryEo.getDeliveryNo();
        Map<String, DeliveryRouteRuleWeightRespDto> ruleMap = this.getRuleMap(orderRouteRule, orderDeliveryEo, routeRecord);
        ArrayList<CargoStorageEo> hasAvailableCargoStorages = new ArrayList<CargoStorageEo>();
        HashedMap hasAvailableCargoStorageGroupMap = new HashedMap();
        HashedMap hasAvailableCargoStorageMap = new HashedMap();
        HashedMap fullAvailableCargoStorageMap = new HashedMap();
        HashedMap cargoWarehouseMap = new HashedMap();
        HashedMap hasAvailableWarehouseMap = new HashedMap();
        List<String> hasRouteWarehouseCodes = this.deliveryRouteRecordService.getHasRouteWarehouseCodes(deliveryNo);
        ArrayList<DeliveryItemEo> deliveryItems = new ArrayList<DeliveryItemEo>();
        Map<String, List<DeliveryItemEo>> deliveryItemGroupMap = deliveryVo.getDeliveryItems().stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getCargoSerial));
        for (Map.Entry<String, List<DeliveryItemEo>> entry : deliveryItemGroupMap.entrySet()) {
            List<DeliveryItemEo> items = entry.getValue();
            Integer n = entry.getValue().stream().mapToInt(StdDeliveryItemEo::getItemNum).sum();
            DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
            BeanUtils.copyProperties((Object)items.get(0), (Object)deliveryItemEo);
            deliveryItemEo.setItemNum(n);
            deliveryItems.add(deliveryItemEo);
        }
        for (DeliveryItemEo deliveryItemEo : deliveryItems) {
            if (null != hasAvailableCargoStorageGroupMap.get(deliveryItemEo.getCargoSerial())) continue;
            if (StringUtils.isEmpty((CharSequence)deliveryItemEo.getCargoSerial())) {
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610009.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u53d1\u8d27\u5355\u5546\u54c1SKU_ID:\u201c" + deliveryItemEo.getSkuSerial() + "\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u8d27\u54c1\u7f16\u7801\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                this.logger.error("\u53d1\u8d27\u5355\u5546\u54c1\u6ca1\u6709\u5bf9\u5e94\u7684\u8d27\u54c1\u7f16\u7801\uff0c\u505c\u6b62\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
                throw new BizException(DeliveryErrorEnum.ERROR_610009.getErrorCode(), "\u53d1\u8d27\u5355\u5546\u54c1\u6ca1\u6709\u5bf9\u5e94\u7684\u8d27\u54c1id");
            }
            String cargoCode = deliveryItemEo.getCargoSerial();
            ArrayList<WarehouseEo> arrayList = new ArrayList<WarehouseEo>();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            ArrayList<CargoStorageEo> hasAvailableCargoStorageList = new ArrayList<CargoStorageEo>();
            ArrayList<CargoStorageEo> fullAvailableCargoStorageList = new ArrayList<CargoStorageEo>();
            this.loadCargoStorageByCargoCode(cargoCode, deliveryItemEo.getItemNum(), arrayList2, hasAvailableCargoStorageList, fullAvailableCargoStorageList, (Map<String, CargoStorageEo>)hasAvailableCargoStorageMap, hasRouteWarehouseCodes);
            hasAvailableCargoStorages.addAll(hasAvailableCargoStorageList);
            try {
                this.loadWarehouseEos(arrayList2, arrayList, (Map<Long, WarehouseEo>)hasAvailableWarehouseMap, orderRouteRule);
            }
            catch (Exception e) {
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610018.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u6839\u636e\u4ed3\u5e93ID\u96c6\u5408\u67e5\u8be2\u4ed3\u5e93\u51fa\u73b0\u5f02\u5e38\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002" + e.getMessage());
                this.logger.error("\u6839\u636e\u4ed3\u5e93id\u96c6\u5408\u67e5\u8be2\u4ed3\u5e93\u51fa\u73b0\u5f02\u5e38\uff0ce:{}", (Object)e.getMessage(), (Object)e);
                throw new BizException(DeliveryErrorEnum.ERROR_610018.getErrorCode(), "\u6839\u636e\u4ed3\u5e93id\u96c6\u5408\u67e5\u8be2\u4ed3\u5e93\u51fa\u73b0\u5f02\u5e38");
            }
            hasAvailableCargoStorageGroupMap.put(cargoCode, hasAvailableCargoStorageList);
            fullAvailableCargoStorageMap.put(cargoCode, fullAvailableCargoStorageList);
            cargoWarehouseMap.put(cargoCode, arrayList);
        }
        if (!this.ifCanSplit(orderRouteRule, deliveryVo.getOrderDelivery().getParentDeliveryNo()).booleanValue()) {
            void var21_33;
            List<Object> mixCargoStorageEos = new ArrayList();
            boolean ifFirst = true;
            for (DeliveryItemEo deliveryItemEo : deliveryItemEos) {
                String string = deliveryItemEo.getCargoSerial();
                List cargoStorageEos = (List)fullAvailableCargoStorageMap.get(string);
                if (CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
                    routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610011.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff1a\u201c" + string + "\u201d\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                    this.logger.info("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff0cdeliveryNo:{}\uff0ccargoCode\uff1a{}", (Object)deliveryNo, (Object)string);
                    throw new BizException(DeliveryErrorEnum.ERROR_610011.getErrorCode(), "\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1");
                }
                if (ifFirst) {
                    mixCargoStorageEos = cargoStorageEos;
                    ifFirst = false;
                    continue;
                }
                if (!CollectionUtils.isEmpty(mixCargoStorageEos = this.mixCollectionList(cargoStorageEos, mixCargoStorageEos))) continue;
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610011.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff1a\u201c" + string + "\u201d\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                this.logger.info("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff0cdeliveryNo:{},cargoCode:{}", (Object)deliveryNo, (Object)string);
                throw new BizException(DeliveryErrorEnum.ERROR_610011.getErrorCode(), "\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1");
            }
            if (CollectionUtils.isEmpty(mixCargoStorageEos)) {
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610012.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u4e0d\u9700\u8981\u62c6\u5355\u6ee1\u8db3\u8def\u7531\u7684\u4ed3\u5e93\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
                throw new BizException(DeliveryErrorEnum.ERROR_610012.getErrorCode(), "\u5339\u914d\u4e0d\u5230\u4e0d\u9700\u8981\u62c6\u5355\u7684\u4ed3\u5e93\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            }
            ArrayList<WarehouseRouteRestDto> warehouseRouteRestDtoList = new ArrayList<WarehouseRouteRestDto>();
            for (CargoStorageEo cargoStorageEo : mixCargoStorageEos) {
                WarehouseRouteRestDto warehouseRouteRestDto = new WarehouseRouteRestDto();
                WarehouseEo warehouseEo = (WarehouseEo)hasAvailableWarehouseMap.get(cargoStorageEo.getWarehouseId());
                if (null == warehouseEo) {
                    this.logger.info("\u4ed3\u5e93\u8d27\u54c1\u5bf9\u5e94\u4ed3\u5e93\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u76f4\u63a5\u8df3\u8fc7\u8be5\u4ed3\u5e93\uff0cwarehouseCode:{},cargoCode:{}", (Object)cargoStorageEo.getWarehouseCode(), (Object)cargoStorageEo.getCargoCode());
                    continue;
                }
                if (null == warehouseEo.getLongitude() || null == warehouseEo.getLatitude()) {
                    this.logger.warn("\u4ed3\u5e93\u7684\u7ecf\u7eac\u5ea6\u4e3a\u7a7a,\u76f4\u63a5\u8df3\u8fc7\u8be5\u4ed3\u5e93\uff0c\u4ed3\u5e93:{}-{}", (Object)warehouseEo.getCode(), (Object)warehouseEo.getName());
                    continue;
                }
                BeanUtils.copyProperties((Object)warehouseEo, (Object)warehouseRouteRestDto);
                warehouseRouteRestDtoList.add(warehouseRouteRestDto);
            }
            if (CollectionUtils.isEmpty(warehouseRouteRestDtoList)) {
                this.logger.error("\u5339\u914d\u4e0d\u5230\u4efb\u4f55\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u505c\u6b62\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610012.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u4e0d\u9700\u8981\u62c6\u5355\u6ee1\u8db3\u8def\u7531\u7684\u4ed3\u5e93\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
                throw new BizException(DeliveryErrorEnum.ERROR_610012.getErrorCode(), "\u5339\u914d\u4e0d\u5230\u4efb\u52a1\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            }
            this.caculateAndSortScore(ruleMap, warehouseRouteRestDtoList, routeRecord, lngLatRespDto);
            Object var21_30 = null;
            if (InventoryPriorityEnum.ROUTE_SCORE.getPriority().equals(orderRouteRule.getInventoryPriority())) {
                this.logger.info("\u5e93\u5b58\u4f18\u5148\u7ea7\u4e3a\u8def\u7531\u5f97\u5206\u4f18\u5148\uff0c\u83b7\u53d6\u8def\u7531\u5206\u6570\u6700\u9ad8\u7684\u4ed3\u5e93\u8fdb\u884c\u8def\u7531\u2026\u2026");
                WarehouseRouteRestDto warehouseRouteRestDto = (WarehouseRouteRestDto)warehouseRouteRestDtoList.get(0);
            } else if (InventoryPriorityEnum.INVENTORY.getPriority().equals(orderRouteRule.getInventoryPriority())) {
                this.logger.info("\u5e93\u5b58\u4f18\u5148\u7ea7\u4e3a\u5e93\u5b58\u4f18\u5148\uff0c\u6839\u636e\u5e93\u5b58\u89c4\u5219\u4fe1\u606f\u83b7\u53d6\u6700\u9ad8\u5f97\u5206\u8fdb\u884c\u8def\u7531\u2026\u2026");
                WarehouseRouteRestDto warehouseRouteRestDto = this.filterByInventoryRule(orderRouteRule, warehouseRouteRestDtoList);
            }
            if (null == var21_33) {
                this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\uff01deliveryNo:{}", (Object)deliveryNo);
                throw new BizException(DeliveryErrorEnum.ERROR_610013.getErrorCode(), "\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\uff01");
            }
            routeRecord.setRouteScore(Double.valueOf(var21_33.getTotalScore()));
            this.router2Warehouse((WarehouseRouteRestDto)var21_33, orderDeliveryEo, deliveryItemEos, routeRecord);
        } else if (DeliverySplitFlagEnum.SPLIT.getFlag().equals(orderRouteRule.getSplitFlag())) {
            boolean needSplit = false;
            List<Object> mixCargoStorageEos = new ArrayList();
            boolean ifFirst = true;
            for (DeliveryItemEo deliveryItemEo : deliveryItemEos) {
                String cargoCode = deliveryItemEo.getCargoSerial();
                List cargoStorageEos = (List)fullAvailableCargoStorageMap.get(cargoCode);
                if (CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
                    needSplit = true;
                    this.logger.info("\u53d1\u8d27\u5355\u4e0d\u62c6\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\uff0cdeliveryNo:{}\uff0ccargoCode\uff1a{}", (Object)deliveryNo, (Object)cargoCode);
                    break;
                }
                if (ifFirst) {
                    mixCargoStorageEos = cargoStorageEos;
                    ifFirst = false;
                    continue;
                }
                if (!CollectionUtils.isEmpty(mixCargoStorageEos = this.mixCollectionList(cargoStorageEos, mixCargoStorageEos))) continue;
                needSplit = true;
                this.logger.info("\u53d1\u8d27\u5355\u4e0d\u62c6\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\uff0cdeliveryNo:{}\uff0ccargoCode\uff1a{}", (Object)deliveryNo, (Object)cargoCode);
                break;
            }
            if (CollectionUtils.isEmpty(mixCargoStorageEos)) {
                needSplit = true;
                this.logger.info("\u53d1\u8d27\u5355\u4e0d\u62c6\u5355\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u4ed3\u5e93\u8d27\u54c1\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\u2026\u2026");
            }
            if (!needSplit) {
                void var22_49;
                ArrayList<WarehouseRouteRestDto> arrayList = new ArrayList<WarehouseRouteRestDto>();
                for (CargoStorageEo cargoStorageEo : mixCargoStorageEos) {
                    WarehouseRouteRestDto warehouseRouteRestDto = new WarehouseRouteRestDto();
                    WarehouseEo warehouseEo = (WarehouseEo)hasAvailableWarehouseMap.get(cargoStorageEo.getWarehouseId());
                    if (null == warehouseEo) {
                        this.logger.info("\u4ed3\u5e93\u8d27\u54c1\u5bf9\u5e94\u4ed3\u5e93\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u76f4\u63a5\u8df3\u8fc7\u8be5\u4ed3\u5e93\uff0cwarehouseCode:{},cargoCode:{}", (Object)cargoStorageEo.getWarehouseCode(), (Object)cargoStorageEo.getCargoCode());
                        continue;
                    }
                    if (null == warehouseEo.getLongitude() || null == warehouseEo.getLatitude()) {
                        this.logger.warn("\u4ed3\u5e93\u7684\u7ecf\u7eac\u5ea6\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8df3\u8fc7\u8be5\u4ed3\u5e93\uff0c\u4ed3\u5e93:{}-{}", (Object)warehouseEo.getCode(), (Object)warehouseEo.getName());
                        continue;
                    }
                    BeanUtils.copyProperties((Object)warehouseEo, (Object)warehouseRouteRestDto);
                    arrayList.add(warehouseRouteRestDto);
                }
                if (CollectionUtils.isEmpty(arrayList)) {
                    this.logger.error("\u5339\u914d\u4e0d\u5230\u4efb\u4f55\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u505c\u6b62\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)deliveryNo);
                    routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610012.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u4e0d\u9700\u8981\u62c6\u5355\u6ee1\u8db3\u8def\u7531\u7684\u4ed3\u5e93\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
                    this.logger.info("\u53d1\u8d27\u5355\u4e0d\u62c6\u5355\u8def\u7531\u4e0d\u5230\u4ed3\u5e93\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\u2026\u2026");
                    this.deliveryRouteSplitService.routeSplit(deliveryVo, orderRouteRule, (Map<String, List<CargoStorageEo>>)hasAvailableCargoStorageGroupMap, (Map<String, CargoStorageEo>)hasAvailableCargoStorageMap, (Map<Long, WarehouseEo>)hasAvailableWarehouseMap, lngLatRespDto, routeRecord);
                    return;
                }
                this.caculateAndSortScore(ruleMap, arrayList, routeRecord, lngLatRespDto);
                Object var22_46 = null;
                if (InventoryPriorityEnum.ROUTE_SCORE.getPriority().equals(orderRouteRule.getInventoryPriority())) {
                    this.logger.info("\u5e93\u5b58\u4f18\u5148\u7ea7\u4e3a\u8def\u7531\u5f97\u5206\u4f18\u5148\uff0c\u83b7\u53d6\u8def\u7531\u5206\u6570\u6700\u9ad8\u7684\u4ed3\u5e93\u8fdb\u884c\u8def\u7531");
                    WarehouseRouteRestDto warehouseRouteRestDto = (WarehouseRouteRestDto)arrayList.get(0);
                } else if (InventoryPriorityEnum.INVENTORY.getPriority().equals(orderRouteRule.getInventoryPriority())) {
                    this.logger.info("\u5e93\u5b58\u4f18\u5148\u7ea7\u4e3a\u5e93\u5b58\u4f18\u5148\uff0c\u6839\u636e\u5e93\u5b58\u89c4\u5219\u4fe1\u606f\u83b7\u53d6\u6700\u9ad8\u5f97\u5206\u8fdb\u884c\u8def\u7531");
                    WarehouseRouteRestDto warehouseRouteRestDto = this.filterByInventoryRule(orderRouteRule, arrayList);
                }
                if (null == var22_49) {
                    this.logger.info("\u53d1\u8d27\u5355\u4e0d\u62c6\u5355\u8def\u7531\u4e0d\u5230\u4ed3\u5e93\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\u2026\u2026");
                    this.deliveryRouteSplitService.routeSplit(deliveryVo, orderRouteRule, (Map<String, List<CargoStorageEo>>)hasAvailableCargoStorageGroupMap, (Map<String, CargoStorageEo>)hasAvailableCargoStorageMap, (Map<Long, WarehouseEo>)hasAvailableWarehouseMap, lngLatRespDto, routeRecord);
                    return;
                }
                routeRecord.setRouteScore(Double.valueOf(var22_49.getTotalScore()));
                this.router2Warehouse((WarehouseRouteRestDto)var22_49, orderDeliveryEo, deliveryItemEos, routeRecord);
            } else {
                this.logger.info("\u53d1\u8d27\u5355\u4e0d\u62c6\u5355\u8def\u7531\u4e0d\u5230\u4ed3\u5e93\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\u2026\u2026");
                this.deliveryRouteSplitService.routeSplit(deliveryVo, orderRouteRule, (Map<String, List<CargoStorageEo>>)hasAvailableCargoStorageGroupMap, (Map<String, CargoStorageEo>)hasAvailableCargoStorageMap, (Map<Long, WarehouseEo>)hasAvailableWarehouseMap, lngLatRespDto, routeRecord);
            }
        } else {
            this.logger.error("\u8def\u7531\u89c4\u5219\u672a\u8bbe\u7f6e\u662f\u5426\u9700\u8981\u62c6\u5355");
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610021.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u89c4\u5219\u672a\u8bbe\u7f6e\u662f\u5426\u9700\u8981\u62c6\u5355,\u8def\u7531\u201c" + orderRouteRule.getRouteRuleName() + "(" + orderRouteRule.getApplicableChannel() + ")\u201d \uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
        }
    }

    private Boolean ifCanSplit(OrderRouteRuleRespDto orderRouteRule, String parentDeliveryNo) {
        if (DeliverySplitFlagEnum.NOT_SPLIT.getFlag().equals(orderRouteRule.getSplitFlag())) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)parentDeliveryNo) && !"0".equals(parentDeliveryNo)) {
            return false;
        }
        return true;
    }

    @Override
    public void caculateAndSortScore(Map<String, DeliveryRouteRuleWeightRespDto> ruleMap, List<WarehouseRouteRestDto> warehouseRouteRestDtoList, DeliveryRouteRecordEo routeRecord, LngLatRespDto lngLatRespDto) {
        DeliveryRouteRuleWeightRespDto distanceRoute = ruleMap.get(DeliveryRouteRuleEnum.EFFICIENCY.getType());
        for (WarehouseRouteRestDto warehouseRouteRestDto : warehouseRouteRestDtoList) {
            double creditScore = 0.0;
            DeliveryRouteRuleWeightRespDto creditRule = ruleMap.get(DeliveryRouteRuleEnum.CREDIT_VALUE.getType());
            if (null != creditRule) {
                creditScore = (double)warehouseRouteRestDto.getCreditValue().intValue() * creditRule.getRation();
            }
            double thresholdScore = 0.0;
            DeliveryRouteRuleWeightRespDto thresholdRoute = ruleMap.get(DeliveryRouteRuleEnum.THRESHOLD.getType());
            if (null != thresholdRoute && null != warehouseRouteRestDto.getThresholdValue()) {
                thresholdScore = (double)warehouseRouteRestDto.getThresholdValue().intValue() * ruleMap.get(DeliveryRouteRuleEnum.THRESHOLD.getType()).getRation();
            }
            double inventoryScore = 0.0;
            DeliveryRouteRuleWeightRespDto inventoryRoute = ruleMap.get(DeliveryRouteRuleEnum.INVENTORY.getType());
            if (null != inventoryRoute) {
                inventoryScore = 100.0 * inventoryRoute.getRation();
            }
            double deliverTimeScore = 0.0;
            DeliveryRouteRuleWeightRespDto efficiencyRoute = ruleMap.get(DeliveryRouteRuleEnum.EFFICIENCY.getType());
            if (null != efficiencyRoute) {
                deliverTimeScore = (double)warehouseRouteRestDto.getDeliverTimeLimit().intValue() * efficiencyRoute.getRation();
            }
            if (null != distanceRoute) {
                double distance = 0.0;
                if (null != warehouseRouteRestDto.getLatitude() && null != warehouseRouteRestDto.getLongitude()) {
                    distance = PointUtil.getDistance(warehouseRouteRestDto.getLatitude(), warehouseRouteRestDto.getLongitude(), lngLatRespDto.getLatitude(), lngLatRespDto.getLongitude());
                }
                warehouseRouteRestDto.setDistance(distance);
            }
            warehouseRouteRestDto.setCreditScore(creditScore);
            warehouseRouteRestDto.setThresholdScore(thresholdScore);
            warehouseRouteRestDto.setInventoryScore(inventoryScore);
            warehouseRouteRestDto.setDeliverTimeScore(deliverTimeScore);
        }
        if (null != distanceRoute) {
            DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "STORE_SETTING", "DISTANCE_SETTING").getData();
            if (null == dictDto) {
                routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610013.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u95e8\u5e97\u8bbe\u7f6e\u672a\u914d\u7f6e'\u8ddd\u79bb\u8bbe\u7f6e'\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
                this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u95e8\u5e97\u8bbe\u7f6e\u672a\u914d\u7f6e'\u8ddd\u79bb\u8bbe\u7f6e'!");
                throw new BizException(DeliveryErrorEnum.ERROR_610013.getErrorCode(), "\u95e8\u5e97\u8bbe\u7f6e\u672a\u914d\u7f6e'\u8ddd\u79bb\u8bbe\u7f6e'");
            }
            warehouseRouteRestDtoList.sort(Comparator.comparing(WarehouseRouteRestDto::getDistance));
            Map map = (Map)JSONObject.parseObject((String)dictDto.getValue(), Map.class);
            Integer stepScore = Integer.parseInt(map.get("value").toString());
            Integer distanceInitScore = 100;
            Double preDistance = null;
            for (WarehouseRouteRestDto warehouseRouteRestDto : warehouseRouteRestDtoList) {
                if (null != preDistance && preDistance.doubleValue() != warehouseRouteRestDto.getDistance() & distanceInitScore > 0) {
                    distanceInitScore = distanceInitScore - stepScore;
                }
                preDistance = warehouseRouteRestDto.getDistance();
                distanceInitScore = distanceInitScore > 0 ? distanceInitScore : 0;
                warehouseRouteRestDto.setDistanceScore((double)distanceInitScore.intValue() * distanceRoute.getRation());
            }
        }
        for (WarehouseRouteRestDto warehouseRouteRestDto : warehouseRouteRestDtoList) {
            warehouseRouteRestDto.setTotalScore(warehouseRouteRestDto.getCreditScore() + warehouseRouteRestDto.getThresholdScore() + warehouseRouteRestDto.getInventoryScore() + warehouseRouteRestDto.getDeliverTimeScore() + warehouseRouteRestDto.getDistanceScore());
        }
        warehouseRouteRestDtoList.sort(Comparator.comparing(WarehouseRouteRestDto::getTotalScore).reversed());
        this.logger.info("\u6ee1\u8db3\u53d1\u8d27\u5355\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(warehouseRouteRestDtoList));
    }

    private WarehouseRouteRestDto filterByInventoryRule(OrderRouteRuleRespDto orderRouteRule, List<WarehouseRouteRestDto> warehouseRouteRestDtoList) {
        String inventoryPriorityItem = orderRouteRule.getInventoryPriorityItem();
        List ruleIds = JSON.parseArray((String)inventoryPriorityItem, Long.class);
        List<RuleRespDto> rules = this.ruleService.queryByIds(ruleIds, EnableEnum.ENABLE.getCode());
        for (RuleRespDto ruleRespDto : rules) {
            for (WarehouseRouteRestDto warehouseRoute : warehouseRouteRestDtoList) {
                boolean ifMatch = this.orderRouteRuleService.checkMatch(warehouseRoute, ruleRespDto);
                if (!ifMatch) continue;
                return warehouseRoute;
            }
        }
        return null;
    }

    public void router2Warehouse(WarehouseRouteRestDto warehouseRouteRestDto, OrderDeliveryEo orderDeliveryEo, List<DeliveryItemEo> deliveryItemEos, DeliveryRouteRecordEo routeRecord) {
        OrderDeliveryEo orderDeliveryUpdate = new OrderDeliveryEo();
        orderDeliveryUpdate.setId(orderDeliveryEo.getId());
        orderDeliveryUpdate.setWarehouseCode(warehouseRouteRestDto.getCode());
        orderDeliveryUpdate.setWarehouseName(warehouseRouteRestDto.getName());
        orderDeliveryUpdate.setWarehouseOrganizationId(warehouseRouteRestDto.getOrganizationId());
        orderDeliveryUpdate.setWarehouseOrganizationName(warehouseRouteRestDto.getOrganizationName());
        routeRecord.setWarehouseCode(warehouseRouteRestDto.getCode());
        routeRecord.setWarehouseName(warehouseRouteRestDto.getName());
        if (WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode() == warehouseRouteRestDto.getSubType().intValue()) {
            orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.TO_RECEIVING.getStatus());
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610022.getErrorCode(), DeliveryStatusEnum.TO_RECEIVING.getStatus(), DeliveryStatusEnum.TO_RECEIVING.getMsg(), "\u8def\u7531\u6210\u529f\uff0c\u8def\u7531\u5230\u95e8\u5e97\u5e93\uff1a\u201c" + warehouseRouteRestDto.getCode() + "-" + warehouseRouteRestDto.getName() + "\u201d\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u63a5\u5355\u3002");
        } else {
            orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.INIT.getStatus());
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610022.getErrorCode(), DeliveryStatusEnum.INIT.getStatus(), DeliveryStatusEnum.INIT.getMsg(), "\u8def\u7531\u6210\u529f\uff0c\u8def\u7531\u5230\u975e\u95e8\u5e97\u5e93\uff1a\u201c" + warehouseRouteRestDto.getCode() + "-" + warehouseRouteRestDto.getName() + "\u201d\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u53d1\u8d27\u3002");
        }
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        for (DeliveryItemEo deliveryItemEo : deliveryItemEos) {
            StorageChangeReqDto storageChangeReqDto = new StorageChangeReqDto();
            storageChangeReqDto.setWarehouseId(warehouseRouteRestDto.getId());
            storageChangeReqDto.setCargoCode(deliveryItemEo.getCargoSerial());
            storageChangeReqDto.setPreempt(new BigDecimal(deliveryItemEo.getItemNum()));
            storageChangeReqDto.setAvailable(new BigDecimal(-deliveryItemEo.getItemNum().intValue()));
            this.cargoStorageService.addAvailablePreempt(storageChangeReqDto);
        }
        DeliveryRouteRespDto deliveryRouteRespDto = new DeliveryRouteRespDto();
        deliveryRouteRespDto.setDeliveryNo(orderDeliveryEo.getDeliveryNo());
        deliveryRouteRespDto.setDeliveryStatus(orderDeliveryUpdate.getDeliveryStatus());
        deliveryRouteRespDto.setWarehouseCode(warehouseRouteRestDto.getCode());
        deliveryRouteRespDto.setWarehouseName(warehouseRouteRestDto.getName());
        deliveryRouteRespDto.setWarehouseSubType(String.valueOf(warehouseRouteRestDto.getSubType()));
        deliveryRouteRespDto.setOrganizationId(warehouseRouteRestDto.getOrganizationId());
        deliveryRouteRespDto.setOrganizationName(warehouseRouteRestDto.getOrganizationName());
        this.logger.info("\u63a5\u6536\u5230\u53d1\u8d27\u5355\u8def\u7531\u6307\u4ee4 --> \u8bbe\u7f6e\u5e93\u5b58\u4e2d\u5fc3\u5173\u8054\u7684\u7ec4\u7ec7\u6743\u9650(\u4ed3\u5e93\u7ec4\u7ec7id) --> \u4f4d\u7f6e\uff1a{}\uff0c\u8bbe\u7f6e\u7ec4\u7ec7\u6743\u9650\u503c\u7684\u5b9e\u4f53\uff1a{}", (Object)"[DeliveryRouteServiceImpl].[router2Warehouse]", (Object)JSONObject.toJSONString((Object)deliveryRouteRespDto));
        this.deliveryRouteProducer.sendDeliberyRoutReslut(deliveryRouteRespDto);
        this.logger.info("\u53d1\u8d27\u5355\u8def\u7531\u6210\u529f\uff0c\u53d1\u8d27\u5355\u53f7\uff1a{}\uff0c\u8def\u7531\u72b6\u6001\uff1a{}-{}\uff0c\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{}", new Object[]{orderDeliveryEo.getDeliveryNo(), orderDeliveryUpdate.getDeliveryStatus(), DeliveryStatusEnum.getMsg((String)orderDeliveryUpdate.getDeliveryStatus()), warehouseRouteRestDto.getCode(), warehouseRouteRestDto.getName()});
    }

    public List<CargoStorageEo> mixCollectionList(List<CargoStorageEo> firstArrayList, List<CargoStorageEo> secondArrayList) {
        if (CollectionUtils.isEmpty(firstArrayList)) {
            return null;
        }
        return firstArrayList.stream().filter(firstList -> secondArrayList.stream().map(StdCargoStorageEo::getWarehouseId).anyMatch(warehouseId -> Objects.equals(firstList.getWarehouseId(), warehouseId))).collect(Collectors.toList());
    }

    private void loadWarehouseEos(List<Long> warehouseIds, List<WarehouseEo> warehouseEos, Map<Long, WarehouseEo> hasAvailableWarehouseMap, OrderRouteRuleRespDto orderRouteRule) {
        PageInfo<WarehouseEo> pageInfo;
        Integer pageNum = 1;
        Integer pageSize = 10000;
        String filterSql = this.orderRouteRuleService.getWarehouseFilterSql(orderRouteRule);
        WarehouseEo warehouseSelect = new WarehouseEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", warehouseIds));
        warehouseSelect.setSqlFilters(sqlFilters);
        warehouseSelect.setType(String.valueOf(WarehouseTypeEnum.LOGICAL.getCode()));
        WarehouseQueryReqDto warehouseQueryReqDto = new WarehouseQueryReqDto();
        warehouseQueryReqDto.setIds(warehouseIds);
        warehouseQueryReqDto.setFilterSql(filterSql);
        while (CollectionUtils.isNotEmpty((Collection)(pageInfo = this.warehouseService.queryWarehouseByFilter(warehouseQueryReqDto, pageNum, pageSize)).getList())) {
            pageInfo.getList().stream().forEach(warehouseEo -> {
                hasAvailableWarehouseMap.put(warehouseEo.getId(), (WarehouseEo)warehouseEo);
                warehouseEos.add((WarehouseEo)warehouseEo);
            });
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }

    @Override
    public Map<String, DeliveryRouteRuleWeightRespDto> getRuleMap(OrderRouteRuleRespDto orderRouteRule, OrderDeliveryEo orderDeliveryEo, DeliveryRouteRecordEo routeRecord) {
        String weightItemJson = orderRouteRule.getWeightItem();
        List orderRouteRuleWeightRespDtos = JSON.parseArray((String)weightItemJson, DeliveryRouteRuleWeightRespDto.class);
        if (CollectionUtils.isEmpty((Collection)orderRouteRuleWeightRespDtos)) {
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610014.getErrorCode(), DeliveryStatusEnum.TO_DO.getStatus(), DeliveryStatusEnum.TO_DO.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u8def\u7531\u89c4\u5219\u6e20\u9053\u201c" + orderRouteRule.getApplicableChannel() + "\u201d\u5bf9\u5e94\u7684\u6743\u91cd\u4e3a\u7a7a\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u5904\u7406\u3002");
            this.logger.error("\u53d1\u8d27\u5355\u8def\u7531\u5931\u8d25\uff0c\u8def\u7531\u89c4\u5219\u6743\u91cd\u4e3a\u7a7a\uff0cdeliveryNo\uff1a{}\uff0cchannel\uff1a{}", (Object)orderDeliveryEo.getDeliveryNo(), (Object)orderDeliveryEo.getChannel());
            throw new BizException(DeliveryErrorEnum.ERROR_610014.getErrorCode(), "\u8def\u7531\u89c4\u5219\u6743\u91cd\u4e3a\u7a7a");
        }
        HashedMap map = new HashedMap();
        for (DeliveryRouteRuleWeightRespDto orderRouteRuleWeightRespDto : orderRouteRuleWeightRespDtos) {
            map.put(orderRouteRuleWeightRespDto.getType(), orderRouteRuleWeightRespDto);
        }
        return map;
    }

    @Override
    public OrderRouteRuleRespDto getRuleByChannel(String channel) {
        OrderRouteRuleQueryReqDto orderRouteRuleQueryReqDto = new OrderRouteRuleQueryReqDto();
        orderRouteRuleQueryReqDto.setApplicableChannel(channel);
        orderRouteRuleQueryReqDto.setStatus(OrderRouteRuleStatusEnum.ENABLE.getStatus());
        List list = this.orderRouteRuleService.queryRouteRulesByPage(orderRouteRuleQueryReqDto, 1, 1).getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (OrderRouteRuleRespDto)list.get(0);
        }
        return null;
    }

    private void loadCargoStorageByCargoCode(String cargoCode, Integer itemNum, List<Long> warehouseIds, List<CargoStorageEo> hasAvailableCargoStorageList, List<CargoStorageEo> fullAvailableCargoStorageList, Map<String, CargoStorageEo> hasAvailableCargoStorageMap, List<String> excludeWarehouseCodes) {
        PageInfo pageInfo;
        List cargoStorageEos;
        Integer pageNum = 1;
        Integer pageSize = 10000;
        CargoStorageEo cargoStorageSelect = new CargoStorageEo();
        cargoStorageSelect.setCargoCode(cargoCode);
        cargoStorageSelect.setWarehouseType(String.valueOf(WarehouseTypeEnum.LOGICAL.getCode()));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.ge((String)"available", (Object)1));
        if (CollectionUtils.isNotEmpty(excludeWarehouseCodes)) {
            for (String warehouseCode : excludeWarehouseCodes) {
                sqlFilters.add(SqlFilter.ne((String)"warehouseCode", (Object)warehouseCode));
            }
        }
        cargoStorageSelect.setSqlFilters(sqlFilters);
        while (CollectionUtils.isNotEmpty((Collection)(cargoStorageEos = (pageInfo = this.cargoStorageDas.selectPage((BaseEo)cargoStorageSelect, pageNum, pageSize)).getList()))) {
            cargoStorageEos.stream().forEach(cargoStorageEo -> {
                warehouseIds.add(cargoStorageEo.getWarehouseId());
                if (cargoStorageEo.getAvailable().longValue() >= (long)itemNum.intValue()) {
                    fullAvailableCargoStorageList.add((CargoStorageEo)cargoStorageEo);
                }
            });
            hasAvailableCargoStorageList.addAll(cargoStorageEos);
            for (CargoStorageEo cargoStorageEo2 : cargoStorageEos) {
                hasAvailableCargoStorageMap.put(cargoStorageEo2.getWarehouseCode() + "-" + cargoStorageEo2.getCargoCode(), cargoStorageEo2);
            }
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }

    public LngLatRespDto getLngLat(String address) {
        if (StringUtils.isEmpty((CharSequence)this.gaodeAmapUrl)) {
            throw new BizException(DeliveryErrorEnum.ERROR_610015.getErrorCode(), "\u672a\u914d\u7f6e\u9ad8\u5fb7\u5730\u56feurl");
        }
        if (StringUtils.isEmpty((CharSequence)this.gaodeAmapKey)) {
            throw new BizException(DeliveryErrorEnum.ERROR_610015.getErrorCode(), "\u672a\u914d\u7f6e\u9ad8\u5fb7\u5730\u56fekey");
        }
        String url = this.gaodeAmapUrl + "?address=" + address + "&output=JSON&key=" + this.gaodeAmapKey;
        String jsonStr = HttpUtil.sendGet((String)url);
        this.logger.info("\u9ad8\u5fb7\u5730\u56fe\u6839\u636e\u5730\u5740address\uff1a{}\u8fd4\u56de\u6570\u636e\uff0cjsonStr:{}", (Object)address, (Object)jsonStr);
        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
        if (jsonObject.getJSONArray("geocodes").size() > 0) {
            String[] split = jsonObject.getJSONArray("geocodes").getJSONObject(0).get((Object)"location").toString().split(",");
            LngLatRespDto lngLatRespDto = new LngLatRespDto();
            lngLatRespDto.setLongitude(new BigDecimal(split[0]));
            lngLatRespDto.setLatitude(new BigDecimal(split[1]));
            return lngLatRespDto;
        }
        this.logger.error("\u9ad8\u5fb7\u5730\u56fe\u67e5\u8be2\u4e0d\u5230\u5730\u5740\u5bf9\u5e94\u7684\u7ecf\u7eac\u5ea6\uff0curl\uff1a{}", (Object)url);
        throw new BizException(DeliveryErrorEnum.ERROR_610016.getErrorCode(), "\u9ad8\u5fb7\u5730\u56fe\u67e5\u8be2\u4e0d\u5230\u5730\u5740\u5bf9\u5e94\u7684\u7ecf\u7eac\u5ea6");
    }
}

