/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageChangeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRuleWeightRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteSplitRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.LngLatRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRouteRestDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryErrorEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRouteOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliverySplitFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.InventoryPriorityEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseSubTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.DeliveryRouteProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliverySplitResultVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.DeliveryVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDeliveryRouteSplitService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IOrderRouteRuleService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRuleService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DeliveryRouteRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefDeliveryOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DeliveryRouteRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefDeliveryOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdDeliveryItemEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DeliveryRouteSplitServiceImpl
implements IDeliveryRouteSplitService {
    private Logger logger = LoggerFactory.getLogger(DeliveryRouteSplitServiceImpl.class);
    @Autowired
    private OrderDeliveryDas orderDeliveryDas;
    @Autowired
    private DeliveryItemDas deliveryItemDas;
    @Resource
    private IRuleService ruleService;
    @Autowired
    private RefDeliveryOrderDas refDeliveryOrderDas;
    @Autowired
    private IDeliveryRouteService deliveryRouteService;
    @Autowired
    private DeliveryRouteProducer deliveryRouteProducer;
    @Autowired
    private DeliveryRouteRecordDas deliveryRouteRecordDas;
    @Autowired
    private ICargoStorageService cargoStorageService;
    @Autowired
    private IOrderRouteRuleService orderRouteRuleService;
    @Value(value="${gaode.amap.key:}")
    private String gaodeAmapKey;
    @Value(value="${gaode.amap.url:}")
    private String gaodeAmapUrl;

    @Override
    public void routeSplit(DeliveryVo deliveryVo, OrderRouteRuleRespDto orderRouteRule, Map<String, List<CargoStorageEo>> hasAvailableCargoStorageGroupMap, Map<String, CargoStorageEo> hasAvailableCargoStorageMap, Map<Long, WarehouseEo> hasAvailableWarehouseMap, LngLatRespDto lngLatRespDto, DeliveryRouteRecordEo routeRecord) {
        this.logger.info("\u8ba2\u5355\u8def\u7531\u89c4\u5219\u914d\u7f6e\u4e3a\u62c6\u5355\u914d\u7f6e\uff0c\u8d70\u62c6\u5355\u6d41\u7a0b\u2026\u2026");
        if (InventoryPriorityEnum.INVENTORY.getPriority().equals(orderRouteRule.getInventoryPriority())) {
            this.handleInventoryPriority(deliveryVo, orderRouteRule, hasAvailableCargoStorageGroupMap, hasAvailableWarehouseMap, routeRecord);
        } else if (InventoryPriorityEnum.ROUTE_SCORE.getPriority().equals(orderRouteRule.getInventoryPriority())) {
            this.handleRouteScorePriority(deliveryVo, orderRouteRule, hasAvailableCargoStorageMap, hasAvailableWarehouseMap, lngLatRespDto, routeRecord);
        }
    }

    private void handleInventoryPriority(DeliveryVo deliveryVo, OrderRouteRuleRespDto orderRouteRule, Map<String, List<CargoStorageEo>> hasAvailableCargoStorageGroupMap, Map<Long, WarehouseEo> hasAvailableWarehouseMap, DeliveryRouteRecordEo routeRecord) {
        this.logger.info("\u53d1\u8d27\u5355\u62c6\u5355\u8d70\u5e93\u5b58\u4f18\u5148\u2026\u2026");
        String inventoryPriorityItem = orderRouteRule.getInventoryPriorityItem();
        List ruleIds = JSON.parseArray((String)inventoryPriorityItem, Long.class);
        List<RuleRespDto> rules = this.ruleService.queryByIds(ruleIds, EnableEnum.ENABLE.getCode());
        ArrayList<DeliveryItemEo> deliveryItems = new ArrayList<DeliveryItemEo>();
        Map<String, List<DeliveryItemEo>> deliveryItemGroupMap = deliveryVo.getDeliveryItems().stream().collect(Collectors.groupingBy(StdDeliveryItemEo::getCargoSerial));
        for (Map.Entry<String, List<DeliveryItemEo>> entry : deliveryItemGroupMap.entrySet()) {
            List<DeliveryItemEo> items = entry.getValue();
            Integer needItemNum = entry.getValue().stream().mapToInt(StdDeliveryItemEo::getItemNum).sum();
            DeliveryItemEo deliveryItemEo = new DeliveryItemEo();
            BeanUtils.copyProperties(items.get(0), (Object)deliveryItemEo);
            deliveryItemEo.setItemNum(needItemNum);
            deliveryItems.add(deliveryItemEo);
        }
        ArrayList<DeliveryRouteSplitRespDto> deliveryRouteSplitRespDtos = new ArrayList<DeliveryRouteSplitRespDto>();
        LinkedHashMap<String, WarehouseEo> routeWarehouseMap = new LinkedHashMap<String, WarehouseEo>();
        for (DeliveryItemEo deliveryItemEo : deliveryItems) {
            String cargoCode = deliveryItemEo.getCargoSerial();
            List<CargoStorageEo> hasAvailableCargoStorages = hasAvailableCargoStorageGroupMap.get(cargoCode);
            if (CollectionUtils.isEmpty(hasAvailableCargoStorages)) {
                this.logger.info("\u8d27\u54c1\uff1a{},\u4ed3\u5e93\u8d27\u54c1\u65e0\u53ef\u7528\u5e93\u5b58\uff0c\u9700\u8981\u5f85\u6307\u6d3e\uff0c\u6570\u91cf\uff1a{}", (Object)deliveryItemEo.getCargoSerial(), (Object)deliveryItemEo.getItemNum());
                continue;
            }
            Integer itemNum = deliveryItemEo.getItemNum();
            for (RuleRespDto ruleRespDto : rules) {
                for (CargoStorageEo cargoStorageEo : hasAvailableCargoStorages) {
                    if (deliveryItemEo.getItemNum() <= 0) continue;
                    if (!routeWarehouseMap.isEmpty()) {
                        for (String warehouseCode : routeWarehouseMap.keySet()) {
                            DeliveryRouteSplitRespDto deliveryRouteSplit;
                            WarehouseEo warehouseEo = hasAvailableWarehouseMap.get(((WarehouseEo)routeWarehouseMap.get(warehouseCode)).getId());
                            WarehouseRouteRestDto warehouseRouteRestDto = new WarehouseRouteRestDto();
                            BeanUtils.copyProperties((Object)warehouseEo, (Object)warehouseRouteRestDto);
                            boolean isMatch = this.orderRouteRuleService.checkMatch(warehouseRouteRestDto, ruleRespDto);
                            int available = cargoStorageEo.getAvailable().intValue();
                            if (isMatch && available >= itemNum) {
                                this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u5145\u8db3\uff0c\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{}", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName()});
                                deliveryItemEo.setItemNum(Integer.valueOf(0));
                                deliveryRouteSplit = new DeliveryRouteSplitRespDto(warehouseEo.getId(), warehouseCode, warehouseEo.getName(), warehouseEo.getSubType(), cargoCode, itemNum, warehouseEo.getOrganizationId(), warehouseEo.getOrganizationName());
                                deliveryRouteSplitRespDtos.add(deliveryRouteSplit);
                                if (routeWarehouseMap.containsKey(warehouseEo.getCode())) continue;
                                routeWarehouseMap.put(warehouseEo.getCode(), warehouseEo);
                                continue;
                            }
                            if (!isMatch || available <= 0) continue;
                            this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u90e8\u5206\u5145\u8db3\uff0c\u90e8\u5206\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{}\uff0c\u8def\u7531\u6570\u91cf\uff1a{}", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName(), available});
                            deliveryItemEo.setItemNum(Integer.valueOf(deliveryItemEo.getItemNum() - available));
                            deliveryRouteSplit = new DeliveryRouteSplitRespDto(warehouseEo.getId(), warehouseCode, warehouseEo.getName(), warehouseEo.getSubType(), cargoCode, Integer.valueOf(available), warehouseEo.getOrganizationId(), warehouseEo.getOrganizationName());
                            deliveryRouteSplitRespDtos.add(deliveryRouteSplit);
                            if (routeWarehouseMap.containsKey(warehouseEo.getCode())) continue;
                            routeWarehouseMap.put(warehouseEo.getCode(), warehouseEo);
                        }
                    }
                    if (routeWarehouseMap.containsKey(cargoStorageEo.getWarehouseCode())) continue;
                    WarehouseEo warehouseEo = hasAvailableWarehouseMap.get(cargoStorageEo.getWarehouseId());
                    WarehouseRouteRestDto warehouseRouteRestDto = new WarehouseRouteRestDto();
                    BeanUtils.copyProperties((Object)warehouseEo, (Object)warehouseRouteRestDto);
                    boolean isMatch = this.orderRouteRuleService.checkMatch(warehouseRouteRestDto, ruleRespDto);
                    int available = cargoStorageEo.getAvailable().intValue();
                    if (!isMatch) {
                        this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\uff1a{}-{}\uff0c\u4e0d\u6ee1\u8db3\u5e93\u5b58\u89c4\u5219ruleId\uff1a{},\u7ee7\u7eed\u5bfb\u627e\u2026\u2026\u3002", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName(), ruleRespDto.getId()});
                        continue;
                    }
                    if (available >= itemNum) {
                        this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u5145\u8db3\uff0c\u5168\u90e8\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{}\uff0c\u8def\u7531\u6570\u91cf\uff1a{}", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName(), itemNum});
                        deliveryItemEo.setItemNum(Integer.valueOf(0));
                        DeliveryRouteSplitRespDto deliveryRouteSplit = new DeliveryRouteSplitRespDto(warehouseEo.getId(), warehouseEo.getCode(), warehouseEo.getName(), warehouseEo.getSubType(), cargoCode, itemNum, warehouseEo.getOrganizationId(), warehouseEo.getOrganizationName());
                        deliveryRouteSplitRespDtos.add(deliveryRouteSplit);
                        if (!routeWarehouseMap.containsKey(warehouseEo.getCode())) {
                            routeWarehouseMap.put(warehouseEo.getCode(), warehouseEo);
                        }
                        cargoStorageEo.setAvailable(new BigDecimal(available - itemNum));
                        hasAvailableCargoStorageGroupMap.put(cargoCode, hasAvailableCargoStorages);
                        continue;
                    }
                    if (available > 0) {
                        this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u90e8\u5206\u5145\u8db3\uff0c\u90e8\u5206\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{}\uff0c\u8def\u7531\u6570\u91cf\uff1a{}", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName(), available});
                        deliveryItemEo.setItemNum(Integer.valueOf(deliveryItemEo.getItemNum() - available));
                        DeliveryRouteSplitRespDto deliveryRouteSplit = new DeliveryRouteSplitRespDto(warehouseEo.getId(), warehouseEo.getCode(), warehouseEo.getName(), warehouseEo.getSubType(), cargoCode, Integer.valueOf(available), warehouseEo.getOrganizationId(), warehouseEo.getOrganizationName());
                        deliveryRouteSplitRespDtos.add(deliveryRouteSplit);
                        if (!routeWarehouseMap.containsKey(warehouseEo.getCode())) {
                            routeWarehouseMap.put(warehouseEo.getCode(), warehouseEo);
                        }
                        cargoStorageEo.setAvailable(new BigDecimal(0));
                        hasAvailableCargoStorageGroupMap.put(cargoCode, hasAvailableCargoStorages);
                        continue;
                    }
                    this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\uff1a{}-{}\uff0c\u4ed3\u5e93\u65e0\u53ef\u7528\u5e93\u5b58,\u7ee7\u7eed\u5bfb\u627e\u2026\u2026\u3002", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName()});
                }
            }
        }
        List<DeliveryItemEo> needAssignItems = deliveryItems.stream().filter(e -> e.getItemNum() > 0).collect(Collectors.toList());
        this.splitDelivery(deliveryVo, deliveryRouteSplitRespDtos, needAssignItems, routeRecord);
    }

    private void handleRouteScorePriority(DeliveryVo deliveryVo, OrderRouteRuleRespDto orderRouteRule, Map<String, CargoStorageEo> hasAvailableCargoStorageMap, Map<Long, WarehouseEo> hasAvailableWarehouseMap, LngLatRespDto lngLatRespDto, DeliveryRouteRecordEo routeRecord) {
        this.logger.info("\u53d1\u8d27\u5355\u62c6\u5355\u8d70\u8def\u7531\u5f97\u5206\u4f18\u5148\u2026\u2026");
        ArrayList deliveryItems = new ArrayList();
        CubeBeanUtils.copyCollection(deliveryItems, deliveryVo.getDeliveryItems(), DeliveryItemEo.class);
        ArrayList<DeliveryRouteSplitRespDto> deliveryRouteSplitRespDtos = new ArrayList<DeliveryRouteSplitRespDto>();
        ArrayList<WarehouseRouteRestDto> matchRuleWarehouses = new ArrayList<WarehouseRouteRestDto>();
        String inventoryPriorityItem = orderRouteRule.getInventoryPriorityItem();
        List ruleIds = JSON.parseArray((String)inventoryPriorityItem, Long.class);
        List<RuleRespDto> ruleRespDtos = this.ruleService.queryByIds(ruleIds, EnableEnum.ENABLE.getCode());
        Iterator<Map.Entry<Long, WarehouseEo>> iterator = hasAvailableWarehouseMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, WarehouseEo> entry = iterator.next();
            WarehouseEo warehouseEo = entry.getValue();
            WarehouseRouteRestDto warehouseRouteRestDto = new WarehouseRouteRestDto();
            BeanUtils.copyProperties((Object)warehouseEo, (Object)warehouseRouteRestDto);
            boolean isMatch = this.orderRouteRuleService.checkMatch(warehouseRouteRestDto, ruleRespDtos);
            if (!isMatch) {
                this.logger.info("\u4ed3\u5e93\uff1a{}-{}\u4e0d\u7b26\u5408\u8def\u7531\u5e93\u5b58\u89c4\u5219\uff0c\u79fb\u51fa\u53ef\u8def\u7531\u4ed3\u5e93\u3002", (Object)warehouseEo.getCode(), (Object)warehouseEo.getName());
                iterator.remove();
                continue;
            }
            matchRuleWarehouses.add(warehouseRouteRestDto);
        }
        if (CollectionUtils.isEmpty(matchRuleWarehouses)) {
            this.logger.error("\u5339\u914d\u4e0d\u5230\u4efb\u4f55\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u505c\u6b62\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)deliveryVo.getOrderDelivery().getDeliveryNo());
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610012.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u4e0d\u9700\u8981\u62c6\u5355\u6ee1\u8db3\u8def\u7531\u7684\u4ed3\u5e93\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            throw new BizException(DeliveryErrorEnum.ERROR_610012.getErrorCode(), "\u5339\u914d\u4e0d\u5230\u4efb\u52a1\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
        }
        Map<String, DeliveryRouteRuleWeightRespDto> ruleMap = this.deliveryRouteService.getRuleMap(orderRouteRule, deliveryVo.getOrderDelivery(), routeRecord);
        this.deliveryRouteService.caculateAndSortScore(ruleMap, matchRuleWarehouses, routeRecord, lngLatRespDto);
        for (WarehouseRouteRestDto warehouseRouteRestDto : matchRuleWarehouses) {
            String warehouseCode = warehouseRouteRestDto.getCode();
            for (DeliveryItemEo deliveryItemEo : deliveryItems) {
                DeliveryRouteSplitRespDto deliveryRouteSplit;
                String cargoCode = deliveryItemEo.getCargoSerial();
                Integer itemNum = deliveryItemEo.getItemNum();
                CargoStorageEo cargoStorageEo = hasAvailableCargoStorageMap.get(warehouseCode + "-" + cargoCode);
                if (null == cargoStorageEo || itemNum <= 0) continue;
                int available = cargoStorageEo.getAvailable().intValue();
                if (available >= itemNum) {
                    this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u5145\u8db3\uff0c\u5168\u90e8\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{},\u8def\u7531\u6570\u91cf\uff1a{}", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName(), itemNum});
                    deliveryItemEo.setItemNum(Integer.valueOf(0));
                    cargoStorageEo.setAvailable(new BigDecimal(available - itemNum));
                    deliveryRouteSplit = new DeliveryRouteSplitRespDto(warehouseRouteRestDto.getId(), warehouseRouteRestDto.getCode(), warehouseRouteRestDto.getName(), warehouseRouteRestDto.getSubType(), cargoCode, itemNum, warehouseRouteRestDto.getOrganizationId(), warehouseRouteRestDto.getOrganizationName());
                    deliveryRouteSplitRespDtos.add(deliveryRouteSplit);
                    continue;
                }
                if (available <= 0) continue;
                this.logger.info("\u8d27\u54c1\uff1a{}\uff0c\u4ed3\u5e93\u8d27\u54c1\u53ef\u7528\u5e93\u5b58\u90e8\u5206\u5145\u8db3\uff0c\u90e8\u5206\u8def\u7531\u5230\u4ed3\u5e93\uff1a{}-{},\u8def\u7531\u6570\u91cf\uff1a{}", new Object[]{cargoCode, cargoStorageEo.getWarehouseCode(), cargoStorageEo.getWarehouseName(), available});
                deliveryItemEo.setItemNum(Integer.valueOf(deliveryItemEo.getItemNum() - available));
                cargoStorageEo.setAvailable(new BigDecimal(0));
                deliveryRouteSplit = new DeliveryRouteSplitRespDto(warehouseRouteRestDto.getId(), warehouseRouteRestDto.getCode(), warehouseRouteRestDto.getName(), warehouseRouteRestDto.getSubType(), cargoCode, Integer.valueOf(available), warehouseRouteRestDto.getOrganizationId(), warehouseRouteRestDto.getOrganizationName());
                deliveryRouteSplitRespDtos.add(deliveryRouteSplit);
            }
        }
        List<DeliveryItemEo> needAssignItems = deliveryItems.stream().filter(item -> item.getItemNum() > 0).collect(Collectors.toList());
        this.splitDelivery(deliveryVo, deliveryRouteSplitRespDtos, needAssignItems, routeRecord);
    }

    private void splitDelivery(DeliveryVo deliveryVo, List<DeliveryRouteSplitRespDto> deliveryRouteSplitRespDtos, List<DeliveryItemEo> needAssignItems, DeliveryRouteRecordEo routeRecord) {
        OrderDeliveryEo orderDeliveryParent = deliveryVo.getOrderDelivery();
        Map<String, List<DeliveryItemEo>> cargoSkuGroupMap = deliveryVo.getDeliveryItems().stream().collect(Collectors.groupingBy(o -> o.getCargoSerial() + "_" + o.getSkuSerial()));
        if (CollectionUtils.isEmpty(deliveryRouteSplitRespDtos)) {
            this.logger.error("\u5339\u914d\u4e0d\u5230\u4efb\u4f55\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u505c\u6b62\u8def\u7531\uff0cdeliveryNo\uff1a{}", (Object)orderDeliveryParent.getDeliveryNo());
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610012.getErrorCode(), DeliveryStatusEnum.TO_ASSIGN.getStatus(), DeliveryStatusEnum.TO_ASSIGN.getMsg(), "\u8def\u7531\u5931\u8d25\uff0c\u5339\u914d\u4e0d\u5230\u4e0d\u9700\u8981\u62c6\u5355\u6ee1\u8db3\u8def\u7531\u7684\u4ed3\u5e93\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
            throw new BizException(DeliveryErrorEnum.ERROR_610012.getErrorCode(), "\u5339\u914d\u4e0d\u5230\u4efb\u52a1\u7b26\u5408\u8def\u7531\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u72b6\u6001\u66f4\u65b0\u4e3a\u5f85\u6307\u6d3e\u3002");
        }
        ArrayList<DeliveryVo> deliverySplitChilds = new ArrayList<DeliveryVo>();
        RefDeliveryOrderEo refDeliveryOrderParent = deliveryVo.getRefDeliveryOrders().get(0);
        Map<String, List<DeliveryRouteSplitRespDto>> deliveryRouteGroupMap = deliveryRouteSplitRespDtos.stream().collect(Collectors.groupingBy(DeliveryRouteSplitRespDto::getWarehouseCode));
        ArrayList<String> childDeliveryNos = new ArrayList<String>();
        for (Map.Entry<String, List<DeliveryRouteSplitRespDto>> entry : deliveryRouteGroupMap.entrySet()) {
            String warehouseCode = entry.getKey();
            String deliveryNo = TradeUtil.generateTradeNo(refDeliveryOrderParent.getOrderNo());
            List<DeliveryRouteSplitRespDto> deliveryRouteSplits = entry.getValue();
            OrderDeliveryEo orderDeliveryChild = new OrderDeliveryEo();
            BeanUtils.copyProperties((Object)orderDeliveryParent, (Object)orderDeliveryChild, (String[])new String[]{"id", "deliveryNo", "deliveryStatus", "warehouseCode", "warehouseName", "createTime", "updateTime"});
            orderDeliveryChild.setDeliveryNo(deliveryNo);
            orderDeliveryChild.setParentDeliveryNo(orderDeliveryParent.getDeliveryNo());
            orderDeliveryChild.setWarehouseCode(warehouseCode);
            orderDeliveryChild.setWarehouseName(deliveryRouteSplits.get(0).getWarehouseName());
            orderDeliveryChild.setOrganizationId(orderDeliveryParent.getOrganizationId());
            orderDeliveryChild.setOrganizationName(orderDeliveryParent.getOrganizationName());
            orderDeliveryChild.setWarehouseOrganizationId(deliveryRouteSplits.get(0).getWarehouseOrganizationId());
            orderDeliveryChild.setWarehouseOrganizationName(deliveryRouteSplits.get(0).getWarehouseOrganizationName());
            if (WarehouseSubTypeEnum.LOGICAL_SHOP_WAREHOUSE.getCode() == ((DeliveryRouteSplitRespDto)deliveryRouteSplits.get(0)).getWarehouseSubType().intValue()) {
                orderDeliveryChild.setDeliveryStatus(DeliveryStatusEnum.TO_RECEIVING.getStatus());
            } else {
                orderDeliveryChild.setDeliveryStatus(DeliveryStatusEnum.INIT.getStatus());
            }
            RefDeliveryOrderEo refDeliveryOrderChild = new RefDeliveryOrderEo();
            BeanUtils.copyProperties((Object)refDeliveryOrderParent, (Object)refDeliveryOrderChild, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
            refDeliveryOrderChild.setDeliveryNo(deliveryNo);
            ArrayList<DeliveryItemEo> deliveryItemChilds = new ArrayList<DeliveryItemEo>();
            Iterator iterator = deliveryRouteSplits.iterator();
            while (iterator.hasNext()) {
                DeliveryRouteSplitRespDto deliveryRouteSplitRespDto = (DeliveryRouteSplitRespDto)iterator.next();
                List<DeliveryItemEo> deliveryItems = this.getDeliveryItemFromGroup(deliveryRouteSplitRespDto, cargoSkuGroupMap, orderDeliveryParent, orderDeliveryChild);
                deliveryItemChilds.addAll(deliveryItems);
            }
            this.orderDeliveryDas.insert((BaseEo)orderDeliveryChild);
            this.refDeliveryOrderDas.insert((BaseEo)refDeliveryOrderChild);
            this.deliveryItemDas.insertBatch(deliveryItemChilds);
            for (DeliveryItemEo deliveryItemEo : deliveryItemChilds) {
                StorageChangeReqDto storageChangeReqDto = new StorageChangeReqDto();
                storageChangeReqDto.setWarehouseId(((DeliveryRouteSplitRespDto)deliveryRouteSplits.get(0)).getWarehouseId());
                storageChangeReqDto.setCargoCode(deliveryItemEo.getCargoSerial());
                storageChangeReqDto.setPreempt(new BigDecimal(deliveryItemEo.getItemNum()));
                storageChangeReqDto.setAvailable(new BigDecimal(-deliveryItemEo.getItemNum().intValue()));
                this.cargoStorageService.addAvailablePreempt(storageChangeReqDto);
            }
            childDeliveryNos.add(deliveryNo);
            DeliveryVo deliverySplitChild = new DeliveryVo(orderDeliveryChild, new ArrayList<RefDeliveryOrderEo>(Arrays.asList(refDeliveryOrderChild)), deliveryItemChilds);
            deliverySplitChilds.add(deliverySplitChild);
        }
        String deliveryNo = TradeUtil.generateTradeNo(refDeliveryOrderParent.getOrderNo());
        OrderDeliveryEo orderDeliveryChild = new OrderDeliveryEo();
        BeanUtils.copyProperties((Object)orderDeliveryParent, (Object)orderDeliveryChild, (String[])new String[]{"id", "deliveryNo", "deliveryStatus", "warehouseCode", "warehouseName", "createTime", "updateTime"});
        orderDeliveryChild.setDeliveryNo(deliveryNo);
        orderDeliveryChild.setParentDeliveryNo(orderDeliveryParent.getDeliveryNo());
        orderDeliveryChild.setDeliveryStatus(DeliveryStatusEnum.TO_ASSIGN.getStatus());
        RefDeliveryOrderEo refDeliveryOrderChild = new RefDeliveryOrderEo();
        BeanUtils.copyProperties((Object)refDeliveryOrderParent, (Object)refDeliveryOrderChild, (String[])new String[]{"id", "deliveryNo", "createTime", "updateTime"});
        refDeliveryOrderChild.setDeliveryNo(deliveryNo);
        if (CollectionUtils.isNotEmpty(needAssignItems)) {
            ArrayList<DeliveryItemEo> deliveryItemChilds = new ArrayList<DeliveryItemEo>();
            for (DeliveryItemEo needAssignItem : needAssignItems) {
                DeliveryRouteSplitRespDto deliveryRouteSplit = new DeliveryRouteSplitRespDto();
                deliveryRouteSplit.setCargoCode(needAssignItem.getCargoSerial());
                deliveryRouteSplit.setItemNum(needAssignItem.getItemNum());
                List<DeliveryItemEo> deliveryItems = this.getDeliveryItemFromGroup(deliveryRouteSplit, cargoSkuGroupMap, orderDeliveryParent, orderDeliveryChild);
                deliveryItemChilds.addAll(deliveryItems);
            }
            this.orderDeliveryDas.insert((BaseEo)orderDeliveryChild);
            this.refDeliveryOrderDas.insert((BaseEo)refDeliveryOrderChild);
            this.deliveryItemDas.insertBatch(deliveryItemChilds);
            DeliveryVo deliverySplitChild = new DeliveryVo(orderDeliveryChild, new ArrayList<RefDeliveryOrderEo>(Arrays.asList(refDeliveryOrderChild)), deliveryItemChilds);
            deliverySplitChilds.add(deliverySplitChild);
            childDeliveryNos.add(deliveryNo);
        }
        OrderDeliveryEo orderDeliveryUpdate = new OrderDeliveryEo();
        orderDeliveryUpdate.setId(orderDeliveryParent.getId());
        orderDeliveryUpdate.setSplitFlag(DeliverySplitFlagEnum.SPLIT.getFlag());
        orderDeliveryUpdate.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
        this.orderDeliveryDas.updateSelective((BaseEo)orderDeliveryUpdate);
        this.logger.info("\u5c06\u7236\u53d1\u8d27\u5355\uff1a{}\u8bbe\u7f6e\u4e3a\u5df2\u62c6\u5355\u5e76\u8bbe\u7f6e\u4e3a\u53d6\u6d88\u72b6\u6001\u3002", (Object)orderDeliveryParent.getDeliveryNo());
        routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610023.getErrorCode(), DeliveryStatusEnum.CANCELED.getStatus(), DeliveryStatusEnum.CANCELED.getMsg(), "\u8def\u7531\u53d1\u8d27\u5355\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\uff0c\u62c6\u5206\u7684\u5b50\u53d1\u8d27\u5355\u53f7\u4e3a\uff1a[" + String.join((CharSequence)",", childDeliveryNos) + "]\uff0c\u539f\u53d1\u8d27\u5355\u72b6\u6001\u66f4\u65b0\u4e3a\u5df2\u53d6\u6d88\u3002");
        this.saveChildDeliveryRouteRecord(deliverySplitChilds);
        DeliveryRouteRespDto parentDelivery = new DeliveryRouteRespDto();
        parentDelivery.setDeliveryNo(orderDeliveryParent.getDeliveryNo());
        parentDelivery.setDeliveryStatus(DeliveryStatusEnum.CANCELED.getStatus());
        parentDelivery.setWarehouseCode("");
        parentDelivery.setWarehouseName("");
        parentDelivery.setOrganizationId(Long.valueOf(0L));
        parentDelivery.setOrganizationName("\u9ed8\u8ba4\u6743\u9650");
        DeliverySplitResultVo deliverySplitResult = new DeliverySplitResultVo();
        deliverySplitResult.setSplitParent(parentDelivery);
        deliverySplitResult.setSplitChilds(deliverySplitChilds);
        this.deliveryRouteProducer.sendDeliberyRoutReslut(deliverySplitResult);
    }

    private List<DeliveryItemEo> getDeliveryItemFromGroup(DeliveryRouteSplitRespDto deliveryRouteSplitRespDto, Map<String, List<DeliveryItemEo>> cargoSkuGroupMap, OrderDeliveryEo orderDeliveryParent, OrderDeliveryEo orderDeliveryChild) {
        ArrayList<DeliveryItemEo> deliveryItems = new ArrayList<DeliveryItemEo>();
        Integer needNum = deliveryRouteSplitRespDto.getItemNum();
        String cargoCode = deliveryRouteSplitRespDto.getCargoCode();
        for (Map.Entry<String, List<DeliveryItemEo>> entry : cargoSkuGroupMap.entrySet()) {
            String key = entry.getKey();
            List<DeliveryItemEo> value = entry.getValue();
            if (!key.startsWith(cargoCode + "_")) continue;
            Iterator<DeliveryItemEo> iterator = value.iterator();
            while (iterator.hasNext()) {
                DeliveryItemEo next = iterator.next();
                DeliveryItemEo deliveryItemNew = new DeliveryItemEo();
                BeanUtils.copyProperties((Object)next, (Object)deliveryItemNew, (String[])new String[]{"id", "deliveryNo", "itemNum", "createTime", "updateTime"});
                deliveryItemNew.setDeliveryNo(orderDeliveryChild.getDeliveryNo());
                deliveryItemNew.setParentDeliveryNo(orderDeliveryParent.getDeliveryNo());
                if (next.getItemNum() > 0 && next.getItemNum() <= needNum) {
                    deliveryItemNew.setItemNum(next.getItemNum());
                    iterator.remove();
                    needNum = needNum - next.getItemNum();
                } else if (next.getItemNum() > 0) {
                    deliveryItemNew.setItemNum(needNum);
                    next.setItemNum(Integer.valueOf(next.getItemNum() - needNum));
                    needNum = 0;
                } else {
                    this.logger.warn("\u8d27\u54c1{}\u6570\u91cf\u4e0d\u8db3", (Object)cargoCode);
                    continue;
                }
                deliveryItems.add(deliveryItemNew);
                if (needNum > 0) continue;
                return deliveryItems;
            }
        }
        return deliveryItems;
    }

    private void saveChildDeliveryRouteRecord(List<DeliveryVo> deliverySplitChilds) {
        ArrayList<DeliveryRouteRecordEo> deliveryRouteRecordEos = new ArrayList<DeliveryRouteRecordEo>();
        for (DeliveryVo deliveryVo : deliverySplitChilds) {
            OrderDeliveryEo orderDelivery = deliveryVo.getOrderDelivery();
            DeliveryRouteRecordEo routeRecord = new DeliveryRouteRecordEo();
            routeRecord.setOptCode(DeliveryRouteOptEnum.AUTO_ROUTE.getOptCode());
            routeRecord.setOptName(DeliveryRouteOptEnum.AUTO_ROUTE.getOptDesc());
            routeRecord.setDeliveryNo(orderDelivery.getDeliveryNo());
            routeRecord.setParentDeliveryNo(orderDelivery.getParentDeliveryNo());
            routeRecord.setOrderNo(deliveryVo.getRefDeliveryOrders().get(0).getOrderNo());
            routeRecord.setPreDeliveryStatus(orderDelivery.getDeliveryStatus());
            routeRecord.setPreDeliveryStatusName(DeliveryStatusEnum.getMsg((String)orderDelivery.getDeliveryStatus()));
            routeRecord.setRouteInfo(DeliveryErrorEnum.ERROR_610024.getErrorCode(), orderDelivery.getDeliveryStatus(), DeliveryStatusEnum.getMsg((String)orderDelivery.getDeliveryStatus()), "\u53d1\u8d27\u5355\u62c6\u5355\u751f\u6210\u5b50\u53d1\u8d27\u5355\u6210\u529f\uff0c\u7236\u53d1\u8d27\u5355\u4e3a\uff1a" + orderDelivery.getParentDeliveryNo() + "\uff0c\u5b50\u53d1\u8d27\u5355\u7684\u521d\u59cb\u72b6\u6001\u4e3a\uff1a" + DeliveryStatusEnum.getMsg((String)orderDelivery.getDeliveryStatus()));
            deliveryRouteRecordEos.add(routeRecord);
        }
        this.deliveryRouteRecordDas.insertBatch(deliveryRouteRecordEos);
    }
}

