/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderDetailModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.DiffOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDiffOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DiffOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DiffOrderDetailEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DiffOrderDetailServiceImpl
implements IDiffOrderDetailService {
    @Resource
    private DiffOrderDetailDas diffOrderDetailDas;
    @Resource
    private CargoDas cargoDas;

    private String getUsername() {
        return ServiceContext.getContext().getRequestUserCode();
    }

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    private static void completeDiffOrderDetail(DiffOrderDetailRespDto dto, CargoEo cargoEo) {
        dto.setCargoCode(cargoEo.getCode());
        dto.setCargoName(cargoEo.getName());
        dto.setCargoArtNo(cargoEo.getArtNo());
        dto.setCargoBarCode(cargoEo.getBarCode());
        dto.setCargoCustomerNo(cargoEo.getCustomerNo());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addDiffOrderDetail(DiffOrderDetailAddReqDto reqDto) {
        DiffOrderDetailEo diffOrderDetailEo = new DiffOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)diffOrderDetailEo);
        String username = this.getUsername();
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long instanceId = this.getInstanceId(reqDto.getInstanceId());
        diffOrderDetailEo.setCreatePerson(username);
        diffOrderDetailEo.setTenantId(tenantId);
        diffOrderDetailEo.setInstanceId(instanceId);
        this.diffOrderDetailDas.insert((BaseEo)diffOrderDetailEo);
        return diffOrderDetailEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDiffOrderDetail(DiffOrderDetailModifyReqDto reqDto) {
        DiffOrderDetailEo diffOrderDetailEo = new DiffOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)diffOrderDetailEo);
        diffOrderDetailEo.setUpdatePerson(this.getUsername());
        diffOrderDetailEo.setTenantId(null);
        diffOrderDetailEo.setInstanceId(null);
        this.diffOrderDetailDas.updateSelective((BaseEo)diffOrderDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDiffOrderDetail(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.diffOrderDetailDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public DiffOrderDetailRespDto queryDiffOrderDetailById(Long id) {
        DiffOrderDetailEo diffOrderDetailEo = (DiffOrderDetailEo)this.diffOrderDetailDas.selectByPrimaryKey(id);
        if (diffOrderDetailEo == null) {
            return null;
        }
        DiffOrderDetailRespDto diffOrderDetailRespDto = new DiffOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)diffOrderDetailEo, (BaseVo)diffOrderDetailRespDto);
        CargoEo cargoEo = (CargoEo)this.cargoDas.selectByPrimaryKey(diffOrderDetailEo.getCargoId());
        DiffOrderDetailServiceImpl.completeDiffOrderDetail(diffOrderDetailRespDto, cargoEo);
        return diffOrderDetailRespDto;
    }

    @Override
    public PageInfo<DiffOrderDetailRespDto> queryDiffOrderDetailByPage(DiffOrderDetailQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        DiffOrderDetailEo diffOrderDetailEo = new DiffOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)diffOrderDetailEo);
        diffOrderDetailEo.setTenantId(this.getTenantId(null));
        PageInfo eoPageInfo = this.diffOrderDetailDas.selectPage((BaseEo)diffOrderDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DiffOrderDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (dtoList.size() > 0) {
            List cargoIds = dtoList.stream().map(DiffOrderDetailRespDto::getCargoId).collect(Collectors.toList());
            CargoEo cargoQueryEo = new CargoEo();
            cargoQueryEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", cargoIds)));
            Map<Long, CargoEo> cargoEoMap = this.cargoDas.select((BaseEo)cargoQueryEo, Integer.valueOf(1), Integer.valueOf(cargoIds.size())).stream().collect(Collectors.toMap(BaseEo::getId, e -> e));
            dtoList.forEach(dto -> DiffOrderDetailServiceImpl.completeDiffOrderDetail(dto, (CargoEo)cargoEoMap.get(dto.getCargoId())));
        }
        return dtoPageInfo;
    }
}

