/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.DiffOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.DiffOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IDiffOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DiffOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DiffOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.TransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.AddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DiffOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DiffOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdDiffOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.TransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DiffOrderServiceImpl
implements IDiffOrderService {
    @Resource
    private DiffOrderDas diffOrderDas;
    @Resource
    private DiffOrderDetailDas diffOrderDetailDas;
    @Resource
    private TransferOrderDas transferOrderDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private AddressDas addressDas;

    private String getUsername() {
        return ServiceContext.getContext().getRequestUserCode();
    }

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addDiffOrder(DiffOrderAddReqDto reqDto) {
        String username = this.getUsername();
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long instanceId = this.getInstanceId(reqDto.getInstanceId());
        DiffOrderEo diffOrderEo = new DiffOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)diffOrderEo);
        diffOrderEo.setCreatePerson(username);
        diffOrderEo.setTenantId(tenantId);
        diffOrderEo.setInstanceId(instanceId);
        this.diffOrderDas.insert((BaseEo)diffOrderEo);
        return diffOrderEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDiffOrder(DiffOrderModifyReqDto reqDto) {
        String username = this.getUsername();
        DiffOrderEo diffOrderEo = new DiffOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)diffOrderEo);
        diffOrderEo.setUpdatePerson(username);
        diffOrderEo.setTenantId(null);
        diffOrderEo.setInstanceId(null);
        this.diffOrderDas.updateSelective((BaseEo)diffOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDiffOrder(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.diffOrderDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public DiffOrderRespDto queryDiffOrderById(Long id) {
        DiffOrderEo diffOrderEo = (DiffOrderEo)this.diffOrderDas.selectByPrimaryKey(id);
        if (diffOrderEo == null) {
            return null;
        }
        DiffOrderRespDto diffOrderRespDto = new DiffOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)diffOrderEo, (BaseVo)diffOrderRespDto);
        Long orderSrcId = diffOrderEo.getOrderSrcId();
        TransferOrderEo transferOrderEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(orderSrcId);
        HashSet<Long> warehouseIds = new HashSet<Long>();
        warehouseIds.add(transferOrderEo.getOutPhysicalWarehouseId());
        warehouseIds.add(transferOrderEo.getOutLogicWarehouseId());
        warehouseIds.add(transferOrderEo.getInPhysicalWarehouseId());
        warehouseIds.add(transferOrderEo.getInLogicWarehouseId());
        WarehouseEo warehouseEoQuery = new WarehouseEo();
        warehouseEoQuery.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", warehouseIds)));
        Map<Long, String> warehouseEoMap = this.warehouseDas.select((BaseEo)warehouseEoQuery, Integer.valueOf(1), Integer.valueOf(warehouseIds.size())).stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getName));
        Map<Long, DiffOrderDetailEo> countDiffOrderMap = this.diffOrderDetailDas.countByOrderSrcId(Collections.singletonList(orderSrcId)).stream().collect(Collectors.toMap(StdDiffOrderDetailEo::getOrderSrcId, e -> e));
        diffOrderRespDto.setOutPhysicalWarehouseName(warehouseEoMap.get(transferOrderEo.getOutPhysicalWarehouseId()));
        diffOrderRespDto.setOutLogicWarehouseName(warehouseEoMap.get(transferOrderEo.getOutLogicWarehouseId()));
        diffOrderRespDto.setInPhysicalWarehouseName(warehouseEoMap.get(transferOrderEo.getInPhysicalWarehouseId()));
        diffOrderRespDto.setInLogicWarehouseName(warehouseEoMap.get(transferOrderEo.getInLogicWarehouseId()));
        diffOrderRespDto.setOutStorageId(transferOrderEo.getOutStorageId());
        diffOrderRespDto.setInStorageId(transferOrderEo.getInStorageId());
        DiffOrderDetailEo diffOrderDetailEo = countDiffOrderMap.get(orderSrcId);
        if (diffOrderDetailEo != null) {
            diffOrderRespDto.setOrderNum(diffOrderDetailEo.getOrderNum());
            diffOrderRespDto.setResultNum(diffOrderDetailEo.getResultNum());
        }
        AddressEo query = new AddressEo();
        query.setRelatedId(orderSrcId.toString());
        List address = this.addressDas.select((BaseEo)query, Integer.valueOf(1), Integer.valueOf(1));
        if (address.size() > 0) {
            AddressRespDto addressReqDto = new AddressRespDto();
            DtoHelper.eo2Dto((BaseEo)((BaseEo)address.get(0)), (BaseVo)addressReqDto);
            diffOrderRespDto.setAddressRespDto(addressReqDto);
        }
        return diffOrderRespDto;
    }

    @Override
    public PageInfo<DiffOrderRespDto> queryDiffOrderByPage(DiffOrderQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        reqDto.setTenantId(this.getTenantId(null));
        List dtoList = this.diffOrderDas.selectPageCustom(reqDto, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        dtoPageInfo.setPageNum(pageNum.intValue());
        dtoPageInfo.setPageSize(pageSize.intValue());
        dtoPageInfo.setList(dtoList);
        if (dtoList.size() > 0) {
            HashSet orderSrcIds = new HashSet();
            HashSet warehouseIds = new HashSet();
            dtoList.forEach(e -> {
                warehouseIds.add(e.getOutPhysicalWarehouseId());
                warehouseIds.add(e.getOutLogicWarehouseId());
                warehouseIds.add(e.getInPhysicalWarehouseId());
                warehouseIds.add(e.getInLogicWarehouseId());
                orderSrcIds.add(e.getOrderSrcId());
            });
            WarehouseEo warehouseEoQuery = new WarehouseEo();
            warehouseEoQuery.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", warehouseIds)));
            Map<Long, String> warehouseEoMap = this.warehouseDas.select((BaseEo)warehouseEoQuery, Integer.valueOf(1), Integer.valueOf(warehouseIds.size())).stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getName));
            Map<Long, DiffOrderDetailEo> countDiffOrderMap = this.diffOrderDetailDas.countByOrderSrcId(orderSrcIds).stream().collect(Collectors.toMap(StdDiffOrderDetailEo::getOrderSrcId, e -> e));
            dtoList.forEach(e -> {
                e.setOutPhysicalWarehouseName((String)warehouseEoMap.get(e.getOutPhysicalWarehouseId()));
                e.setOutLogicWarehouseName((String)warehouseEoMap.get(e.getOutLogicWarehouseId()));
                e.setInPhysicalWarehouseName((String)warehouseEoMap.get(e.getInPhysicalWarehouseId()));
                e.setInLogicWarehouseName((String)warehouseEoMap.get(e.getInLogicWarehouseId()));
                e.setOutStorageId(e.getOutStorageId());
                e.setInStorageId(e.getInStorageId());
                DiffOrderDetailEo diffOrderDetailEo = (DiffOrderDetailEo)countDiffOrderMap.get(e.getOrderSrcId());
                if (diffOrderDetailEo != null) {
                    e.setOrderNum(diffOrderDetailEo.getOrderNum());
                    e.setResultNum(diffOrderDetailEo.getResultNum());
                }
            });
        }
        return dtoPageInfo;
    }
}

