/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleValueRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRouteRestDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRuleOptEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.DeliveryRuleRelationshipEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.EnableEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IOrderRouteRuleService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRuleService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderRouteRuleDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderRouteRuleEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="orderRouteRuleService")
public class OrderRouteRuleServiceImpl
implements IOrderRouteRuleService {
    private Logger logger = LoggerFactory.getLogger(OrderRouteRuleServiceImpl.class);
    @Resource
    private OrderRouteRuleDas orderRouteRuleDas;
    @Resource
    private IRuleService ruleService;

    @Override
    public PageInfo<OrderRouteRuleRespDto> queryRouteRulesByPage(OrderRouteRuleQueryReqDto dto, Integer pageNum, Integer pageSize) {
        PageInfo orderRouteRuleRespDtoPageInfo = new PageInfo();
        ArrayList orderRouteRuleRespDtos = new ArrayList();
        OrderRouteRuleEo eo = new OrderRouteRuleEo();
        ArrayList<SqlFilter> sqlFilterList = eo.getSqlFilters();
        if (null == sqlFilterList) {
            sqlFilterList = new ArrayList<SqlFilter>();
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getRouteRuleName())) {
            sqlFilterList.add(SqlFilter.like((String)"routeRuleName", (Object)("%" + dto.getRouteRuleName() + "%")));
        }
        if (null != dto && null != dto.getStatus()) {
            eo.setRouteStatus(dto.getStatus());
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getModifyStartTime())) {
            sqlFilterList.add(SqlFilter.ge((String)"updateTime", (Object)(dto.getModifyStartTime() + " 00:00:00")));
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getModifyEndTime())) {
            sqlFilterList.add(SqlFilter.le((String)"updateTime", (Object)(dto.getModifyEndTime() + " 23:59:59")));
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getApplicableChannel())) {
            eo.setApplicableChannel(dto.getApplicableChannel());
        }
        eo.setSqlFilters(sqlFilterList);
        eo.setOrderByDesc("updateTime");
        PageInfo orderRouteRuleEoPageInfo = this.orderRouteRuleDas.selectPage((BaseEo)eo, pageNum, pageSize);
        if (null == orderRouteRuleEoPageInfo) {
            return orderRouteRuleRespDtoPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)orderRouteRuleRespDtoPageInfo, (Object)orderRouteRuleEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)orderRouteRuleEoPageInfo.getList(), orderRouteRuleRespDtos, OrderRouteRuleRespDto.class);
        orderRouteRuleRespDtoPageInfo.setList(orderRouteRuleRespDtos);
        return orderRouteRuleRespDtoPageInfo;
    }

    @Override
    public OrderRouteRuleRespDto queryRouteRuleById(Long id) {
        OrderRouteRuleRespDto dto = new OrderRouteRuleRespDto();
        OrderRouteRuleEo eo = (OrderRouteRuleEo)this.orderRouteRuleDas.selectByPrimaryKey(id);
        if (null == eo) {
            throw new BizException(InventoryExceptionCode.ORDER_RULE_EMPTY_ERROR.getCode(), InventoryExceptionCode.ORDER_RULE_EMPTY_ERROR.getMsg());
        }
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    @Transactional
    public void saveRouteRule(OrderRouteRuleReqDto dto) {
        if (null == dto.getId()) {
            if (this.checkRouteRuleName(dto.getRouteRuleName()).booleanValue()) {
                throw new BizException(InventoryExceptionCode.ROUTE_RULE_NAME_UNIQUE_ERROR.getCode(), InventoryExceptionCode.ROUTE_RULE_NAME_UNIQUE_ERROR.getMsg());
            }
            if (this.checkRouteRuleChannel(dto.getApplicableChannel()).booleanValue()) {
                throw new BizException(InventoryExceptionCode.APPLICABLE_CHANNELS_UNIQUE_ERROR.getCode(), InventoryExceptionCode.APPLICABLE_CHANNELS_UNIQUE_ERROR.getMsg());
            }
            if ("COMBINE".equals(dto.getRouteType())) {
                if (0 == dto.getInventoryPriority() && StringUtils.isEmpty((Object)dto.getInventoryPriorityItem())) {
                    throw new BizException(InventoryExceptionCode.INVENTORY_PRIORITY_ITEM_EMPTY_ERROR.getCode(), InventoryExceptionCode.INVENTORY_PRIORITY_ITEM_EMPTY_ERROR.getMsg());
                }
                this.validateWeight(dto.getWeightItem());
            }
            this.addRouteRule(dto);
        } else {
            OrderRouteRuleEo eo = (OrderRouteRuleEo)this.orderRouteRuleDas.selectByPrimaryKey(dto.getId());
            if (null == eo) {
                throw new BizException(InventoryExceptionCode.ORDER_RULE_EMPTY_ERROR.getCode(), InventoryExceptionCode.ORDER_RULE_EMPTY_ERROR.getMsg());
            }
            if (!dto.getRouteRuleName().equals(eo.getRouteRuleName()) && this.checkRouteRuleName(dto.getRouteRuleName()).booleanValue()) {
                throw new BizException(InventoryExceptionCode.ROUTE_RULE_NAME_UNIQUE_ERROR.getCode(), InventoryExceptionCode.ROUTE_RULE_NAME_UNIQUE_ERROR.getMsg());
            }
            if (!dto.getApplicableChannel().equals(eo.getApplicableChannel()) && this.checkRouteRuleChannel(dto.getApplicableChannel()).booleanValue()) {
                throw new BizException(InventoryExceptionCode.APPLICABLE_CHANNELS_UNIQUE_ERROR.getCode(), InventoryExceptionCode.APPLICABLE_CHANNELS_UNIQUE_ERROR.getMsg());
            }
            if ("COMBINE".equals(dto.getRouteType())) {
                if (0 == dto.getInventoryPriority() && StringUtils.isEmpty((Object)dto.getInventoryPriorityItem())) {
                    throw new BizException(InventoryExceptionCode.INVENTORY_PRIORITY_ITEM_EMPTY_ERROR.getCode(), InventoryExceptionCode.INVENTORY_PRIORITY_ITEM_EMPTY_ERROR.getMsg());
                }
                this.validateWeight(dto.getWeightItem());
            }
            this.updateRouteRule(dto);
        }
    }

    @Override
    public void enOrDisableRouteRule(Long id, Integer status) {
        OrderRouteRuleEo eo = new OrderRouteRuleEo();
        eo.setId(id);
        eo.setRouteStatus(status);
        this.orderRouteRuleDas.updateSelective((BaseEo)eo);
    }

    private Boolean checkRouteRuleName(String routeRuleName) {
        OrderRouteRuleEo eo = new OrderRouteRuleEo();
        eo.setRouteRuleName(routeRuleName);
        return !CollectionUtils.isEmpty((Collection)this.orderRouteRuleDas.select((BaseEo)eo));
    }

    private Boolean checkRouteRuleChannel(String applicableChannels) {
        OrderRouteRuleEo eo = new OrderRouteRuleEo();
        eo.setApplicableChannel(applicableChannels);
        return !CollectionUtils.isEmpty((Collection)this.orderRouteRuleDas.select((BaseEo)eo));
    }

    private void validateWeight(String weightItems) {
        JSONArray weightArrays;
        Integer weightCounts = 0;
        HashSet<String> wightItemTypeSet = new HashSet<String>();
        HashSet<String> wightItemIdSet = new HashSet<String>();
        if (!StringUtils.isEmpty((Object)weightItems) && !(weightArrays = JSON.parseArray((String)weightItems)).isEmpty()) {
            for (int i = 0; i < weightArrays.size(); ++i) {
                weightCounts = weightCounts + (Integer)weightArrays.getJSONObject(i).get((Object)"ration");
                wightItemTypeSet.add(weightArrays.getJSONObject(i).get((Object)"type").toString());
                wightItemIdSet.add(weightArrays.getJSONObject(i).get((Object)"id").toString());
            }
        }
        if (100 != weightCounts) {
            throw new BizException(InventoryExceptionCode.WEIGHT_TOTAL_ERROR.getCode(), InventoryExceptionCode.WEIGHT_TOTAL_ERROR.getMsg());
        }
        if (!StringUtils.isEmpty((Object)weightItems) && wightItemTypeSet.size() != JSON.parseArray((String)weightItems).size() || !StringUtils.isEmpty((Object)weightItems) && wightItemIdSet.size() != JSON.parseArray((String)weightItems).size()) {
            throw new BizException(InventoryExceptionCode.WEIGHT_ITEM_UNIQUE_ERROR.getCode(), InventoryExceptionCode.WEIGHT_ITEM_UNIQUE_ERROR.getMsg());
        }
    }

    private void addRouteRule(OrderRouteRuleReqDto dto) {
        OrderRouteRuleEo eo = new OrderRouteRuleEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.orderRouteRuleDas.insert((BaseEo)eo);
    }

    private void updateRouteRule(OrderRouteRuleReqDto dto) {
        OrderRouteRuleEo eo = new OrderRouteRuleEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.orderRouteRuleDas.update((BaseEo)eo);
    }

    @Override
    public boolean checkMatch(WarehouseRouteRestDto warehouseRouteRestDto, RuleRespDto ruleRespDto) {
        Integer ruleRelationship = ruleRespDto.getRuleRelationship();
        List ruleValues = ruleRespDto.getRuleValues();
        for (RuleValueRespDto ruleValue : ruleValues) {
            HashSet<String> resultSet;
            HashSet<String> codeSet;
            String columnValue;
            String columnName = ruleValue.getColumnName();
            String opt = ruleValue.getOpt();
            String value = ruleValue.getValue();
            if ("code".equals(columnName)) {
                columnValue = warehouseRouteRestDto.getCode();
            } else if ("name".equals(columnName)) {
                columnValue = warehouseRouteRestDto.getName();
            } else if ("id".equals(columnName)) {
                columnValue = String.valueOf(warehouseRouteRestDto.getId());
            } else if ("credit_value".equals(columnName)) {
                columnValue = String.valueOf(warehouseRouteRestDto.getCreditValue());
            } else if ("type".equals(columnName)) {
                columnValue = String.valueOf(warehouseRouteRestDto.getType());
            } else if ("sub_type".equals(columnName)) {
                columnValue = String.valueOf(warehouseRouteRestDto.getSubType());
            } else {
                return false;
            }
            if (DeliveryRuleRelationshipEnum.OR.getRuleRelationship().equals(ruleRelationship)) {
                if ("code".equals(columnName) || "name".equals(columnName)) {
                    if (DeliveryRuleOptEnum.EQ.getOpt().equals(opt) && columnValue.equals(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.NE.getOpt().equals(opt) && !columnValue.equals(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.GT.getOpt().equals(opt) && columnValue.compareTo(value) > 0) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.LT.getOpt().equals(opt) && columnValue.compareTo(value) < 0) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.GE.getOpt().equals(opt) && columnValue.compareTo(value) >= 0) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.LE.getOpt().equals(opt) && columnValue.compareTo(value) <= 0) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.IN.getOpt().equals(opt) && (codeSet = new HashSet<String>(Arrays.asList(value.split(",")))).contains(columnValue)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.NOT_IN.getOpt().equals(opt) && !(codeSet = new HashSet<String>(Arrays.asList(value.split(",")))).contains(columnValue)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.LIKE.getOpt().equals(opt) && columnValue.contains(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.NOT_LIKE.getOpt().equals(opt) && !columnValue.contains(value)) {
                        return true;
                    }
                }
                if ("id".equals(columnName) || "credit_value".equals(columnName) || "type".equals(columnName) || "sub_type".equals(columnName)) {
                    HashSet<String> resultSet2;
                    if (DeliveryRuleOptEnum.EQ.getOpt().equals(opt) && columnValue.equals(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.NE.getOpt().equals(opt) && !columnValue.equals(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.GT.getOpt().equals(opt) && Long.valueOf(columnValue) > Long.valueOf(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.LT.getOpt().equals(opt) && Long.valueOf(columnValue) < Long.valueOf(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.GE.getOpt().equals(opt) && Long.valueOf(columnValue) >= Long.valueOf(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.LE.getOpt().equals(opt) && Long.valueOf(columnValue) <= Long.valueOf(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.NOT_IN.getOpt().equals(opt) && !(resultSet2 = new HashSet<String>(Arrays.asList(value.split(",")))).contains(columnValue)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.IN.getOpt().equals(opt) && (resultSet2 = new HashSet<String>(Arrays.asList(value.split(",")))).contains(columnValue)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.LIKE.getOpt().equals(opt) && columnValue.contains(value)) {
                        return true;
                    }
                    if (DeliveryRuleOptEnum.NOT_LIKE.getOpt().equals(opt) && !columnValue.contains(value)) {
                        return true;
                    }
                }
            }
            if (!DeliveryRuleRelationshipEnum.ADD.getRuleRelationship().equals(ruleRelationship)) continue;
            if ("code".equals(columnName) || "name".equals(columnName)) {
                if (DeliveryRuleOptEnum.EQ.getOpt().equals(opt) && !columnValue.equals(value)) {
                    return false;
                }
                if (DeliveryRuleOptEnum.NE.getOpt().equals(opt) && columnValue.equals(value)) {
                    return false;
                }
                if (DeliveryRuleOptEnum.GT.getOpt().equals(opt) && columnValue.compareTo(value) <= 0) {
                    return false;
                }
                if (DeliveryRuleOptEnum.LT.getOpt().equals(opt) && columnValue.compareTo(value) >= 0) {
                    return false;
                }
                if (DeliveryRuleOptEnum.GE.getOpt().equals(opt) && columnValue.compareTo(value) < 0) {
                    return false;
                }
                if (DeliveryRuleOptEnum.LE.getOpt().equals(opt) && columnValue.compareTo(value) > 0) {
                    return false;
                }
                if (DeliveryRuleOptEnum.IN.getOpt().equals(opt) && !(codeSet = new HashSet<String>(Arrays.asList(value.split(",")))).contains(columnValue)) {
                    return false;
                }
                if (DeliveryRuleOptEnum.NOT_IN.getOpt().equals(opt) && (codeSet = new HashSet<String>(Arrays.asList(value.split(",")))).contains(columnValue)) {
                    return false;
                }
                if (DeliveryRuleOptEnum.LIKE.getOpt().equals(opt) && !columnValue.contains(value)) {
                    return false;
                }
                if (DeliveryRuleOptEnum.NOT_LIKE.getOpt().equals(opt) && columnValue.contains(value)) {
                    return false;
                }
            }
            if (!"id".equals(columnName) && !"credit_value".equals(columnName) && !"type".equals(columnName) && !"sub_type".equals(columnName)) continue;
            long columnLongValue = Long.valueOf(columnValue);
            if (DeliveryRuleOptEnum.EQ.getOpt().equals(opt) && columnLongValue != Long.valueOf(value)) {
                return false;
            }
            if (DeliveryRuleOptEnum.NE.getOpt().equals(opt) && columnLongValue == Long.valueOf(value)) {
                return false;
            }
            if (DeliveryRuleOptEnum.GT.getOpt().equals(opt) && columnLongValue <= Long.valueOf(value)) {
                return false;
            }
            if (DeliveryRuleOptEnum.LT.getOpt().equals(opt) && columnLongValue >= Long.valueOf(value)) {
                return false;
            }
            if (DeliveryRuleOptEnum.GE.getOpt().equals(opt) && columnLongValue < Long.valueOf(value)) {
                return false;
            }
            if (DeliveryRuleOptEnum.LE.getOpt().equals(opt) && columnLongValue > Long.valueOf(value)) {
                return false;
            }
            if (DeliveryRuleOptEnum.IN.getOpt().equals(opt) && !(resultSet = new HashSet<String>(Arrays.asList(value.split(",")))).contains(String.valueOf(columnLongValue))) {
                return false;
            }
            if (DeliveryRuleOptEnum.NOT_IN.getOpt().equals(opt) && (resultSet = new HashSet<String>(Arrays.asList(value.split(",")))).contains(String.valueOf(columnLongValue))) {
                return false;
            }
            if (DeliveryRuleOptEnum.LIKE.getOpt().equals(opt) && !columnValue.contains(value)) {
                return false;
            }
            if (!DeliveryRuleOptEnum.NOT_LIKE.getOpt().equals(opt) || columnValue.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkMatch(WarehouseRouteRestDto warehouseRouteRestDto, List<RuleRespDto> ruleRespDtos) {
        Boolean hasMatch = false;
        for (RuleRespDto ruleRespDto : ruleRespDtos) {
            boolean isMatch = this.checkMatch(warehouseRouteRestDto, ruleRespDto);
            if (!isMatch) continue;
            hasMatch = true;
            break;
        }
        return hasMatch;
    }

    @Override
    public String getWarehouseFilterSql(OrderRouteRuleRespDto orderRouteRule) {
        List ruleIds = JSON.parseArray((String)orderRouteRule.getInventoryPriorityItem(), Long.class);
        List<RuleRespDto> ruleRespDtos = this.ruleService.queryByIds(ruleIds, EnableEnum.ENABLE.getCode());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ruleRespDtos)) {
            this.logger.info("\u672a\u914d\u5e93\u5b58\u89c4\u5219\u4fe1\u606f, applicableChannel:{}", (Object)orderRouteRule.getApplicableChannel());
            return "";
        }
        boolean oneFirst = true;
        StringBuilder filterSql = new StringBuilder("(");
        for (RuleRespDto ruleRespDto : ruleRespDtos) {
            Integer ruleRelationship = ruleRespDto.getRuleRelationship();
            filterSql.append(oneFirst ? " ( " : " " + DeliveryRuleRelationshipEnum.getByRuleRelationship((Integer)ruleRelationship).getCode() + " ( ");
            boolean twofirst = true;
            List ruleValues = ruleRespDto.getRuleValues();
            for (RuleValueRespDto ruleValueRespDto : ruleValues) {
                String columnName = ruleValueRespDto.getColumnName();
                String opt = ruleValueRespDto.getOpt();
                String value = ruleValueRespDto.getValue();
                filterSql.append(twofirst ? "" : " OR ");
                if (DeliveryRuleOptEnum.IN.getOpt().equals(opt) || DeliveryRuleOptEnum.NOT_IN.getOpt().equals(opt)) {
                    value = "'" + value.replace(",", "','") + "'";
                    filterSql.append(columnName + " " + opt + "(" + value + ")");
                } else if (DeliveryRuleOptEnum.LIKE.getOpt().equals(opt) || DeliveryRuleOptEnum.NOT_LIKE.getOpt().equals(opt)) {
                    filterSql.append(columnName + " " + opt + " '%" + value + "%'");
                } else {
                    filterSql.append(columnName + " " + opt + " '" + value + "'");
                }
                twofirst = false;
            }
            filterSql.append(")");
            oneFirst = false;
        }
        filterSql.append(")");
        this.logger.info("\u6839\u636e\u5e93\u5b58\u89c4\u5219\u62fc\u63a5\u51fa\u7684SQL :{}", (Object)filterSql.toString());
        return filterSql.toString();
    }
}

