/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.PositionTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.PositionCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.PositionQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.PositionUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.PositionQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IPositionService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.PositionDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.PositionEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="positionService")
public class PositionServiceImpl
implements IPositionService {
    private static Logger logger = LoggerFactory.getLogger(PositionServiceImpl.class);
    @Resource
    private PositionDas positionDas;
    @Resource
    private WarehouseDas warehouseDas;

    @Override
    public Long addPosition(PositionCreateReqDto positionCreateReqDto) {
        Assert.notNull((Object)positionCreateReqDto.getCode(), (String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)positionCreateReqDto.getTenantId(), (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)positionCreateReqDto.getInstanceId(), (String)"\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a");
        if (!PositionTypeEnum.isContain((String)positionCreateReqDto.getType())) {
            throw new BizException("\u4ed3\u4f4d\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(positionCreateReqDto.getWarehouseId());
        Assert.notNull((Object)warehouseEo, (String)"\u4ed3\u5e93id\u4e0d\u5408\u6cd5");
        PositionEo positionEo = new PositionEo();
        positionEo.setCode(positionCreateReqDto.getCode());
        positionEo.setInstanceId(positionCreateReqDto.getInstanceId());
        positionEo.setTenantId(positionCreateReqDto.getTenantId());
        List positionEos = this.positionDas.select((BaseEo)positionEo);
        if (CollectionUtils.isEmpty((Collection)positionEos)) {
            PositionEo eo = new PositionEo();
            DtoHelper.dto2Eo((BaseVo)positionCreateReqDto, (BaseEo)eo);
            this.positionDas.insert((BaseEo)eo);
            return positionEo.getId();
        }
        throw new BizException("code\u91cd\u590d\uff0c\u8bf7\u91cd\u4f20");
    }

    @Override
    public void modifyPosition(Long id, PositionUpdateReqDto positionUpdateReqDto) {
        PositionEo positionEo = new PositionEo();
        if (null != positionUpdateReqDto) {
            DtoHelper.dto2Eo((BaseVo)positionUpdateReqDto, (BaseEo)positionEo);
        }
        positionEo.setId(id);
        this.positionDas.updateSelective((BaseEo)positionEo);
    }

    @Override
    public void removeById(Long id) {
        this.positionDas.logicDeleteById(id);
    }

    @Override
    public void removeByCode(String code) {
        PositionEo positionEo = new PositionEo();
        positionEo.setCode(code);
        List positionEos = this.positionDas.select((BaseEo)positionEo);
        for (PositionEo positionEo1 : positionEos) {
            this.positionDas.logicDeleteById(positionEo1.getId());
        }
    }

    @Override
    public PositionQueryRespDto getById(Long id) {
        PositionEo positionEo = (PositionEo)this.positionDas.selectByPrimaryKey(id);
        PositionQueryRespDto positionQueryRespDto = new PositionQueryRespDto();
        if (null != positionEo) {
            DtoHelper.eo2Dto((BaseEo)positionEo, (BaseVo)positionQueryRespDto);
        }
        return positionQueryRespDto;
    }

    @Override
    public PositionQueryRespDto getByCode(String code, Long instanceId, Long tenantId) {
        PositionEo positionEo = new PositionEo();
        positionEo.setCode(code);
        positionEo.setInstanceId(instanceId);
        positionEo.setTenantId(tenantId);
        List positionEos = this.positionDas.select((BaseEo)positionEo);
        PositionEo positionEoRes = new PositionEo();
        if (positionEos.size() != 0) {
            positionEoRes = (PositionEo)positionEos.get(0);
        }
        PositionQueryRespDto positionQueryRespDto = new PositionQueryRespDto();
        DtoHelper.eo2Dto((BaseEo)positionEoRes, (BaseVo)positionQueryRespDto);
        return positionQueryRespDto;
    }

    @Override
    public PageInfo<PositionQueryRespDto> queryByPage(PositionQueryReqDto positionQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo positionEoPageInfo;
        PositionEo positionEo = new PositionEo();
        if (null != positionQueryReqDto) {
            DtoHelper.dto2Eo((BaseVo)positionQueryReqDto, (BaseEo)positionEo);
        }
        if (null == (positionEoPageInfo = this.positionDas.selectPage((BaseEo)positionEo, pageNum, pageSize))) {
            return null;
        }
        PageInfo positionQueryRespDtoPageInfo = new PageInfo();
        ArrayList positionQueryRespDtos = new ArrayList();
        CubeBeanUtils.copyProperties((Object)positionQueryRespDtoPageInfo, (Object)positionEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)positionEoPageInfo.getList(), positionQueryRespDtos, PositionQueryRespDto.class);
        positionQueryRespDtoPageInfo.setList(positionQueryRespDtos);
        return positionQueryRespDtoPageInfo;
    }

    @Override
    public List<PositionQueryRespDto> queryByList(PositionQueryReqDto positionQueryReqDto) {
        PositionEo positionEo = new PositionEo();
        if (null != positionEo) {
            DtoHelper.dto2Eo((BaseVo)positionQueryReqDto, (BaseEo)positionEo);
        }
        List positionEos = this.positionDas.select((BaseEo)positionEo);
        ArrayList<PositionQueryRespDto> positionQueryRespDtos = new ArrayList<PositionQueryRespDto>();
        if (positionEos.size() != 0) {
            DtoHelper.eoList2DtoList((Collection)positionEos, positionQueryRespDtos, PositionQueryRespDto.class);
        }
        return positionQueryRespDtos;
    }
}

