/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRAreaWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RAreaWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RAreaWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ServiceAreaEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.RAreaWarehouseRespDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RAreaWarehouseServiceImpl
implements IRAreaWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(RAreaWarehouseServiceImpl.class);
    @Resource
    private RAreaWarehouseDas rAreaWarehouseDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private ServiceAreaDas serviceAreaDas;

    @Override
    public int countWarehouseId(Long houseId) {
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setWarehouseId(houseId);
        return this.rAreaWarehouseDas.count((BaseEo)rAreaWarehouseEo);
    }

    @Override
    public Long addRAreaWarehouse(RAreaWarehouseEo rAreaWarehouseEo) {
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(rAreaWarehouseEo.getWarehouseId());
        if (null == warehouseEo) {
            logger.error(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
            throw new BizException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        ServiceAreaEo serviceAreaEo = (ServiceAreaEo)this.serviceAreaDas.selectByPrimaryKey(rAreaWarehouseEo.getServiceAreaId());
        if (null == serviceAreaEo) {
            logger.error(InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getMsg());
            throw new BizException(InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getCode(), InventoryExceptionCode.SERVICE_AREA_NOT_EXIST.getMsg());
        }
        this.rAreaWarehouseDas.insert((BaseEo)rAreaWarehouseEo);
        return rAreaWarehouseEo.getId();
    }

    @Override
    public void removeByIds(List<Long> ids, RequestDto requestDto) {
        LinkedHashSet<Long> disIds = new LinkedHashSet<Long>();
        disIds.addAll(ids);
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(disIds, (String)",")));
        rAreaWarehouseEo.setSqlFilters(sqlFilters);
        rAreaWarehouseEo.setInstanceId(requestDto.getInstanceId());
        rAreaWarehouseEo.setTenantId(requestDto.getTenantId());
        if (this.rAreaWarehouseDas.count((BaseEo)rAreaWarehouseEo) != disIds.size()) {
            InventoryBusinessRuntimeException.recordNotExist();
        }
        this.rAreaWarehouseDas.delete((BaseEo)rAreaWarehouseEo);
    }

    @Override
    public void removeById(Long id) {
        this.rAreaWarehouseDas.logicDeleteById(id);
    }

    @Override
    public List<RAreaWarehouseRespDto> queryByServiceAreaId(Long serviceAreaId) {
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setServiceAreaId(serviceAreaId);
        List rAreaWarehouseEos = this.rAreaWarehouseDas.select((BaseEo)rAreaWarehouseEo);
        ArrayList<RAreaWarehouseRespDto> rAreaWarehouseDtos = new ArrayList<RAreaWarehouseRespDto>();
        DtoHelper.eoList2DtoList((Collection)rAreaWarehouseEos, rAreaWarehouseDtos, RAreaWarehouseRespDto.class);
        return rAreaWarehouseDtos;
    }

    @Override
    public List<RAreaWarehouseRespDto> queryByWarehouseId(Long warehouseId) {
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setWarehouseId(warehouseId);
        List rAreaWarehouseEos = this.rAreaWarehouseDas.select((BaseEo)rAreaWarehouseEo);
        LinkedList list = Lists.newLinkedList();
        DtoHelper.eoList2DtoList((Collection)rAreaWarehouseEos, (Collection)list, RAreaWarehouseRespDto.class);
        return list;
    }
}

