/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RServiceAreaReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RServiceAreaRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRServiceAreaService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RServiceAreaEo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RServiceAreaServiceImpl
implements IRServiceAreaService {
    private static Logger logger = LoggerFactory.getLogger(RServiceAreaServiceImpl.class);
    @Resource
    private RServiceAreaDas rServiceAreaDas;

    @Override
    public Long add(RServiceAreaReqDto rServiceAreaReqDto) {
        RServiceAreaEo rServiceAreaEo = new RServiceAreaEo();
        DtoHelper.dto2Eo((BaseVo)rServiceAreaReqDto, (BaseEo)rServiceAreaEo);
        this.rServiceAreaDas.insert((BaseEo)rServiceAreaEo);
        return rServiceAreaEo.getId();
    }

    @Override
    public List<Long> queryWarehouseId(String provCode, String cityCode, String areaCode, Long instanceId, Long tenantId) {
        return null;
    }

    @Override
    public RServiceAreaRespDto queryByArea(String provCode, String cityCode, String areaCode) {
        RServiceAreaEo eo = new RServiceAreaEo();
        eo.setProvCode(provCode);
        eo.setCityCode(cityCode);
        eo.setAreaCode(areaCode);
        RServiceAreaEo rServiceAreaEo = (RServiceAreaEo)this.rServiceAreaDas.selectOne((BaseEo)eo);
        RServiceAreaRespDto respDto = new RServiceAreaRespDto();
        DtoHelper.eo2Dto((BaseEo)rServiceAreaEo, (BaseVo)respDto);
        return respDto;
    }

    @Override
    public List<RServiceAreaRespDto> queryByServiceAreaId(Long serviceAreaId) {
        RServiceAreaEo eo = new RServiceAreaEo();
        eo.setServiceAreaId(serviceAreaId);
        List eoList = this.rServiceAreaDas.select((BaseEo)eo);
        LinkedList dtoList = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty((Collection)eoList)) {
            DtoHelper.eoList2DtoList((Collection)eoList, (Collection)dtoList, RServiceAreaRespDto.class);
        }
        return dtoList;
    }

    @Override
    public void removeById(Long id) {
        this.rServiceAreaDas.logicDeleteById(id);
    }
}

