/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RefWarehousePageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RefWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RefWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRefWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RefWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdRefWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RefWarehouseServiceImpl
implements IRefWarehouseService {
    @Resource
    private RefWarehouseDas refWarehouseDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private CargoStorageDas cargoStorageDas;

    @Override
    public Long addRefWarehouse(List<RefWarehouseReqDto> RefWarehouseReqDtos) {
        this.refWarehouseDas.insertBatch(EoUtil.dtoListToEoList(RefWarehouseReqDtos, RefWarehouseEo.class));
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRefWarehouse(List<RefWarehouseReqDto> refWarehouseReqDtos) {
        try {
            WarehouseEo warehouseEo;
            if (CollectionUtils.isEmpty(refWarehouseReqDtos)) {
                return;
            }
            String warehouseId = refWarehouseReqDtos.get(0).getWarehouseId();
            List cargoIds = refWarehouseReqDtos.stream().map(RefWarehouseReqDto::getCargoId).filter(Objects::nonNull).collect(Collectors.toList());
            List cargoStorageEos = new ArrayList(cargoIds.size());
            Map<Object, Object> cargoStorageMap = new HashMap(cargoIds.size());
            if (CollectionUtils.isNotEmpty(cargoIds) && CollectionUtils.isNotEmpty(cargoStorageEos = this.cargoStorageDas.select(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouse_id", (Object)warehouseId).eq("inventory_share_status", (Object)1).in("cargo_id", (Object)StringUtils.join(cargoIds, (String)",")).eo()))) {
                cargoStorageMap = cargoStorageEos.stream().collect(Collectors.toMap(StdCargoStorageEo::getCargoId, StdCargoStorageEo::getAvailable));
            }
            if (null == (warehouseEo = (WarehouseEo)this.warehouseDas.getMapper().findById(WarehouseEo.class, Long.valueOf(warehouseId)))) {
                return;
            }
            Boolean inventoryShareStatus = warehouseEo.getInventoryShareStatus();
            List warehouseEoList = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).eq("warehouse_id", (Object)warehouseId).eo());
            Map<Object, Object> map = new HashMap(warehouseEoList.size());
            if (CollectionUtils.isNotEmpty((Collection)warehouseEoList)) {
                map = warehouseEoList.stream().collect(Collectors.toMap(k -> k.getRefWarehouseId() + (null == k.getCargoId() ? "" : k.getCargoId()), w -> w));
            }
            HashMap finalMap = map;
            List refWarehouseEos = EoUtil.dtoListToEoList(refWarehouseReqDtos, RefWarehouseEo.class);
            RefWarehouseEo refWarehouseEo = new RefWarehouseEo();
            refWarehouseEo.setWarehouseId(warehouseId);
            this.refWarehouseDas.insertBatchByExample(refWarehouseEos, (BaseEo)refWarehouseEo);
            List finalCargoStorageEos = cargoStorageEos;
            Map<Object, Object> finalCargoStorageMap = cargoStorageMap;
            refWarehouseEos.stream().forEach(r -> {
                if (1 != r.getType()) {
                    RefWarehouseEo refWarehouseEo1 = (RefWarehouseEo)finalMap.get(r.getRefWarehouseId() + r.getCargoId());
                    if (null != refWarehouseEo1) {
                        BigDecimal proportion = r.getProportion();
                        if (refWarehouseEo1.getProportion().compareTo(proportion) != 0 && inventoryShareStatus.booleanValue() && CollectionUtils.isNotEmpty((Collection)finalCargoStorageEos)) {
                            InventoryCountDto dto = new InventoryCountDto();
                            dto.setWarehouseId(Long.valueOf(r.getWarehouseId()));
                            dto.setRefWarehouseId(Long.valueOf(r.getRefWarehouseId()));
                            dto.setCargoId(r.getCargoId());
                            dto.setNo(TradeUtil.generateTradeNo(r.getCargoId().toString()));
                            BigDecimal available = (BigDecimal)finalCargoStorageMap.get(r.getCargoId());
                            if (null != available) {
                                dto.setNum(available.multiply(proportion.divide(new BigDecimal("100"), 2, 4)).subtract(available.multiply(refWarehouseEo1.getProportion().divide(new BigDecimal("100"), 2, 4))).divide(proportion.divide(new BigDecimal("100"), 2, 4), 2, 4));
                                ArrayList<InventoryCountDto> list = new ArrayList<InventoryCountDto>();
                                list.add(dto);
                                this.sendMq(list);
                            }
                        }
                    } else if (inventoryShareStatus.booleanValue() && CollectionUtils.isNotEmpty((Collection)finalCargoStorageEos)) {
                        InventoryCountDto dto = new InventoryCountDto();
                        dto.setWarehouseId(Long.valueOf(r.getWarehouseId()));
                        dto.setRefWarehouseId(Long.valueOf(r.getRefWarehouseId()));
                        dto.setCargoId(r.getCargoId());
                        dto.setNo(TradeUtil.generateTradeNo(r.getCargoId().toString()));
                        BigDecimal available = (BigDecimal)finalCargoStorageMap.get(r.getCargoId());
                        if (null != available) {
                            dto.setNum(available);
                            ArrayList<InventoryCountDto> list = new ArrayList<InventoryCountDto>();
                            list.add(dto);
                            this.sendMq(list);
                        }
                    }
                }
            });
            Map<Integer, List<RefWarehouseReqDto>> refWarehouseMap = refWarehouseReqDtos.stream().collect(Collectors.groupingBy(RefWarehouseReqDto::getType));
            List<RefWarehouseReqDto> warehouseReqDtos = refWarehouseMap.get(2);
            if (CollectionUtils.isNotEmpty((Collection)warehouseEoList) && CollectionUtils.isNotEmpty(warehouseReqDtos)) {
                Map<String, RefWarehouseReqDto> reqDtoMap = warehouseReqDtos.stream().collect(Collectors.toMap(k -> k.getRefWarehouseId() + (null == k.getCargoId() ? "" : k.getCargoId()), w -> w));
                warehouseEoList.stream().forEach(r -> {
                    if (1 != r.getType()) {
                        BigDecimal proportion = r.getProportion();
                        RefWarehouseReqDto refWarehouseReqDto = (RefWarehouseReqDto)reqDtoMap.get(r.getRefWarehouseId() + r.getCargoId());
                        if (null == refWarehouseReqDto && inventoryShareStatus.booleanValue() && CollectionUtils.isNotEmpty((Collection)finalCargoStorageEos)) {
                            InventoryCountDto dto = new InventoryCountDto();
                            dto.setWarehouseId(Long.valueOf(r.getWarehouseId()));
                            dto.setRefWarehouseId(Long.valueOf(r.getRefWarehouseId()));
                            dto.setCargoId(r.getCargoId());
                            dto.setNo(TradeUtil.generateTradeNo(r.getCargoId().toString()));
                            BigDecimal available = (BigDecimal)finalCargoStorageMap.get(r.getCargoId());
                            if (null != available) {
                                BigDecimal divide = proportion.divide(new BigDecimal("100"), 2, 4);
                                dto.setNum(available.multiply(divide).negate().divide(divide, 2, 4));
                                ArrayList<InventoryCountDto> list = new ArrayList<InventoryCountDto>();
                                list.add(dto);
                                this.sendMq(list);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void allWarehouse(RefWarehouseEo r) {
        List select = this.refWarehouseDas.select(SqlFilterBuilder.create(RefWarehouseEo.class).eq("ref_warehouse_id", (Object)r.getRefWarehouseId()).eq("type", (Object)1).eo());
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            List warehouseIds = select.stream().map(StdRefWarehouseEo::getWarehouseId).collect(Collectors.toList());
            List cargoStorageEos = this.cargoStorageDas.select(SqlFilterBuilder.create(CargoStorageEo.class).in("warehouse_id", (Object)StringUtils.join(warehouseIds, (String)",")).eq("inventory_share_status", (Object)1).eo());
            if (CollectionUtils.isEmpty((Collection)cargoStorageEos)) {
                return;
            }
            Map<Long, List<CargoStorageEo>> cargoStorageMap = cargoStorageEos.stream().collect(Collectors.groupingBy(StdCargoStorageEo::getWarehouseId));
            List warehouseEos = this.warehouseDas.select(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join(warehouseIds, (String)",")).eo());
            Map<Long, Boolean> warehouseMap = warehouseEos.stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getInventoryShareStatus));
            select.stream().forEach(s -> {
                String warehouseId = s.getWarehouseId();
                BigDecimal proportion = r.getProportion();
                if (!warehouseId.equals(r.getWarehouseId())) {
                    List storageEos = (List)cargoStorageMap.get(Long.valueOf(warehouseId));
                    Boolean status = (Boolean)warehouseMap.get(Long.valueOf(warehouseId));
                    if (null != status && status.booleanValue() && CollectionUtils.isNotEmpty((Collection)storageEos)) {
                        this.sendMq(storageEos.stream().map(c -> {
                            InventoryCountDto dto = new InventoryCountDto();
                            dto.setWarehouseId(c.getWarehouseId());
                            dto.setRefWarehouseId(Long.valueOf(s.getRefWarehouseId()));
                            dto.setCargoId(c.getCargoId());
                            BigDecimal available = c.getAvailable();
                            dto.setNum(available.multiply(proportion.divide(new BigDecimal("100"), 2, 4)).subtract(available.multiply(s.getProportion().divide(new BigDecimal("100"), 2, 4))).divide(proportion.divide(new BigDecimal("100"), 2, 4), 2, 4));
                            return dto;
                        }).collect(Collectors.toList()));
                    }
                }
            });
        }
    }

    private void sendMq(List<InventoryCountDto> inventoryCountDtos) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData(inventoryCountDtos);
        this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)messageVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRefWarehouse(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            RefWarehouseEo refWarehouseEo = new RefWarehouseEo();
            refWarehouseEo.setWarehouseId(id);
            this.refWarehouseDas.deleteByExample((BaseEo)refWarehouseEo);
        }
    }

    @Override
    public RefWarehouseRespDto queryById(Long id) {
        RefWarehouseEo refWarehouseEo = (RefWarehouseEo)this.refWarehouseDas.selectByPrimaryKey(id);
        RefWarehouseRespDto refWarehouseReqDto = (RefWarehouseRespDto)EoUtil.eoToDto((BaseEo)refWarehouseEo, RefWarehouseRespDto.class);
        return refWarehouseReqDto;
    }

    @Override
    public List<RefWarehouseRespDto> queryByIds(List<Long> refWarehouseId) {
        RefWarehouseEo query = (RefWarehouseEo)SqlFilterBuilder.create(RefWarehouseEo.class).in("id", refWarehouseId).eo();
        List refWarehouses = this.refWarehouseDas.select((BaseEo)query);
        List RefWarehouseRespDtos = EoUtil.eoListToDtoList((Collection)refWarehouses, RefWarehouseRespDto.class);
        return RefWarehouseRespDtos;
    }

    @Override
    public PageInfo<RefWarehouseRespDto> queryByPage(RefWarehousePageDto refWarehousePageReqDto) {
        RefWarehouseEo queryEo = (RefWarehouseEo)EoUtil.dtoToEo((BaseVo)refWarehousePageReqDto, RefWarehouseEo.class);
        PageInfo eoPageInfo = null;
        if (null != queryEo.getType() && 2 == queryEo.getType()) {
            eoPageInfo = this.refWarehouseDas.selectByGroup(queryEo, refWarehousePageReqDto.getPageNum(), refWarehousePageReqDto.getPageSize());
            List eoPageInfoList = eoPageInfo.getList();
            if (CollectionUtils.isEmpty((Collection)eoPageInfoList)) {
                return new PageInfo();
            }
            queryEo.setSqlFilters(SqlFilterBuilder.create(RefWarehouseEo.class).in("cargo_id", (Object)StringUtils.join((Iterable)eoPageInfoList.stream().map(StdRefWarehouseEo::getCargoId).collect(Collectors.toList()), (String)",")).filters());
            List refWarehouseEos = this.refWarehouseDas.select((BaseEo)queryEo);
            Map<Long, List<RefWarehouseEo>> refWarehouseMap = refWarehouseEos.stream().collect(Collectors.groupingBy(StdRefWarehouseEo::getCargoId));
            ArrayList refWarehouseRespDtos = new ArrayList(refWarehouseMap.keySet().size());
            refWarehouseMap.keySet().forEach(k -> {
                List warehouseEos = (List)refWarehouseMap.get(k);
                RefWarehouseRespDto dto = new RefWarehouseRespDto();
                CubeBeanUtils.copyProperties((Object)dto, warehouseEos.get(0), (String[])new String[0]);
                dto.setRefWarehouseReqDtos(EoUtil.eoListToDtoList((Collection)warehouseEos, RefWarehouseRespDto.class));
                refWarehouseRespDtos.add(dto);
            });
            PageInfo pageInfo = EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, RefWarehouseRespDto.class);
            pageInfo.setList(refWarehouseRespDtos);
            return pageInfo;
        }
        eoPageInfo = this.refWarehouseDas.selectPage((BaseEo)queryEo, refWarehousePageReqDto.getPageNum(), refWarehousePageReqDto.getPageSize());
        return EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, RefWarehouseRespDto.class);
    }
}

