/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.RulePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.RuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRuleService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderRouteRuleDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RuleDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageObjectDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderRouteRuleEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RuleEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageObjectEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageObjectEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuleServiceImpl
implements IRuleService {
    @Resource
    private RuleDas ruleDas;
    @Resource
    private StorageObjectDas storageObjectDas;
    @Resource
    private OrderRouteRuleDas orderRouteRuleDas;

    @Override
    public Long addRule(RuleEo ruleEo) {
        Assert.isTrue(!CollectionUtils.isNotEmpty((Collection)this.ruleDas.selectPage(SqlFilterBuilder.create(RuleEo.class).eq("name", (Object)ruleEo.getName()).eo(), Integer.valueOf(1), Integer.valueOf(1)).getList()), "\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        this.ruleDas.insert((BaseEo)ruleEo);
        return ruleEo.getId();
    }

    @Override
    public void modifyRule(RuleEo ruleEo) {
        Assert.isTrue(CollectionUtils.isEmpty((Collection)this.orderRouteRuleDas.select(SqlFilterBuilder.create(OrderRouteRuleEo.class).like("inventory_priority_item", (Object)("%" + ruleEo.getId() + "%")).eo())), "\u5df2\u5173\u8054\u7684\u89c4\u5219\u4e0d\u80fd\u4fee\u6539");
        Assert.isTrue(!StringUtils.isNotEmpty((CharSequence)ruleEo.getName()) || !CollectionUtils.isNotEmpty((Collection)this.ruleDas.select(SqlFilterBuilder.create(RuleEo.class).ne("id", (Object)ruleEo.getId()).eq("name", (Object)ruleEo.getName()).eo())), "\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        EoUtil.setNullVal((Object)ruleEo, (String[])new String[]{"createTime"});
        this.ruleDas.updateSelective((BaseEo)ruleEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRule(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.ruleDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public RuleRespDto queryById(Long id) {
        List select;
        RuleEo ruleEo = (RuleEo)this.ruleDas.selectByPrimaryKey(id);
        RuleRespDto ruleReqDto = (RuleRespDto)EoUtil.eoToDto((BaseEo)ruleEo, RuleRespDto.class);
        if (null != ruleReqDto && CollectionUtils.isNotEmpty((Collection)(select = this.storageObjectDas.select(SqlFilterBuilder.create(StorageObjectEo.class).eq("id", (Object)ruleEo.getInObjectId()).eo())))) {
            Map<Long, String> nameMap = select.stream().collect(Collectors.toMap(BaseEo::getId, StdStorageObjectEo::getStorageObjName));
            ruleReqDto.setInObjectName(nameMap.get(ruleEo.getInObjectId()));
        }
        return ruleReqDto;
    }

    @Override
    public List<RuleRespDto> queryByIds(List<Long> ruleIds, Integer status) {
        RuleEo query = (RuleEo)SqlFilterBuilder.create(RuleEo.class).in("id", ruleIds).eo();
        query.setStatus(status);
        List rules = this.ruleDas.select((BaseEo)query);
        List ruleRespDtos = EoUtil.eoListToDtoList((Collection)rules, RuleRespDto.class);
        if (CollectionUtils.isNotEmpty((Collection)ruleRespDtos)) {
            Map<Long, RuleRespDto> nameMap = ruleRespDtos.stream().collect(Collectors.toMap(o -> o.getId(), o -> o));
            ArrayList<RuleRespDto> respDtos = new ArrayList<RuleRespDto>();
            for (Long ruleId : ruleIds) {
                RuleRespDto ruleRespDto = nameMap.get(ruleId);
                if (null == ruleRespDto) continue;
                respDtos.add(ruleRespDto);
            }
            return respDtos;
        }
        return ruleRespDtos;
    }

    @Override
    public PageInfo<RuleRespDto> queryByPage(RulePageReqDto rulePageReqDto) {
        List select;
        RuleEo queryEo = (RuleEo)EoUtil.dtoToEo((BaseVo)rulePageReqDto, RuleEo.class);
        ArrayList sqlFilters = new ArrayList(2);
        if (StringUtils.isNotEmpty((CharSequence)rulePageReqDto.getCode())) {
            sqlFilters.addAll(SqlFilterBuilder.create(RuleEo.class).like("code", (Object)("%" + rulePageReqDto.getCode() + "%")).filters());
            queryEo.setCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)rulePageReqDto.getName())) {
            sqlFilters.addAll(SqlFilterBuilder.create(RuleEo.class).like("name", (Object)("%" + rulePageReqDto.getName() + "%")).filters());
            queryEo.setName(null);
        }
        if (null != rulePageReqDto.getUpdateStartTime() && null != rulePageReqDto.getUpdateEndTime()) {
            sqlFilters.addAll(SqlFilterBuilder.create(RuleEo.class).ge("update_time", (Object)rulePageReqDto.getUpdateStartTime()).le("update_time", (Object)rulePageReqDto.getUpdateEndTime()).filters());
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            queryEo.setSqlFilters(sqlFilters);
        }
        queryEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.ruleDas.selectPage((BaseEo)queryEo, rulePageReqDto.getPageNum(), rulePageReqDto.getPageSize());
        PageInfo ruleRespDtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, RuleRespDto.class);
        List dtoPageInfoList = ruleRespDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfoList) && CollectionUtils.isNotEmpty((Collection)(select = this.storageObjectDas.select(SqlFilterBuilder.create(StorageObjectEo.class).in("id", (Object)StringUtils.join((Iterable)dtoPageInfoList.stream().map(RuleRespDto::getInObjectId).collect(Collectors.toList()), (String)",")).eo())))) {
            Map<Long, String> nameMap = select.stream().collect(Collectors.toMap(BaseEo::getId, StdStorageObjectEo::getStorageObjName));
            dtoPageInfoList.stream().forEach(d -> d.setInObjectName((String)nameMap.get(d.getInObjectId())));
            ruleRespDtoPageInfo.setList(dtoPageInfoList);
        }
        return ruleRespDtoPageInfo;
    }
}

