/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.lock.provider.redis.RedisLockService;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.StockInsufficientException;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageChangeLogEo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class StockDsl {
    private static final Logger log = LoggerFactory.getLogger(StockDsl.class);
    private static final String INCR_STOCK_LACK_CHECK_LUA = "local lackKeys = '';local nilKeys = ''\nlocal nums = {}\nfor i=1, #KEYS do\n    local temp = redis.call('get', KEYS[i])\n    if temp then\n        local current = tonumber(temp)\n        local num = tonumber(ARGV[i])\n        if (num < 0 and current + num < 0) then\n            lackKeys = lackKeys .. KEYS[i] .. ','\n        else\n            nums[i] = num\n        end\n    else\n        nilKeys = nilKeys .. KEYS[i] .. ','\n    end\nend\nif ('' ~= lackKeys or '' ~= nilKeys) then\n    return lackKeys .. '],[' .. nilKeys\nelse\n   for i=1, #KEYS do\n       redis.call('incrby', KEYS[i], nums[i])\n   end\n   return '],['\nend\n";
    private static final String INCR_STOCK_LACK_NO_CHECK_LUA = "local nilKeys = ''\nlocal nums = {}\nfor i=1, #KEYS do\n    if (redis.call('exists', KEYS[i]) == 1) then\n        nums[i] = tonumber(ARGV[i])\n    else\n        nilKeys = nilKeys .. KEYS[i] .. ','\n    end\nend\nif ('' ~= nilKeys) then\n    return nilKeys\nelse\n   for i=1, #KEYS do\n       redis.call('incrby', KEYS[i], nums[i])\n   end\n   return ''\nend\n";
    private static final String SET_STOCK_LUA = "for i=1, #KEYS do\n    redis.call('set', KEYS[i], ARGV[i])\nend\n";
    private static final String UPDATE_STOCK_LOCK_KEY = "UPDATE_STOCK_LOCK_KEY";
    @Resource
    private ICacheService cacheService;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private RedisLockService redisLockService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${STOCK_CHANGE_TOPIC:STOCK_CHANGE_TOPIC}")
    private String STOCK_CHANGE_TOPIC;
    @Value(value="${STOCK_CHANGE_TAG:STOCK_CHANGE_TAG}")
    private String STOCK_CHANGE_TAG;
    @Value(value="${inventory.async-update-db-stock:false}")
    private Boolean asyncUpdateDbStock;

    private List<String> incrStockFromRedis(List<String> keys, List<String> args, Boolean checkStock) {
        if (Boolean.FALSE.equals(checkStock)) {
            String result = (String)this.cacheService.eval(INCR_STOCK_LACK_NO_CHECK_LUA, String.class, keys, args.toArray());
            if (!"".equals(result)) {
                if (StringUtils.hasText((String)result)) {
                    return Arrays.asList(result.split(","));
                }
                throw new BizException("\u5e93\u5b58\u53d8\u66f4\u5931\u8d25[" + result + "]");
            }
        } else {
            String result = (String)this.cacheService.eval(INCR_STOCK_LACK_CHECK_LUA, String.class, keys, args.toArray());
            if (!"],[".equals(result)) {
                String[] split = result.split("],\\[");
                if ((split.length == 1 || split.length == 2) && StringUtils.hasText((String)split[0])) {
                    throw new StockInsufficientException(split[0]);
                }
                if (split.length == 2 && StringUtils.hasText((String)split[1])) {
                    return Arrays.asList(split[1].split(","));
                }
                throw new BizException("\u5e93\u5b58\u53d8\u66f4\u5931\u8d25[" + result + "]");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initStockToRedis(List<Long> warehouseIds, List<Long> cargoIds, StockChangeDto dto) {
        Mutex mutex = null;
        try {
            mutex = this.redisLockService.lock(UPDATE_STOCK_LOCK_KEY, "", 1, 5, TimeUnit.MINUTES);
            CargoStorageEo cargoStorageEo = new CargoStorageEo();
            cargoStorageEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"warehouseId", warehouseIds), SqlFilter.in((String)"cargoId", cargoIds)));
            List select = this.cargoStorageDas.select((BaseEo)cargoStorageEo);
            if (!CollectionUtil.isEmpty((Collection)select)) {
                for (CargoStorageEo stock : select) {
                    String stockBalanceKey = StockDsl.getStockCacheKey(stock.getWarehouseId(), stock.getCargoId(), "balance");
                    this.cacheService.setIfAbsent(stockBalanceKey, String.valueOf(stock.getBalance().longValue()));
                    String stockAvailableKey = StockDsl.getStockCacheKey(stock.getWarehouseId(), stock.getCargoId(), "available");
                    this.cacheService.setIfAbsent(stockAvailableKey, String.valueOf(stock.getAvailable().longValue()));
                    String stockPreemptKey = StockDsl.getStockCacheKey(stock.getWarehouseId(), stock.getCargoId(), "preempt");
                    this.cacheService.setIfAbsent(stockPreemptKey, String.valueOf(stock.getPreempt().longValue()));
                }
            }
            if (mutex == null) return;
        }
        catch (Throwable throwable) {
            if (mutex == null) throw throwable;
            this.redisLockService.unlock(mutex);
            throw throwable;
        }
        this.redisLockService.unlock(mutex);
    }

    private static String getStockCacheKey(Long warehouseId, Long cargoId, String stockType) {
        return "{stock}:" + warehouseId + ":" + cargoId + ":" + stockType;
    }

    public int modifyStock(StockChangeDto dto) {
        List items = dto.getItems();
        Boolean checkStock = false;
        ArrayList keys = new ArrayList(items.size());
        ArrayList nums = new ArrayList(items.size());
        items.forEach(item -> item.getStocks().forEach(stock -> {
            keys.add(StockDsl.getStockCacheKey(item.getWarehouseId(), item.getCargoId(), stock.getStockType()));
            nums.add(String.valueOf(stock.getNum().longValue()));
        }));
        if (!this.asyncUpdateDbStock.booleanValue()) {
            return this.updateTcbjDbStock(dto);
        }
        dto.setMessageId(UUID.randomUUID().toString());
        this.commonsMqService.sendSingleMessage(this.STOCK_CHANGE_TOPIC, this.STOCK_CHANGE_TAG, (Object)dto);
        return 999;
    }

    public int updateTcbjDbStock(StockChangeDto dto) {
        List items = dto.getItems();
        items.sort(Comparator.comparing(StockChangeDto.StockChangeItemDto::getWarehouseId).thenComparing(StockChangeDto.StockChangeItemDto::getCargoId));
        int i = this.cargoStorageDas.incrStock(items);
        log.error("\u6c64\u81e3\u500d\u5065\u4fee\u6539\u6570\u636e\u5e93\u5e93\u5b58\u7ed3\u679c{}", (Object)i);
        this.saveStockChangeLog(dto);
        return i;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDbStock(StockChangeDto dto) {
        List items = dto.getItems();
        items.sort(Comparator.comparing(StockChangeDto.StockChangeItemDto::getWarehouseId).thenComparing(StockChangeDto.StockChangeItemDto::getCargoId));
        this.cargoStorageDas.incrStock(items);
        this.saveStockChangeLog(dto);
    }

    private void saveStockChangeLog(StockChangeDto dto) {
        List logEos = dto.getItems().stream().flatMap(item -> item.getStocks().stream().map(stock -> {
            StorageChangeLogEo eo = new StorageChangeLogEo();
            eo.setChangeType(dto.getChangeType());
            eo.setActionType(dto.getBizType());
            eo.setOrderNo(dto.getOrderNo());
            eo.setWarehouseId(item.getWarehouseId());
            eo.setCargoId(item.getCargoId());
            eo.setActionStatus(stock.getStockType());
            eo.setAllocate(Long.valueOf(stock.getNum().longValue()));
            return eo;
        })).collect(Collectors.toList());
        this.storageChangeLogDas.insertBatch(logEos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void overrideStock(StockChangeDto dto) {
        List list = dto.getItems();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException("\u8986\u76d6\u5e93\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Mutex mutex = null;
        try {
            mutex = this.redisLockService.lock(UPDATE_STOCK_LOCK_KEY, "", 1, 5, TimeUnit.MINUTES);
            ArrayList keys = new ArrayList();
            ArrayList args = new ArrayList();
            list.forEach(item -> item.getStocks().forEach(stock -> {
                keys.add(StockDsl.getStockCacheKey(item.getWarehouseId(), item.getCargoId(), stock.getStockType()));
                args.add(String.valueOf(stock.getNum().longValue()));
            }));
            this.cacheService.eval(SET_STOCK_LUA, keys, args);
            this.cargoStorageDas.overrideStock(list);
            this.saveStockChangeLog(dto);
            if (mutex == null) return;
        }
        catch (Throwable throwable) {
            if (mutex == null) throw throwable;
            this.redisLockService.unlock(mutex);
            throw throwable;
        }
        this.redisLockService.unlock(mutex);
    }
}

