/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.ChangeLogTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageAdjustMethodEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageAdjustStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustConnReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustCoverCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustCoverReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageAdjustCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageAdjustRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageAdjustService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.StockDsl;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.NOUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustCargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageAdjustDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageAdjustEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageAdjustServiceImpl
implements IStorageAdjustService {
    private static Logger log = LoggerFactory.getLogger(StorageAdjustServiceImpl.class);
    @Resource
    private StorageAdjustDas storageAdjustDas;
    @Resource
    private StorageAdjustCargoDas storageAdjustCargoDas;
    @Resource
    private ChangeLogDas changeLogDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private CargoDas cargoDas;
    @Resource
    private StockDsl stockDsl;

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    @Override
    public PageInfo<StorageAdjustRespDto> queryStorageAdjustByPage(StorageAdjustQueryReqDto dto, Integer pageNum, Integer pageSize) {
        List select;
        StorageAdjustEo eo = new StorageAdjustEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (!StringUtils.isEmpty((CharSequence)dto.getStorageAdjustNo())) {
            sqlFilters.add(SqlFilter.like((String)"storageAdjustNo", (Object)("%" + dto.getStorageAdjustNo() + "%")));
            eo.setStorageAdjustNo(null);
        }
        if (null != dto.getCreateTimeStart()) {
            sqlFilters.add(SqlFilter.ge((String)"createTime", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCreateTimeStart())));
        }
        if (null != dto.getCreateTimeEnd()) {
            sqlFilters.add(SqlFilter.le((String)"createTime", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)dto.getCreateTimeEnd())));
        }
        eo.setSqlFilters(sqlFilters);
        eo.setCreateTime(null);
        eo.setOrderByDesc("createTime");
        PageInfo pageInfo = this.storageAdjustDas.selectPage((BaseEo)eo, pageNum, pageSize);
        PageInfo dtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)pageInfo, StorageAdjustRespDto.class);
        List dtoPageInfoList = dtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfoList) && CollectionUtils.isNotEmpty((Collection)(select = this.warehouseDas.select(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join((Iterable)dtoPageInfoList.stream().map(StorageAdjustRespDto::getWarehouseId).collect(Collectors.toList()), (String)",")).eo())))) {
            Map<Long, String> nameMap = select.stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getName));
            Map<Long, String> codeMap = select.stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getCode));
            dtoPageInfoList.stream().forEach(bean -> {
                bean.setWarehouseName((String)nameMap.get(bean.getWarehouseId()));
                bean.setWarehouseCode((String)codeMap.get(bean.getWarehouseId()));
            });
            dtoPageInfo.setList(dtoPageInfoList);
        }
        return dtoPageInfo;
    }

    @Override
    public StorageAdjustRespDto queryStorageAdjustById(Long id) {
        StorageAdjustEo eo = (StorageAdjustEo)this.storageAdjustDas.selectByPrimaryKey(id);
        if (null != eo) {
            StorageAdjustRespDto storageAdjustRespDto = (StorageAdjustRespDto)EoUtil.eoToDto((BaseEo)eo, StorageAdjustRespDto.class);
            WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(eo.getWarehouseId());
            if (null != warehouseEo) {
                storageAdjustRespDto.setWarehouseName(warehouseEo.getName());
            }
            return storageAdjustRespDto;
        }
        return null;
    }

    @Override
    @Transactional
    public String addStorageAdjust(StorageAdjustReqDto dto) {
        StorageAdjustEo eo = (StorageAdjustEo)EoUtil.dtoToEo((BaseVo)dto, StorageAdjustEo.class);
        String no = NOUtil.generateNo();
        eo.setStorageAdjustNo(no);
        if (StringUtils.isEmpty((CharSequence)eo.getStatus())) {
            eo.setStatus(StorageAdjustStatusEnum.WAIT_COMMIT.getStatus());
        }
        if (StringUtils.isEmpty((CharSequence)eo.getDirection())) {
            eo.setDirection("\u4e2d\u53f0->\u4e2d\u53f0");
        }
        this.storageAdjustDas.insert((BaseEo)eo);
        if (!CollectionUtils.isEmpty((Collection)dto.getAdjustCargoReqDtos())) {
            dto.getAdjustCargoReqDtos().stream().forEach(bean -> bean.setStorageAdjustNo(no));
            this.storageAdjustCargoDas.insertBatch(EoUtil.dtoListToEoList((Collection)dto.getAdjustCargoReqDtos(), StorageAdjustCargoEo.class));
        }
        if (StorageAdjustStatusEnum.AUDIT_PASS.getStatus().equals(eo.getStatus())) {
            this.insertChangeLog(eo.getId());
            if (CollectionUtils.isNotEmpty((Collection)dto.getAdjustCargoReqDtos())) {
                ArrayList cargoStorageEos = new ArrayList();
                dto.getAdjustCargoReqDtos().stream().forEach(bean -> {
                    CargoStorageEo cargoStorageEo = new CargoStorageEo();
                    cargoStorageEo.setCargoId(bean.getCargoId());
                    cargoStorageEo.setAvailable(bean.getAdjustNum());
                    cargoStorageEo.setUpdateTime(new Date());
                    cargoStorageEos.add(cargoStorageEo);
                });
                this.cargoStorageDas.updateList(cargoStorageEos, (List)Lists.newArrayList((Object[])new Long[]{dto.getWarehouseId()}));
            }
        }
        return no;
    }

    @Override
    @Transactional
    public void modifyStorageAdjust(Long id, StorageAdjustReqDto storageAdjustReqDto) {
        StorageAdjustEo eo = (StorageAdjustEo)this.storageAdjustDas.selectByPrimaryKey(id);
        if (null == eo) {
            throw new BizException(InventoryExceptionCode.STORAGE_ADJUST_NOT_EXIST.getCode(), InventoryExceptionCode.STORAGE_ADJUST_NOT_EXIST.getMsg());
        }
        String no = eo.getStorageAdjustNo();
        StorageAdjustEo storageAdjustEo = (StorageAdjustEo)EoUtil.dtoToEo((BaseVo)storageAdjustReqDto, StorageAdjustEo.class);
        storageAdjustEo.setId(id);
        this.storageAdjustDas.updateSelective((BaseEo)storageAdjustEo);
        if (!CollectionUtils.isEmpty((Collection)storageAdjustReqDto.getAdjustCargoReqDtos())) {
            storageAdjustReqDto.getAdjustCargoReqDtos().stream().forEach(bean -> bean.setStorageAdjustNo(no));
            this.storageAdjustCargoDas.deleteByStorageAdjustNo(no);
            this.storageAdjustCargoDas.insertBatch(EoUtil.dtoListToEoList((Collection)storageAdjustReqDto.getAdjustCargoReqDtos(), StorageAdjustCargoEo.class));
        }
    }

    @Override
    public void commitStorageAdjust(Long id) {
        StorageAdjustEo eo = new StorageAdjustEo();
        eo.setId(id);
        eo.setStatus(StorageAdjustStatusEnum.WAIT_AUDIT.getStatus());
        this.storageAdjustDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditStorageAdjust(Long id, StorageAdjustAuditReqDto storageAdjustAuditReqDto) {
        String status = storageAdjustAuditReqDto.getStatus();
        log.debug("\u5e93\u5b58\u8c03\u6574\u65b0\u589e\u7684\u5ba1\u6838\uff1a\u8c03\u6574\u5e93\u5b58\u8868\u7684id\uff1a{}\uff0c\u8c03\u6574\u72b6\u6001\uff1a{}", (Object)id, (Object)status);
        if (!StorageAdjustStatusEnum.AUDIT_PASS.getStatus().equals(status) && !StorageAdjustStatusEnum.AUDIT_NO_PASS.getStatus().equals(status)) {
            throw new BizException(InventoryExceptionCode.STORAGE_ADJUST_AUDIT_STATUS_ERROR.getCode(), InventoryExceptionCode.STORAGE_ADJUST_AUDIT_STATUS_ERROR.getMsg());
        }
        StorageAdjustEo eo = new StorageAdjustEo();
        eo.setId(id);
        eo.setStatus(status);
        this.storageAdjustDas.updateSelective((BaseEo)eo);
        if (StorageAdjustStatusEnum.AUDIT_PASS.getStatus().equals(status)) {
            Map<String, Object> map = this.preStorageAdjustCheckAndSelect(id);
            if (!((Boolean)map.get("flag")).booleanValue()) {
                return;
            }
            StorageAdjustEo dbEo = (StorageAdjustEo)map.get("dbEo");
            List dbCargoEos = (List)map.get("dbCargoEos");
            this.insertChangeLog(dbEo, dbCargoEos);
            this.updateCargoStorageById(dbEo, dbCargoEos);
            MessageVo messageVo = new MessageVo();
            messageVo.setData(dbCargoEos.stream().map(b -> {
                InventoryCountDto dto = new InventoryCountDto();
                dto.setWarehouseId(dbEo.getWarehouseId());
                dto.setCargoId(b.getCargoId());
                dto.setNum(b.getAdjustNum());
                dto.setNo(TradeUtil.generateTradeNo(b.getCargoId().toString()));
                return dto;
            }).collect(Collectors.toList()));
            this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)messageVo);
        }
    }

    @Override
    public PageInfo<StorageAdjustCargoRespDto> queryAdjustCargoByStorageAdjustNo(String no, Integer pageNum, Integer pageSize) {
        StorageAdjustCargoEo eo = new StorageAdjustCargoEo();
        eo.setStorageAdjustNo(no);
        eo.setOrderByDesc("updateTime");
        PageInfo pageInfo = this.storageAdjustCargoDas.selectPage((BaseEo)eo, pageNum, pageSize);
        return EoUtil.eoPageToDtoPage((PageInfo)pageInfo, StorageAdjustCargoRespDto.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String syncStorageAdjust(StorageAdjustConnReqDto dto) {
        ArrayList<String> nos = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)dto.getStorageAdjustReqDtos())) {
            for (StorageAdjustReqDto bean : dto.getStorageAdjustReqDtos()) {
                nos.add(this.addStorageAdjust(bean));
            }
        }
        return StringUtils.join(nos, (String)",");
    }

    private Map<String, Object> preStorageAdjustCheckAndSelect(Long id) {
        log.info("\u5ba1\u6838\u901a\u8fc7\u540e\u67e5\u8be2\u6570\u636e\u5e93\u5e76\u6821\u9a8c\u8868\u8bb0\u5f55\u5b58\u5728\u6027----start");
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        StorageAdjustEo dbEo = (StorageAdjustEo)this.storageAdjustDas.getMapper().findById(StorageAdjustEo.class, id);
        log.debug("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684id\uff1a{}\uff0c\u67e5\u8be2\u5e93\u5b58\u8c03\u6574\u8868\u7684\u8bb0\u5f55\uff1a{}", (Object)id, (Object)JSONObject.toJSONString((Object)dbEo));
        if (Objects.isNull(dbEo)) {
            map.put("flag", false);
            log.info("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684id\uff1a{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5e93\u5b58\u8c03\u6574\u8868\u7684\u8bb0\u5f55---fail\uff0cresult\uff1a{}", (Object)id, (Object)JSONObject.toJSONString(map));
            return map;
        }
        List dbCargoEos = this.storageAdjustCargoDas.selectByStorageAdjustNo(dbEo.getStorageAdjustNo());
        log.debug("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684\u5e93\u5b58\u8c03\u6574\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u5e93\u5b58\u8c03\u6574\u8d27\u54c1\u4fe1\u606f\u8868\u7684\u8bb0\u5f55\uff1a{}", (Object)dbEo.getStorageAdjustNo(), (Object)JSONObject.toJSONString((Object)dbCargoEos));
        if (CollectionUtils.isEmpty((Collection)dbCargoEos)) {
            map.put("flag", false);
            log.info("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684\u5e93\u5b58\u8c03\u6574\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5e93\u5b58\u8c03\u6574\u8d27\u54c1\u4fe1\u606f\u8868\u7684\u8bb0\u5f55---fail\uff0cresult\uff1a{}", (Object)dbEo.getStorageAdjustNo(), (Object)JSONObject.toJSONString(map));
            return map;
        }
        map.put("flag", true);
        map.put("dbEo", dbEo);
        map.put("dbCargoEos", dbCargoEos);
        log.info("\u5ba1\u6838\u901a\u8fc7\u540e\u67e5\u8be2\u6570\u636e\u5e93\u5e76\u6821\u9a8c\u8868\u8bb0\u5f55\u5b58\u5728\u6027----success\uff0cresult\uff1a{}", (Object)JSONObject.toJSONString(map));
        return map;
    }

    private void insertChangeLog(Long id) {
        StorageAdjustEo dbEo = (StorageAdjustEo)this.storageAdjustDas.selectByPrimaryKey(id);
        log.debug("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684id\uff1a{}\uff0c\u67e5\u8be2\u5e93\u5b58\u8c03\u6574\u8868\u7684\u8bb0\u5f55\uff1a{}", (Object)id, (Object)JSONObject.toJSONString((Object)dbEo));
        if (Objects.isNull(dbEo)) {
            log.info("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684id\uff1a{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5e93\u5b58\u8c03\u6574\u8868\u7684\u8bb0\u5f55\uff0c\u65e0\u6cd5\u65b0\u589e\u5e93\u5b58\u6d41\u6c34", (Object)id);
            return;
        }
        List dbCargoEos = this.storageAdjustCargoDas.selectByStorageAdjustNo(dbEo.getStorageAdjustNo());
        log.debug("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684\u5e93\u5b58\u8c03\u6574\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u5e93\u5b58\u8c03\u6574\u8d27\u54c1\u4fe1\u606f\u8868\u7684\u8bb0\u5f55\uff1a{}", (Object)dbEo.getStorageAdjustNo(), (Object)JSONObject.toJSONString((Object)dbCargoEos));
        if (CollectionUtils.isEmpty((Collection)dbCargoEos)) {
            log.info("\u901a\u8fc7\u5e93\u5b58\u8c03\u6574\u8868\u7684\u5e93\u5b58\u8c03\u6574\u5355\u53f7\uff1a{}\uff0c\u67e5\u8be2\u4e0d\u5230\u5e93\u5b58\u8c03\u6574\u8d27\u54c1\u4fe1\u606f\u8868\u7684\u8bb0\u5f55\uff0c\u65e0\u6cd5\u65b0\u589e\u5e93\u5b58\u6d41\u6c34", (Object)dbEo.getStorageAdjustNo());
            return;
        }
        this.insertChangeLog(dbEo, dbCargoEos);
    }

    private void insertChangeLog(StorageAdjustEo eo, List<StorageAdjustCargoEo> cargoEos) {
        log.info("\u5ba1\u6838\u901a\u8fc7\u66f4\u65b0\u5e93\u5b58\u6d41\u6c34----start");
        List changeLogEos = cargoEos.stream().filter(e -> {
            if (Objects.isNull(e.getAdjustNum())) {
                throw new BizException(InventoryExceptionCode.STORAGE_ADJUST_NUM_IS_NULL.getCode(), InventoryExceptionCode.STORAGE_ADJUST_NUM_IS_NULL.getMsg());
            }
            return true;
        }).map(e -> {
            ChangeLogEo changeLogEo = new ChangeLogEo();
            changeLogEo.setRelevanceNo(eo.getStorageAdjustNo());
            changeLogEo.setCargoId(e.getCargoId());
            changeLogEo.setCargoCode(e.getCargoCode());
            changeLogEo.setCargoName(e.getCargoName());
            changeLogEo.setCargoNo(e.getCargoNo());
            changeLogEo.setCargoBarCode(e.getCargoBarCode());
            changeLogEo.setClientId(e.getClientId());
            changeLogEo.setClientName(e.getClientName());
            changeLogEo.setWarehouseId(String.valueOf(eo.getWarehouseId()));
            WarehouseEo dbWarehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(eo.getWarehouseId());
            if (Objects.nonNull(dbWarehouseEo)) {
                changeLogEo.setWarehouseCode(dbWarehouseEo.getCode());
                changeLogEo.setWarehouseName(dbWarehouseEo.getName());
                changeLogEo.setWarehouseSubType(dbWarehouseEo.getSubType());
            }
            changeLogEo.setType(ChangeLogTypeEnum.STORAGE_ADJUST_ORDER.getStatus());
            CargoStorageEo dbCargoStorageEo = this.cargoStorageDas.selectByIds(eo.getWarehouseId(), e.getCargoId());
            if (Objects.nonNull(dbCargoStorageEo)) {
                changeLogEo.setOldNum(dbCargoStorageEo.getAvailable());
                changeLogEo.setChangeNum(e.getAdjustNum());
                BigDecimal newNum = dbCargoStorageEo.getAvailable().add(e.getAdjustNum());
                changeLogEo.setNewNum(newNum.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : newNum);
            }
            return changeLogEo;
        }).collect(Collectors.toList());
        int batch = this.changeLogDas.insertBatch(changeLogEos);
        log.info("\u5ba1\u6838\u901a\u8fc7\u540e\u65b0\u589e\u5e93\u5b58\u6d41\u6c34----success\uff1a\u6210\u529f\u63d2\u5165\u5e93\u5b58\u6d41\u6c34\u6570\u91cf\uff1a{}", (Object)batch);
    }

    private void updateCargoStorageById(StorageAdjustEo eo, List<StorageAdjustCargoEo> cargoEos) {
        log.info("\u5ba1\u6838\u901a\u8fc7\u66f4\u65b0\u8d27\u54c1\u5e93\u5b58----start");
        List cargoStorageEos = cargoEos.stream().map(e -> {
            CargoStorageEo cargoStorageEo = new CargoStorageEo();
            cargoStorageEo.setCargoId(e.getCargoId());
            cargoStorageEo.setAvailable(e.getAdjustNum());
            cargoStorageEo.setUpdateTime(new Date());
            return cargoStorageEo;
        }).collect(Collectors.toList());
        this.cargoStorageDas.updateList(cargoStorageEos, (List)Lists.newArrayList((Object[])new Long[]{eo.getWarehouseId()}));
        log.info("\u5ba1\u6838\u901a\u8fc7\u66f4\u65b0\u8d27\u54c1\u5e93\u5b58----success");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void storageAdjustCover(StorageAdjustCoverReqDto reqDto) {
        List cargoStorageCoverLines = reqDto.getCargoStorageCoverCargos();
        if (CollectionUtils.isEmpty((Collection)cargoStorageCoverLines)) {
            throw new BizException("\u8986\u76d6\u8d27\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setCode(reqDto.getWarehouseCode());
        warehouseEo.setId(reqDto.getWarehouseId());
        warehouseEo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
        if (warehouseEo == null) {
            throw new BizException(InventoryExceptionCode.WARE_HOUSE_NULL.getCode(), InventoryExceptionCode.WARE_HOUSE_NULL.getMsg());
        }
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long instanceId = this.getInstanceId(reqDto.getInstanceId());
        reqDto.setTenantId(tenantId);
        reqDto.setInstanceId(instanceId);
        Long warehouseId = warehouseEo.getId();
        String no = NOUtil.generateNo();
        StorageAdjustEo eo = this.insertStorageAdjust(no, warehouseId, tenantId, instanceId);
        ArrayList<StockChangeDto.StockChangeItemDto> stockChangeItemDtos = new ArrayList<StockChangeDto.StockChangeItemDto>();
        this.insertStorageAdjustCargos(cargoStorageCoverLines, warehouseId, no, stockChangeItemDtos, tenantId, instanceId);
        Collection<StockChangeDto.StockChangeItemDto> changeItems = stockChangeItemDtos.stream().collect(Collectors.toMap(e -> e.getWarehouseId() + ":" + e.getCargoId(), e -> e, (e1, e2) -> {
            ArrayList stocks = new ArrayList();
            stocks.addAll(e1.getStocks());
            stocks.addAll(e2.getStocks());
            return new StockChangeDto.StockChangeItemDto(e1.getWarehouseId(), e2.getCargoId(), e2.getBatch(), stocks, e2.getVersion());
        })).values();
        StockChangeDto coverDto = new StockChangeDto();
        coverDto.setChangeType("STOCK_OVERRIDE");
        coverDto.setBizType("STOCK_ADJUST");
        coverDto.setOrderNo(eo.getId().toString());
        coverDto.setItems(new ArrayList<StockChangeDto.StockChangeItemDto>(changeItems));
        this.stockDsl.overrideStock(coverDto);
    }

    private StorageAdjustEo insertStorageAdjust(String no, Long warehouseId, Long tenantId, Long instanceId) {
        StorageAdjustEo eo = new StorageAdjustEo();
        eo.setWarehouseId(warehouseId);
        eo.setStatus(StorageAdjustStatusEnum.AUDIT_PASS.getStatus());
        eo.setAdjustType("COMMON_ADJUST");
        eo.setAdjustMethod(StorageAdjustMethodEnum.COVER.getcode());
        eo.setRemark("\u5e93\u5b58\u8986\u76d6");
        eo.setDirection("\u4e2d\u53f0->\u4e2d\u53f0");
        eo.setStorageAdjustNo(no);
        if (StringUtils.isEmpty((CharSequence)eo.getDirection())) {
            eo.setDirection("\u4e2d\u53f0->\u4e2d\u53f0");
        }
        eo.setTenantId(tenantId);
        eo.setInstanceId(instanceId);
        this.storageAdjustDas.insert((BaseEo)eo);
        return eo;
    }

    private void insertStorageAdjustCargos(List<StorageAdjustCoverCargoReqDto> cargoStorageCoverLines, Long warehouseId, String orderNo, List<StockChangeDto.StockChangeItemDto> stockChangeItemDtos, Long tenantId, Long instanceId) {
        List storageAdjustCargoEos = cargoStorageCoverLines.stream().map(e -> {
            CargoEo cargoEo = new CargoEo();
            cargoEo.setId(e.getCargoId());
            cargoEo.setCode(e.getCargoCode());
            cargoEo = (CargoEo)this.cargoDas.selectOne((BaseEo)cargoEo);
            if (cargoEo == null) {
                throw new BizException(InventoryExceptionCode.CARGO_NOT_EXIST.getCode(), InventoryExceptionCode.CARGO_NOT_EXIST.getCode());
            }
            StorageAdjustCargoEo adjustCargoEo = new StorageAdjustCargoEo();
            adjustCargoEo.setStorageAdjustNo(orderNo);
            adjustCargoEo.setCargoId(cargoEo.getId());
            adjustCargoEo.setCargoCode(cargoEo.getCode());
            adjustCargoEo.setCargoName(cargoEo.getName());
            adjustCargoEo.setCargoNo(cargoEo.getArtNo());
            adjustCargoEo.setCargoBarCode(cargoEo.getBrandCode());
            adjustCargoEo.setAdjustNum(e.getNum());
            adjustCargoEo.setStockType(e.getStockType());
            adjustCargoEo.setTenantId(tenantId);
            adjustCargoEo.setInstanceId(instanceId);
            stockChangeItemDtos.add(new StockChangeDto.StockChangeItemDto(warehouseId, e.getCargoId(), e.getBatch(), Collections.singletonList(new StockChangeDto.Stock(e.getStockType(), e.getNum())), e.getVersion()));
            return adjustCargoEo;
        }).collect(Collectors.toList());
        this.storageAdjustCargoDas.insertBatch(storageAdjustCargoEos);
    }
}

