/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageObjectQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageObjectReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageObjectRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageObjectService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RuleDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageObjectDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RuleEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageObjectEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class StorageObjectServiceImpl
implements IStorageObjectService {
    @Resource
    private RuleDas ruleDas;
    @Resource
    private StorageObjectDas storageObjectDas;

    @Override
    public PageInfo<StorageObjectRespDto> queryStorageObjectByPage(StorageObjectQueryReqDto dto, Integer pageNum, Integer pageSize) {
        PageInfo storageObjectRespDtoPageInfo = new PageInfo();
        ArrayList storageObjectRespDtos = new ArrayList();
        StorageObjectEo eo = new StorageObjectEo();
        ArrayList<SqlFilter> sqlFilterList = eo.getSqlFilters();
        if (null == sqlFilterList) {
            sqlFilterList = new ArrayList<SqlFilter>();
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getStorageObjName())) {
            sqlFilterList.add(SqlFilter.like((String)"storageObjName", (Object)("%" + dto.getStorageObjName() + "%")));
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getModifyStartTime())) {
            sqlFilterList.add(SqlFilter.ge((String)"updateTime", (Object)(dto.getModifyStartTime() + " 00:00:00")));
        }
        if (null != dto && !StringUtils.isEmpty((Object)dto.getModifyEndTime())) {
            sqlFilterList.add(SqlFilter.le((String)"updateTime", (Object)(dto.getModifyEndTime() + " 23:59:59")));
        }
        eo.setSqlFilters(sqlFilterList);
        eo.setOrderByDesc("updateTime");
        PageInfo storageObjectEoPageInfo = this.storageObjectDas.selectPage((BaseEo)eo, pageNum, pageSize);
        if (null == storageObjectEoPageInfo) {
            return storageObjectRespDtoPageInfo;
        }
        CubeBeanUtils.copyProperties((Object)storageObjectRespDtoPageInfo, (Object)storageObjectEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)storageObjectEoPageInfo.getList(), storageObjectRespDtos, StorageObjectRespDto.class);
        storageObjectRespDtoPageInfo.setList(storageObjectRespDtos);
        return storageObjectRespDtoPageInfo;
    }

    @Override
    public StorageObjectRespDto queryStorageObjectById(Long id) {
        StorageObjectRespDto dto = new StorageObjectRespDto();
        StorageObjectEo eo = (StorageObjectEo)this.storageObjectDas.selectByPrimaryKey(id);
        if (null == eo) {
            throw new BizException(InventoryExceptionCode.STORAGE_OBJECT_EMPTY_ERROR.getCode(), InventoryExceptionCode.STORAGE_OBJECT_EMPTY_ERROR.getMsg());
        }
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        return dto;
    }

    @Override
    @Transactional
    public void saveStorageObject(StorageObjectReqDto dto) {
        if (null == dto.getId()) {
            if (this.checkStorageObjectName(dto.getStorageObjName()).booleanValue()) {
                throw new BizException(InventoryExceptionCode.STORAGE_OBJECT_NAME_UNIQUE_ERROR.getCode(), InventoryExceptionCode.STORAGE_OBJECT_NAME_UNIQUE_ERROR.getMsg());
            }
            this.addStorageObject(dto);
        } else {
            Assert.isTrue(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)this.ruleDas.select(SqlFilterBuilder.create(RuleEo.class).eq("in_object_id", (Object)dto.getId()).eo())), "\u5df2\u5173\u8054\u7684\u5bf9\u8c61\u4e0d\u80fd\u4fee\u6539");
            StorageObjectEo eo = (StorageObjectEo)this.storageObjectDas.selectByPrimaryKey(dto.getId());
            if (null == eo) {
                throw new BizException(InventoryExceptionCode.STORAGE_OBJECT_EMPTY_ERROR.getCode(), InventoryExceptionCode.STORAGE_OBJECT_EMPTY_ERROR.getMsg());
            }
            if (!dto.getStorageObjName().equals(eo.getStorageObjName()) && this.checkStorageObjectName(dto.getStorageObjName()).booleanValue()) {
                throw new BizException(InventoryExceptionCode.STORAGE_OBJECT_NAME_UNIQUE_ERROR.getCode(), InventoryExceptionCode.STORAGE_OBJECT_NAME_UNIQUE_ERROR.getMsg());
            }
            this.updateStorageObject(dto);
        }
    }

    private void addStorageObject(StorageObjectReqDto dto) {
        StorageObjectEo eo = new StorageObjectEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.storageObjectDas.insert((BaseEo)eo);
    }

    private void updateStorageObject(StorageObjectReqDto dto) {
        StorageObjectEo eo = new StorageObjectEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.storageObjectDas.updateSelective((BaseEo)eo);
    }

    private Boolean checkStorageObjectName(String storageObjectName) {
        StorageObjectEo eo = new StorageObjectEo();
        eo.setStorageObjName(storageObjectName);
        return !CollectionUtils.isEmpty((Collection)this.storageObjectDas.select((BaseEo)eo));
    }
}

