/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class StorageOrderDetailServiceImpl
implements IStorageOrderDetailService {
    @Resource
    private StorageOrderDetailDas storageOrderDetailDas;

    @Override
    public List<StorageOrderDetailEo> queryByOrderId(Long orderId) {
        Objects.requireNonNull(orderId);
        StorageOrderDetailEo detailEo = new StorageOrderDetailEo();
        detailEo.setOrderId(orderId);
        return this.storageOrderDetailDas.select((BaseEo)detailEo);
    }

    @Override
    public List<StorageOrderDetailEo> queryByPackageId(Long packageId) {
        Assert.notNull((Object)packageId, (String)"packageId is not null");
        StorageOrderDetailEo detailEo = new StorageOrderDetailEo();
        detailEo.setPackageId(packageId);
        return this.storageOrderDetailDas.select((BaseEo)detailEo);
    }

    @Override
    public void modifyStatusByPackageId(Long packageId, String status) {
        Assert.notNull((Object)packageId, (String)"packageId is not null");
        Assert.notNull((Object)status, (String)"status is not null");
        List<StorageOrderDetailEo> storageOrderDetailEos = this.queryByPackageId(packageId);
        if (CollectionUtils.isNotEmpty(storageOrderDetailEos)) {
            for (StorageOrderDetailEo storageOrderDetailEo : storageOrderDetailEos) {
                this.modifyStatusById(storageOrderDetailEo.getId(), status);
            }
        }
    }

    @Override
    public void modifyStatusById(Long id, String status) {
        Assert.notNull((Object)id, (String)"id is not null");
        Assert.notNull((Object)status, (String)"status is not null");
        StorageOrderDetailEo detailEo = new StorageOrderDetailEo();
        detailEo.setId(id);
        detailEo.setStatus(status);
        this.storageOrderDetailDas.updateSelective((BaseEo)detailEo);
    }
}

