/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.InStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.OutStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.PackageStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageCategoryEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageChangeStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderCreateDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderPageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.StorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.DeliverStorageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.InStorageCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.InStorageInReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.OutStorageCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.OutStorageOutReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageCheckRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.EoUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.producer.InOrOutStorageProducer;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.vo.InStorageMessageVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ITransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.CargoStorageServiceImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.StockDsl;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.OrderDeliveryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.AddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OrderDeliveryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageOrderServiceImpl
implements IStorageOrderService {
    @Resource
    private StorageOrderDas storageOrderDas;
    @Resource
    private StorageOrderDetailDas storageOrderDetailDas;
    @Resource
    private ICargoStorageService cargoStorageService;
    @Resource
    private IPackageService packageService;
    @Resource
    private IWarehouseService wareHouseService;
    @Resource
    private ICargoService cargoService;
    @Resource
    private CargoDas cargoDas;
    @Resource
    private AddressDas addressDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private InOrOutStorageProducer inOrOutStorageProducer;
    @Resource
    private ITransferOrderService transferOrderService;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private OrderDeliveryDas orderDeliveryDas;
    @Resource
    private StockDsl stockDsl;
    @Resource
    private CargoStorageServiceImpl cargoStorageServiceImpl;

    private String getUsername() {
        return ServiceContext.getContext().getRequestUserCode();
    }

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addStorageOrder(StorageOrderCreateDto dto) {
        if (dto == null || dto.getStorageOrderReqDto() == null || CollectionUtils.isEmpty((Collection)dto.getStorageOrderDetailReqDtoList())) {
            throw new InventoryBusinessRuntimeException("\u8d27\u54c1\u5fc5\u9009");
        }
        StorageOrderReqDto storageOrderReqDto = dto.getStorageOrderReqDto();
        String warehouseCode = storageOrderReqDto.getWarehouseCode();
        ArrayList<String> warehousecodeList = new ArrayList<String>();
        warehousecodeList.add(warehouseCode);
        List<WarehouseEo> warehouseEoList = this.cargoStorageServiceImpl.queryWarehouseCodeById(warehousecodeList);
        if (CollectionUtils.isNotEmpty(warehouseEoList)) {
            WarehouseEo warehouseEo = warehouseEoList.get(0);
            dto.getStorageOrderReqDto().setWarehouseId(warehouseEo.getId());
        }
        WarehouseRespDto warehouseRespDto = null;
        Long warehouseId = dto.getStorageOrderReqDto().getWarehouseId();
        warehouseRespDto = Objects.nonNull(warehouseId) ? this.wareHouseService.queryById(warehouseId) : this.wareHouseService.queryByCode(dto.getStorageOrderReqDto().getWarehouseCode());
        if (warehouseRespDto == null) {
            throw new BizException(InventoryExceptionCode.WARE_HOUSE_NULL.getCode(), InventoryExceptionCode.WARE_HOUSE_NULL.getMsg());
        }
        warehouseId = warehouseRespDto.getId();
        String status = warehouseRespDto.getStatus();
        if (!WarehouseStatusEnum.NORMAL.getCode().equals(status)) {
            throw new BizException(InventoryExceptionCode.WARE_HOUSE_DISABLED.getCode(), InventoryExceptionCode.WARE_HOUSE_DISABLED.getMsg());
        }
        StorageOrderReqDto orderReqDto = dto.getStorageOrderReqDto();
        orderReqDto.setWarehouseId(warehouseRespDto.getId());
        orderReqDto.setWarehouseId(warehouseRespDto.getId());
        Long tenantId = this.getTenantId(orderReqDto.getTenantId());
        Long instanceId = this.getInstanceId(orderReqDto.getInstanceId());
        List detailList = dto.getStorageOrderDetailReqDtoList();
        StorageOrderEo orderEo = new StorageOrderEo();
        long id = IdGenrator.getDistributedId();
        orderEo.setId(Long.valueOf(id));
        DtoHelper.dto2Eo((BaseVo)orderReqDto, (BaseEo)orderEo);
        if (dto.getSkipAudit().booleanValue()) {
            if (orderReqDto.getCategory().equals(StorageCategoryEnum.CATEGORY_OUT.getCategory())) {
                orderEo.setStatus(OutStorageOrderStatusEnum.FINISH.getStatus());
            } else {
                orderEo.setStatus(InStorageOrderStatusEnum.FINISH.getStatus());
            }
        } else if (null == orderEo.getStatus()) {
            orderEo.setStatus(InStorageOrderStatusEnum.WAIT_COMMIT.getStatus());
        }
        if (StringUtils.isEmpty((CharSequence)orderReqDto.getOrderNo())) {
            orderEo.setOrderNo(id + "");
        }
        orderEo.setTenantId(tenantId);
        orderEo.setInstanceId(instanceId);
        this.storageOrderDas.insert((BaseEo)orderEo);
        if (null != dto.getAddressReqDto()) {
            AddressEo addressEo = (AddressEo)EoUtil.dtoToEo((BaseVo)dto.getAddressReqDto(), AddressEo.class);
            addressEo.setRelatedId(orderEo.getId().toString());
            this.addressDas.insert((BaseEo)addressEo);
        }
        for (StorageOrderDetailReqDto detailReqDto : detailList) {
            if (detailReqDto.getNum() == null) {
                throw new BizException(InventoryExceptionCode.NUM_NOT_NULL.getCode(), InventoryExceptionCode.NUM_NOT_NULL.getMsg());
            }
            CargoEo cargoQuery = new CargoEo();
            cargoQuery.setCode(detailReqDto.getCargoCode());
            cargoQuery.setId(detailReqDto.getCargoId());
            CargoEo cargoEo = (CargoEo)this.cargoDas.selectOne((BaseEo)cargoQuery);
            Assert.notNull(cargoEo, "\u8d27\u54c1\u4e0d\u5b58\u5728");
            detailReqDto.setCargoId(cargoEo.getId());
            detailReqDto.setWarehouseId(warehouseId);
            detailReqDto.setCargoCode(cargoEo.getCode());
            detailReqDto.setTenantId(tenantId);
            detailReqDto.setInstanceId(instanceId);
            detailReqDto.setOrderId(orderEo.getId());
            detailReqDto.setOrderNo(orderEo.getOrderNo());
        }
        this.saveDetailBatch(orderEo, detailList);
        if (dto.getSkipAudit().booleanValue()) {
            List<StorageOrderDetailEo> orderDetailEos = detailList.stream().map(e -> {
                StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
                BeanUtils.copyProperties((Object)e, (Object)storageOrderDetailEo);
                return storageOrderDetailEo;
            }).collect(Collectors.toList());
            this.updateCargoStorage(orderEo, orderDetailEos, dto.getCheckStock(), dto.getConfirmPreempt());
        }
        return orderEo.getId();
    }

    @Override
    @Transactional
    public void modifyStorageOrder(StorageOrderCreateDto dto) {
        if (dto == null || dto.getStorageOrderReqDto() == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        StorageOrderReqDto storageOrderReqDto = dto.getStorageOrderReqDto();
        List detailList = dto.getStorageOrderDetailReqDtoList();
        StorageOrderEo storageOrderEo = (StorageOrderEo)this.storageOrderDas.selectByPrimaryKey(storageOrderReqDto.getId());
        Assert.notNull(storageOrderEo, "\u51fa\u5165\u5e93\u5355\u636e\u4e0d\u5b58\u5728");
        StorageOrderEo orderEo = (StorageOrderEo)EoUtil.dtoToEo((BaseVo)storageOrderReqDto, StorageOrderEo.class);
        this.storageOrderDas.updateSelective((BaseEo)orderEo);
        if (null != dto.getAddressReqDto()) {
            AddressEo addressEo = (AddressEo)EoUtil.dtoToEo((BaseVo)dto.getAddressReqDto(), AddressEo.class);
            addressEo.setSqlFilters(SqlFilterBuilder.create().eq("related_id", (Object)orderEo.getId().toString()).filters());
            addressEo.setId(null);
            this.addressDas.updateSelectiveSqlFilter((BaseEo)addressEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (StorageOrderDetailReqDto detailReqDto : detailList) {
                if (detailReqDto.getNum() == null) {
                    throw new BizException(InventoryExceptionCode.NUM_NOT_NULL.getCode(), InventoryExceptionCode.NUM_NOT_NULL.getMsg());
                }
                CargoRespDto cargoRespDto = this.cargoService.getById(detailReqDto.getCargoId());
                Assert.notNull(cargoRespDto, "\u8d27\u54c1\u4e0d\u5b58\u5728");
                detailReqDto.setInstanceId(orderEo.getInstanceId());
                detailReqDto.setTenantId(orderEo.getTenantId());
                detailReqDto.setOrderId(orderEo.getId());
                detailReqDto.setOrderNo(orderEo.getOrderNo());
            }
            this.saveDetailBatch(orderEo, detailList);
        }
        if (Objects.nonNull(orderEo.getStatus()) && !orderEo.getStatus().equals(storageOrderEo.getStatus()) && InStorageOrderStatusEnum.FINISH.getStatus().equals(orderEo.getStatus())) {
            InStorageMessageVo inStorageMessageVo = new InStorageMessageVo();
            inStorageMessageVo.setStorageNo(orderEo.getId() + "");
            inStorageMessageVo.setBusinessId(storageOrderEo.getBusinessId());
            inStorageMessageVo.setStatus(orderEo.getStatus() + "");
            this.inOrOutStorageProducer.sendInStorageMessage(inStorageMessageVo);
        }
    }

    @Override
    public PageInfo<StorageOrderRespDto> queryByPage(StorageOrderPageReqDto storageOrderPageReqDto, Integer pageNum, Integer pageSize) {
        List select;
        StorageOrderEo queryEo = (StorageOrderEo)EoUtil.dtoToEo((BaseVo)storageOrderPageReqDto, StorageOrderEo.class);
        ArrayList sqlFilters = new ArrayList(4);
        if (StringUtils.isNotEmpty((CharSequence)storageOrderPageReqDto.getOrderSrc())) {
            sqlFilters.addAll(SqlFilterBuilder.create(StorageOrderEo.class).like("order_src", (Object)("%" + storageOrderPageReqDto.getOrderSrc() + "%")).filters());
            queryEo.setOrderSrc(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)storageOrderPageReqDto.getOrderNo())) {
            sqlFilters.addAll(SqlFilterBuilder.create(StorageOrderEo.class).like("order_no", (Object)("%" + storageOrderPageReqDto.getOrderNo() + "%")).filters());
            queryEo.setOrderNo(null);
        }
        if (null != storageOrderPageReqDto.getBusinessId()) {
            sqlFilters.addAll(SqlFilterBuilder.create(StorageOrderEo.class).like("business_id", (Object)("%" + storageOrderPageReqDto.getBusinessId() + "%")).filters());
            queryEo.setBusinessId(null);
        }
        if (null != storageOrderPageReqDto.getOrderSrcId()) {
            sqlFilters.addAll(SqlFilterBuilder.create(StorageOrderEo.class).like("order_src_id", (Object)("%" + storageOrderPageReqDto.getOrderSrcId() + "%")).filters());
            queryEo.setOrderSrcId(null);
        }
        if (null != storageOrderPageReqDto.getCreateStartTime() && null != storageOrderPageReqDto.getCreateEndTime()) {
            sqlFilters.addAll(SqlFilterBuilder.create(StorageOrderEo.class).ge("create_time", (Object)storageOrderPageReqDto.getCreateStartTime()).le("update_time", (Object)storageOrderPageReqDto.getCreateEndTime()).filters());
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            queryEo.setSqlFilters(sqlFilters);
        }
        queryEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.storageOrderDas.selectPage((BaseEo)queryEo, pageNum, pageSize);
        PageInfo storageOrderRespDtoPageInfo = EoUtil.eoPageToDtoPage((PageInfo)eoPageInfo, StorageOrderRespDto.class);
        List dtoPageInfoList = storageOrderRespDtoPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)dtoPageInfoList) && CollectionUtils.isNotEmpty((Collection)(select = this.warehouseDas.select(SqlFilterBuilder.create(WarehouseEo.class).in("id", (Object)StringUtils.join((Iterable)dtoPageInfoList.stream().map(StorageOrderRespDto::getWarehouseId).collect(Collectors.toList()), (String)",")).eo())))) {
            Map<Long, String> nameMap = select.stream().collect(Collectors.toMap(BaseEo::getId, StdWarehouseEo::getName));
            dtoPageInfoList.forEach(d -> d.setWarehouseName((String)nameMap.get(d.getWarehouseId())));
            storageOrderRespDtoPageInfo.setList(dtoPageInfoList);
        }
        return storageOrderRespDtoPageInfo;
    }

    @Override
    @Transactional
    public void auditStorageOrder(Long id, Integer status, String name) {
        if (!Arrays.asList(OutStorageOrderStatusEnum.WAIT_OUT.getStatus(), OutStorageOrderStatusEnum.AUDIT_NO_PASS.getStatus(), InStorageOrderStatusEnum.WAIT_IN.getStatus(), InStorageOrderStatusEnum.AUDIT_NO_PASS.getStatus()).contains(status)) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5f85\u51fa\u5e93,\u5f85\u5165\u5e93,\u5ba1\u6838\u4e0d\u901a\u8fc7");
        }
        StorageOrderEo orderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)id);
        if (orderEo == null) {
            throw new BizException("id\u4e3a" + id + "\u7684\u51fa\u5165\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        if (!OutStorageOrderStatusEnum.WAIT_AUDIT.getStatus().equals(orderEo.getStatus())) {
            throw new BizException("id\u4e3a" + id + "\u7684\u51fa\u5165\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        orderEo.setAuditPerson(this.getUsername());
        orderEo.setAuditTime(new Date());
        orderEo.setStatus(status);
        this.storageOrderDas.updateSelective((BaseEo)orderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelOutStorageOrder(OutStorageCancelReqDto reqDto) {
        if (!OutStorageOrderStatusEnum.CANCEL.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5df2\u53d6\u6d88");
        }
        StorageOrderEo orderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)reqDto.getId());
        if (orderEo == null) {
            throw new BizException("id\u4e3a" + reqDto.getId() + "\u7684\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        StorageOrderEo orderDbEo = new StorageOrderEo();
        orderDbEo.setId(reqDto.getId());
        orderDbEo.setStatus(reqDto.getStatus());
        this.storageOrderDas.updateSelective((BaseEo)orderDbEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void outStorageOrder(OutStorageOutReqDto reqDto) {
        if (!OutStorageOrderStatusEnum.WAIT_DELIVER.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5f85\u53d1\u8d27");
        }
        StorageOrderEo orderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)reqDto.getId());
        if (orderEo == null) {
            throw new BizException("id\u4e3a" + reqDto.getId() + "\u7684\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        if (!OutStorageOrderStatusEnum.WAIT_OUT.getStatus().equals(orderEo.getStatus())) {
            throw new BizException("\u53ea\u6709\u5f85\u51fa\u5e93\u72b6\u6001\u624d\u80fd\u505a\u51fa\u5e93\u64cd\u4f5c");
        }
        orderEo.setAuditPerson(reqDto.getName());
        orderEo.setAuditTime(new Date());
        orderEo.setStatus(reqDto.getStatus());
        this.storageOrderDas.updateSelective((BaseEo)orderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<StorageCheckRespDto> deliverStorageOrder(DeliverStorageReqDto reqDto) {
        List<StorageCheckRespDto> logicResult;
        if (!OutStorageOrderStatusEnum.FINISH.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5f85\u53d1\u8d27");
        }
        StorageOrderEo orderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)reqDto.getId());
        if (orderEo == null) {
            throw new BizException("id\u4e3a" + reqDto.getId() + "\u7684\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        if (!OutStorageOrderStatusEnum.WAIT_DELIVER.getStatus().equals(orderEo.getStatus())) {
            throw new BizException("\u53ea\u6709\u5f85\u53d1\u8d27\u72b6\u6001\u624d\u80fd\u505a\u53d1\u8d27\u64cd\u4f5c");
        }
        StorageOrderDetailEo orderDetailEoQuery = new StorageOrderDetailEo();
        orderDetailEoQuery.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)"order_id", (Object)orderEo.getId())));
        List detailList = this.storageOrderDetailDas.select((BaseEo)orderDetailEoQuery, Integer.valueOf(1), Integer.valueOf(10000));
        List<StorageCheckRespDto> result = this.checkInventoryAndReturn(detailList, orderEo.getWarehouseId());
        if (StorageOrderTypeEnum.TRANSFER.getCode().equals(orderEo.getType()) && CollectionUtils.isNotEmpty(logicResult = this.transferOrderService.outTransferOrderCheck(orderEo.getOrderSrcId()))) {
            result.addAll(logicResult);
        }
        if (CollectionUtils.isNotEmpty(result)) {
            return result;
        }
        orderEo.setAuditPerson(reqDto.getName());
        orderEo.setAuditTime(new Date());
        orderEo.setStatus(reqDto.getStatus());
        this.storageOrderDas.updateSelective((BaseEo)orderEo);
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)reqDto.getAddressReqDto(), (BaseEo)addressEo);
        addressEo.setSqlFilters(SqlFilterBuilder.create().eq("related_id", (Object)orderEo.getId().toString()).filters());
        addressEo.setId(null);
        this.addressDas.updateSelectiveSqlFilter((BaseEo)addressEo);
        if (StorageOrderTypeEnum.TRANSFER.getCode().equals(orderEo.getType())) {
            this.transferOrderService.outTransferOrder(orderEo.getOrderSrcId());
        }
        this.updateCargoStorage(orderEo, detailList);
        return new ArrayList<StorageCheckRespDto>();
    }

    private List<StorageCheckRespDto> checkInventoryAndReturn(List<StorageOrderDetailEo> data, Long warehouseId) {
        if (data.size() == 0) {
            throw new BizException("\u5ba1\u6279\u7684\u8d27\u54c1\u4e3a\u7a7a");
        }
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(warehouseId);
        if (warehouseEo == null) {
            throw new BizException("id\u4e3a" + warehouseId + "\u7684\u4ed3\u5e93\u4e0d\u5b58\u5728");
        }
        List cargoIds = data.stream().map(StdStorageOrderDetailEo::getCargoId).collect(Collectors.toList());
        CargoStorageEo cargoStorageQuery = new CargoStorageEo();
        cargoStorageQuery.setWarehouseId(warehouseId);
        cargoStorageQuery.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"cargo_id", cargoIds)));
        Map<Long, CargoStorageEo> cargoStorageMap = this.cargoStorageDas.select((BaseEo)cargoStorageQuery).stream().collect(Collectors.toMap(StdCargoStorageEo::getCargoId, e -> e));
        ArrayList<StorageCheckRespDto> notEnough = new ArrayList<StorageCheckRespDto>(data.size());
        data.forEach(e -> {
            CargoStorageEo cargoStorageEo = (CargoStorageEo)cargoStorageMap.get(e.getCargoId());
            BigDecimal num = new BigDecimal(e.getNum());
            if (cargoStorageEo != null && cargoStorageEo.getAvailable().compareTo(num) < 0) {
                StorageCheckRespDto respDto = new StorageCheckRespDto();
                respDto.setWarehouseName(warehouseEo.getName());
                respDto.setCargoCode(cargoStorageEo.getCargoCode());
                respDto.setCargoName(cargoStorageEo.getCargoName());
                respDto.setAvailable(cargoStorageEo.getAvailable());
                respDto.setNum(num);
                notEnough.add(respDto);
            }
        });
        return notEnough;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelInStorageOrder(InStorageCancelReqDto reqDto) {
        if (!InStorageOrderStatusEnum.CANCEL.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5df2\u53d6\u6d88");
        }
        StorageOrderEo orderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)reqDto.getId());
        if (orderEo == null) {
            throw new BizException("id\u4e3a" + reqDto.getId() + "\u7684\u5165\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        StorageOrderEo orderDbEo = new StorageOrderEo();
        orderDbEo.setId(reqDto.getId());
        orderDbEo.setStatus(reqDto.getStatus());
        this.storageOrderDas.updateSelective((BaseEo)orderDbEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void inStorageOrder(InStorageInReqDto reqDto) {
        List detailList;
        StorageOrderDetailEo orderDetailEoQuery;
        if (!InStorageOrderStatusEnum.FINISH.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5df2\u5165\u5e93");
        }
        StorageOrderEo orderEo = (StorageOrderEo)this.storageOrderDas.getMapper().selectById((Serializable)reqDto.getId());
        if (orderEo == null) {
            throw new BizException("id\u4e3a" + reqDto.getId() + "\u7684\u5165\u5e93\u5355\u4e0d\u5b58\u5728");
        }
        if (!InStorageOrderStatusEnum.WAIT_IN.getStatus().equals(orderEo.getStatus())) {
            throw new BizException("\u53ea\u6709\u5f85\u5165\u5e93\u72b6\u6001\u624d\u80fd\u505a\u5165\u5e93\u64cd\u4f5c");
        }
        orderEo.setStatus(reqDto.getStatus());
        this.storageOrderDas.updateSelective((BaseEo)orderEo);
        if (StorageOrderTypeEnum.TRANSFER.getCode().equals(orderEo.getType())) {
            this.transferOrderService.inTransferOrder(reqDto, orderEo);
            orderDetailEoQuery = new StorageOrderDetailEo();
            orderDetailEoQuery.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)"order_id", (Object)orderEo.getId())));
            detailList = this.storageOrderDetailDas.select((BaseEo)orderDetailEoQuery, Integer.valueOf(1), Integer.valueOf(10000));
            for (StorageOrderDetailEo eo : detailList) {
                eo.setNum(eo.getActualNum());
            }
        } else {
            orderDetailEoQuery = new StorageOrderDetailEo();
            orderDetailEoQuery.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)"order_id", (Object)orderEo.getId())));
            detailList = this.storageOrderDetailDas.select((BaseEo)orderDetailEoQuery, Integer.valueOf(1), Integer.valueOf(10000));
        }
        this.updateCargoStorage(orderEo, detailList);
        InStorageMessageVo inStorageMessageVo = new InStorageMessageVo();
        inStorageMessageVo.setStorageNo(orderEo.getId() + "");
        inStorageMessageVo.setBusinessId(orderEo.getBusinessId());
        inStorageMessageVo.setStatus(reqDto.getStatus() + "");
        this.inOrOutStorageProducer.sendInStorageMessage(inStorageMessageVo);
    }

    @Override
    @Transactional
    public Long addStorageOrderByPackageAndCargo(List<PackageDetailDto> packageDetailDtoList) {
        if (CollectionUtils.isEmpty(packageDetailDtoList)) {
            throw new BizException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
        List<Long> packageIds = packageDetailDtoList.stream().map(PackageDetailDto::getPackageId).collect(Collectors.toList());
        List packageDtos = this.packageService.queryByPackageIds(packageIds).getPackageDtos();
        Long deliveryOrderId = ((PackageDto)packageDtos.get(0)).getDeliveryOrderId();
        OrderDeliveryEo deliveryOrderEo = (OrderDeliveryEo)this.orderDeliveryDas.selectByPrimaryKey(deliveryOrderId);
        if (deliveryOrderEo == null) {
            throw new BizException("id\u4e3a" + deliveryOrderId + "\u7684\u53d1\u8d27\u5355\u4e0d\u5b58\u5728");
        }
        String warehouseCode = deliveryOrderEo.getWarehouseCode();
        WarehouseEo warehouseEo = this.warehouseDas.selectByCode(warehouseCode);
        if (warehouseEo == null) {
            throw new BizException("\u7f16\u7801code\u4e3a" + warehouseCode + "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        }
        StorageOrderCreateDto storageOrderCreateDto = new StorageOrderCreateDto();
        StorageOrderReqDto storageOrderReqDto = this.buildStorageOrder(deliveryOrderEo, warehouseEo);
        storageOrderCreateDto.setStorageOrderReqDto(storageOrderReqDto);
        ArrayList<StorageOrderDetailReqDto> storageOrderDetailReqDtos = new ArrayList<StorageOrderDetailReqDto>();
        for (PackageDto packageDto : packageDtos) {
            if (!packageDto.getStatus().equals(PackageStatusEnum.PACKED.getStatus())) {
                throw new BizException(InventoryExceptionCode.PACKAGE_STATUS_ERROR.getCode(), InventoryExceptionCode.PACKAGE_STATUS_ERROR.getMsg());
            }
            List packageDetailDtos = packageDto.getPackageDetailDtos();
            for (PackageDetailDto packageDetailReqDto : packageDetailDtoList) {
                if (!packageDto.getId().equals(packageDetailReqDto.getPackageId())) continue;
                for (PackageDetailDto packageDetailDto : packageDetailDtos) {
                    if (!packageDetailDto.getCargoId().equals(packageDetailReqDto.getCargoId())) continue;
                    this.buildStorageOrderDetail(packageDto, packageDetailDto, deliveryOrderEo, warehouseEo, storageOrderReqDto.getOrderNo(), storageOrderDetailReqDtos);
                }
            }
            this.packageService.updateStatusById(packageDto.getId(), PackageStatusEnum.WAIT_OUT.getStatus());
        }
        storageOrderCreateDto.setStorageOrderDetailReqDtoList(storageOrderDetailReqDtos);
        return this.addStorageOrder(storageOrderCreateDto);
    }

    private StorageOrderReqDto buildStorageOrder(OrderDeliveryEo deliveryOrderEo, WarehouseEo warehouseEo) {
        StorageOrderReqDto storageOrderReqDto = new StorageOrderReqDto();
        storageOrderReqDto.setInstanceId(deliveryOrderEo.getInstanceId());
        storageOrderReqDto.setTenantId(deliveryOrderEo.getTenantId());
        storageOrderReqDto.setWarehouseId(warehouseEo.getId());
        storageOrderReqDto.setCategory(StorageCategoryEnum.CATEGORY_OUT.getCategory());
        storageOrderReqDto.setOrderNo(String.valueOf(System.currentTimeMillis()));
        return storageOrderReqDto;
    }

    private void buildStorageOrderDetail(PackageDto packageDto, PackageDetailDto packageDetailDto, OrderDeliveryEo deliveryOrderEo, WarehouseEo warehouseEo, String storageOrderNo, List<StorageOrderDetailReqDto> storageOrderDetailReqDtos) {
        OrderDeliveryEo packageDeliveryOrder = (OrderDeliveryEo)this.orderDeliveryDas.selectByPrimaryKey(packageDto.getDeliveryOrderId());
        List<StorageChangeLogEo> storageChangeLogEos = this.cargoStorageService.queryByType(packageDeliveryOrder.getDeliveryNo(), StorageChangeTypeEnum.ORDER_CHANGE.getType(), packageDetailDto.getCargoId());
        for (StorageChangeLogEo storageChangeLogEo : storageChangeLogEos) {
            storageChangeLogEo.setAppending(Long.valueOf(-storageChangeLogEo.getAppending().longValue()));
            storageChangeLogEo.setBalance(storageChangeLogEo.getAppending());
        }
        if (CollectionUtils.isNotEmpty(storageChangeLogEos)) {
            this.cargoStorageService.modifyStorageChange(storageChangeLogEos, StorageChangeStatusEnum.STORAGE_OUT.getStatus());
        }
        StorageOrderDetailReqDto storageOrderDetailReqDto = new StorageOrderDetailReqDto();
        storageOrderDetailReqDto.setInstanceId(deliveryOrderEo.getInstanceId());
        storageOrderDetailReqDto.setTenantId(deliveryOrderEo.getTenantId());
        storageOrderDetailReqDto.setNum(packageDetailDto.getNum());
        storageOrderDetailReqDto.setPackageId(packageDto.getId());
        storageOrderDetailReqDto.setPositionId(Long.valueOf(0L));
        storageOrderDetailReqDto.setOrderNo(storageOrderNo);
        storageOrderDetailReqDto.setStatus(InStorageOrderStatusEnum.FINISH.getStatus().toString());
        storageOrderDetailReqDto.setWarehouseId(warehouseEo.getId());
        storageOrderDetailReqDto.setCargoId(packageDetailDto.getCargoId());
        storageOrderDetailReqDto.setWarehouseId(warehouseEo.getId());
        storageOrderDetailReqDtos.add(storageOrderDetailReqDto);
    }

    @Override
    public StorageOrderEo queryById(Long id) {
        return (StorageOrderEo)this.storageOrderDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<StorageOrderEo> queryPage(StorageOrderEo storageOrderEo, Integer pageNum, Integer pageSize) {
        return this.storageOrderDas.selectPage((BaseEo)storageOrderEo, pageNum, pageSize);
    }

    private void saveDetailBatch(StorageOrderEo orderEo, List<StorageOrderDetailReqDto> detailList) {
        if (orderEo.getId() == null) {
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.PARAMETER_ERROR);
        }
        ArrayList<StorageOrderDetailEo> detailEoList = new ArrayList<StorageOrderDetailEo>();
        for (StorageOrderDetailReqDto detailReqDto : detailList) {
            StorageOrderDetailEo detailEo = new StorageOrderDetailEo();
            DtoHelper.dto2Eo((BaseVo)detailReqDto, (BaseEo)detailEo);
            detailEoList.add(detailEo);
        }
        if (CollectionUtils.isNotEmpty(detailEoList)) {
            StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
            storageOrderDetailEo.setOrderId(((StorageOrderDetailEo)detailEoList.get(0)).getOrderId());
            this.storageOrderDetailDas.insertBatchByExample(detailEoList, (BaseEo)storageOrderDetailEo);
        }
    }

    private void updateCargoStorage(StorageOrderEo orderEo, List<StorageOrderDetailEo> detailList, boolean checkStock, boolean needConfirmPreempt) {
        if (orderEo == null || orderEo.getId() == null) {
            InventoryBusinessRuntimeException.parameterError();
        }
        StockChangeDto stockChangeDto = new StockChangeDto();
        stockChangeDto.setOrderNo(orderEo.getOrderNo());
        stockChangeDto.setCheckStock(Boolean.valueOf(checkStock));
        if (StringUtils.equals((CharSequence)orderEo.getCategory(), (CharSequence)"CATEGORY_IN")) {
            stockChangeDto.setChangeType("STOCK_IN");
            ArrayList<StockChangeDto.StockChangeItemDto> stockChangeItemDtoList = new ArrayList<StockChangeDto.StockChangeItemDto>();
            for (StorageOrderDetailEo orderDetailEo : detailList) {
                StockChangeDto.StockChangeItemDto stockChangeItemDto = new StockChangeDto.StockChangeItemDto();
                stockChangeItemDto.setWarehouseId(orderDetailEo.getWarehouseId());
                stockChangeItemDto.setCargoId(orderDetailEo.getCargoId());
                ArrayList<StockChangeDto.Stock> stockList = new ArrayList<StockChangeDto.Stock>();
                StockChangeDto.Stock stockBalance = new StockChangeDto.Stock();
                stockBalance.setStockType("balance");
                stockBalance.setNum(new BigDecimal(orderDetailEo.getNum()));
                stockList.add(stockBalance);
                StockChangeDto.Stock stockAvailable = new StockChangeDto.Stock();
                stockAvailable.setStockType("available");
                stockAvailable.setNum(new BigDecimal(orderDetailEo.getNum()));
                stockList.add(stockAvailable);
                stockChangeItemDto.setStocks(stockList);
                stockChangeItemDtoList.add(stockChangeItemDto);
                stockChangeDto.setItems(stockChangeItemDtoList);
            }
        } else if (StringUtils.equals((CharSequence)orderEo.getCategory(), (CharSequence)"CATEGORY_OUT")) {
            stockChangeDto.setChangeType("STOCK_OUT");
            ArrayList<StockChangeDto.StockChangeItemDto> stockChangeItemDtoList = new ArrayList<StockChangeDto.StockChangeItemDto>();
            for (StorageOrderDetailEo orderDetailEo : detailList) {
                StockChangeDto.StockChangeItemDto stockChangeItemDto = new StockChangeDto.StockChangeItemDto();
                stockChangeItemDto.setWarehouseId(orderDetailEo.getWarehouseId());
                stockChangeItemDto.setCargoId(orderDetailEo.getCargoId());
                ArrayList<StockChangeDto.Stock> stockList = new ArrayList<StockChangeDto.Stock>();
                StockChangeDto.Stock stockBalance = new StockChangeDto.Stock();
                stockBalance.setStockType("balance");
                stockBalance.setNum(new BigDecimal(orderDetailEo.getNum()).negate());
                stockList.add(stockBalance);
                if (needConfirmPreempt) {
                    StockChangeDto.Stock stockPreempt = new StockChangeDto.Stock();
                    stockPreempt.setStockType("preempt");
                    stockPreempt.setNum(new BigDecimal(orderDetailEo.getNum()).negate());
                    stockList.add(stockPreempt);
                } else {
                    StockChangeDto.Stock stockAvailable = new StockChangeDto.Stock();
                    stockAvailable.setStockType("available");
                    stockAvailable.setNum(new BigDecimal(orderDetailEo.getNum()).negate());
                    stockList.add(stockAvailable);
                }
                stockChangeItemDto.setStocks(stockList);
                stockChangeItemDtoList.add(stockChangeItemDto);
                stockChangeDto.setItems(stockChangeItemDtoList);
            }
        }
        this.stockDsl.modifyStock(stockChangeDto);
    }

    @Override
    public void updateCargoStorage(StorageOrderEo orderEo, List<StorageOrderDetailEo> detailList) {
        this.updateCargoStorage(orderEo, detailList, true, false);
    }
}

