/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderDetailModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.TransferOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ITransferOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.TransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.TransferOrderDetailEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferOrderDetailServiceImpl
implements ITransferOrderDetailService {
    @Resource
    private TransferOrderDetailDas transferOrderDetailDas;
    @Resource
    private CargoDas cargoDas;

    private String getUsername() {
        return ServiceContext.getContext().getRequestUserCode();
    }

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addTransferOrderDetail(TransferOrderDetailAddReqDto reqDto) {
        String username = this.getUsername();
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long instanceId = this.getInstanceId(reqDto.getInstanceId());
        TransferOrderDetailEo transferOrderDetailEo = new TransferOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)transferOrderDetailEo);
        transferOrderDetailEo.setCreatePerson(username);
        transferOrderDetailEo.setTenantId(tenantId);
        transferOrderDetailEo.setInstanceId(instanceId);
        this.transferOrderDetailDas.insert((BaseEo)transferOrderDetailEo);
        return transferOrderDetailEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyTransferOrderDetail(TransferOrderDetailModifyReqDto reqDto) {
        String username = this.getUsername();
        TransferOrderDetailEo transferOrderDetailEo = new TransferOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)transferOrderDetailEo);
        transferOrderDetailEo.setUpdatePerson(username);
        transferOrderDetailEo.setTenantId(null);
        transferOrderDetailEo.setInstanceId(null);
        this.transferOrderDetailDas.updateSelective((BaseEo)transferOrderDetailEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTransferOrderDetail(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.transferOrderDetailDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public TransferOrderDetailRespDto queryTransferOrderDetailById(Long id) {
        TransferOrderDetailEo transferOrderDetailEo = (TransferOrderDetailEo)this.transferOrderDetailDas.selectByPrimaryKey(id);
        if (transferOrderDetailEo == null) {
            return null;
        }
        TransferOrderDetailRespDto transferOrderDetailRespDto = new TransferOrderDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)transferOrderDetailEo, (BaseVo)transferOrderDetailRespDto);
        CargoEo cargoEo = (CargoEo)this.cargoDas.selectByPrimaryKey(transferOrderDetailEo.getCargoId());
        TransferOrderDetailServiceImpl.completeOrderDetail(transferOrderDetailRespDto, cargoEo);
        return transferOrderDetailRespDto;
    }

    @Override
    public PageInfo<TransferOrderDetailRespDto> queryTransferOrderDetailByPage(TransferOrderDetailQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        TransferOrderDetailEo transferOrderDetailEo = new TransferOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)transferOrderDetailEo);
        transferOrderDetailEo.setTenantId(this.getTenantId(null));
        PageInfo eoPageInfo = this.transferOrderDetailDas.selectPage((BaseEo)transferOrderDetailEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TransferOrderDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (dtoList.size() > 0) {
            List cargoIds = dtoList.stream().map(TransferOrderDetailRespDto::getCargoId).collect(Collectors.toList());
            CargoEo cargoQueryEo = new CargoEo();
            cargoQueryEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", cargoIds)));
            Map<Long, CargoEo> cargoEoMap = this.cargoDas.select((BaseEo)cargoQueryEo, Integer.valueOf(1), Integer.valueOf(cargoIds.size())).stream().collect(Collectors.toMap(BaseEo::getId, e -> e));
            dtoList.forEach(dto -> TransferOrderDetailServiceImpl.completeOrderDetail(dto, (CargoEo)cargoEoMap.get(dto.getCargoId())));
        }
        return dtoPageInfo;
    }

    private static void completeOrderDetail(TransferOrderDetailRespDto dto, CargoEo cargoEo) {
        if (cargoEo == null) {
            return;
        }
        dto.setCargoCode(cargoEo.getCode());
        dto.setCargoName(cargoEo.getName());
        dto.setCargoArtNo(cargoEo.getArtNo());
        dto.setCargoBarCode(cargoEo.getBarCode());
        dto.setCargoCustomerNo(cargoEo.getCustomerNo());
    }
}

