/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.InStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.OutStorageOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.StorageOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.TransferOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.TransferOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.StockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.AddressReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.InStorageDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.storage.InStorageInReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderDetailModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderModifyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.transfer.TransferOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.StorageCheckRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.transfer.TransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ITransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.StockDsl;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.AddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DiffOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.DiffOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.TransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.TransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.AddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DiffOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DiffOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdStorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdTransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.TransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.TransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TransferOrderServiceImpl
implements ITransferOrderService {
    public static final Logger logger = LoggerFactory.getLogger(TransferOrderServiceImpl.class);
    @Resource
    private TransferOrderDas transferOrderDas;
    @Resource
    private TransferOrderDetailDas transferOrderDetailDas;
    @Resource
    private StorageOrderDas storageOrderDas;
    @Resource
    private StorageOrderDetailDas storageOrderDetailDas;
    @Resource
    private DiffOrderDas diffOrderDas;
    @Resource
    private DiffOrderDetailDas diffOrderDetailDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private AddressDas addressDas;
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private StockDsl stockDsl;

    private String getUsername() {
        return ServiceContext.getContext().getRequestUserCode();
    }

    private Long getTenantId(Long paramTenantId) {
        return paramTenantId == null ? ServiceContext.getContext().getRequestTenantId() : paramTenantId;
    }

    private Long getInstanceId(Long paramInstanceId) {
        return paramInstanceId == null ? ServiceContext.getContext().getRequestTenantId() : paramInstanceId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addTransferOrder(TransferOrderAddReqDto reqDto) {
        List transferOrderDetails;
        this.addTransferOrderCheck(reqDto);
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)transferOrderEo);
        String username = this.getUsername();
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long instanceId = this.getInstanceId(reqDto.getInstanceId());
        long id = IdGenrator.getDistributedId();
        transferOrderEo.setId(Long.valueOf(id));
        transferOrderEo.setOrderNo(id + "");
        transferOrderEo.setCreatePerson(username);
        transferOrderEo.setTenantId(tenantId);
        transferOrderEo.setInstanceId(instanceId);
        this.transferOrderDas.insert((BaseEo)transferOrderEo);
        Long orderId = transferOrderEo.getId();
        AddressReqDto addressReqDto = reqDto.getAddressReqDto();
        if (addressReqDto != null) {
            AddressEo addressEo = new AddressEo();
            DtoHelper.dto2Eo((BaseVo)addressReqDto, (BaseEo)addressEo);
            addressEo.setRelatedId(orderId.toString());
            addressEo.setCreatePerson(username);
            addressEo.setTenantId(tenantId);
            addressEo.setInstanceId(instanceId);
            this.addressDas.insert((BaseEo)addressEo);
        }
        if (!CollectionUtils.isEmpty((Collection)(transferOrderDetails = reqDto.getTransferOrderDetails()))) {
            ArrayList eos = new ArrayList();
            CubeBeanUtils.copyCollection(eos, (Collection)transferOrderDetails, TransferOrderDetailEo.class);
            eos.forEach(e -> e.setOrderId(orderId));
            this.transferOrderDetailDas.insertBatch(eos);
        }
        return transferOrderEo.getId();
    }

    private void addTransferOrderCheck(TransferOrderAddReqDto reqDto) {
        if (!TransferOrderStatusEnum.WAIT_COMMIT.getStatus().equals(reqDto.getStatus()) && !TransferOrderStatusEnum.WAIT_AUDIT.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u63d0\u4ea4\u72b6\u6001\u53ea\u80fd\u4e3a\u5f85\u63d0\u4ea4\u6216\u5f85\u5ba1\u6838");
        }
        if (TransferOrderStatusEnum.WAIT_AUDIT.getStatus().equals(reqDto.getStatus())) {
            if (CollectionUtils.isEmpty((Collection)reqDto.getTransferOrderDetails())) {
                throw new BizException("\u63d0\u4ea4\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\u65f6, \u8d27\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<Long> cargoIds = reqDto.getTransferOrderDetails().stream().map(TransferOrderDetailAddReqDto::getCargoId).collect(Collectors.toList());
            if (TransferOrderTypeEnum.PHYSICAL.getType().equals(reqDto.getType())) {
                this.cargoStorageCheck(reqDto.getOutPhysicalWarehouseId(), cargoIds, "\u53d1\u8d27\u4ed3\u5e93");
                this.cargoStorageCheck(reqDto.getInPhysicalWarehouseId(), cargoIds, "\u6536\u8d27\u4ed3\u5e93");
            }
            this.cargoStorageCheck(reqDto.getOutLogicWarehouseId(), cargoIds, "\u53d1\u8d27\u903b\u8f91\u4ed3");
            this.cargoStorageCheck(reqDto.getInLogicWarehouseId(), cargoIds, "\u6536\u8d27\u903b\u8f91\u4ed3");
        }
        if (TransferOrderTypeEnum.nameOf((Integer)reqDto.getType()) == null) {
            throw new BizException("\u7c7b\u578b\u53ea\u80fd\u4e3a\u7269\u7406\u8c03\u62e8\u5355\u6216\u865a\u62df\u8c03\u62e8\u5355");
        }
        if (TransferOrderTypeEnum.VIRTUAL.getType().equals(reqDto.getType())) {
            Long outLogicWarehouseId = reqDto.getOutLogicWarehouseId();
            Long inLogicWarehouseId = reqDto.getInLogicWarehouseId();
            if (outLogicWarehouseId != null && outLogicWarehouseId.equals(inLogicWarehouseId)) {
                throw new BizException("\u53d1\u8d27\u903b\u8f91\u4ed3\u548c\u6536\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u76f8\u540c");
            }
            List warehouseEos = this.warehouseDas.selectByIds(Arrays.asList(outLogicWarehouseId, inLogicWarehouseId));
            if (warehouseEos.size() == 2 && !Objects.equals(((WarehouseEo)warehouseEos.get(0)).getParentId(), ((WarehouseEo)warehouseEos.get(1)).getParentId())) {
                throw new BizException("\u53d1\u8d27\u903b\u8f91\u4ed3\u548c\u6536\u8d27\u903b\u8f91\u4ed3\u5fc5\u987b\u540c\u5c5e\u540c\u4e00\u4e2a\u7269\u7406\u4ed3");
            }
        }
    }

    private void cargoStorageCheck(Long warehouseId, List<Long> cargoIds, String warehouseName) {
        List notExistCargoIds = this.cargoStorageDas.notExistCargoIds(warehouseId, cargoIds);
        if (notExistCargoIds.size() > 0) {
            throw new BizException("\u4ee5\u4e0b\u8d27\u54c1[id\u4e3a" + StringUtils.collectionToCommaDelimitedString((Collection)notExistCargoIds) + "]\u672a\u5173\u8054" + warehouseName);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyTransferOrder(TransferOrderModifyReqDto reqDto) {
        List transferOrderDetails;
        Long orderId = this.modifyTransferOrderCheck(reqDto);
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)transferOrderEo, (String[])new String[]{"transferOrderDetails"});
        String username = this.getUsername();
        Long tenantId = this.getTenantId(reqDto.getTenantId());
        Long instanceId = this.getInstanceId(reqDto.getInstanceId());
        transferOrderEo.setUpdatePerson(username);
        transferOrderEo.setTenantId(null);
        transferOrderEo.setInstanceId(null);
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        AddressReqDto addressReqDto = reqDto.getAddressReqDto();
        if (addressReqDto != null) {
            AddressEo addressEo = new AddressEo();
            DtoHelper.dto2Eo((BaseVo)addressReqDto, (BaseEo)addressEo);
            addressEo.setSqlFilters(Collections.singletonList(SqlFilter.eq((String)"related_id", (Object)orderId.toString())));
            addressEo.setId(null);
            addressEo.setUpdatePerson(username);
            addressEo.setTenantId(null);
            addressEo.setInstanceId(null);
            this.addressDas.updateSelectiveSqlFilter((BaseEo)addressEo);
        }
        if (!CollectionUtils.isEmpty((Collection)(transferOrderDetails = reqDto.getTransferOrderDetails()))) {
            TransferOrderDetailEo transferOrderDetailEo = new TransferOrderDetailEo();
            transferOrderDetailEo.setOrderId(orderId);
            this.transferOrderDetailDas.delete((BaseEo)transferOrderDetailEo);
            ArrayList eos = new ArrayList();
            CubeBeanUtils.copyCollection(eos, (Collection)transferOrderDetails, TransferOrderDetailEo.class);
            eos.forEach(e -> {
                e.setOrderId(transferOrderEo.getId());
                e.setCreatePerson(username);
                e.setTenantId(tenantId);
                e.setInstanceId(instanceId);
            });
            this.transferOrderDetailDas.insertBatch(eos);
        }
    }

    private Long modifyTransferOrderCheck(TransferOrderModifyReqDto reqDto) {
        Long orderId;
        TransferOrderEo dbEo;
        if (!TransferOrderStatusEnum.WAIT_COMMIT.getStatus().equals(reqDto.getStatus()) && !TransferOrderStatusEnum.WAIT_AUDIT.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u4fee\u6539\u72b6\u6001\u53ea\u80fd\u4e3a\u5f85\u63d0\u4ea4\u6216\u5f85\u5ba1\u6838");
        }
        if (reqDto.getType() != null && TransferOrderTypeEnum.nameOf((Integer)reqDto.getType()) == null) {
            throw new BizException("\u7c7b\u578b\u53ea\u80fd\u4e3a\u7269\u7406\u8c03\u62e8\u5355\u6216\u865a\u62df\u8c03\u62e8\u5355");
        }
        if (TransferOrderTypeEnum.VIRTUAL.getType().equals(reqDto.getType())) {
            Long outLogicWarehouseId = reqDto.getOutLogicWarehouseId();
            Long inLogicWarehouseId = reqDto.getInLogicWarehouseId();
            if (outLogicWarehouseId != null && outLogicWarehouseId.equals(inLogicWarehouseId)) {
                throw new BizException("\u53d1\u8d27\u903b\u8f91\u4ed3\u548c\u6536\u8d27\u903b\u8f91\u4ed3\u4e0d\u80fd\u76f8\u540c");
            }
            List warehouseEos = this.warehouseDas.selectByIds(Arrays.asList(outLogicWarehouseId, inLogicWarehouseId));
            if (warehouseEos.size() == 2 && !Objects.equals(((WarehouseEo)warehouseEos.get(0)).getParentId(), ((WarehouseEo)warehouseEos.get(1)).getParentId())) {
                throw new BizException("\u53d1\u8d27\u903b\u8f91\u4ed3\u548c\u6536\u8d27\u903b\u8f91\u4ed3\u5fc5\u987b\u540c\u5c5e\u540c\u4e00\u4e2a\u7269\u7406\u4ed3");
            }
            reqDto.setOutPhysicalWarehouseId(Long.valueOf(0L));
            reqDto.setInPhysicalWarehouseId(Long.valueOf(0L));
        }
        if ((dbEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(orderId = reqDto.getId())) == null) {
            throw new BizException("\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        }
        if (!Arrays.asList(TransferOrderStatusEnum.WAIT_COMMIT.getStatus(), TransferOrderStatusEnum.AUDIT_NO_PASS.getStatus()).contains(dbEo.getStatus())) {
            throw new BizException("\u8c03\u62e8\u5355\u4e0d\u80fd\u4fee\u6539");
        }
        if (!TransferOrderStatusEnum.WAIT_COMMIT.getStatus().equals(reqDto.getStatus()) && !TransferOrderStatusEnum.WAIT_AUDIT.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u63d0\u4ea4\u72b6\u6001\u53ea\u80fd\u4e3a\u5f85\u63d0\u4ea4\u6216\u5f85\u5ba1\u6838");
        }
        if (TransferOrderStatusEnum.WAIT_AUDIT.getStatus().equals(reqDto.getStatus()) && !CollectionUtils.isEmpty((Collection)reqDto.getTransferOrderDetails())) {
            List<Long> cargoIds = reqDto.getTransferOrderDetails().stream().map(TransferOrderDetailModifyReqDto::getCargoId).collect(Collectors.toList());
            if (TransferOrderTypeEnum.PHYSICAL.getType().equals(reqDto.getType())) {
                this.cargoStorageCheck(reqDto.getOutPhysicalWarehouseId(), cargoIds, "\u53d1\u8d27\u4ed3\u5e93");
                this.cargoStorageCheck(reqDto.getInPhysicalWarehouseId(), cargoIds, "\u6536\u8d27\u4ed3\u5e93");
            }
            this.cargoStorageCheck(reqDto.getOutLogicWarehouseId(), cargoIds, "\u53d1\u8d27\u903b\u8f91\u4ed3");
            this.cargoStorageCheck(reqDto.getInLogicWarehouseId(), cargoIds, "\u6536\u8d27\u903b\u8f91\u4ed3");
        }
        return orderId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelTransferOrder(TransferOrderCancelReqDto reqDto) {
        TransferOrderEo dbEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(reqDto.getId());
        if (dbEo == null) {
            throw new BizException("\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        }
        if (!TransferOrderStatusEnum.CANCEL.getStatus().equals(reqDto.getStatus())) {
            throw new BizException("\u8bf7\u6c42\u72b6\u6001\u5fc5\u987b\u4e3a\u53d6\u6d88\u72b6\u6001");
        }
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        transferOrderEo.setId(reqDto.getId());
        transferOrderEo.setStatus(reqDto.getStatus());
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<StorageCheckRespDto> auditTransferOrder(TransferOrderAuditReqDto reqDto) {
        TransferOrderEo dbEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(reqDto.getId());
        if (dbEo == null) {
            throw new BizException("\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        }
        if (!TransferOrderStatusEnum.WAIT_AUDIT.getStatus().equals(dbEo.getStatus())) {
            throw new BizException("\u8c03\u62e8\u5355\u4e3a\u975e\u5f85\u5ba1\u6838\u72b6\u6001[status=" + dbEo.getStatus() + "]");
        }
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        if (TransferOrderTypeEnum.PHYSICAL.getType().equals(dbEo.getType())) {
            if (!TransferOrderStatusEnum.AUDIT_NO_PASS.getStatus().equals(reqDto.getStatus()) && !TransferOrderStatusEnum.WAIT_EXECUTE.getStatus().equals(reqDto.getStatus())) {
                throw new BizException("\u63d0\u4ea4\u72b6\u6001\u53ea\u80fd\u4e3a\u5ba1\u6838\u4e0d\u901a\u8fc7\u6216\u5f85\u6267\u884c");
            }
            if (TransferOrderStatusEnum.WAIT_EXECUTE.getStatus().equals(reqDto.getStatus())) {
                Long outStorageOrderId = this.createOutStorageOrder(dbEo);
                transferOrderEo.setOutStorageId(outStorageOrderId);
            }
        } else if (TransferOrderTypeEnum.VIRTUAL.getType().equals(dbEo.getType())) {
            if (!TransferOrderStatusEnum.AUDIT_NO_PASS.getStatus().equals(reqDto.getStatus()) && !TransferOrderStatusEnum.FINISH.getStatus().equals(reqDto.getStatus())) {
                throw new BizException("\u63d0\u4ea4\u72b6\u6001\u53ea\u80fd\u4e3a\u5ba1\u6838\u4e0d\u901a\u8fc7\u6216\u5df2\u5b8c\u6210");
            }
            if (TransferOrderStatusEnum.FINISH.getStatus().equals(reqDto.getStatus())) {
                TransferOrderDetailEo detailEo = new TransferOrderDetailEo();
                detailEo.setOrderId(dbEo.getId());
                List data = this.transferOrderDetailDas.select((BaseEo)detailEo, Integer.valueOf(1), Integer.valueOf(10000));
                List<StorageCheckRespDto> notEnough = this.checkInventoryAndReturn(data, dbEo.getOutLogicWarehouseId());
                if (notEnough.size() > 0) {
                    return notEnough;
                }
                StockChangeDto stockChangeOut = new StockChangeDto();
                stockChangeOut.setChangeType("STOCK_TRANSFER");
                stockChangeOut.setBizType("TRANSFER_ORDER_VIRTUAL");
                stockChangeOut.setOrderNo(dbEo.getId().toString());
                List outItems = data.stream().map(cargo -> {
                    StockChangeDto.StockChangeItemDto itemDto = new StockChangeDto.StockChangeItemDto();
                    itemDto.setWarehouseId(dbEo.getOutLogicWarehouseId());
                    itemDto.setCargoId(cargo.getCargoId());
                    itemDto.setStocks(Arrays.asList(new StockChangeDto.Stock("balance", cargo.getNum().negate()), new StockChangeDto.Stock("available", cargo.getNum().negate())));
                    return itemDto;
                }).collect(Collectors.toList());
                List inItems = data.stream().map(cargo -> {
                    StockChangeDto.StockChangeItemDto itemDto = new StockChangeDto.StockChangeItemDto();
                    itemDto.setWarehouseId(dbEo.getInLogicWarehouseId());
                    itemDto.setCargoId(cargo.getCargoId());
                    itemDto.setStocks(Arrays.asList(new StockChangeDto.Stock("balance", cargo.getNum()), new StockChangeDto.Stock("available", cargo.getNum())));
                    return itemDto;
                }).collect(Collectors.toList());
                outItems.addAll(inItems);
                stockChangeOut.setItems(outItems);
                this.stockDsl.modifyStock(stockChangeOut);
            }
        }
        transferOrderEo.setId(reqDto.getId());
        transferOrderEo.setStatus(reqDto.getStatus());
        transferOrderEo.setAuditTime(new Date());
        transferOrderEo.setAuditPerson(this.getUsername());
        transferOrderEo.setAuditDesc(reqDto.getAuditDesc());
        transferOrderEo.setTenantId(null);
        transferOrderEo.setInstanceId(null);
        this.transferOrderDas.updateSelective((BaseEo)transferOrderEo);
        return new ArrayList<StorageCheckRespDto>();
    }

    private List<StorageCheckRespDto> checkInventoryAndReturn(List<TransferOrderDetailEo> data, Long outLogicWarehouseId) {
        if (data.size() == 0) {
            throw new BizException("\u5ba1\u6279\u7684\u8d27\u54c1\u4e3a\u7a7a");
        }
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(outLogicWarehouseId);
        if (warehouseEo == null) {
            throw new BizException("id\u4e3a" + outLogicWarehouseId + "\u7684\u4ed3\u5e93\u4e0d\u5b58\u5728");
        }
        List cargoIds = data.stream().map(StdTransferOrderDetailEo::getCargoId).collect(Collectors.toList());
        CargoStorageEo cargoStorageQuery = new CargoStorageEo();
        cargoStorageQuery.setWarehouseId(outLogicWarehouseId);
        cargoStorageQuery.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"cargo_id", cargoIds)));
        Map<Long, CargoStorageEo> cargoStorageMap = this.cargoStorageDas.select((BaseEo)cargoStorageQuery).stream().collect(Collectors.toMap(StdCargoStorageEo::getCargoId, e -> e));
        ArrayList<StorageCheckRespDto> notEnough = new ArrayList<StorageCheckRespDto>(data.size());
        data.forEach(e -> {
            CargoStorageEo cargoStorageEo = (CargoStorageEo)cargoStorageMap.get(e.getCargoId());
            if (cargoStorageEo != null && cargoStorageEo.getAvailable().compareTo(e.getNum()) < 0) {
                StorageCheckRespDto respDto = new StorageCheckRespDto();
                respDto.setWarehouseName(warehouseEo.getName());
                respDto.setCargoCode(cargoStorageEo.getCargoCode());
                respDto.setCargoName(cargoStorageEo.getCargoName());
                respDto.setAvailable(cargoStorageEo.getAvailable());
                respDto.setNum(e.getNum());
                notEnough.add(respDto);
            }
        });
        return notEnough;
    }

    private Long createOutStorageOrder(TransferOrderEo dbEo) {
        StorageOrderEo storageOrderEo = new StorageOrderEo();
        storageOrderEo.setCategory("CATEGORY_OUT");
        storageOrderEo.setType(StorageOrderTypeEnum.TRANSFER.getCode());
        storageOrderEo.setOrderNo(dbEo.getOrderNo());
        storageOrderEo.setOrderSrc("\u4e2d\u53f0->\u4e2d\u53f0");
        storageOrderEo.setOrderSrcId(dbEo.getId());
        storageOrderEo.setStatus(OutStorageOrderStatusEnum.WAIT_OUT.getStatus());
        storageOrderEo.setWarehouseId(dbEo.getOutPhysicalWarehouseId());
        storageOrderEo.setLogicWarehouseId(dbEo.getOutLogicWarehouseId());
        storageOrderEo.setCreatePerson("\u7cfb\u7edf");
        String username = this.getUsername();
        Long tenantId = dbEo.getTenantId();
        Long instanceId = dbEo.getInstanceId();
        storageOrderEo.setCreatePerson(username);
        storageOrderEo.setTenantId(tenantId);
        storageOrderEo.setInstanceId(instanceId);
        this.storageOrderDas.insert((BaseEo)storageOrderEo);
        AddressEo query = new AddressEo();
        query.setRelatedId(dbEo.getId().toString());
        List address = this.addressDas.select((BaseEo)query, Integer.valueOf(1), Integer.valueOf(1));
        if (address.size() > 0) {
            AddressEo addressEo = (AddressEo)address.get(0);
            addressEo.setId(null);
            addressEo.setRelatedId(storageOrderEo.getId().toString());
            addressEo.setCreatePerson(username);
            addressEo.setTenantId(tenantId);
            addressEo.setInstanceId(instanceId);
            this.addressDas.insert((BaseEo)addressEo);
        }
        TransferOrderDetailEo transferOrderDetailEoQuery = new TransferOrderDetailEo();
        transferOrderDetailEoQuery.setOrderId(dbEo.getId());
        List detailEos = this.transferOrderDetailDas.select((BaseEo)transferOrderDetailEoQuery, Integer.valueOf(1), Integer.valueOf(10000)).stream().map(e -> {
            StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
            storageOrderDetailEo.setOrderId(storageOrderEo.getId());
            storageOrderDetailEo.setOrderNo(storageOrderDetailEo.getOrderId() + "");
            storageOrderDetailEo.setWarehouseId(storageOrderEo.getWarehouseId());
            storageOrderDetailEo.setCargoId(e.getCargoId());
            storageOrderDetailEo.setNum(Long.valueOf(e.getNum().longValue()));
            storageOrderDetailEo.setActualNum(Long.valueOf(e.getNum().longValue()));
            storageOrderDetailEo.setCreatePerson(username);
            storageOrderDetailEo.setTenantId(tenantId);
            storageOrderDetailEo.setInstanceId(instanceId);
            return storageOrderDetailEo;
        }).collect(Collectors.toList());
        if (detailEos.size() > 0) {
            this.storageOrderDetailDas.insertBatch(detailEos);
        }
        return storageOrderEo.getId();
    }

    @Override
    public List<StorageCheckRespDto> outTransferOrderCheck(Long id) {
        TransferOrderEo dbEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(id);
        TransferOrderDetailEo detailEo = new TransferOrderDetailEo();
        detailEo.setOrderId(dbEo.getId());
        List data = this.transferOrderDetailDas.select((BaseEo)detailEo, Integer.valueOf(1), Integer.valueOf(10000));
        return this.checkInventoryAndReturn(data, dbEo.getOutLogicWarehouseId());
    }

    @Override
    public void outTransferOrder(Long id) {
        TransferOrderEo dbEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(id);
        dbEo.setStatus(TransferOrderStatusEnum.IN_EXECUTE.getStatus());
        String username = this.getUsername();
        Long tenantId = dbEo.getTenantId();
        Long instanceId = dbEo.getInstanceId();
        StorageOrderEo storageOrderEo = this.physicStorageOrder(dbEo, username, tenantId, instanceId);
        List<StorageOrderDetailEo> detailEos = this.physicStorageOrderDetails(dbEo, storageOrderEo, username, tenantId, instanceId);
        this.physicLogicWarehouseOut(dbEo, detailEos);
        dbEo.setInStorageId(storageOrderEo.getId());
        this.transferOrderDas.updateSelective((BaseEo)dbEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int tcbjPhysicLogicWarehouseOut(StockChangeDto stockChangeOut, List<StorageOrderDetailEo> detailEos) {
        logger.error("\u6c64\u81e3\u500d\u5065\u4fee\u6539\u5e93\u5b58\u5165\u53c2stockChangeOut:{},detailEos:{}", (Object)JSON.toJSONString((Object)stockChangeOut), (Object)JSON.toJSONString(detailEos));
        stockChangeOut.setOrderNo(stockChangeOut.getOrderNo());
        if (stockChangeOut.getChangeType().equals("STOCK_IN")) {
            stockChangeOut.setCheckStock(Boolean.valueOf(true));
        }
        stockChangeOut.setItems(detailEos.stream().map(cargo -> new StockChangeDto.StockChangeItemDto(((StorageOrderDetailEo)detailEos.get(0)).getWarehouseId(), cargo.getCargoId(), cargo.getBatch(), Arrays.asList(new StockChangeDto.Stock("balance", new BigDecimal(cargo.getNum()).negate()), new StockChangeDto.Stock("available", new BigDecimal(cargo.getNum()).negate()), new StockChangeDto.Stock("preempt", cargo.getActualNum() == null ? BigDecimal.ZERO : new BigDecimal(cargo.getActualNum()).negate())), cargo.getVersion())).collect(Collectors.toList()));
        logger.error("\u6c64\u81e3\u500d\u5065\u4fee\u6539\u5e93\u5b58modifyStock\u5165\u53c2stockChangeOut:{}", (Object)JSON.toJSONString((Object)stockChangeOut));
        return this.stockDsl.modifyStock(stockChangeOut);
    }

    private StorageOrderEo physicStorageOrder(TransferOrderEo dbEo, String username, Long tenantId, Long instanceId) {
        StorageOrderEo storageOrderEo = new StorageOrderEo();
        storageOrderEo.setCategory("CATEGORY_IN");
        storageOrderEo.setType(StorageOrderTypeEnum.TRANSFER.getCode());
        storageOrderEo.setOrderNo(dbEo.getOrderNo());
        storageOrderEo.setOrderSrcId(dbEo.getId());
        storageOrderEo.setOrderSrc("\u4e2d\u53f0->\u4e2d\u53f0");
        storageOrderEo.setStatus(InStorageOrderStatusEnum.WAIT_IN.getStatus());
        storageOrderEo.setCreatePerson("\u7cfb\u7edf");
        if (TransferOrderTypeEnum.PHYSICAL.getType().equals(dbEo.getType())) {
            storageOrderEo.setWarehouseId(dbEo.getInPhysicalWarehouseId());
        } else if (TransferOrderTypeEnum.VIRTUAL.getType().equals(dbEo.getType())) {
            storageOrderEo.setWarehouseId(dbEo.getInLogicWarehouseId());
        }
        storageOrderEo.setCreatePerson(username);
        storageOrderEo.setTenantId(tenantId);
        storageOrderEo.setInstanceId(instanceId);
        this.storageOrderDas.insert((BaseEo)storageOrderEo);
        AddressEo query = new AddressEo();
        query.setRelatedId(dbEo.getId().toString());
        List address = this.addressDas.select((BaseEo)query, Integer.valueOf(1), Integer.valueOf(1));
        if (address.size() > 0) {
            AddressEo addressEo = (AddressEo)address.get(0);
            addressEo.setId(null);
            addressEo.setRelatedId(storageOrderEo.getId().toString());
            addressEo.setCreatePerson(username);
            addressEo.setTenantId(tenantId);
            addressEo.setInstanceId(instanceId);
            this.addressDas.insert((BaseEo)addressEo);
        }
        return storageOrderEo;
    }

    private List<StorageOrderDetailEo> physicStorageOrderDetails(TransferOrderEo dbEo, StorageOrderEo storageOrderEo, String username, Long tenantId, Long instanceId) {
        TransferOrderDetailEo transferOrderDetailEoQuery = new TransferOrderDetailEo();
        transferOrderDetailEoQuery.setOrderId(dbEo.getId());
        List<StorageOrderDetailEo> detailEos = this.transferOrderDetailDas.select((BaseEo)transferOrderDetailEoQuery, Integer.valueOf(1), Integer.valueOf(10000)).stream().map(e -> {
            StorageOrderDetailEo storageOrderDetailEo = new StorageOrderDetailEo();
            storageOrderDetailEo.setOrderId(storageOrderEo.getId());
            storageOrderDetailEo.setOrderNo(storageOrderDetailEo.getOrderId() + "");
            storageOrderDetailEo.setWarehouseId(storageOrderEo.getWarehouseId());
            storageOrderDetailEo.setCargoId(e.getCargoId());
            storageOrderDetailEo.setNum(Long.valueOf(e.getNum().longValue()));
            storageOrderDetailEo.setActualNum(Long.valueOf(e.getNum().longValue()));
            storageOrderDetailEo.setCreatePerson(username);
            storageOrderDetailEo.setTenantId(tenantId);
            storageOrderDetailEo.setInstanceId(instanceId);
            return storageOrderDetailEo;
        }).collect(Collectors.toList());
        if (detailEos.size() > 0) {
            this.storageOrderDetailDas.insertBatch(detailEos);
        }
        return detailEos;
    }

    private void physicLogicWarehouseOut(TransferOrderEo dbEo, List<StorageOrderDetailEo> detailEos) {
        StockChangeDto stockChangeOut = new StockChangeDto();
        stockChangeOut.setChangeType("STOCK_OUT");
        stockChangeOut.setBizType("TRANSFER_ORDER_PHYSICAL_OUT");
        stockChangeOut.setOrderNo(dbEo.getId().toString());
        stockChangeOut.setItems(detailEos.stream().map(cargo -> new StockChangeDto.StockChangeItemDto(dbEo.getOutLogicWarehouseId(), cargo.getCargoId(), cargo.getBatch(), Arrays.asList(new StockChangeDto.Stock("balance", new BigDecimal(cargo.getNum()).negate()), new StockChangeDto.Stock("available", new BigDecimal(cargo.getNum()).negate())), cargo.getVersion())).collect(Collectors.toList()));
        this.stockDsl.modifyStock(stockChangeOut);
    }

    @Override
    public void inTransferOrder(InStorageInReqDto storageOrderReqDto, StorageOrderEo storageOrderEo) {
        TransferOrderEo dbEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(storageOrderEo.getOrderSrcId());
        dbEo.setStatus(TransferOrderStatusEnum.FINISH.getStatus());
        List reqStorageOrderDetails = storageOrderReqDto.getStorageOrderDetails();
        StorageOrderDetailEo queryEo = new StorageOrderDetailEo();
        queryEo.setOrderId(storageOrderEo.getId());
        List dbStorageOrderDetails = this.storageOrderDetailDas.select((BaseEo)queryEo);
        if (reqStorageOrderDetails.size() != dbStorageOrderDetails.size()) {
            throw new BizException("\u8bf7\u6c42\u7684\u5165\u5e93\u660e\u7ec6[" + reqStorageOrderDetails.size() + "]\u4e0e\u5b9e\u9645\u660e\u7ec6\u5927\u5c0f[" + dbStorageOrderDetails.size() + "]\u4e0d\u4e00\u81f4");
        }
        this.physicLogicWarehouseIn(dbEo, dbStorageOrderDetails);
        this.diffOrder(storageOrderEo.getOrderSrcId(), dbEo, dbStorageOrderDetails, reqStorageOrderDetails);
        this.transferOrderDas.updateSelective((BaseEo)dbEo);
    }

    private void physicLogicWarehouseIn(TransferOrderEo dbEo, List<StorageOrderDetailEo> detailEos) {
        StockChangeDto stockChangeOut = new StockChangeDto();
        stockChangeOut.setChangeType("STOCK_IN");
        stockChangeOut.setBizType("TRANSFER_ORDER_PHYSICAL_IN");
        stockChangeOut.setOrderNo(dbEo.getId().toString());
        stockChangeOut.setCheckStock(Boolean.valueOf(false));
        stockChangeOut.setItems(detailEos.stream().map(cargo -> new StockChangeDto.StockChangeItemDto(dbEo.getInLogicWarehouseId(), cargo.getCargoId(), cargo.getBatch(), Arrays.asList(new StockChangeDto.Stock("balance", new BigDecimal(cargo.getActualNum())), new StockChangeDto.Stock("available", new BigDecimal(cargo.getActualNum()))), cargo.getVersion())).collect(Collectors.toList()));
        this.stockDsl.modifyStock(stockChangeOut);
    }

    private void diffOrder(Long orderSrcId, TransferOrderEo dbEo, List<StorageOrderDetailEo> dbStorageOrderDetails, List<InStorageDetailReqDto> reqStorageOrderDetails) {
        Map<Long, InStorageDetailReqDto> reqDtoMap = reqStorageOrderDetails.stream().collect(Collectors.toMap(InStorageDetailReqDto::getId, e -> e));
        String username = this.getUsername();
        Long tenantId = dbEo.getTenantId();
        Long instanceId = dbEo.getInstanceId();
        ArrayList dodList = new ArrayList();
        dbStorageOrderDetails.forEach(e -> {
            Long actualNum = ((InStorageDetailReqDto)reqDtoMap.get(e.getId())).getNum();
            if (!e.getNum().equals(actualNum)) {
                DiffOrderDetailEo diffOrderDetailEo = new DiffOrderDetailEo();
                diffOrderDetailEo.setOrderSrcId(dbEo.getId());
                diffOrderDetailEo.setCargoId(e.getCargoId());
                diffOrderDetailEo.setOrderNum(Integer.valueOf(e.getNum().intValue()));
                diffOrderDetailEo.setResultNum(Integer.valueOf(actualNum.intValue()));
                diffOrderDetailEo.setCreatePerson(username);
                diffOrderDetailEo.setTenantId(tenantId);
                diffOrderDetailEo.setInstanceId(instanceId);
                dodList.add(diffOrderDetailEo);
                StorageOrderDetailEo detailEo = new StorageOrderDetailEo();
                detailEo.setId(e.getId());
                detailEo.setActualNum(actualNum);
                this.storageOrderDetailDas.updateSelective((BaseEo)detailEo);
                e.setActualNum(actualNum);
            }
        });
        if (dodList.size() > 0) {
            DiffOrderEo diffOrderEo = new DiffOrderEo();
            diffOrderEo.setOrderSrc("\u4e2d\u53f0->\u4e2d\u53f0");
            diffOrderEo.setOrderSrcId(orderSrcId);
            this.diffOrderDas.insert((BaseEo)diffOrderEo);
            Long id = diffOrderEo.getId();
            dbEo.setDiffOrderId(id);
            dodList.forEach(e -> e.setOrderId(id));
            this.diffOrderDetailDas.insertBatch(dodList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTransferOrder(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.transferOrderDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public TransferOrderRespDto queryTransferOrderById(Long id) {
        TransferOrderEo transferOrderEo = (TransferOrderEo)this.transferOrderDas.selectByPrimaryKey(id);
        if (transferOrderEo == null) {
            return null;
        }
        TransferOrderRespDto transferOrderRespDto = new TransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)transferOrderEo, (BaseVo)transferOrderRespDto);
        AddressEo query = new AddressEo();
        query.setRelatedId(id.toString());
        List address = this.addressDas.select((BaseEo)query, Integer.valueOf(1), Integer.valueOf(1));
        if (address.size() > 0) {
            AddressRespDto addressReqDto = new AddressRespDto();
            DtoHelper.eo2Dto((BaseEo)((BaseEo)address.get(0)), (BaseVo)addressReqDto);
            transferOrderRespDto.setAddressRespDto(addressReqDto);
        }
        return transferOrderRespDto;
    }

    @Override
    public PageInfo<TransferOrderRespDto> queryTransferOrderByPage(TransferOrderQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        String createTimeEnd;
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)transferOrderEo);
        transferOrderEo.setTenantId(this.getTenantId(null));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        String createTimeStart = reqDto.getCreateTimeStart();
        if (StringUtils.hasText((String)createTimeStart)) {
            sqlFilters.add(SqlFilter.ge((String)"create_time", (Object)createTimeStart));
        }
        if (StringUtils.hasText((String)(createTimeEnd = reqDto.getCreateTimeEnd()))) {
            sqlFilters.add(SqlFilter.le((String)"create_time", (Object)createTimeEnd));
        }
        transferOrderEo.setSqlFilters(sqlFilters);
        transferOrderEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.transferOrderDas.selectPage((BaseEo)transferOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, TransferOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        ArrayList storageIds = new ArrayList();
        dtoList.forEach(e -> {
            if (e.getOutStorageId() != 0L) {
                storageIds.add(e.getOutStorageId());
            }
            if (e.getInStorageId() != 0L) {
                storageIds.add(e.getInStorageId());
            }
        });
        if (storageIds.size() > 0) {
            StorageOrderEo storageOrderEo = new StorageOrderEo();
            storageOrderEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", storageIds)));
            Map<Long, Integer> idMapStatus = this.storageOrderDas.select((BaseEo)storageOrderEo, Integer.valueOf(1), Integer.valueOf(storageIds.size())).stream().collect(Collectors.toMap(BaseEo::getId, StdStorageOrderEo::getStatus));
            dtoList.forEach(e -> {
                Long inStorageId;
                Long outStorageId = e.getOutStorageId();
                if (outStorageId != 0L) {
                    Integer outStatus = (Integer)idMapStatus.get(outStorageId);
                    e.setOutStatus(OutStorageOrderStatusEnum.nameOf((Integer)outStatus));
                }
                if ((inStorageId = e.getInStorageId()) != 0L) {
                    Integer inStatus = (Integer)idMapStatus.get(inStorageId);
                    e.setInStatus(InStorageOrderStatusEnum.nameOf((Integer)inStatus));
                }
            });
        }
        return dtoPageInfo;
    }
}

