/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.InventoryShareStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCheckItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoStorageInfoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventoryCountDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.util.TradeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseCargoService;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.CargoStorageCacheUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StdCargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class WarehouseCargoService
implements IWarehouseCargoService {
    private static final Logger logger = LoggerFactory.getLogger(IWarehouseCargoService.class);
    @Autowired
    private CargoStorageDas cargoStorageDas;
    @Autowired
    private WarehouseDas warehouseDas;
    @Autowired
    private CargoDas cargoDas;
    @Resource
    private CargoStorageCacheUtils cargoStorageCacheUtils;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public void batchAdd(WarehouseCargoCreateReqDto warehouseCargoCreateReqDto) {
        logger.info("\u65b0\u589e\u4ed3\u5e93\u8d27\u54c1\u4fe1\u606f\uff0c\u5165\u53c2warehouseCargoCreateReqDto\uff1a{}", (Object)JSON.toJSONString((Object)warehouseCargoCreateReqDto));
        Long warehouseId = warehouseCargoCreateReqDto.getWarehouseId();
        List cargoIds = warehouseCargoCreateReqDto.getCargoIds();
        if (null == warehouseId) {
            throw new BizException("\u8bf7\u9009\u62e9\u65b0\u589e\u6570\u636e\u7684\u4ed3\u5e93\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)cargoIds)) {
            throw new BizException("\u8bf7\u9009\u62e9\u8d27\u54c1\uff01");
        }
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(warehouseId);
        if (null == warehouseEo) {
            throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u4ed3\u5e93\u4fe1\u606f");
        }
        ArrayList cargoStorageEos = new ArrayList();
        cargoIds.forEach(cargoId -> {
            CargoStorageEo select = new CargoStorageEo();
            select.setWarehouseId(warehouseId);
            select.setCargoId(cargoId);
            CargoStorageEo cargoStorage = (CargoStorageEo)this.cargoStorageDas.selectOne((BaseEo)select);
            if (null == cargoStorage) {
                CargoEo cargoEo = (CargoEo)this.cargoDas.selectByPrimaryKey(cargoId);
                if (null == cargoEo) {
                    throw new BizException("\u627e\u4e0d\u5230\u5bf9\u5e94\u4ed3\u5e93\u4fe1\u606f");
                }
                CargoStorageEo cargoStorageEo = new CargoStorageEo();
                cargoStorageEo.setGroupId(Long.valueOf(-1L));
                cargoStorageEo.setBalance(BigDecimal.ZERO);
                cargoStorageEo.setPreempt(BigDecimal.ZERO);
                cargoStorageEo.setAvailable(BigDecimal.ZERO);
                cargoStorageEo.setIntransit(BigDecimal.ZERO);
                cargoStorageEo.setFuturesInventory(Long.valueOf(0L));
                cargoStorageEo.setFuturesIssued(Long.valueOf(0L));
                cargoStorageEo.setPending(Long.valueOf(0L));
                cargoStorageEo.setImperfections(Long.valueOf(0L));
                cargoStorageEo.setIndemnity(Long.valueOf(0L));
                cargoStorageEo.setWarehouseId(warehouseId);
                cargoStorageEo.setWarehouseCode(warehouseEo.getCode());
                cargoStorageEo.setWarehouseName(warehouseEo.getName());
                cargoStorageEo.setWarehouseType(warehouseEo.getType());
                cargoStorageEo.setWarehouseSubType(warehouseEo.getSubType());
                cargoStorageEo.setCargoId(cargoId);
                cargoStorageEo.setCargoCode(cargoEo.getCode());
                cargoStorageEo.setCargoName(cargoEo.getName());
                cargoStorageEo.setArtNo(cargoEo.getArtNo());
                cargoStorageEo.setBarCode(cargoEo.getBarCode());
                cargoStorageEo.setInventoryShareStatus(InventoryShareStatusEnum.CLOSE.getStatus());
                cargoStorageEo.setTenantId(warehouseEo.getTenantId());
                cargoStorageEo.setInstanceId(warehouseEo.getInstanceId());
                cargoStorageEos.add(cargoStorageEo);
            } else {
                logger.info("\u4ed3\u5e93\u8d27\u54c1\u5173\u8054\u5df2\u5b58\u5728\uff0c\u76f4\u63a5\u8df3\u8fc7.warehouseId:{}, cargoId:{}", (Object)warehouseId, cargoId);
            }
        });
        if (!CollectionUtils.isEmpty(cargoStorageEos)) {
            this.cargoStorageDas.insertBatch(cargoStorageEos);
            logger.info("\u65b0\u589e\u4ed3\u5e93\u8d27\u54c1\u4fe1\u606f\uff0cwarehouseId\uff1a{}\uff0ccargoIds\uff1a{}\uff0c\u65b0\u589e\u6761\u6570\uff1a{}", new Object[]{warehouseId, cargoIds, cargoStorageEos.size()});
        }
    }

    @Override
    public PageInfo<WarehouseCargoRespDto> page(WarehouseCargoReqDto warehouseCargoReqDto, Integer pageavailable, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageavailable.intValue());
        pageInfo.setPageSize(pageSize.intValue());
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        BeanUtils.copyProperties((Object)warehouseCargoReqDto, (Object)cargoStorageEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)warehouseCargoReqDto.getCargoName())) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).like("cargoName", (Object)("%" + warehouseCargoReqDto.getCargoName() + "%")).filters());
            cargoStorageEo.setCargoName(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseCargoReqDto.getWarehouseName())) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).like("warehouseName", (Object)("%" + warehouseCargoReqDto.getWarehouseName() + "%")).filters());
            cargoStorageEo.setWarehouseName(null);
        }
        if (StringUtils.isNotBlank((CharSequence)warehouseCargoReqDto.getCargoCode())) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).like("cargoCode", (Object)("%" + warehouseCargoReqDto.getCargoCode() + "%")).filters());
            cargoStorageEo.setCargoCode(null);
        }
        if (StringUtils.isNotBlank((CharSequence)warehouseCargoReqDto.getArtNo())) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).like("artNo", (Object)("%" + warehouseCargoReqDto.getArtNo() + "%")).filters());
            cargoStorageEo.setArtNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)warehouseCargoReqDto.getArtNo())) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).like("artNo", (Object)("%" + warehouseCargoReqDto.getArtNo() + "%")).filters());
            cargoStorageEo.setArtNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)warehouseCargoReqDto.getWarehouseType())) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouseType", (Object)warehouseCargoReqDto.getWarehouseType()).filters());
            cargoStorageEo.setWarehouseType(null);
        }
        if (null != warehouseCargoReqDto.getWarehouseSubType()) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouseSubType", (Object)warehouseCargoReqDto.getWarehouseSubType()).filters());
            cargoStorageEo.setWarehouseSubType(null);
        }
        Integer collectionMethod = warehouseCargoReqDto.getCollectionMethod();
        Long preemptMin = warehouseCargoReqDto.getPreemptMin();
        Long preemptMax = warehouseCargoReqDto.getPreemptMax();
        if (null != collectionMethod && collectionMethod == 0 && null != preemptMin && null != preemptMax) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).le("balance", (Object)preemptMin).ge("balance", (Object)preemptMax).filters());
        }
        if (null != collectionMethod && collectionMethod == 1 && null != preemptMin && null != preemptMax) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).le("preempt", (Object)preemptMin).ge("preempt", (Object)preemptMax).filters());
        }
        if (null != collectionMethod && collectionMethod == 2 && null != preemptMin && null != preemptMax) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).le("available", (Object)preemptMin).ge("available", (Object)preemptMax).filters());
        }
        if (null != collectionMethod && collectionMethod == 3 && null != preemptMin && null != preemptMax) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).le("available", (Object)preemptMin).ge("available", (Object)preemptMax).filters());
        }
        if (null != collectionMethod && collectionMethod == 4 && null != preemptMin && null != preemptMax) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).le("pending", (Object)preemptMin).ge("pending", (Object)preemptMax).filters());
        }
        if (null != collectionMethod && collectionMethod == 5 && null != preemptMin && null != preemptMax) {
            sqlFilters.addAll(SqlFilterBuilder.create(CargoStorageEo.class).le("intransit", (Object)preemptMin).ge("intransit", (Object)preemptMax).filters());
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseCargoReqDto.getUpdateTimeStart())) {
            sqlFilters.add(SqlFilter.ge((String)"updateTime", (Object)warehouseCargoReqDto.getUpdateTimeStart()));
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseCargoReqDto.getUpdateTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"updateTime", (Object)warehouseCargoReqDto.getUpdateTimeEnd()));
        }
        cargoStorageEo.setSqlFilters(sqlFilters);
        cargoStorageEo.setOrderByDesc("updateTime");
        PageInfo eoPageInfo = this.cargoStorageDas.selectPage((BaseEo)cargoStorageEo, pageavailable, pageSize);
        if (!CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            BeanUtils.copyProperties((Object)eoPageInfo, (Object)pageInfo);
            ArrayList dtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, WarehouseCargoRespDto.class);
            pageInfo.setList(dtoList);
        }
        return pageInfo;
    }

    @Override
    public void checkCargoStorage(CargoStorageCheckReqDto cargoStorageCheckReqDto) {
        CargoStorageEo cargoStorageSelect = new CargoStorageEo();
        cargoStorageSelect.setWarehouseCode(cargoStorageCheckReqDto.getWarehouseCode());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        List cargoStorageCheckItems = cargoStorageCheckReqDto.getCargos();
        List cargoCodes = cargoStorageCheckItems.stream().map(CargoStorageCheckItemReqDto::getCargoCode).collect(Collectors.toList());
        sqlFilters.add(SqlFilter.in((String)"cargoCode", cargoCodes));
        cargoStorageSelect.setSqlFilters(sqlFilters);
        List cargoStorages = this.cargoStorageDas.select((BaseEo)cargoStorageSelect);
        if (CollectionUtils.isEmpty((Collection)cargoStorages)) {
            logger.error("\u6821\u9a8c\u4ed3\u5e93\u8d27\u54c1\u6570\u636e\u5931\u8d25\uff0c\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u8d27\u54c1\u4fe1\u606f\uff0ccargoStorageCheckReqDto\uff1a{}", (Object)JSON.toJSONString((Object)cargoStorageCheckReqDto));
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u8d27\u54c1\u4fe1\u606f\uff01");
        }
        Map<String, CargoStorageEo> cargoStorageMap = cargoStorages.stream().collect(Collectors.toMap(StdCargoStorageEo::getCargoCode, w -> w));
        for (CargoStorageCheckItemReqDto cargoStorageCheckItem : cargoStorageCheckItems) {
            String cargoCode = cargoStorageCheckItem.getCargoCode();
            CargoStorageEo cargoStorage = cargoStorageMap.get(cargoCode);
            if (null == cargoStorage) {
                logger.error("\u6821\u9a8c\u4ed3\u5e93\u8d27\u54c1\u6570\u636e\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8d27\u54c1\uff1a{}\u4fe1\u606f\uff0ccargoStorageCheckReqDto\uff1a{}", (Object)cargoCode, (Object)JSON.toJSONString((Object)cargoStorageCheckReqDto));
                throw new BizException("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u4ed3\u5e93\u8d27\u54c1\u4fe1\u606f\uff01");
            }
            if (cargoStorage.getAvailable().intValue() >= cargoStorageCheckItem.getCargoNum()) continue;
            logger.error("\u6821\u9a8c\u4ed3\u5e93\u8d27\u54c1\u6570\u636e\u5931\u8d25\uff0c\u8d27\u54c1\uff1a{}\u53ef\u7528\u5e93\u5b58\u6570\u4e0d\u8db3\uff0c\u6240\u9700\u5e93\u5b58\uff1a{}\uff0c\u5b9e\u9645\u53ef\u7528\u5e93\u5b58\uff1a{}\uff0ccargoStorageCheckReqDto\uff1a{}", new Object[]{cargoCode, cargoStorageCheckItem.getCargoNum(), cargoStorage.getAvailable(), JSON.toJSONString((Object)cargoStorageCheckReqDto)});
            throw new BizException("\u4ed3\u5e93\u8d27\u54c1\u201c" + cargoStorage.getCargoName() + "\u201d\u5e93\u5b58\u4e0d\u8db3\uff01");
        }
    }

    @Override
    public void updateInventoryShareStatus(Long id, Integer inventoryShareStatus) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setId(id);
        cargoStorageEo.setInventoryShareStatus(inventoryShareStatus);
        this.cargoStorageDas.updateSelective((BaseEo)cargoStorageEo);
        CargoStorageEo storageEo = (CargoStorageEo)this.cargoStorageDas.getMapper().findById(CargoStorageEo.class, id);
        MessageVo messageVo = new MessageVo();
        final InventoryCountDto dto = new InventoryCountDto();
        dto.setWarehouseId(storageEo.getWarehouseId());
        dto.setCargoId(storageEo.getCargoId());
        BigDecimal available = storageEo.getAvailable();
        dto.setNum(0 == inventoryShareStatus ? available.negate() : available);
        dto.setNo(TradeUtil.generateTradeNo(storageEo.getCargoId().toString()));
        messageVo.setData((Object)new ArrayList<InventoryCountDto>(){
            {
                this.add(dto);
            }
        });
        this.commonsMqService.publishMessage("inventoryChangeInMessagetest", (Object)messageVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void subCargoStorage(List<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtos) {
        ArrayList<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtoList = new ArrayList<CargoStorageInfoCreateReqDto>();
        AtomicBoolean subFlag = new AtomicBoolean(false);
        try {
            cargoStorageInfoCreateReqDtos.forEach(cargoStorageInfoCreateReqDto -> {
                boolean success;
                List select;
                cargoStorageInfoCreateReqDtoList.add((CargoStorageInfoCreateReqDto)cargoStorageInfoCreateReqDto);
                Long cargoId = cargoStorageInfoCreateReqDto.getCargoId();
                Long warehouseId = cargoStorageInfoCreateReqDto.getWarehouseId();
                BigDecimal buyStock = cargoStorageInfoCreateReqDto.getNum();
                Integer type = cargoStorageInfoCreateReqDto.getType();
                BigDecimal zero = BigDecimal.ZERO;
                BigDecimal available = this.cargoStorageCacheUtils.queryCargoStorageCacheBigDecimal(warehouseId, cargoId, cargoId);
                if (available.compareTo(zero) == 0 && !CollectionUtils.isEmpty((Collection)(select = this.cargoStorageDas.select(SqlFilterBuilder.create(CargoStorageEo.class).eq("warehouse_id", (Object)warehouseId).eq("cargo_id", (Object)cargoId).eo())))) {
                    available = ((CargoStorageEo)select.get(0)).getAvailable();
                    this.cargoStorageCacheUtils.addCargoStorageCacheDouble(warehouseId, cargoId, cargoId, available.doubleValue());
                }
                if (type != 3 && available.compareTo(zero) == 0) {
                    throw new BizException("\u8d27\u54c1\u5e93\u5b58[warehouseId=" + warehouseId + ",cargoId=" + cargoId + "]\u4e3a\u96f6");
                }
                if (buyStock.compareTo(BigDecimal.ZERO) < 0) {
                    buyStock = buyStock.negate();
                }
                if (type == 3) {
                    success = this.cargoStorageCacheUtils.addCargoStorageCacheDouble(warehouseId, cargoId, cargoId, buyStock.doubleValue());
                } else {
                    if (available.compareTo(buyStock) < 0) {
                        if (type == 4) {
                            buyStock = available;
                        } else {
                            throw new BizException("\u8d27\u54c1\u5e93\u5b58[warehouseId=" + warehouseId + ",cargoId=" + cargoId + "]\u4e0d\u8db3");
                        }
                    }
                    success = this.cargoStorageCacheUtils.subCargoStorageCacheDouble(warehouseId, cargoId, cargoId, buyStock.doubleValue());
                }
                subFlag.set(success);
                if (!subFlag.get()) {
                    throw new InventoryBusinessRuntimeException(InventoryExceptionCode.CARGO_NOT_ENOUGH);
                }
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString((Object)cargoStorageInfoCreateReqDto));
                logger.info("mq\u53d1\u9001\u6263\u51cf\u5e93\u5b58\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)messageVo));
                this.commonsMqService.publishMessage("cargo_storage7", (Object)messageVo);
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            if (subFlag.get()) {
                this.rollbackOutCargoStorage(cargoStorageInfoCreateReqDtoList);
            }
            throw e;
        }
    }

    @Override
    public void addCargoStorage(List<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtos) {
        ArrayList<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtoList = new ArrayList<CargoStorageInfoCreateReqDto>();
        try {
            cargoStorageInfoCreateReqDtos.forEach(cargoStorageInfoCreateReqDto -> {
                cargoStorageInfoCreateReqDtoList.add((CargoStorageInfoCreateReqDto)cargoStorageInfoCreateReqDto);
                Long cargoId = cargoStorageInfoCreateReqDto.getCargoId();
                Long warehouseId = cargoStorageInfoCreateReqDto.getWarehouseId();
                BigDecimal buyStock = cargoStorageInfoCreateReqDto.getNum();
                this.cargoStorageCacheUtils.addCargoStorageCacheDouble(warehouseId, cargoId, cargoId, buyStock.doubleValue());
                MessageVo messageVo = new MessageVo();
                messageVo.setData((Object)JSON.toJSONString((Object)cargoStorageInfoCreateReqDto));
                logger.info("mq\u53d1\u9001\u589e\u52a0\u5e93\u5b58\u5185\u5bb9:{}", (Object)JSON.toJSONString((Object)messageVo));
                this.commonsMqService.publishMessage("cargo_storage7", (Object)messageVo);
            });
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.rollbackIntCargoStorage(cargoStorageInfoCreateReqDtoList);
            throw e;
        }
    }

    private void rollbackOutCargoStorage(List<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtos) {
        cargoStorageInfoCreateReqDtos.forEach(changeLogEo -> {
            logger.info("\u8d27\u54c1redis\u6263\u51cf\u7f13\u5b58\u56de\u9000:{}", (Object)JSON.toJSONString((Object)changeLogEo));
            if (changeLogEo != null && changeLogEo.getNum() != null && changeLogEo.getNum().compareTo(BigDecimal.ZERO) != 0) {
                this.cargoStorageCacheUtils.addCargoStorageCacheDouble(changeLogEo.getWarehouseId(), changeLogEo.getCargoId(), changeLogEo.getCargoId(), changeLogEo.getNum().doubleValue());
            }
        });
    }

    private void rollbackIntCargoStorage(List<CargoStorageInfoCreateReqDto> cargoStorageInfoCreateReqDtos) {
        cargoStorageInfoCreateReqDtos.forEach(changeLogEo -> {
            logger.info("\u8d27\u54c1redis\u589e\u52a0\u7f13\u5b58\u56de\u9000:{}", (Object)JSON.toJSONString((Object)changeLogEo));
            if (changeLogEo != null && changeLogEo.getNum() != null && changeLogEo.getNum().compareTo(BigDecimal.ZERO) != 0) {
                this.cargoStorageCacheUtils.subCargoStorageCacheDouble(changeLogEo.getWarehouseId(), changeLogEo.getCargoId(), changeLogEo.getCargoId(), changeLogEo.getNum().doubleValue());
            }
        });
    }
}

