/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.DeliveryRouteRuleItemEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.constants.PageConstants;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.OrderRouteRuleQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DeliveryRouteRuleItemRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.OrderRouteRuleRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IOrderRouteRuleService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseRouteScoreService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseRouteScoreDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseRouteScoreEo;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WarehouseRouteScoreServiceImpl
implements IWarehouseRouteScoreService {
    private static Logger logger = LoggerFactory.getLogger(WarehouseRouteScoreServiceImpl.class);
    @Autowired
    private WarehouseDas warehouseDas;
    @Autowired
    private WarehouseRouteScoreDas warehouseRouteScoreDas;
    @Autowired
    private IOrderRouteRuleService orderRouteRuleService;

    @Override
    public void initScore() {
        Thread.currentThread().setName("WAREHOUSE-ROUTE-SCORE-" + UUID.randomUUID().toString());
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u6240\u6709\u4ed3\u5e93\u6240\u6709\u6e20\u9053\u8def\u7531\u5f97\u5206...");
        long stime = System.currentTimeMillis();
        Integer pageNum = PageConstants.PAGE_ONE;
        WarehouseEo warehouse = new WarehouseEo();
        OrderRouteRuleQueryReqDto orderRouteRuleQueryReqDto = new OrderRouteRuleQueryReqDto();
        orderRouteRuleQueryReqDto.setStatus(Integer.valueOf(0));
        List routeRules = this.orderRouteRuleService.queryRouteRulesByPage(orderRouteRuleQueryReqDto, PageConstants.PAGE_ONE, PageConstants.PAGE_SIZE_1000).getList();
        while (true) {
            logger.info("\u5f00\u59cb\u5904\u7406\u7b2c{}\u9875\u4ed3\u5e93\u8def\u7531\u5f97\u5206...", (Object)pageNum);
            PageInfo warehouseEoPageInfo = this.warehouseDas.selectPage((BaseEo)warehouse, pageNum, PageConstants.PAGE_SIZE_1000);
            List list = warehouseEoPageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.handleRouteScore(list, routeRules);
            }
            logger.info("\u5904\u7406\u7b2c{}\u9875\u4ed3\u5e93\u8def\u7531\u5f97\u5206\u7ed3\u675f\uff01.", (Object)pageNum);
            if (warehouseEoPageInfo.getPageNum() == warehouseEoPageInfo.getPages()) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        long etime = System.currentTimeMillis();
        logger.info("\u8ba1\u7b97\u6240\u6709\u4ed3\u5e93\u6240\u6709\u6e20\u9053\u8def\u7531\u5f97\u5206\u7ed3\u675f,\u603b\u5171\u8017\u65f6\uff1a{}s", (Object)Float.valueOf((float)(etime - stime) / 1000.0f));
    }

    private void handleRouteScore(List<WarehouseEo> list, List<OrderRouteRuleRespDto> routeRules) {
        list.stream().forEach(warehouseEo -> routeRules.stream().forEach(routeRuleDto -> {
            Map<String, DeliveryRouteRuleItemRespDto> routeMap = this.getRouteMap((OrderRouteRuleRespDto)routeRuleDto);
            WarehouseRouteScoreEo select = new WarehouseRouteScoreEo();
            select.setWarehouseCode(warehouseEo.getCode());
            select.setApplicableChannel(routeRuleDto.getApplicableChannel());
            WarehouseRouteScoreEo oriScoreEo = (WarehouseRouteScoreEo)this.warehouseRouteScoreDas.selectOne((BaseEo)select);
            this.handleSore((WarehouseEo)warehouseEo, (OrderRouteRuleRespDto)routeRuleDto, oriScoreEo, routeMap);
        }));
    }

    private void handleSore(WarehouseEo warehouseEo, OrderRouteRuleRespDto routeRuleDto, WarehouseRouteScoreEo routeScoreEo, Map<String, DeliveryRouteRuleItemRespDto> routeMap) {
        Integer deliverThresholdWeight = null == routeMap.get(DeliveryRouteRuleItemEnum.DELIVER_THRESHOLD.getType()) ? 0 : routeMap.get(DeliveryRouteRuleItemEnum.DELIVER_THRESHOLD.getType()).getRation();
        Integer deliverEfficiencyWeight = null == routeMap.get(DeliveryRouteRuleItemEnum.DELIVER_EFFICIENCY.getType()) ? 0 : routeMap.get(DeliveryRouteRuleItemEnum.DELIVER_EFFICIENCY.getType()).getRation();
        Integer deliverCreditWeight = null == routeMap.get(DeliveryRouteRuleItemEnum.DELIVER_CREDIT.getType()) ? 0 : routeMap.get(DeliveryRouteRuleItemEnum.DELIVER_CREDIT.getType()).getRation();
        Integer totalScore = 0;
        WarehouseRouteScoreEo warehouseRouteScoreEo = new WarehouseRouteScoreEo();
        if (null == routeScoreEo) {
            Integer deliverThresholdValue = warehouseEo.getDeliverThresholdValue();
            Integer deliverTimeLimit = warehouseEo.getDeliverTimeLimit();
            Integer creditValue = warehouseEo.getCreditValue();
            warehouseRouteScoreEo.setWarehouseCode(warehouseEo.getCode());
            warehouseRouteScoreEo.setWarehouseType(warehouseEo.getType());
            warehouseRouteScoreEo.setApplicableChannel(routeRuleDto.getApplicableChannel());
            warehouseRouteScoreEo.setDeliverNum(Integer.valueOf(0));
            warehouseRouteScoreEo.setDeliverThresholdLeft(deliverThresholdValue);
            warehouseRouteScoreEo.setDeliverEfficiency(deliverTimeLimit);
            warehouseRouteScoreEo.setCreditValue(creditValue);
            totalScore = totalScore + deliverThresholdValue * deliverThresholdWeight + deliverTimeLimit * deliverEfficiencyWeight + creditValue * deliverCreditWeight;
            warehouseRouteScoreEo.setTotalScore(totalScore);
            this.warehouseRouteScoreDas.insert((BaseEo)warehouseRouteScoreEo);
        } else {
            warehouseRouteScoreEo.setId(routeScoreEo.getId());
            totalScore = totalScore + routeScoreEo.getDeliverThresholdLeft() * deliverThresholdWeight + routeScoreEo.getDeliverEfficiency() * deliverEfficiencyWeight + routeScoreEo.getCreditValue() * deliverCreditWeight;
            warehouseRouteScoreEo.setTotalScore(totalScore);
            this.warehouseRouteScoreDas.updateSelective((BaseEo)warehouseRouteScoreEo);
        }
    }

    private Map<String, DeliveryRouteRuleItemRespDto> getRouteMap(OrderRouteRuleRespDto routeRuleDto) {
        HashedMap map = new HashedMap();
        String routeRuleJson = routeRuleDto.getWeightItem();
        List routeRules = JSON.parseArray((String)routeRuleJson, DeliveryRouteRuleItemRespDto.class);
        routeRules.stream().forEach(arg_0 -> WarehouseRouteScoreServiceImpl.lambda$getRouteMap$2((Map)map, arg_0));
        return map;
    }

    private static /* synthetic */ void lambda$getRouteMap$2(Map map, DeliveryRouteRuleItemRespDto deliveryRouteRuleItemRespDto) {
        map.put(deliveryRouteRuleItemRespDto.getType(), deliveryRouteRuleItemRespDto);
    }
}

