/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.AreaDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseCoordinateQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseDeliveryDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseLockReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.WarehouseUnLockReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.ElectricFenceRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.WarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.enums.WarehouseTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.ICargoStorageService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IElectricFenceService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IRAreaWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RAreaWarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.RServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ServiceAreaDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RAreaWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.RServiceAreaEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ServiceAreaEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.RAreaWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.shipping.dao.vo.WarehouseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WarehouseServiceImpl
implements IWarehouseService {
    private static Logger logger = LoggerFactory.getLogger(WarehouseServiceImpl.class);
    @Resource
    private WarehouseDas warehouseDas;
    @Resource
    private RAreaWarehouseDas rAreaWarehouseDas;
    @Resource
    private IRAreaWarehouseService irAreaWarehouseService;
    @Resource
    private IElectricFenceService electricFenceService;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private ICargoStorageService cargoStorageService;
    @Resource
    private ServiceAreaDas serviceAreaDas;
    @Resource
    private RServiceAreaDas rServiceAreaDas;

    @Override
    public Long addWarehouse(WarehouseEo warehouseEo) {
        if (null == warehouseEo.getType()) {
            warehouseEo.setType(WarehouseTypeEnum.PHYSICAL.getCode() + "");
        }
        this.checkWarehouseGeneralUnique(warehouseEo);
        warehouseEo.setMainWarehouse(Integer.valueOf(0));
        this.warehouseDas.insert((BaseEo)warehouseEo);
        return warehouseEo.getId();
    }

    private void checkWarehouseGeneralUnique(WarehouseEo warehouseEo) {
        if (com.dtyunxi.yundt.cube.center.inventory.api.constants.WarehouseTypeEnum.GENERAL.getType().equals(warehouseEo.getType())) {
            WarehouseEo queryGeneral = new WarehouseEo();
            queryGeneral.setTenantId(warehouseEo.getTenantId());
            queryGeneral.setInstanceId(warehouseEo.getInstanceId());
            queryGeneral.setType(com.dtyunxi.yundt.cube.center.inventory.api.constants.WarehouseTypeEnum.GENERAL.getType());
            int generalCount = this.warehouseDas.count((BaseEo)queryGeneral);
            if (generalCount > 0) {
                throw new BizException(InventoryExceptionCode.OVER_ONE.getCode(), InventoryExceptionCode.OVER_ONE.getMsg());
            }
        }
    }

    private void checkWarehouseCodeUnique(WarehouseEo warehouseEo) {
        if (StringUtils.isNotBlank((CharSequence)warehouseEo.getCode())) {
            WarehouseEo eo = new WarehouseEo();
            eo.setTenantId(warehouseEo.getTenantId());
            eo.setInstanceId(warehouseEo.getInstanceId());
            eo.setCode(warehouseEo.getCode());
            int count = this.warehouseDas.count((BaseEo)eo);
            if (count > 0) {
                logger.error(InventoryExceptionCode.WAREHOUSE_CODE_EXIST.getCode(), (Object)InventoryExceptionCode.WAREHOUSE_CODE_EXIST.getMsg());
                throw new CubeException(InventoryExceptionCode.WAREHOUSE_CODE_EXIST.getCode(), InventoryExceptionCode.WAREHOUSE_CODE_EXIST.getMsg());
            }
        }
    }

    @Override
    public void modifyWarehouse(WarehouseEo warehouseEo) {
        WarehouseEo eo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(warehouseEo.getId());
        if (eo == null) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        if (null != warehouseEo.getMainWarehouse() && WarehouseTypeEnum.LOGICAL.getCode() == Integer.parseInt(warehouseEo.getType()) && 1 == warehouseEo.getMainWarehouse() && null != warehouseEo.getParentId()) {
            WarehouseEo warehouseEo1 = (WarehouseEo)SqlFilterBuilder.create(WarehouseEo.class).eq("parent_id", (Object)warehouseEo.getParentId()).eo();
            warehouseEo1.setMainWarehouse(Integer.valueOf(0));
            this.warehouseDas.updateSelectiveSqlFilter((BaseEo)warehouseEo1);
        }
        this.warehouseDas.updateSelective((BaseEo)warehouseEo);
        if (StringUtils.isNotEmpty((CharSequence)warehouseEo.getName()) && !warehouseEo.getName().equals(eo.getName())) {
            CargoStorageEo cargoStorageEo = new CargoStorageEo();
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.eq((String)"warehouseId", (Object)warehouseEo.getId()));
            cargoStorageEo.setSqlFilters(sqlFilterList);
            cargoStorageEo.setWarehouseName(warehouseEo.getName());
            int num = this.cargoStorageDas.updateSelectiveSqlFilter((BaseEo)cargoStorageEo);
            logger.info("\u66f4\u65b0\u5173\u8054\u4ed3\u5e93\u8d27\u54c1\u6570\uff1a{},warehouseId:{}", (Object)num, (Object)warehouseEo.getId());
        }
    }

    @Override
    public void removeById(Long id) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setWarehouseId(id);
        int count = this.cargoStorageDas.count((BaseEo)cargoStorageEo);
        if (count > 0) {
            throw new BizException(InventoryExceptionCode.WARE_HOUSE_EXIT.getCode(), InventoryExceptionCode.WARE_HOUSE_EXIT.getCode());
        }
        this.warehouseDas.logicDeleteById(id);
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setWarehouseId(id);
        RAreaWarehouseEo rAreaWarehouse = (RAreaWarehouseEo)this.rAreaWarehouseDas.selectOne((BaseEo)rAreaWarehouseEo);
        if (rAreaWarehouse != null) {
            Long serviceAreaId = rAreaWarehouse.getServiceAreaId();
            this.rAreaWarehouseDas.logicDelete((BaseEo)rAreaWarehouseEo);
            ServiceAreaEo serviceAreaEo = (ServiceAreaEo)this.serviceAreaDas.selectByPrimaryKey(serviceAreaId);
            if (serviceAreaEo != null) {
                this.serviceAreaDas.logicDeleteById(serviceAreaId);
                RServiceAreaEo rServiceAreaEo = new RServiceAreaEo();
                rServiceAreaEo.setServiceAreaId(serviceAreaId);
                this.rServiceAreaDas.logicDelete((BaseEo)rServiceAreaEo);
            }
        }
    }

    @Override
    public void removeByCode(String code) {
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setCode(code);
        WarehouseEo eo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
        if (null != eo) {
            this.warehouseDas.logicDeleteById(eo.getId());
            Long id = eo.getId();
            RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
            rAreaWarehouseEo.setWarehouseId(id);
            this.rAreaWarehouseDas.delete((BaseEo)rAreaWarehouseEo);
        }
    }

    @Override
    public void removeByIds(List<Long> ids) {
        WarehouseEo warehouseEo = new WarehouseEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        warehouseEo.setSqlFilters(sqlFilters);
        this.warehouseDas.logicDeleteByExample((BaseEo)warehouseEo);
    }

    @Override
    public void removeByServiceAreaId(Long serviceAreaId) {
        List<RAreaWarehouseRespDto> rAreaWarehouseDtos = this.irAreaWarehouseService.queryByServiceAreaId(serviceAreaId);
        if (CollectionUtils.isEmpty(rAreaWarehouseDtos)) {
            logger.info("\u5220\u9664\u5931\u8d25\uff1a\u8be5\u670d\u52a1\u533a\u4e0b\u6ca1\u6709\u4ed3\u5e93");
        } else {
            List<Long> ids = rAreaWarehouseDtos.stream().map(RAreaWarehouseRespDto::getWarehouseId).collect(Collectors.toList());
            this.removeByIds(ids);
        }
    }

    @Override
    public int count(Long instanceId, Long tenantId, Long id, Long groupId) {
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setTenantId(tenantId);
        warehouseEo.setInstanceId(instanceId);
        warehouseEo.setGroupId(groupId);
        warehouseEo.setId(id);
        return this.warehouseDas.count((BaseEo)warehouseEo);
    }

    @Override
    public WarehouseRespDto queryById(Long id) {
        WarehouseEo warehouseEo = (WarehouseEo)this.warehouseDas.selectByPrimaryKey(id);
        WarehouseRespDto warehouseDto = new WarehouseRespDto();
        if (null == warehouseEo) {
            return null;
        }
        DtoHelper.eo2Dto((BaseEo)warehouseEo, (BaseVo)warehouseDto);
        warehouseDto.setInventoryShareStatus(Integer.valueOf(warehouseEo.getInventoryShareStatus() != false ? 1 : 0));
        warehouseDto.setExpressDeliveryStatus(Integer.valueOf(warehouseEo.getExpressDeliveryStatus() != false ? 1 : 0));
        warehouseDto.setCityDeliveryStatus(Integer.valueOf(warehouseEo.getCityDeliveryStatus() != false ? 1 : 0));
        if (StringUtils.isNotEmpty((CharSequence)warehouseEo.getExtension())) {
            warehouseDto.setWarehouseDeliveryDtoList(JSONObject.parseArray((String)warehouseEo.getExtension(), WarehouseDeliveryDto.class));
        }
        return warehouseDto;
    }

    @Override
    public WarehouseRespDto queryById(Long instanceId, Long tenantId, Long id) {
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setInstanceId(instanceId);
        warehouseEo.setTenantId(tenantId);
        warehouseEo.setId(id);
        warehouseEo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
        WarehouseRespDto warehouseDto = new WarehouseRespDto();
        if (null == warehouseEo) {
            logger.error(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), (Object)InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        DtoHelper.eo2Dto((BaseEo)warehouseEo, (BaseVo)warehouseDto);
        return warehouseDto;
    }

    @Override
    public WarehouseRespDto queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setCode(code);
        WarehouseEo respEo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)warehouseEo);
        if (null == respEo) {
            return null;
        }
        WarehouseRespDto warehouseDto = new WarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)respEo, (BaseVo)warehouseDto);
        return warehouseDto;
    }

    @Override
    public PageInfo<WarehouseRespDto> queryByPage(WarehouseEo warehouseEo, Integer pageNum, Integer pageSize) {
        PageInfo warehouseEoPageInfo = this.warehouseDas.selectPage((BaseEo)warehouseEo, pageNum, pageSize);
        PageInfo warehouseDtoPageInfo = new PageInfo();
        ArrayList warehouseDtoList = new ArrayList();
        CubeBeanUtils.copyProperties((Object)warehouseDtoPageInfo, (Object)warehouseEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)warehouseEoPageInfo.getList(), warehouseDtoList, WarehouseRespDto.class);
        warehouseDtoPageInfo.setList(warehouseDtoList);
        return warehouseDtoPageInfo;
    }

    @Override
    public List<WarehouseRespDto> queryByGroupId(Long groupId) {
        WarehouseEo warehouseEo = new WarehouseEo();
        warehouseEo.setGroupId(groupId);
        List warehouseEoList = this.warehouseDas.select((BaseEo)warehouseEo);
        ArrayList<WarehouseRespDto> warehouseDtoList = new ArrayList<WarehouseRespDto>();
        if (!CollectionUtils.isEmpty((Collection)warehouseEoList)) {
            DtoHelper.eoList2DtoList((Collection)warehouseEoList, warehouseDtoList, WarehouseRespDto.class);
        }
        return warehouseDtoList;
    }

    @Override
    public PageInfo<WarehouseRespDto> queryByPage(WarehouseQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        String name;
        WarehouseEo eo = new WarehouseEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        eo.setOrderByDesc("updateTime");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        String code = reqDto.getCode();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            sqlFilters.add(SqlFilter.like((String)"code", (Object)StringUtils.wrapIfMissing((String)code, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)(name = reqDto.getName()))) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)StringUtils.wrapIfMissing((String)name, (String)"%")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateTimeStart())) {
            sqlFilters.add(SqlFilter.ge((String)"updateTime", (Object)reqDto.getUpdateTimeStart()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateTimeEnd())) {
            sqlFilters.add(SqlFilter.le((String)"updateTime", (Object)reqDto.getUpdateTimeEnd()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getTypes())) {
            sqlFilters.add(SqlFilter.in((String)"type", (Object)reqDto.getTypes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getCodes())) {
            sqlFilters.add(SqlFilter.eq((String)"code", (Object)reqDto.getCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getIds())) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)reqDto.getIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getOrganizationIds())) {
            sqlFilters.add(SqlFilter.in((String)"organizationId", (Object)reqDto.getOrganizationIds()));
        }
        eo.setSqlFilters(sqlFilters);
        PageInfo eos = this.warehouseDas.selectPage((BaseEo)eo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        if (!CollectionUtils.isEmpty((Collection)eos.getList())) {
            List<WarehouseRespDto> results = eos.getList().stream().map(warehouseEo -> {
                WarehouseRespDto dto = new WarehouseRespDto();
                DtoHelper.eo2Dto((BaseEo)warehouseEo, (BaseVo)dto);
                dto.setInventoryShareStatus(Integer.valueOf(warehouseEo.getInventoryShareStatus() != false ? 1 : 0));
                dto.setExpressDeliveryStatus(Integer.valueOf(warehouseEo.getExpressDeliveryStatus() != false ? 1 : 0));
                dto.setCityDeliveryStatus(Integer.valueOf(warehouseEo.getCityDeliveryStatus() != false ? 1 : 0));
                return dto;
            }).collect(Collectors.toList());
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eos, (String[])new String[]{"list", "navigatepageNums"});
            results.forEach(dto -> {
                List<AreaDto> areaDtoList = this.queryWarehouseAreaById(dto.getId());
                dto.setServiceAreaList(areaDtoList);
                ElectricFenceRespDto electricFenceRespDto = this.electricFenceService.queryByWarehouseId(dto.getId());
                if (electricFenceRespDto != null) {
                    dto.setGeoFence(electricFenceRespDto.getParamsValue());
                }
            });
            pageInfo.setList(results);
            pageInfo.setNavigatepageNums(eos.getNavigatepageNums());
        }
        return pageInfo;
    }

    @Override
    public PageInfo<WarehouseVo> queryByLogAndLat(WarehouseCoordinateQueryReqDto coordinateQueryReqDto) {
        PageHelper.startPage((int)coordinateQueryReqDto.getPageNum(), (int)coordinateQueryReqDto.getPageSize());
        List warehouseVos = this.warehouseDas.queryByLogAndLat(coordinateQueryReqDto.getLongitude(), coordinateQueryReqDto.getLatitude(), coordinateQueryReqDto.getWarehouseIds());
        return new PageInfo(warehouseVos);
    }

    @Override
    public PageInfo<WarehouseEo> queryWarehouseByFilter(WarehouseQueryReqDto warehouseQueryReqDto, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        StringBuilder filterSql = new StringBuilder();
        filterSql.append(" AND deliver_threshold_left_value > 0 AND type = " + WarehouseTypeEnum.LOGICAL.getCode());
        if (StringUtils.isNotEmpty((CharSequence)warehouseQueryReqDto.getFilterSql())) {
            filterSql.append(" AND " + warehouseQueryReqDto.getFilterSql());
        }
        if (!CollectionUtils.isEmpty((Collection)warehouseQueryReqDto.getIds())) {
            filterSql.append(" AND id IN (" + StringUtils.join((Iterable)warehouseQueryReqDto.getIds(), (String)",") + ") ");
        }
        List warehouseEos = this.warehouseDas.queryWarehouseByFilter(filterSql.toString());
        return new PageInfo(warehouseEos);
    }

    @Override
    public List<AreaDto> queryWarehouseAreaById(Long warehouseId) {
        ArrayList areaDtoList = Lists.newArrayList();
        RAreaWarehouseEo rAreaWarehouseEo = new RAreaWarehouseEo();
        rAreaWarehouseEo.setWarehouseId(warehouseId);
        RAreaWarehouseEo areaWarehouseEo = (RAreaWarehouseEo)this.rAreaWarehouseDas.selectOne((BaseEo)rAreaWarehouseEo);
        if (areaWarehouseEo != null) {
            Long serviceAreaId = areaWarehouseEo.getServiceAreaId();
            RServiceAreaEo rServiceAreaEo = new RServiceAreaEo();
            rServiceAreaEo.setServiceAreaId(serviceAreaId);
            List serviceAreaEoList = this.rServiceAreaDas.select((BaseEo)rServiceAreaEo);
            if (!CollectionUtils.isEmpty((Collection)serviceAreaEoList)) {
                DtoHelper.eoList2DtoList((Collection)serviceAreaEoList, (Collection)areaDtoList, AreaDto.class);
            }
        }
        return areaDtoList;
    }

    @Override
    public Integer addCreditValue(String warehouseCode, Integer changeValue) {
        Integer rowNum = this.warehouseDas.addCreditValue(warehouseCode, changeValue);
        logger.info("\u6263\u51cf\u4ed3\u5e93\u4fe1\u7528\u5206\uff0cwarehouseCode\uff1a{}, changeValue:{}, updates\uff1a{}", new Object[]{warehouseCode, changeValue, rowNum});
        return rowNum;
    }

    @Override
    public void lockWarehouse(WarehouseLockReqDto warehouseLockReqDto) {
        WarehouseEo query = new WarehouseEo();
        query.setCode(warehouseLockReqDto.getWarehouseCode());
        query.setId(warehouseLockReqDto.getWarehouseId());
        WarehouseEo eo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)query);
        if (eo == null) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        eo.setStatus(WarehouseStatusEnum.BANNED.getCode());
        this.warehouseDas.update((BaseEo)eo);
    }

    @Override
    public void unlockWarehouse(WarehouseUnLockReqDto warehouseUnLockReqDto) {
        WarehouseEo query = new WarehouseEo();
        query.setCode(warehouseUnLockReqDto.getWarehouseCode());
        query.setId(warehouseUnLockReqDto.getWarehouseId());
        WarehouseEo eo = (WarehouseEo)this.warehouseDas.selectOne((BaseEo)query);
        if (eo == null) {
            throw new CubeException(InventoryExceptionCode.RECORD_NOT_EXIST.getCode(), InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        }
        eo.setStatus(WarehouseStatusEnum.NORMAL.getCode());
        this.warehouseDas.update((BaseEo)eo);
    }

    @Override
    public List<WarehouseRespDto> queryListByCodes(List<String> codes) {
        if (codes == null || codes.size() <= 0) {
            return null;
        }
        StringBuilder filterSql = new StringBuilder();
        filterSql.append("AND code IN ('" + StringUtils.join(codes, (String)"','") + "') ");
        List warehouseEoList = this.warehouseDas.queryWarehouseByFilter(filterSql.toString());
        ArrayList<WarehouseRespDto> warehouseRespDtoList = new ArrayList<WarehouseRespDto>();
        DtoHelper.eoList2DtoList((Collection)warehouseEoList, warehouseRespDtoList, WarehouseRespDto.class);
        return warehouseRespDtoList;
    }
}

