/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.schedule;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.CargoStorageCacheUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoStorageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageCheckDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.StorageCheckDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageChangeLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageCheckDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.StorageCheckEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageCheckScheduler {
    private Logger logger = LoggerFactory.getLogger(StorageCheckScheduler.class);
    @Resource
    private CargoDas cargoDas;
    @Resource
    private CargoStorageDas cargoStorageDas;
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private StorageCheckDas storageCheckDas;
    @Resource
    private StorageCheckDetailDas storageCheckDetailDas;
    @Resource
    private CargoStorageCacheUtils cargoStorageCacheUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageCheckJob() {
        boolean result = this.cargoStorageCacheUtils.startRecalculate();
        this.logger.info("\u5f00\u542f\u76d8\u70b9\u529f\u80fd\uff0c\u5f00\u542f\u72b6\u6001\u4e3a:{}", (Object)result);
        try {
            if (result) {
                this.waiting();
                int cargoCount = this.cargoDas.count((BaseEo)new CargoEo());
                if (cargoCount > 0) {
                    Integer pageNum = 1;
                    Integer pageSize = 33;
                    Integer cycles = cargoCount / pageSize;
                    if (cargoCount % pageSize != 0) {
                        cycles = cycles + 1;
                    }
                    for (int i = 0; i < cycles; ++i) {
                        PageInfo cargoEoPageInfo = this.cargoDas.selectPage((BaseEo)new CargoEo(), pageNum, pageSize);
                        if (cargoEoPageInfo == null || !CollectionUtils.isNotEmpty((Collection)cargoEoPageInfo.getList())) continue;
                        for (CargoEo cargoEo : cargoEoPageInfo.getList()) {
                            this.storageCheckService(cargoEo);
                        }
                    }
                } else {
                    this.logger.info("\u6ca1\u6709\u9700\u8981\u76d8\u70b9\u7684\u8d27\u54c1");
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.cargoStorageCacheUtils.stopRecalculate();
        }
        this.logger.info("\u76d8\u70b9\u4efb\u52a1\u8c03\u5ea6\u7ed3\u675f");
    }

    @Transactional(rollbackFor={Exception.class})
    private void storageCheckService(CargoEo cargoEo) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setCargoId(cargoEo.getId());
        List cargoStorageEoList = this.cargoStorageDas.select((BaseEo)cargoStorageEo);
        if (CollectionUtils.isNotEmpty((Collection)cargoStorageEoList)) {
            Map<Long, List<CargoStorageEo>> warehouseCargoMap = this.assortByWarehouseId(cargoStorageEoList);
            this.cargoStorageCheckService(warehouseCargoMap, cargoEo.getId());
        }
    }

    private Map<Long, List<CargoStorageEo>> assortByWarehouseId(List<CargoStorageEo> cargoStorageEoList) {
        HashMap<Long, List<CargoStorageEo>> warehouseCargoMap = new HashMap<Long, List<CargoStorageEo>>(8);
        for (CargoStorageEo storageEo : cargoStorageEoList) {
            ArrayList<CargoStorageEo> storageEoList = (ArrayList<CargoStorageEo>)warehouseCargoMap.get(storageEo.getWarehouseId());
            if (storageEoList == null) {
                storageEoList = new ArrayList<CargoStorageEo>();
                warehouseCargoMap.put(storageEo.getWarehouseId(), storageEoList);
            }
            storageEoList.add(storageEo);
        }
        return warehouseCargoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cargoStorageCheckService(Map<Long, List<CargoStorageEo>> warehouseCargoMap, Long cargoId) {
        if (!warehouseCargoMap.isEmpty()) {
            for (Long warehouseId : warehouseCargoMap.keySet()) {
                Date beginTime = this.queryStorageCheckBeginTime(warehouseId, cargoId);
                if (beginTime == null) continue;
                StorageCheckEo storageCheckEo = null;
                List<CargoStorageEo> storageEoList = warehouseCargoMap.get(warehouseId);
                if (CollectionUtils.isNotEmpty(storageEoList)) {
                    boolean lockResult = this.cargoStorageCacheUtils.lockCargo(warehouseId, null, cargoId);
                    try {
                        Date endTime = null;
                        block6: for (CargoStorageEo storageEo : storageEoList) {
                            Integer replayTime = 0;
                            while (true) {
                                if (lockResult) {
                                    StorageCheckDetailEo storageCheckDetailEo = this.addStorageCheckDetailEo(storageEo, beginTime, endTime);
                                    if (endTime == null) {
                                        endTime = storageCheckDetailEo.getCheckEndTime();
                                    }
                                    this.checkCargoStorageCache(storageCheckDetailEo);
                                    storageCheckEo = this.createStorageCheckEo(storageCheckEo, storageCheckDetailEo);
                                    continue block6;
                                }
                                if (replayTime > 7) {
                                    this.logger.info("\u672a\u83b7\u53d6\u5230\u8d27\u54c1\u9501:{}", (Object)JSON.toJSONString((Object)storageEo));
                                    continue block6;
                                }
                                Thread.sleep(1000L);
                                lockResult = this.cargoStorageCacheUtils.lockCargo(storageEo);
                                replayTime = replayTime + 1;
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        this.cargoStorageCacheUtils.releaseCargo(warehouseId, null, cargoId);
                    }
                }
                if (storageCheckEo == null) continue;
                this.storageCheckDas.insert(storageCheckEo);
            }
        }
    }

    private void checkCargoStorageCache(StorageCheckDetailEo storageCheckDetailEo) {
        Long available = this.cargoStorageCacheUtils.queryCargoStorageCache(storageCheckDetailEo.getWarehouseId(), storageCheckDetailEo.getPositionId(), storageCheckDetailEo.getCargoId());
        if (!storageCheckDetailEo.getAvailable().equals(available)) {
            this.logger.info("\u8d27\u54c1\u76d8\u70b9\u68c0\u6d4b\u5230\u8d27\u54c1\u6570\u76ee\u4e0d\u4e00\u81f4:{},available:{}", (Object)JSON.toJSONString((Object)storageCheckDetailEo), (Object)available);
            if (storageCheckDetailEo.getAvailable() > available) {
                this.cargoStorageCacheUtils.addCargoStorageCache(storageCheckDetailEo.getWarehouseId(), storageCheckDetailEo.getPositionId(), storageCheckDetailEo.getCargoId(), storageCheckDetailEo.getActivity() - available);
            } else if (storageCheckDetailEo.getAvailable() < available) {
                this.cargoStorageCacheUtils.subCargoStorageCache(storageCheckDetailEo.getWarehouseId(), storageCheckDetailEo.getPositionId(), storageCheckDetailEo.getCargoId(), available - storageCheckDetailEo.getActivity());
            }
        }
    }

    private StorageCheckEo createStorageCheckEo(StorageCheckEo storageCheckEo, StorageCheckDetailEo storageCheckDetailEo) {
        if (storageCheckEo == null) {
            storageCheckEo = new StorageCheckEo();
            storageCheckEo.setCheckBeginTime(storageCheckDetailEo.getCheckBeginTime());
            storageCheckEo.setCheckEndTime(storageCheckDetailEo.getCheckEndTime());
            storageCheckEo.setWarehouseId(storageCheckDetailEo.getWarehouseId());
            storageCheckEo.setCargoId(storageCheckDetailEo.getCargoId());
            storageCheckEo.setTenantId(storageCheckDetailEo.getTenantId());
            storageCheckEo.setInstanceId(storageCheckDetailEo.getInstanceId());
        }
        if (storageCheckEo != null) {
            this.storageCheckStatistics(storageCheckEo, storageCheckDetailEo);
        }
        return storageCheckEo;
    }

    private StorageCheckDetailEo addStorageCheckDetailEo(CargoStorageEo cargoStorageEo, Date beginTime, Date endTime) {
        StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
        storageChangeLogEo.setWarehouseId(cargoStorageEo.getWarehouseId());
        storageChangeLogEo.setPositionId(cargoStorageEo.getPositionId());
        storageChangeLogEo.setCargoId(cargoStorageEo.getCargoId());
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (endTime == null) {
            endTime = new Date();
        }
        sqlFilterList.add(SqlFilter.gt((String)"create_time", (Object)new DateTime((Object)beginTime).toString("yyyy-MM-dd HH:mm:ss")));
        sqlFilterList.add(SqlFilter.le((String)"create_time", (Object)new DateTime((Object)endTime).toString("yyyy-MM-dd HH:mm:ss")));
        storageChangeLogEo.setSqlFilters(sqlFilterList);
        List storageChangeLogEoList = this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
        StorageCheckDetailEo storageCheckDetailEo = null;
        if (CollectionUtils.isNotEmpty((Collection)storageChangeLogEoList)) {
            storageCheckDetailEo = new StorageCheckDetailEo();
            storageCheckDetailEo.setCheckBeginTime(beginTime);
            storageCheckDetailEo.setCheckEndTime(endTime);
            storageCheckDetailEo.setCargoId(cargoStorageEo.getCargoId());
            storageCheckDetailEo.setPositionId(cargoStorageEo.getPositionId());
            storageCheckDetailEo.setWarehouseId(cargoStorageEo.getWarehouseId());
            storageCheckDetailEo.setTenantId(cargoStorageEo.getTenantId());
            storageCheckDetailEo.setInstanceId(cargoStorageEo.getInstanceId());
            for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
                this.storageCheckDetailStatistics(storageCheckDetailEo, changeLogEo);
            }
            Long available = this.queryAvailable(cargoStorageEo);
            available = available == null || available == 0L ? storageCheckDetailEo.getBalance() : Long.valueOf(available + storageCheckDetailEo.getBalance());
            storageCheckDetailEo.setActivity(available);
        }
        if (storageCheckDetailEo != null) {
            this.storageCheckDetailDas.insert((BaseEo)storageCheckDetailEo);
        }
        return storageCheckDetailEo;
    }

    private Long queryAvailable(CargoStorageEo cargoStorageEo) {
        StorageCheckDetailEo selectEo = new StorageCheckDetailEo();
        selectEo.setWarehouseId(cargoStorageEo.getWarehouseId());
        selectEo.setPositionId(cargoStorageEo.getPositionId());
        selectEo.setCargoId(cargoStorageEo.getCargoId());
        PageInfo checkDetailEoPageInfo = this.storageCheckDetailDas.selectPage((BaseEo)selectEo, Integer.valueOf(1), Integer.valueOf(1));
        if (checkDetailEoPageInfo != null && CollectionUtils.isNotEmpty((Collection)checkDetailEoPageInfo.getList())) {
            return ((StorageCheckDetailEo)checkDetailEoPageInfo.getList().get(0)).getAvailable();
        }
        return null;
    }

    private void storageCheckDetailStatistics(StorageCheckDetailEo storageCheckDetailEo, StorageChangeLogEo storageChangeLogEo) {
        storageCheckDetailEo.setBalance(Long.valueOf(storageCheckDetailEo.getBalance() == null ? storageChangeLogEo.getBalance() : storageCheckDetailEo.getBalance() + storageChangeLogEo.getBalance()));
        storageCheckDetailEo.setAppending(Long.valueOf(storageCheckDetailEo.getAppending() == null ? storageChangeLogEo.getAppending() : storageCheckDetailEo.getAppending() + storageChangeLogEo.getAppending()));
        storageCheckDetailEo.setAllocate(Long.valueOf(storageCheckDetailEo.getAllocate() == null ? storageChangeLogEo.getAllocate() : storageCheckDetailEo.getAllocate() + storageChangeLogEo.getAllocate()));
        storageCheckDetailEo.setIntransit(Long.valueOf(storageCheckDetailEo.getIntransit() == null ? storageChangeLogEo.getIntransit() : storageCheckDetailEo.getIntransit() + storageChangeLogEo.getIntransit()));
        storageCheckDetailEo.setPresell(Long.valueOf(storageCheckDetailEo.getPresell() == null ? storageChangeLogEo.getPresell() : storageCheckDetailEo.getPresell() + storageChangeLogEo.getPresell()));
        storageCheckDetailEo.setActivity(Long.valueOf(storageCheckDetailEo.getActivity() == null ? storageChangeLogEo.getActivity() : storageCheckDetailEo.getActivity() + storageChangeLogEo.getActivity()));
    }

    private void storageCheckStatistics(StorageCheckEo storageCheckEo, StorageCheckDetailEo storageCheckDetailEo) {
        storageCheckEo.setAvailable(Long.valueOf(storageCheckEo.getAvailable() == null ? storageCheckDetailEo.getAvailable() : storageCheckEo.getAvailable() + storageCheckDetailEo.getAvailable()));
        storageCheckEo.setAppending(Long.valueOf(storageCheckEo.getAppending() == null ? storageCheckDetailEo.getAppending() : storageCheckEo.getAppending() + storageCheckDetailEo.getAppending()));
        storageCheckEo.setBalance(Long.valueOf(storageCheckEo.getBalance() == null ? storageCheckDetailEo.getBalance() : storageCheckEo.getBalance() + storageCheckDetailEo.getBalance()));
        storageCheckEo.setAllocate(Long.valueOf(storageCheckEo.getAllocate() == null ? storageCheckDetailEo.getAllocate() : storageCheckEo.getAllocate() + storageCheckDetailEo.getAllocate()));
        storageCheckEo.setIntransit(Long.valueOf(storageCheckEo.getIntransit() == null ? storageCheckDetailEo.getIntransit() : storageCheckEo.getIntransit() + storageCheckDetailEo.getIntransit()));
        storageCheckEo.setPresell(Long.valueOf(storageCheckEo.getPresell() == null ? storageCheckDetailEo.getPresell() : storageCheckEo.getPresell() + storageCheckDetailEo.getPresell()));
        storageCheckEo.setActivity(Long.valueOf(storageCheckEo.getActivity() == null ? storageCheckDetailEo.getActivity() : storageCheckEo.getActivity() + storageCheckDetailEo.getActivity()));
    }

    private Date queryStorageCheckBeginTime(Long warehouseId, Long cargoId) {
        StorageCheckEo checkEo = new StorageCheckEo();
        checkEo.setWarehouseId(warehouseId);
        checkEo.setCargoId(cargoId);
        PageInfo storageCheckEoPageInfo = this.storageCheckDas.selectPage((BaseEo)checkEo, Integer.valueOf(1), Integer.valueOf(1));
        if (storageCheckEoPageInfo == null || CollectionUtils.isEmpty((Collection)storageCheckEoPageInfo.getList())) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 1970);
            calendar.set(2, 0);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        return ((StorageCheckEo)storageCheckEoPageInfo.getList().get(0)).getCheckEndTime();
    }

    private void waiting() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

