/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoStorageEo;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CargoStorageCacheUtils {
    private static final String recalculateCacheStartValue = "1";
    private static final String recalculateCacheStopValue = "0";
    private static final String recalculateCacheKey = "recalculate";
    private static final Logger logger = LoggerFactory.getLogger(CargoStorageCacheUtils.class);
    @Resource
    private ICacheService centerCacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCargoStorageCache(Long warehouseId, Long positionId, Long cargoId, Long num) {
        if (num < 0L) {
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u65b0\u589e\u6570\u76ee\u4e3a\u8d1f:{}", (Object)num);
            num = -num.longValue();
        }
        boolean result = true;
        String cacheKey = this.getCacheKey(warehouseId, positionId);
        boolean storageCheck = this.checkRecalculate();
        try {
            if (storageCheck && !this.lockCargo(warehouseId, positionId, cargoId)) {
                throw new InventoryBusinessRuntimeException(InventoryExceptionCode.STORAGE_CHECK);
            }
            Long resultNum = this.centerCacheService.hincrBy(cacheKey, String.valueOf(cargoId), num);
            if (resultNum == null || resultNum == 0L) {
                result = false;
            }
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u65b0\u589ecacheKey:{},warehouseId:{},positionId:{},cargoId:{},num:{},totalNum:{}", new Object[]{cacheKey, warehouseId, positionId, cargoId, num, resultNum});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (storageCheck) {
                this.releaseCargo(warehouseId, positionId, cargoId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCargoStorageCacheDouble(Long warehouseId, Long positionId, Long cargoId, Double num) {
        if (num < 0.0) {
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u65b0\u589e\u6570\u76ee\u4e3a\u8d1f:{}", (Object)num);
            num = -num.doubleValue();
        }
        boolean result = true;
        String cacheKey = this.getCacheKey(warehouseId, positionId);
        boolean storageCheck = this.checkRecalculate();
        try {
            if (storageCheck && !this.lockCargo(warehouseId, positionId, cargoId)) {
                throw new InventoryBusinessRuntimeException(InventoryExceptionCode.STORAGE_CHECK);
            }
            Double resultNum = this.centerCacheService.hincrBy(cacheKey, String.valueOf(cargoId), num);
            if (resultNum == null || resultNum == 0.0) {
                result = false;
            }
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u65b0\u589ecacheKey:{},warehouseId:{},positionId:{},cargoId:{},num:{},totalNum:{}", new Object[]{cacheKey, warehouseId, positionId, cargoId, num, resultNum});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (storageCheck) {
                this.releaseCargo(warehouseId, positionId, cargoId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subCargoStorageCache(Long warehouseId, Long positionId, Long cargoId, Long num) {
        if (num < 0L) {
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u6263\u51cf\u6570\u76ee\u4e3a\u8d1f:{}", (Object)num);
            num = -num.longValue();
        }
        boolean result = false;
        String cacheKey = this.getCacheKey(warehouseId, positionId);
        boolean storageCheck = this.checkRecalculate();
        try {
            if (storageCheck && !this.lockCargo(warehouseId, positionId, cargoId)) {
                throw new InventoryBusinessRuntimeException(InventoryExceptionCode.STORAGE_CHECK);
            }
            Long ava = this.centerCacheService.hincrBy(cacheKey, String.valueOf(cargoId), Long.valueOf(-num.longValue()));
            if (ava < 0L) {
                ava = this.centerCacheService.hincrBy(cacheKey, String.valueOf(cargoId), num);
                result = false;
            } else {
                result = true;
            }
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u6263\u51cfcacheKey:{},warehouseId:{},positionId:{},cargoId:{},num:{},totalNum:{}", new Object[]{cacheKey, warehouseId, positionId, cargoId, num, ava});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (storageCheck) {
                this.releaseCargo(warehouseId, positionId, cargoId);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subCargoStorageCacheDouble(Long warehouseId, Long positionId, Long cargoId, Double num) {
        if (num < 0.0) {
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u6263\u51cf\u6570\u76ee\u4e3a\u8d1f:{}", (Object)num);
            num = -num.doubleValue();
        }
        boolean result = false;
        String cacheKey = this.getCacheKey(warehouseId, positionId);
        boolean storageCheck = this.checkRecalculate();
        try {
            if (storageCheck && !this.lockCargo(warehouseId, positionId, cargoId)) {
                throw new InventoryBusinessRuntimeException(InventoryExceptionCode.STORAGE_CHECK);
            }
            Double ava = this.centerCacheService.hincrBy(cacheKey, String.valueOf(cargoId), Double.valueOf(-num.doubleValue()));
            if (ava < 0.0) {
                ava = this.centerCacheService.hincrBy(cacheKey, String.valueOf(cargoId), num);
                result = false;
            } else {
                result = true;
            }
            logger.info("redis\u8d27\u54c1\u5e93\u5b58\u6263\u51cfcacheKey:{},warehouseId:{},positionId:{},cargoId:{},num:{},totalNum:{}", new Object[]{cacheKey, warehouseId, positionId, cargoId, num, ava});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (storageCheck) {
                this.releaseCargo(warehouseId, positionId, cargoId);
            }
        }
        return result;
    }

    public Long queryCargoStorageCache(Long warehouseId, Long positionId, Long cargoId) {
        String cacheKey = this.getCacheKey(warehouseId, positionId);
        Long num = (Long)this.centerCacheService.hget(cacheKey, String.valueOf(cargoId), Long.class);
        logger.info("redis\u8d27\u54c1\u5e93\u5b58\u67e5\u8be2cacheKey:{},warehouseId:{},positionId:{},cargoId:{},totalNum:{}", new Object[]{cacheKey, warehouseId, positionId, cargoId, num});
        if (num == null) {
            num = 0L;
        }
        return num;
    }

    public BigDecimal queryCargoStorageCacheBigDecimal(Long warehouseId, Long positionId, Long cargoId) {
        String cacheKey = this.getCacheKey(warehouseId, positionId);
        String hget = (String)this.centerCacheService.hget(cacheKey, String.valueOf(cargoId), String.class);
        logger.info("redis\u8d27\u54c1\u5e93\u5b58\u67e5\u8be2cacheKey:{},warehouseId:{},positionId:{},cargoId:{},totalNum:{}", new Object[]{cacheKey, warehouseId, positionId, cargoId, hget});
        BigDecimal num = StringUtils.hasText((String)hget) ? new BigDecimal(hget) : BigDecimal.ZERO;
        num = num.setScale(2, 4);
        return num;
    }

    private String getCacheKey(Long warehouseId, Long positionId) {
        return "CargoStorage_" + warehouseId + "_" + positionId;
    }

    public boolean checkRecalculate() {
        return recalculateCacheStartValue.equals(this.centerCacheService.getCache(recalculateCacheKey, String.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRecalculate() {
        boolean result = true;
        String sign = (String)this.centerCacheService.getCache(recalculateCacheKey, String.class);
        if (!recalculateCacheStartValue.equals(sign)) {
            Class<CargoStorageCacheUtils> clazz = CargoStorageCacheUtils.class;
            synchronized (CargoStorageCacheUtils.class) {
                sign = (String)this.centerCacheService.getCache(recalculateCacheKey, String.class);
                if (!recalculateCacheStartValue.equals(sign)) {
                    this.centerCacheService.setPersistCache(recalculateCacheKey, (Object)recalculateCacheStartValue);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            result = false;
        }
        {
            logger.info("\u5f00\u542f\u76d8\u70b9\u529f\u80fdsign:{},result:{}", (Object)sign, (Object)result);
            return result;
        }
    }

    public boolean stopRecalculate() {
        return this.centerCacheService.setPersistCache(recalculateCacheKey, (Object)recalculateCacheStopValue);
    }

    public boolean lockCargo(CargoStorageEo cargoStorageEo) {
        String cacheKey = this.getCargoCacheKey(cargoStorageEo);
        boolean result = this.centerCacheService.add(cacheKey, (Object)recalculateCacheStartValue, 600);
        logger.info("\u8d27\u54c1\u9501key:{},result:{}", (Object)cacheKey, (Object)result);
        return result;
    }

    public boolean lockCargo(Long warehouseId, Long positionId, Long cargoId) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setWarehouseId(warehouseId);
        cargoStorageEo.setPositionId(positionId);
        cargoStorageEo.setCargoId(cargoId);
        return this.lockCargo(cargoStorageEo);
    }

    public boolean releaseCargo(Long warehouseId, Long positionId, Long cargoId) {
        CargoStorageEo cargoStorageEo = new CargoStorageEo();
        cargoStorageEo.setWarehouseId(warehouseId);
        cargoStorageEo.setPositionId(positionId);
        cargoStorageEo.setCargoId(cargoId);
        return this.releaseCargo(cargoStorageEo);
    }

    public boolean releaseCargo(CargoStorageEo cargoStorageEo) {
        String cacheKey = this.getCargoCacheKey(cargoStorageEo);
        boolean result = this.centerCacheService.delCache(cacheKey);
        logger.info("\u91ca\u653e\u8d27\u54c1\u9501:{},result:{}", (Object)cacheKey, (Object)result);
        return result;
    }

    private String getCargoCacheKey(CargoStorageEo cargoStorageEo) {
        return cargoStorageEo.getWarehouseId() + "_" + cargoStorageEo.getCargoId();
    }
}

