/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shipping.api.IPackageApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageModReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackagePackedReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageSplitConfigCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageSplitConfigUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageSplitConfigService;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.PackageSplitConfigEo;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="packageApi")
public class PackageApiImpl
implements IPackageApi {
    @Resource
    IPackageService packageService;
    @Resource
    private IPackageSplitConfigService packageSplitConfigService;

    public RestResponse<Void> modifyPackage(@Valid PackageReqDto packageReqDto) {
        this.packageService.modifyPackageManual(packageReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyPackage(Long id, PackageModReqDto packageDto) {
        packageDto.setId(id);
        packageDto.setDeliveryOrderId(null);
        packageDto.setDeliveryOrderNo(null);
        this.packageService.modifyPackage(packageDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> packed(Long id, PackagePackedReqDto packedReqDto) {
        packedReqDto.setId(id);
        this.packageService.packed(packedReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addPackageSplitConfig(PackageSplitConfigCreateReqDto packageSplitConfigCreateReqDto) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        DtoHelper.dto2Eo((BaseVo)packageSplitConfigCreateReqDto, (BaseEo)packageSplitConfigEo);
        return new RestResponse((Object)this.packageSplitConfigService.addPackageSplitConfig(packageSplitConfigEo));
    }

    public RestResponse<Void> modifyPackageSplitConfig(Long id, PackageSplitConfigUpdateReqDto packageSplitConfigUpdateReqDto) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        DtoHelper.dto2Eo((BaseVo)packageSplitConfigUpdateReqDto, (BaseEo)packageSplitConfigEo);
        packageSplitConfigEo.setId(id);
        this.packageSplitConfigService.modifyPackageSplitConfig(packageSplitConfigEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeConfigById(Long id, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        this.packageSplitConfigService.removeByIds(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeConfigByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.packageSplitConfigService.removeByCode(code);
        return RestResponse.VOID;
    }
}

