/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shipping.api.IShippingApi;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.RTtemplateAreaReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingCompanyCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingCompanyUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerConfigCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerConfigUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingPartnerUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingTemplateCreateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.ShippingTemplateUpdateReqDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IRTemplateAreaService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingCompanyService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingRuleService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingTemplateService;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.RTemplateAreaEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingCompanyEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingRuleEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingTemplateEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shippingApi")
public class ShippingApiImpl
implements IShippingApi {
    @Resource
    private IShippingCompanyService shippingCompanyService;
    @Resource
    private IShippingTemplateService shippingTemplateService;
    @Resource
    private IShippingRuleService shippingRuleService;
    @Resource
    private IRTemplateAreaService irTemplateAreaService;
    @Autowired
    private IShippingPartnerService shippingPartnerService;

    public RestResponse<Long> addShippingCompany(ShippingCompanyCreateReqDto shippingCompanyCreateReqDto) {
        ShippingCompanyEo shippingCompanyEo = new ShippingCompanyEo();
        if (null != shippingCompanyCreateReqDto) {
            DtoHelper.dto2Eo((BaseVo)shippingCompanyCreateReqDto, (BaseEo)shippingCompanyEo);
        }
        return new RestResponse((Object)this.shippingCompanyService.addShippingCompany(shippingCompanyEo));
    }

    public RestResponse<Void> modifyShippingCompany(ShippingCompanyUpdateReqDto shippingCompanyUpdateReqDto, Long id) {
        ShippingCompanyEo shippingCompanyEo = new ShippingCompanyEo();
        if (null != shippingCompanyUpdateReqDto) {
            DtoHelper.dto2Eo((BaseVo)shippingCompanyUpdateReqDto, (BaseEo)shippingCompanyEo, (String[])new String[]{"instanceId", "tenantId"});
        }
        shippingCompanyEo.setId(id);
        this.shippingCompanyService.modifyShippingCompany(shippingCompanyEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeCompanyById(Long id, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.shippingCompanyService.removeById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeCompanyByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.shippingCompanyService.removeByCode(code);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addShippingTemplateAndRule(ShippingTemplateCreateReqDto shippingTemplateCreateReqDto) {
        ShippingTemplateEo shippingTemplateEo = new ShippingTemplateEo();
        DtoHelper.dto2Eo((BaseVo)shippingTemplateCreateReqDto, (BaseEo)shippingTemplateEo);
        Long id = this.shippingTemplateService.addShippingTemplate(shippingTemplateEo);
        if (null != id) {
            ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
            DtoHelper.dto2Eo((BaseVo)shippingTemplateCreateReqDto.getShippingRuleCreateReqDto(), (BaseEo)shippingRuleEo);
            shippingRuleEo.setShippingTplId(id);
            shippingRuleEo.setInstanceId(shippingTemplateCreateReqDto.getInstanceId());
            shippingRuleEo.setTenantId(shippingTemplateCreateReqDto.getTenantId());
            this.shippingRuleService.addShippingRule(shippingRuleEo);
        }
        return new RestResponse((Object)id);
    }

    public RestResponse<Void> modifyTemplateAndRule(Long id, ShippingTemplateUpdateReqDto shippingTemplateUpdateReqDto) {
        ShippingTemplateEo shippingTemplateEo = new ShippingTemplateEo();
        DtoHelper.dto2Eo((BaseVo)shippingTemplateUpdateReqDto, (BaseEo)shippingTemplateEo, (String[])new String[]{"instanceId", "tenantId"});
        shippingTemplateEo.setId(id);
        this.shippingTemplateService.modifyShippingTemplate(shippingTemplateEo);
        ShippingRuleEo ruleEo = this.shippingRuleService.queryByShippingTplId(id);
        ShippingRuleEo shippingRuleEo = new ShippingRuleEo();
        if (null != ruleEo && null != shippingTemplateUpdateReqDto.getShippingRuleUpdateReqDto()) {
            DtoHelper.dto2Eo((BaseVo)shippingTemplateUpdateReqDto.getShippingRuleUpdateReqDto(), (BaseEo)shippingRuleEo);
            shippingRuleEo.setId(ruleEo.getId());
        }
        this.shippingRuleService.modifyShippingRule(shippingRuleEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeTemplateById(Long id, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.shippingTemplateService.removeById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeTemplateByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.shippingTemplateService.removeByCode(code);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addRelationToArea(RTtemplateAreaReqDto rTtemplateAreaReqDto) {
        RTemplateAreaEo rTemplateAreaEo = new RTemplateAreaEo();
        DtoHelper.dto2Eo((BaseVo)rTtemplateAreaReqDto, (BaseEo)rTemplateAreaEo);
        this.irTemplateAreaService.addRTemplateArea(rTemplateAreaEo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeRelationByShippingTplId(Long shippingTplId, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        this.irTemplateAreaService.removeByShippingTplId(shippingTplId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addShippingPartner(ShippingPartnerCreateReqDto shippingPartnerCreateReqDto) {
        this.shippingPartnerService.addShippingPartner(shippingPartnerCreateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyShippingPartnerById(Long id, ShippingPartnerUpdateReqDto shippingPartnerUpdateReqDto) {
        this.shippingPartnerService.modifyShippingPartner(id, shippingPartnerUpdateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removePartnerById(Long id, String filter) {
        this.shippingPartnerService.removeById(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> addShippingPartnerConfig(ShippingPartnerConfigCreateReqDto shippingPartnerConfigCreateReqDto) {
        this.shippingPartnerService.addShippingPartnerConfig(shippingPartnerConfigCreateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyShippingPartnerConfigById(Long id, ShippingPartnerConfigUpdateReqDto shippingPartnerConfigUpdateReqDto) {
        this.shippingPartnerService.modifyShippingPartnerConfig(id, shippingPartnerConfigUpdateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeConfigById(Long id, String filter) {
        this.shippingPartnerService.removeConfigById(id);
        return RestResponse.VOID;
    }
}

