/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.apiimpl.query;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.FreightForCargoReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.FreightForOrderReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForCustomerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForOperatorRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IFreightQueryApi;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IFreightChargeService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="freightQueryApi")
public class FreightQueryApiImpl
implements IFreightQueryApi {
    @Resource
    private IFreightChargeService freightChargeService;

    public RestResponse<List<FreightForCustomerRespDto>> queryByCustomer(String filter) {
        FreightForOrderReqDto freightForOrderReqDto = new FreightForOrderReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            freightForOrderReqDto = (FreightForOrderReqDto)JSONObject.parseObject((String)filter, FreightForOrderReqDto.class);
        }
        if (null == freightForOrderReqDto.getInstanceId() || null == freightForOrderReqDto.getTenantId()) {
            throw new BizException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
        return new RestResponse(this.freightChargeService.directToCustomer(freightForOrderReqDto.getOrderDetailReqDtos()));
    }

    public RestResponse<FreightForOperatorRespDto> queryByOperator(String filter) {
        FreightForCargoReqDto freightForCargoReqDto = new FreightForCargoReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            freightForCargoReqDto = (FreightForCargoReqDto)JSONObject.parseObject((String)filter, FreightForCargoReqDto.class);
        }
        if (null == freightForCargoReqDto.getInstanceId() || null == freightForCargoReqDto.getTenantId()) {
            throw new BizException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
        return new RestResponse((Object)this.freightChargeService.directToOperator(freightForCargoReqDto.getCargoDetailReqDtos()));
    }
}

