/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageSplitConfigRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IPackageQueryApi;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageSplitConfigService;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.PackageSplitConfigEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="packageQueryApi")
public class PackageQueryApiImpl
implements IPackageQueryApi {
    @Resource
    IPackageService packageService;
    @Resource
    private IPackageSplitConfigService packageSplitConfigService;

    public RestResponse<PackageRespDto> queryPackageById(Long deliveryOrderId) {
        return new RestResponse((Object)this.packageService.queryByDeliveryOrderId(deliveryOrderId));
    }

    public RestResponse<PackageSplitConfigRespDto> queryConfigById(Long id, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.packageSplitConfigService.queryById(id));
    }

    public RestResponse<PackageShippingLogRespDto> queryPackLogById(Long id) {
        PackageShippingLogRespDto packageShippingLogRespDto = this.packageService.queryPackLogById(id);
        return new RestResponse((Object)packageShippingLogRespDto);
    }

    public RestResponse<PackageSplitConfigRespDto> queryConfigByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.packageSplitConfigService.queryByCode(code));
    }

    public RestResponse<PageInfo<PackageSplitConfigRespDto>> queryConfigByPage(String filter, Integer pageNum, Integer pageSize) {
        PackageSplitConfigEo packageSplitConfigEo = new PackageSplitConfigEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            packageSplitConfigEo = (PackageSplitConfigEo)JSON.parseObject((String)filter, PackageSplitConfigEo.class);
        }
        return new RestResponse(this.packageSplitConfigService.queryByPage(packageSplitConfigEo, pageNum, pageSize));
    }

    public RestResponse<List<PackageSplitConfigRespDto>> queryConfigByGroupId(Long groupId, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse(this.packageSplitConfigService.queryByGroupId(groupId));
    }
}

