/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingCompanyRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerConfigRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingPartnerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingTemplateRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.query.IShippingQueryApi;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IFreightChargeService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingCompanyService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingLogService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingPartnerService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingTemplateService;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingCompanyEo;
import com.dtyunxi.yundt.cube.center.shipping.dao.eo.ShippingTemplateEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="shippingQueryApi")
public class ShippingQueryApiImpl
implements IShippingQueryApi {
    @Resource
    private IShippingLogService shippingLogService;
    @Resource
    private IShippingCompanyService shippingCompanyService;
    @Resource
    private IShippingPartnerService shippingPartnerService;
    @Resource
    private IShippingTemplateService shippingTemplateService;
    @Resource
    private IFreightChargeService freightChargeService;

    public RestResponse<String> queryLogByShippingNo(String shippingNo) {
        return new RestResponse((Object)this.shippingLogService.queryLogByShippingNo(shippingNo));
    }

    public RestResponse<ShippingCompanyRespDto> queryCompanyById(Long id, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.shippingCompanyService.queryById(id));
    }

    public RestResponse<ShippingCompanyRespDto> queryCompanyByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.shippingCompanyService.queryByCode(code));
    }

    public RestResponse<PageInfo<ShippingCompanyRespDto>> queryCompanyByPage(String filter, Integer pageNum, Integer pageSize) {
        ShippingCompanyEo shippingCompanyEo = new ShippingCompanyEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            shippingCompanyEo = (ShippingCompanyEo)JSON.parseObject((String)filter, ShippingCompanyEo.class);
        }
        return new RestResponse(this.shippingCompanyService.queryByPage(shippingCompanyEo, pageNum, pageSize));
    }

    public RestResponse<ShippingPartnerRespDto> queryPartnerById(Long id, String filter) {
        return new RestResponse((Object)this.shippingPartnerService.getById(id));
    }

    public RestResponse<ShippingPartnerConfigRespDto> queryConfigById(Long id, String filter) {
        return new RestResponse((Object)this.shippingPartnerService.getConfigById(id));
    }

    public RestResponse<ShippingTemplateRespDto> queryTemplateById(Long id, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.shippingTemplateService.queryById(id));
    }

    public RestResponse<ShippingTemplateRespDto> queryTemplateByCode(String code, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse((Object)this.shippingTemplateService.queryByCode(code));
    }

    public RestResponse<List<ShippingTemplateRespDto>> queryTemplateByGroupId(Long groupId, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse(this.shippingTemplateService.queryByGroupId(groupId));
    }

    public RestResponse<List<ShippingTemplateRespDto>> queryTemplateByServiceAreaId(Long serviceAreaId, String filter) {
        RequestDto requestDto = new RequestDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            requestDto = (RequestDto)JSON.parseObject((String)filter, RequestDto.class);
        }
        return new RestResponse(this.shippingTemplateService.queryByServiceAreaId(serviceAreaId));
    }

    public RestResponse<PageInfo<ShippingTemplateRespDto>> queryTemplateByPage(String filter, Integer pageNum, Integer pageSize) {
        ShippingTemplateEo shippingTemplateEo = new ShippingTemplateEo();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            shippingTemplateEo = (ShippingTemplateEo)JSON.parseObject((String)filter, ShippingTemplateEo.class);
        }
        return new RestResponse(this.shippingTemplateService.queryByPage(shippingTemplateEo, pageNum, pageSize));
    }
}

