/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.CargoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.CargoDetailReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.OrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForCustomerRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.FreightForOperatorRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.exception.FreightComputeModeEnum;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IFreightChargeService;
import com.dtyunxi.yundt.cube.center.shipping.dao.das.ShippingRuleDas;
import com.dtyunxi.yundt.cube.center.shipping.dao.vo.TemplateAndRuleVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FreightChargeServiceImpl
implements IFreightChargeService {
    private static final Logger logger = LoggerFactory.getLogger(FreightChargeServiceImpl.class);
    @Resource
    private ShippingRuleDas shippingRuleDas;
    @Resource
    private CargoDas cargoDas;

    @Override
    public List<FreightForCustomerRespDto> directToCustomer(List<OrderDetailReqDto> orderDetailReqDtos) {
        if (CollectionUtils.isEmpty(orderDetailReqDtos)) {
            logger.error(InventoryExceptionCode.PARAMETER_ERROR.getCode(), (Object)InventoryExceptionCode.PARAMETER_ERROR.getMsg());
            throw new CubeException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
        for (OrderDetailReqDto reqDto : orderDetailReqDtos) {
            if (null == reqDto.getOrderId()) {
                logger.error(InventoryExceptionCode.PARAMETER_ERROR.getCode(), (Object)InventoryExceptionCode.PARAMETER_ERROR.getMsg());
                throw new CubeException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
            }
            this.validated(reqDto.getCargoDetailReqDtos());
        }
        ArrayList<FreightForCustomerRespDto> freightForCustomerRespDtos = new ArrayList<FreightForCustomerRespDto>();
        for (OrderDetailReqDto orderDetailReqDto : orderDetailReqDtos) {
            FreightForCustomerRespDto freightForCustomerRespDto = new FreightForCustomerRespDto();
            freightForCustomerRespDto.setOrderId(orderDetailReqDto.getOrderId());
            orderDetailReqDto.setCargoDetailReqDtos(this.getCargoDetail(orderDetailReqDto.getCargoDetailReqDtos()));
            List<Long> ids = orderDetailReqDto.getCargoDetailReqDtos().stream().map(CargoDetailReqDto::getShippingTplId).collect(Collectors.toList());
            List<TemplateAndRuleVo> templateAndRuleVos = this.getShippingTplAndRule(ids);
            freightForCustomerRespDto.setFreight(this.getFreight(orderDetailReqDto.getCargoDetailReqDtos(), templateAndRuleVos));
            freightForCustomerRespDtos.add(freightForCustomerRespDto);
        }
        return freightForCustomerRespDtos;
    }

    @Override
    public FreightForOperatorRespDto directToOperator(List<CargoDetailReqDto> cargoDetailReqDtos) {
        this.validated(cargoDetailReqDtos);
        FreightForOperatorRespDto respDto = new FreightForOperatorRespDto();
        cargoDetailReqDtos = this.getCargoDetail(cargoDetailReqDtos);
        List<Long> ids = cargoDetailReqDtos.stream().map(CargoDetailReqDto::getShippingTplId).collect(Collectors.toList());
        List<TemplateAndRuleVo> templateAndRuleVos = this.getShippingTplAndRule(ids);
        if (CollectionUtils.isEmpty(templateAndRuleVos)) {
            return respDto;
        }
        String computeMode = templateAndRuleVos.get(0).getComputeMode();
        if (FreightComputeModeEnum.PIECE.getType().equals(computeMode)) {
            respDto = this.computeByPiece(cargoDetailReqDtos, templateAndRuleVos.get(0));
        } else if (FreightComputeModeEnum.VOLUME.getType().equals(computeMode)) {
            respDto = this.computeByVolume(cargoDetailReqDtos, templateAndRuleVos.get(0));
        } else if (FreightComputeModeEnum.WEIGHT.getType().equals(computeMode)) {
            respDto = this.computeByWeight(cargoDetailReqDtos, templateAndRuleVos.get(0));
        } else if (FreightComputeModeEnum.ORDER.getType().equals(computeMode)) {
            respDto = this.computeByOrder(templateAndRuleVos.get(0));
        }
        return respDto;
    }

    public FreightForOperatorRespDto computeByPiece(List<CargoDetailReqDto> cargoDetailReqDtos, TemplateAndRuleVo templateAndRuleVo) {
        int num = 0;
        for (CargoDetailReqDto cargoDetailReqDto : cargoDetailReqDtos) {
            num = (int)((long)num + cargoDetailReqDto.getNum());
        }
        BigDecimal baseCost = templateAndRuleVo.getBaseCost();
        BigDecimal feight = baseCost.multiply(BigDecimal.valueOf(num));
        FreightForOperatorRespDto respDto = new FreightForOperatorRespDto();
        respDto.setComputeMode(templateAndRuleVo.getComputeMode());
        respDto.setFreight(feight);
        return respDto;
    }

    public FreightForOperatorRespDto computeByOrder(TemplateAndRuleVo templateAndRuleVo) {
        FreightForOperatorRespDto respDto = new FreightForOperatorRespDto();
        respDto.setComputeMode(FreightComputeModeEnum.ORDER.getType());
        respDto.setFreight(templateAndRuleVo.getBaseCost());
        return respDto;
    }

    public FreightForOperatorRespDto computeByVolume(List<CargoDetailReqDto> cargoDetailReqDtos, TemplateAndRuleVo templateAndRuleVo) {
        BigDecimal volumeTotal = new BigDecimal(0);
        for (CargoDetailReqDto cargoDetailReqDto : cargoDetailReqDtos) {
            BigDecimal volume = cargoDetailReqDto.getVolume().multiply(BigDecimal.valueOf(cargoDetailReqDto.getNum()));
            volumeTotal = volumeTotal.add(volume);
        }
        BigDecimal baseCost = templateAndRuleVo.getBaseCost().multiply(templateAndRuleVo.getBaseSpec());
        BigDecimal incr = volumeTotal.subtract(templateAndRuleVo.getBaseSpec()).multiply(templateAndRuleVo.getIncrCost());
        BigDecimal freight = baseCost.add(incr);
        FreightForOperatorRespDto respDto = new FreightForOperatorRespDto();
        respDto.setComputeMode(templateAndRuleVo.getComputeMode());
        respDto.setFreight(freight);
        respDto.setSpec(volumeTotal);
        return respDto;
    }

    public FreightForOperatorRespDto computeByWeight(List<CargoDetailReqDto> cargoDetailReqDtos, TemplateAndRuleVo templateAndRuleVo) {
        BigDecimal quantityTotal = BigDecimal.ZERO;
        for (CargoDetailReqDto cargoDetailReqDto : cargoDetailReqDtos) {
            BigDecimal quantity = cargoDetailReqDto.getQuantity().multiply(BigDecimal.valueOf(cargoDetailReqDto.getNum()));
            quantityTotal = quantityTotal.add(quantity);
        }
        BigDecimal baseCost = templateAndRuleVo.getBaseCost().multiply(templateAndRuleVo.getBaseSpec());
        BigDecimal incr = quantityTotal.subtract(templateAndRuleVo.getBaseSpec()).multiply(templateAndRuleVo.getIncrCost());
        BigDecimal freight = baseCost.add(incr);
        FreightForOperatorRespDto respDto = new FreightForOperatorRespDto();
        respDto.setComputeMode(templateAndRuleVo.getComputeMode());
        respDto.setFreight(freight);
        respDto.setSpec(quantityTotal);
        return respDto;
    }

    public List<TemplateAndRuleVo> getShippingTplAndRule(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            logger.info("\u8fd0\u8d39\u8ba1\u7b97\u5931\u8d25\uff1a\u8fd0\u8d39\u6a21\u677fid\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.FREIGHT_FAIL_ID_NOT_EXISTS);
        }
        List templateAndRuleVos = this.shippingRuleDas.selectByShippingTplIds(ids);
        if (CollectionUtils.isEmpty((Collection)templateAndRuleVos)) {
            logger.info("\u8fd0\u8d39\u8ba1\u7b97\u5931\u8d25\uff1a\u672a\u627e\u5230\u76f8\u5173\u8fd0\u8d39\u6a21\u677f");
            throw new InventoryBusinessRuntimeException(InventoryExceptionCode.FREIGHT_FAIL_CAN_NOT_FIND);
        }
        Collections.sort(templateAndRuleVos, new Comparator<TemplateAndRuleVo>(){

            @Override
            public int compare(TemplateAndRuleVo o1, TemplateAndRuleVo o2) {
                if (o1.getBaseCost().compareTo(o2.getBaseCost()) == 1) {
                    return -1;
                }
                if (o1.getBaseCost().compareTo(o2.getBaseCost()) == 0) {
                    return 0;
                }
                return 1;
            }
        });
        return templateAndRuleVos;
    }

    public BigDecimal getFreight(List<CargoDetailReqDto> cargoDetailReqDtos, List<TemplateAndRuleVo> templateAndRuleVos) {
        List ShippingTplids = templateAndRuleVos.stream().map(TemplateAndRuleVo::getId).collect(Collectors.toList());
        HashSet set = new HashSet();
        set.addAll(ShippingTplids);
        FreightForOperatorRespDto respDto = new FreightForOperatorRespDto();
        if (set.size() == 1) {
            String computeMode = templateAndRuleVos.get(0).getComputeMode();
            if (FreightComputeModeEnum.PIECE.getType().equals(computeMode)) {
                respDto = this.computeByPiece(cargoDetailReqDtos, templateAndRuleVos.get(0));
            } else if (FreightComputeModeEnum.VOLUME.getType().equals(computeMode)) {
                respDto = this.computeByVolume(cargoDetailReqDtos, templateAndRuleVos.get(0));
            } else if (FreightComputeModeEnum.WEIGHT.getType().equals(computeMode)) {
                respDto = this.computeByWeight(cargoDetailReqDtos, templateAndRuleVos.get(0));
            }
        } else {
            respDto = this.computeByOrder(templateAndRuleVos.get(0));
        }
        return respDto.getFreight();
    }

    public void validated(List<CargoDetailReqDto> cargoDetailReqDtos) {
        if (CollectionUtils.isEmpty(cargoDetailReqDtos)) {
            logger.error(InventoryExceptionCode.PARAMETER_ERROR.getCode(), (Object)InventoryExceptionCode.PARAMETER_ERROR.getMsg());
            throw new CubeException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
        for (CargoDetailReqDto reqDto : cargoDetailReqDtos) {
            if (null != reqDto.getCargoId() && reqDto.getNum() >= 1L && null != reqDto.getNum()) continue;
            logger.error(InventoryExceptionCode.PARAMETER_ERROR.getCode(), (Object)InventoryExceptionCode.PARAMETER_ERROR.getMsg());
            throw new CubeException(InventoryExceptionCode.PARAMETER_ERROR.getCode(), InventoryExceptionCode.PARAMETER_ERROR.getMsg());
        }
    }

    public List<CargoDetailReqDto> getCargoDetail(List<CargoDetailReqDto> cargoDetailReqDtos) {
        List cargoIds = cargoDetailReqDtos.stream().map(CargoDetailReqDto::getCargoId).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(cargoIds, (String)",")));
        CargoEo cargoEo = new CargoEo();
        cargoEo.setSqlFilters(sqlFilters);
        List cargoEos = this.cargoDas.select((BaseEo)cargoEo);
        ArrayList<CargoDetailReqDto> reqDtos = new ArrayList<CargoDetailReqDto>();
        block0: for (CargoDetailReqDto sourceDto : cargoDetailReqDtos) {
            for (CargoEo eo : cargoEos) {
                if (!eo.getId().equals(sourceDto.getCargoId())) continue;
                sourceDto.setShippingTplId(eo.getShippingTplId());
                sourceDto.setQuantity(eo.getQuantity());
                sourceDto.setVolume(eo.getVolume());
                reqDtos.add(sourceDto);
                continue block0;
            }
        }
        return reqDtos;
    }
}

