/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shipping.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.channel.shipping.beans.Trace;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.util.Assert;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.PackageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.PackageDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.PackageDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.PackageEo;
import com.dtyunxi.yundt.cube.center.shipping.api.constants.PackageStatusEnum;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDetailDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageModReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackagePackedReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.request.PackageReqDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.PackageShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingCompanyRespDto;
import com.dtyunxi.yundt.cube.center.shipping.api.dto.response.ShippingLogRespDto;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IPackageService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IQueryShippingService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingCompanyService;
import com.dtyunxi.yundt.cube.center.shipping.biz.service.IShippingLogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="packageService")
public class PackageServiceImpl
implements IPackageService {
    private static final Logger logger = LoggerFactory.getLogger(PackageServiceImpl.class);
    @Resource
    private PackageDas packageDas;
    @Resource
    PackageDetailDas packageDetailDas;
    @Resource
    private IQueryShippingService queryShippingService;
    @Resource
    IShippingLogService shippingLogService;
    @Resource
    IShippingCompanyService shippingCompanyService;

    @Override
    public void modifyPackageManual(PackageReqDto packageReqDto) {
        Long deliveryOrderId = packageReqDto.getDeliveryOrderId();
        String deliveryOrderNo = packageReqDto.getDeliveryOrderNo();
        Long orderId = packageReqDto.getOrderId();
        String orderNo = packageReqDto.getOrderNo();
        Long instanceId = packageReqDto.getInstanceId();
        Long tenantId = packageReqDto.getTenantId();
        PackageEo packageEoSelect = new PackageEo();
        packageEoSelect.setDeliveryOrderId(deliveryOrderId);
        List packageEos = this.packageDas.select((BaseEo)packageEoSelect);
        for (PackageEo packageEo1 : packageEos) {
            PackageDetailEo packageDetailEo = new PackageDetailEo();
            packageDetailEo.setPackageId(packageEo1.getId());
            List packageDetailEos = this.packageDetailDas.select((BaseEo)packageDetailEo);
            for (PackageDetailEo packageDetailEo1 : packageDetailEos) {
                this.packageDetailDas.logicDeleteById(packageDetailEo1.getId());
            }
        }
        this.packageDas.deleteByDeliveryOrderId(deliveryOrderId);
        List packageDtos = packageReqDto.getPackageDtos();
        for (PackageDto packageDto : packageDtos) {
            PackageEo packageEo = new PackageEo();
            DtoHelper.dto2Eo((BaseVo)packageDto, (BaseEo)packageEo);
            packageEo.setDeliveryOrderNo(deliveryOrderNo);
            packageEo.setOrderNo(orderNo);
            packageEo.setOrderId(orderId);
            packageEo.setInstanceId(instanceId);
            packageEo.setDeliveryOrderId(deliveryOrderId);
            packageEo.setTenantId(tenantId);
            this.packageDas.insert((BaseEo)packageEo);
            Long packageId = packageEo.getId();
            String packageNo = packageEo.getPackageNo();
            List packageDetailDtos = packageDto.getPackageDetailDtos();
            for (PackageDetailDto packageDetailDto : packageDetailDtos) {
                PackageDetailEo packageDetailEo = new PackageDetailEo();
                packageDetailEo.setPackageId(packageId);
                packageDetailEo.setPackageNo(packageNo);
                packageDetailEo.setCargoId(packageDetailDto.getCargoId());
                packageDetailEo.setNum(packageDetailDto.getNum());
                packageDetailEo.setInstanceId(instanceId);
                packageDetailEo.setTenantId(tenantId);
                this.packageDetailDas.insert((BaseEo)packageDetailEo);
            }
        }
    }

    @Override
    public void modifyPackage(PackageModReqDto packageDto) {
        PackageEo packageEo = new PackageEo();
        if (packageDto.getShippingCompanyId() != null) {
            ShippingCompanyRespDto shippingCompanyRespDto = this.shippingCompanyService.queryById(packageDto.getShippingCompanyId());
            Assert.notNull(shippingCompanyRespDto, "\u5feb\u9012\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        DtoHelper.dto2Eo((BaseVo)packageDto, (BaseEo)packageEo);
        this.packageDas.updateSelective((BaseEo)packageEo);
    }

    @Override
    public void packed(PackagePackedReqDto packedReqDto) {
        if (null != packedReqDto.getShippingCompanyId()) {
            Assert.notNull(packedReqDto.getShippingNo(), "\u7269\u6d41\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            ShippingCompanyRespDto shippingCompanyRespDto = this.shippingCompanyService.queryById(packedReqDto.getShippingCompanyId());
            Assert.notNull(shippingCompanyRespDto, "\u5feb\u9012\u516c\u53f8\u4e0d\u5b58\u5728");
        }
        PackageEo packageEo = new PackageEo();
        DtoHelper.dto2Eo((BaseVo)packedReqDto, (BaseEo)packageEo);
        packageEo.setStatus(PackageStatusEnum.PACKED.getCode());
        this.packageDas.updateSelective((BaseEo)packageEo);
    }

    @Override
    public PackageShippingLogRespDto queryPackLogById(Long id) {
        PackageDto packageDto = this.queryById(id);
        return this.queryPackLog(packageDto);
    }

    @Override
    public PackageShippingLogRespDto queryPackLog(PackageDto packageDto) {
        ShippingLogRespDto shippingLogRespDto;
        Assert.notNull(packageDto, "\u5305\u88f9\u4e0d\u5b58\u5728");
        PackageShippingLogRespDto packageShippingLogRespDto = new PackageShippingLogRespDto();
        packageShippingLogRespDto.setPack(packageDto);
        if (StringUtils.isNotEmpty((CharSequence)packageDto.getShippingNo()) && StringUtils.isNotEmpty((CharSequence)(shippingLogRespDto = this.shippingLogService.queryLogByShippingNo(packageDto.getShippingNo(), packageDto)).getTraceLog())) {
            List traces = JSON.parseArray((String)shippingLogRespDto.getTraceLog(), Trace.class);
            packageShippingLogRespDto.setTraces(traces);
            packageShippingLogRespDto.setType(shippingLogRespDto.getType());
            return packageShippingLogRespDto;
        }
        return null;
    }

    @Override
    public PackageRespDto queryByDeliveryOrderId(Long deliveryOrderId) {
        PackageEo packageEo = new PackageEo();
        packageEo.setDeliveryOrderId(deliveryOrderId);
        List packageEos = this.packageDas.select((BaseEo)packageEo);
        PackageRespDto packageRespDto = new PackageRespDto();
        packageRespDto.setDeliveryOrderId(deliveryOrderId);
        ArrayList<PackageDto> packageDtos = new ArrayList<PackageDto>();
        this.changeToPackageDto(packageEos, packageDtos);
        packageRespDto.setPackageDtos(packageDtos);
        return packageRespDto;
    }

    @Override
    public int countByStatus(Long deliveryId, String status) {
        PackageEo packageEo = new PackageEo();
        packageEo.setDeliveryOrderId(deliveryId);
        packageEo.setStatus(status);
        return this.packageDas.count((BaseEo)packageEo);
    }

    @Override
    public int countByStatus(Long deliveryId, Set<String> statusList) {
        PackageEo packageEo = new PackageEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"status", (Object)StringUtils.join(statusList, (String)",")));
        sqlFilters.add(SqlFilter.eq((String)"delivery_order_id", (Object)deliveryId));
        packageEo.setSqlFilters(sqlFilters);
        return this.packageDas.count((BaseEo)packageEo);
    }

    private void changeToPackageDto(List<PackageEo> packageEos, List<PackageDto> packageDtos) {
        for (PackageEo packageEo1 : packageEos) {
            Long packageId = packageEo1.getId();
            PackageDetailEo packageDetailEo = new PackageDetailEo();
            packageDetailEo.setPackageId(packageId);
            List packageDetailEos = this.packageDetailDas.select((BaseEo)packageDetailEo);
            PackageDto packageDto = new PackageDto();
            DtoHelper.eo2Dto((BaseEo)packageEo1, (BaseVo)packageDto);
            ArrayList<PackageDetailDto> packageDetailDtos = new ArrayList<PackageDetailDto>();
            for (PackageDetailEo packageDetailEo1 : packageDetailEos) {
                PackageDetailDto packageDetailDto = new PackageDetailDto();
                DtoHelper.eo2Dto((BaseEo)packageDetailEo1, (BaseVo)packageDetailDto);
                packageDetailDtos.add(packageDetailDto);
            }
            packageDto.setPackageDetailDtos(packageDetailDtos);
            packageDtos.add(packageDto);
        }
    }

    @Override
    public PackageRespDto queryByPackageIds(Collection<Long> ids) {
        PackageEo packageEo = new PackageEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        packageEo.setSqlFilters(sqlFilters);
        List packageEos = this.packageDas.select((BaseEo)packageEo);
        PackageRespDto packageRespDto = new PackageRespDto();
        ArrayList<PackageDto> packageDtos = new ArrayList<PackageDto>();
        this.changeToPackageDto(packageEos, packageDtos);
        packageRespDto.setPackageDtos(packageDtos);
        return packageRespDto;
    }

    @Override
    public List<PackageDetailDto> queryDetailByPackageIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        PackageDetailEo packageDetailEo = new PackageDetailEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"package_id", (Object)StringUtils.join(ids, (String)",")));
        packageDetailEo.setSqlFilters(sqlFilters);
        List packageDetailEos = this.packageDetailDas.select((BaseEo)packageDetailEo);
        ArrayList<PackageDetailDto> packageDetailDtos = new ArrayList<PackageDetailDto>();
        if (packageDetailEos != null) {
            DtoHelper.eoList2DtoList((Collection)packageDetailEos, packageDetailDtos, PackageDetailDto.class);
        }
        return packageDetailDtos;
    }

    @Override
    public List<PackageDto> queryByDeliveryIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        PackageEo packageEo = new PackageEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        ArrayList<String> status = new ArrayList<String>();
        status.add(PackageStatusEnum.SEND_OUT.getCode());
        status.add(PackageStatusEnum.SIGNED.getCode());
        sqlFilters.add(SqlFilter.in((String)"status", (Object)StringUtils.join(status, (String)",")));
        sqlFilters.add(SqlFilter.in((String)"delivery_order_id", (Object)StringUtils.join(ids, (String)",")));
        packageEo.setSqlFilters(sqlFilters);
        ArrayList<PackageDto> packageDtos = new ArrayList<PackageDto>();
        List packageEos = this.packageDas.select((BaseEo)packageEo);
        if (packageEos != null) {
            DtoHelper.eoList2DtoList((Collection)packageEos, packageDtos, PackageDto.class);
        }
        return packageDtos;
    }

    @Override
    public PackageDto queryById(Long id) {
        PackageEo packageEo = (PackageEo)this.packageDas.selectByPrimaryKey(id);
        if (packageEo == null) {
            return null;
        }
        PackageDto packageDto = new PackageDto();
        DtoHelper.eo2Dto((BaseEo)packageEo, (BaseVo)packageDto);
        return packageDto;
    }

    @Override
    public List<PackageDto> queryByShippingNo(String shippingNo) {
        PackageEo packageEo = new PackageEo();
        packageEo.setShippingNo(shippingNo);
        ArrayList<PackageDto> packageDtos = new ArrayList<PackageDto>();
        List packageEos = this.packageDas.select((BaseEo)packageEo);
        if (packageEos != null) {
            DtoHelper.eoList2DtoList((Collection)packageEos, packageDtos, PackageDto.class);
        }
        return packageDtos;
    }

    @Override
    public List<PackageDto> queryByOrderNos(Collection<String> nos) {
        if (CollectionUtils.isEmpty(nos)) {
            return null;
        }
        PackageEo packageEo = new PackageEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"order_no", (Object)StringUtils.join(nos, (String)",")));
        packageEo.setSqlFilters(sqlFilters);
        ArrayList<PackageDto> packageDtos = new ArrayList<PackageDto>();
        List packageEos = this.packageDas.select((BaseEo)packageEo);
        if (packageEos != null) {
            DtoHelper.eoList2DtoList((Collection)packageEos, packageDtos, PackageDto.class);
        }
        return packageDtos;
    }

    public String getCode() {
        String code = "";
        String s = String.valueOf(System.currentTimeMillis());
        code = "pk" + s;
        return code;
    }

    @Override
    public void updateStatusById(Long packageId, String status) {
        PackageEo eo = new PackageEo();
        eo.setId(packageId);
        eo.setStatus(status);
        this.packageDas.updateSelective((BaseEo)eo);
    }

    @Override
    public void trace() {
    }
}

